/* component-icalendar.c generated by valac 0.26.0, the Vala compiler
 * generated from component-icalendar.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libical/ical.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COMPONENT_TYPE_ICALENDAR (california_component_icalendar_get_type ())
#define CALIFORNIA_COMPONENT_ICALENDAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendar))
#define CALIFORNIA_COMPONENT_ICALENDAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendarClass))
#define CALIFORNIA_COMPONENT_IS_ICALENDAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_ICALENDAR))
#define CALIFORNIA_COMPONENT_IS_ICALENDAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_ICALENDAR))
#define CALIFORNIA_COMPONENT_ICALENDAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendarClass))

typedef struct _CaliforniaComponentiCalendar CaliforniaComponentiCalendar;
typedef struct _CaliforniaComponentiCalendarClass CaliforniaComponentiCalendarClass;
typedef struct _CaliforniaComponentiCalendarPrivate CaliforniaComponentiCalendarPrivate;

#define CALIFORNIA_COMPONENT_TYPE_INSTANCE (california_component_instance_get_type ())
#define CALIFORNIA_COMPONENT_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance))
#define CALIFORNIA_COMPONENT_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))
#define CALIFORNIA_COMPONENT_IS_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_IS_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))

typedef struct _CaliforniaComponentInstance CaliforniaComponentInstance;
typedef struct _CaliforniaComponentInstanceClass CaliforniaComponentInstanceClass;

#define CALIFORNIA_COMPONENT_TYPE_EVENT (california_component_event_get_type ())
#define CALIFORNIA_COMPONENT_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent))
#define CALIFORNIA_COMPONENT_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))
#define CALIFORNIA_COMPONENT_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))

typedef struct _CaliforniaComponentEvent CaliforniaComponentEvent;
typedef struct _CaliforniaComponentEventClass CaliforniaComponentEventClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _icalcomponent_free0(var) ((var == NULL) ? NULL : (var = (icalcomponent_free (var), NULL)))

#define CALIFORNIA_BACKING_TYPE_SOURCE (california_backing_source_get_type ())
#define CALIFORNIA_BACKING_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource))
#define CALIFORNIA_BACKING_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))
#define CALIFORNIA_BACKING_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))

typedef struct _CaliforniaBackingSource CaliforniaBackingSource;
typedef struct _CaliforniaBackingSourceClass CaliforniaBackingSourceClass;

#define CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE (california_backing_calendar_source_get_type ())
#define CALIFORNIA_BACKING_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSource))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))

typedef struct _CaliforniaBackingCalendarSource CaliforniaBackingCalendarSource;
typedef struct _CaliforniaBackingCalendarSourceClass CaliforniaBackingCalendarSourceClass;

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaComponentiCalendar {
	CaliforniaBaseObject parent_instance;
	CaliforniaComponentiCalendarPrivate * priv;
};

struct _CaliforniaComponentiCalendarClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaComponentiCalendarPrivate {
	gchar* _prodid;
	gchar* _version;
	icalproperty_method _method;
	gchar* _calscale;
	GeeList* _events;
	icalcomponent* _ical_component;
};

typedef enum  {
	CALIFORNIA_COMPONENT_ERROR_INVALID,
	CALIFORNIA_COMPONENT_ERROR_MISMATCH,
	CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE
} CaliforniaComponentError;
#define CALIFORNIA_COMPONENT_ERROR california_component_error_quark ()

static gpointer california_component_icalendar_parent_class = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_component_icalendar_get_type (void) G_GNUC_CONST;
GType california_component_instance_get_type (void) G_GNUC_CONST;
GType california_component_event_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_COMPONENT_ICALENDAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendarPrivate))
enum  {
	CALIFORNIA_COMPONENT_ICALENDAR_DUMMY_PROPERTY,
	CALIFORNIA_COMPONENT_ICALENDAR_PRODID,
	CALIFORNIA_COMPONENT_ICALENDAR_VERSION,
	CALIFORNIA_COMPONENT_ICALENDAR_METHOD,
	CALIFORNIA_COMPONENT_ICALENDAR_CALSCALE,
	CALIFORNIA_COMPONENT_ICALENDAR_EVENTS,
	CALIFORNIA_COMPONENT_ICALENDAR_ICAL_COMPONENT
};
#define CALIFORNIA_COMPONENT_ICALENDAR_DEFAULT_METHOD ICAL_METHOD_PUBLISH
static CaliforniaComponentiCalendar* california_component_icalendar_new (icalcomponent* root, GError** error);
static CaliforniaComponentiCalendar* california_component_icalendar_construct (GType object_type, icalcomponent* root, GError** error);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
GQuark california_component_error_quark (void);
static void california_component_icalendar_set_prodid (CaliforniaComponentiCalendar* self, const gchar* value);
static void california_component_icalendar_set_version (CaliforniaComponentiCalendar* self, const gchar* value);
static void california_component_icalendar_set_calscale (CaliforniaComponentiCalendar* self, const gchar* value);
static void california_component_icalendar_set_method (CaliforniaComponentiCalendar* self, icalproperty_method value);
GType california_backing_source_get_type (void) G_GNUC_CONST;
GType california_backing_calendar_source_get_type (void) G_GNUC_CONST;
CaliforniaComponentInstance* california_component_instance_convert (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
GeeList* california_component_icalendar_get_events (CaliforniaComponentiCalendar* self);
CaliforniaComponentiCalendar* california_component_icalendar_parse (const gchar* str, GError** error);
gboolean california_string_is_empty (const gchar* str);
static gchar* california_component_icalendar_real_to_string (CaliforniaBaseObject* base);
const gchar* california_component_icalendar_get_prodid (CaliforniaComponentiCalendar* self);
const gchar* california_component_icalendar_get_version (CaliforniaComponentiCalendar* self);
const gchar* california_component_icalendar_get_calscale (CaliforniaComponentiCalendar* self);
icalproperty_method california_component_icalendar_get_method (CaliforniaComponentiCalendar* self);
const gchar* ical_icalproperty_method_to_string (icalproperty_method self);
static const char* _ical_icalproperty_method_to_string (icalproperty_method value);
static void california_component_icalendar_set_events (CaliforniaComponentiCalendar* self, GeeList* value);
icalcomponent* california_component_icalendar_get_ical_component (CaliforniaComponentiCalendar* self);
static void california_component_icalendar_finalize (GObject* obj);
static void _vala_california_component_icalendar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_component_icalendar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create an {@link iCalendar} representation of the iCal component.
     *
     * @throws ComponentError.INVALID if root is not a VCALENDAR.
     */
static CaliforniaComponentiCalendar* california_component_icalendar_construct (GType object_type, icalcomponent* root, GError** error) {
	CaliforniaComponentiCalendar * self = NULL;
	icalcomponent* _tmp0_ = NULL;
	icalcomponent_kind _tmp1_ = 0;
	icalproperty* prop = NULL;
	icalcomponent* _tmp3_ = NULL;
	icalproperty* _tmp4_ = NULL;
	icalproperty* _tmp5_ = NULL;
	icalcomponent* _tmp8_ = NULL;
	icalproperty* _tmp9_ = NULL;
	icalproperty* _tmp10_ = NULL;
	icalcomponent* _tmp13_ = NULL;
	icalproperty* _tmp14_ = NULL;
	icalproperty* _tmp15_ = NULL;
	icalcomponent* _tmp18_ = NULL;
	icalproperty* _tmp19_ = NULL;
	icalproperty* _tmp20_ = NULL;
	icalcomponent* child_component = NULL;
	icalcomponent* _tmp24_ = NULL;
	icalcomponent* _tmp25_ = NULL;
	icalcomponent* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
#line 79 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_val_if_fail (root != NULL, NULL);
#line 79 "/home/jim/git/california/src/component/component-icalendar.vala"
	self = (CaliforniaComponentiCalendar*) california_base_object_construct (object_type);
#line 80 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = root;
#line 80 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp1_ = icalcomponent_isa (_tmp0_);
#line 80 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (_tmp1_ != ICAL_VCALENDAR_COMPONENT) {
#line 201 "component-icalendar.c"
		GError* _tmp2_ = NULL;
#line 81 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp2_ = g_error_new_literal (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, "Not a VCALENDAR");
#line 81 "/home/jim/git/california/src/component/component-icalendar.vala"
		_inner_error_ = _tmp2_;
#line 81 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/jim/git/california/src/component/component-icalendar.vala"
		_icalcomponent_free0 (root);
#line 81 "/home/jim/git/california/src/component/component-icalendar.vala"
		_g_object_unref0 (self);
#line 81 "/home/jim/git/california/src/component/component-icalendar.vala"
		return NULL;
#line 215 "component-icalendar.c"
	}
#line 87 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp3_ = root;
#line 87 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp4_ = icalcomponent_get_first_property (_tmp3_, ICAL_PRODID_PROPERTY);
#line 87 "/home/jim/git/california/src/component/component-icalendar.vala"
	prop = _tmp4_;
#line 88 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp5_ = prop;
#line 88 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (_tmp5_ != NULL) {
#line 227 "component-icalendar.c"
		icalproperty* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 89 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp6_ = prop;
#line 89 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp7_ = icalproperty_get_prodid (_tmp6_);
#line 89 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_prodid (self, _tmp7_);
#line 236 "component-icalendar.c"
	}
#line 91 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp8_ = root;
#line 91 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp9_ = icalcomponent_get_first_property (_tmp8_, ICAL_VERSION_PROPERTY);
#line 91 "/home/jim/git/california/src/component/component-icalendar.vala"
	prop = _tmp9_;
#line 92 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp10_ = prop;
#line 92 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (_tmp10_ != NULL) {
#line 248 "component-icalendar.c"
		icalproperty* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 93 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp11_ = prop;
#line 93 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp12_ = icalproperty_get_version (_tmp11_);
#line 93 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_version (self, _tmp12_);
#line 257 "component-icalendar.c"
	}
#line 95 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp13_ = root;
#line 95 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp14_ = icalcomponent_get_first_property (_tmp13_, ICAL_CALSCALE_PROPERTY);
#line 95 "/home/jim/git/california/src/component/component-icalendar.vala"
	prop = _tmp14_;
#line 96 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp15_ = prop;
#line 96 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (_tmp15_ != NULL) {
#line 269 "component-icalendar.c"
		icalproperty* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 97 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp16_ = prop;
#line 97 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp17_ = icalproperty_get_calscale (_tmp16_);
#line 97 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_calscale (self, _tmp17_);
#line 278 "component-icalendar.c"
	}
#line 101 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp18_ = root;
#line 101 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp19_ = icalcomponent_get_first_property (_tmp18_, ICAL_METHOD_PROPERTY);
#line 101 "/home/jim/git/california/src/component/component-icalendar.vala"
	prop = _tmp19_;
#line 102 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp20_ = prop;
#line 102 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (_tmp20_ != NULL) {
#line 290 "component-icalendar.c"
		icalproperty* _tmp21_ = NULL;
		icalproperty_method _tmp22_ = 0;
#line 103 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp21_ = prop;
#line 103 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp22_ = icalproperty_get_method (_tmp21_);
#line 103 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_method (self, _tmp22_);
#line 299 "component-icalendar.c"
	} else {
		icalcomponent* _tmp23_ = NULL;
#line 105 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp23_ = root;
#line 105 "/home/jim/git/california/src/component/component-icalendar.vala"
		icalcomponent_set_method (_tmp23_, CALIFORNIA_COMPONENT_ICALENDAR_DEFAULT_METHOD);
#line 306 "component-icalendar.c"
	}
#line 112 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp24_ = root;
#line 112 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp25_ = icalcomponent_get_first_component (_tmp24_, ICAL_VEVENT_COMPONENT);
#line 112 "/home/jim/git/california/src/component/component-icalendar.vala"
	child_component = _tmp25_;
#line 114 "/home/jim/git/california/src/component/component-icalendar.vala"
	while (TRUE) {
#line 316 "component-icalendar.c"
		icalcomponent* _tmp26_ = NULL;
		CaliforniaComponentInstance* _tmp27_ = NULL;
		icalcomponent* _tmp28_ = NULL;
		CaliforniaComponentInstance* _tmp29_ = NULL;
		GeeList* _tmp30_ = NULL;
		CaliforniaComponentInstance* _tmp31_ = NULL;
		CaliforniaComponentEvent* _tmp32_ = NULL;
		CaliforniaComponentEvent* _tmp33_ = NULL;
		icalcomponent* _tmp34_ = NULL;
		icalcomponent* _tmp35_ = NULL;
#line 114 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp26_ = child_component;
#line 114 "/home/jim/git/california/src/component/component-icalendar.vala"
		if (!(_tmp26_ != NULL)) {
#line 114 "/home/jim/git/california/src/component/component-icalendar.vala"
			break;
#line 333 "component-icalendar.c"
		}
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp28_ = child_component;
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp29_ = california_component_instance_convert (NULL, _tmp28_, &_inner_error_);
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp27_ = _tmp29_;
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
			g_propagate_error (error, _inner_error_);
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
			_icalcomponent_free0 (root);
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
			_g_object_unref0 (self);
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
			return NULL;
#line 351 "component-icalendar.c"
		}
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp30_ = self->priv->_events;
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp31_ = _tmp27_;
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp27_ = NULL;
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp32_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, CALIFORNIA_COMPONENT_TYPE_EVENT) ? ((CaliforniaComponentEvent*) _tmp31_) : NULL;
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		if (_tmp32_ == NULL) {
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
			_g_object_unref0 (_tmp31_);
#line 365 "component-icalendar.c"
		}
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp33_ = _tmp32_;
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), _tmp33_);
#line 115 "/home/jim/git/california/src/component/component-icalendar.vala"
		_g_object_unref0 (_tmp33_);
#line 116 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp34_ = root;
#line 116 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp35_ = icalcomponent_get_next_component (_tmp34_, ICAL_VEVENT_COMPONENT);
#line 116 "/home/jim/git/california/src/component/component-icalendar.vala"
		child_component = _tmp35_;
#line 114 "/home/jim/git/california/src/component/component-icalendar.vala"
		_g_object_unref0 (_tmp27_);
#line 381 "component-icalendar.c"
	}
#line 120 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp36_ = root;
#line 120 "/home/jim/git/california/src/component/component-icalendar.vala"
	root = NULL;
#line 120 "/home/jim/git/california/src/component/component-icalendar.vala"
	_icalcomponent_free0 (self->priv->_ical_component);
#line 120 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_ical_component = _tmp36_;
#line 79 "/home/jim/git/california/src/component/component-icalendar.vala"
	_icalcomponent_free0 (root);
#line 79 "/home/jim/git/california/src/component/component-icalendar.vala"
	return self;
#line 395 "component-icalendar.c"
}


static CaliforniaComponentiCalendar* california_component_icalendar_new (icalcomponent* root, GError** error) {
#line 79 "/home/jim/git/california/src/component/component-icalendar.vala"
	return california_component_icalendar_construct (CALIFORNIA_COMPONENT_TYPE_ICALENDAR, root, error);
#line 402 "component-icalendar.c"
}


/**
     * Returns an appropriate {@link Calendar} instance for the string of iCalendar data.
     *
     * @throws ComponentError if data is unrecognized
     */
CaliforniaComponentiCalendar* california_component_icalendar_parse (const gchar* str, GError** error) {
	CaliforniaComponentiCalendar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	icalcomponent* ical_component = NULL;
	const gchar* _tmp3_ = NULL;
	icalcomponent* _tmp4_ = NULL;
	icalcomponent* _tmp5_ = NULL;
	CaliforniaComponentiCalendar* _tmp13_ = NULL;
	icalcomponent* _tmp14_ = NULL;
	CaliforniaComponentiCalendar* _tmp15_ = NULL;
	CaliforniaComponentiCalendar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 129 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = str;
#line 129 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 129 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (_tmp1_) {
#line 430 "component-icalendar.c"
		GError* _tmp2_ = NULL;
#line 130 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp2_ = g_error_new_literal (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, "Empty VCALENDAR string");
#line 130 "/home/jim/git/california/src/component/component-icalendar.vala"
		_inner_error_ = _tmp2_;
#line 130 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_propagate_error (error, _inner_error_);
#line 130 "/home/jim/git/california/src/component/component-icalendar.vala"
		return NULL;
#line 440 "component-icalendar.c"
	}
#line 132 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp3_ = str;
#line 132 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp4_ = icalparser_parse_string (_tmp3_);
#line 132 "/home/jim/git/california/src/component/component-icalendar.vala"
	ical_component = _tmp4_;
#line 133 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp5_ = ical_component;
#line 133 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (_tmp5_ == NULL) {
#line 452 "component-icalendar.c"
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp6_ = str;
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp7_ = strlen (_tmp6_);
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp8_ = _tmp7_;
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp9_ = g_strdup_printf ("Unable to parse VCALENDAR (%db)", _tmp8_);
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp10_ = _tmp9_;
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp11_ = g_error_new_literal (CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_INVALID, _tmp10_);
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_tmp12_ = _tmp11_;
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_g_free0 (_tmp10_);
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_inner_error_ = _tmp12_;
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_propagate_error (error, _inner_error_);
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		_icalcomponent_free0 (ical_component);
#line 134 "/home/jim/git/california/src/component/component-icalendar.vala"
		return NULL;
#line 484 "component-icalendar.c"
	}
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp14_ = ical_component;
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	ical_component = NULL;
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp15_ = california_component_icalendar_new (_tmp14_, &_inner_error_);
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp13_ = _tmp15_;
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_propagate_error (error, _inner_error_);
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
		_icalcomponent_free0 (ical_component);
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
		return NULL;
#line 502 "component-icalendar.c"
	}
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp16_ = _tmp13_;
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp13_ = NULL;
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp16_;
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_object_unref0 (_tmp13_);
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	_icalcomponent_free0 (ical_component);
#line 136 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 516 "component-icalendar.c"
}


static const char* _ical_icalproperty_method_to_string (icalproperty_method value) {
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	switch (value) {
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_X:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_X";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_PUBLISH:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_PUBLISH";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_REQUEST:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_REQUEST";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_REPLY:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_REPLY";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_ADD:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_ADD";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_CANCEL:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_CANCEL";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_REFRESH:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_REFRESH";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_COUNTER:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_COUNTER";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_DECLINECOUNTER:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_DECLINECOUNTER";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_CREATE:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_CREATE";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_READ:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_READ";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_RESPONSE:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_RESPONSE";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_MOVE:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_MOVE";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_MODIFY:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_MODIFY";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_GENERATEUID:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_GENERATEUID";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_DELETE:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_DELETE";
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		case ICAL_METHOD_NONE:
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
		return "ICAL_METHOD_NONE";
#line 591 "component-icalendar.c"
	}
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	return NULL;
#line 595 "component-icalendar.c"
}


static gchar* california_component_icalendar_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaComponentiCalendar * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	icalproperty_method _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	GeeList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
#line 139 "/home/jim/git/california/src/component/component-icalendar.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendar);
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = self->priv->_prodid;
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp1_ = self->priv->_version;
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp2_ = self->priv->_calscale;
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp3_ = self->priv->_method;
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp4_ = _ical_icalproperty_method_to_string (_tmp3_);
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp5_ = self->priv->_events;
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp7_ = _tmp6_;
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp8_ = g_strdup_printf ("iCalendar|%s|%s|%s|%s (%d events)", _tmp0_, _tmp1_, _tmp2_, _tmp4_, _tmp7_);
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp8_;
#line 140 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 635 "component-icalendar.c"
}


const gchar* california_component_icalendar_get_prodid (CaliforniaComponentiCalendar* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self), NULL);
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = self->priv->_prodid;
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp0_;
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 650 "component-icalendar.c"
}


static void california_component_icalendar_set_prodid (CaliforniaComponentiCalendar* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self));
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = value;
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_free0 (self->priv->_prodid);
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_prodid = _tmp1_;
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_notify ((GObject *) self, "prodid");
#line 669 "component-icalendar.c"
}


const gchar* california_component_icalendar_get_version (CaliforniaComponentiCalendar* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self), NULL);
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = self->priv->_version;
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp0_;
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 684 "component-icalendar.c"
}


static void california_component_icalendar_set_version (CaliforniaComponentiCalendar* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self));
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = value;
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_free0 (self->priv->_version);
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_version = _tmp1_;
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_notify ((GObject *) self, "version");
#line 703 "component-icalendar.c"
}


icalproperty_method california_component_icalendar_get_method (CaliforniaComponentiCalendar* self) {
	icalproperty_method result;
	icalproperty_method _tmp0_ = 0;
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self), 0);
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = self->priv->_method;
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp0_;
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 718 "component-icalendar.c"
}


static void california_component_icalendar_set_method (CaliforniaComponentiCalendar* self, icalproperty_method value) {
	icalproperty_method _tmp0_ = 0;
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self));
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = value;
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_method = _tmp0_;
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_notify ((GObject *) self, "method");
#line 732 "component-icalendar.c"
}


const gchar* california_component_icalendar_get_calscale (CaliforniaComponentiCalendar* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self), NULL);
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = self->priv->_calscale;
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp0_;
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 747 "component-icalendar.c"
}


static void california_component_icalendar_set_calscale (CaliforniaComponentiCalendar* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self));
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = value;
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_free0 (self->priv->_calscale);
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_calscale = _tmp1_;
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_notify ((GObject *) self, "calscale");
#line 766 "component-icalendar.c"
}


GeeList* california_component_icalendar_get_events (CaliforniaComponentiCalendar* self) {
	GeeList* result;
	GeeList* _tmp0_ = NULL;
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self), NULL);
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = self->priv->_events;
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp0_;
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 781 "component-icalendar.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	return self ? g_object_ref (self) : NULL;
#line 788 "component-icalendar.c"
}


static void california_component_icalendar_set_events (CaliforniaComponentiCalendar* self, GeeList* value) {
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self));
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = value;
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_object_unref0 (self->priv->_events);
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_events = _tmp1_;
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_notify ((GObject *) self, "events");
#line 807 "component-icalendar.c"
}


icalcomponent* california_component_icalendar_get_ical_component (CaliforniaComponentiCalendar* self) {
	icalcomponent* result;
	icalcomponent* _tmp0_ = NULL;
#line 72 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_ICALENDAR (self), NULL);
#line 72 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = self->priv->_ical_component;
#line 72 "/home/jim/git/california/src/component/component-icalendar.vala"
	result = _tmp0_;
#line 72 "/home/jim/git/california/src/component/component-icalendar.vala"
	return result;
#line 822 "component-icalendar.c"
}


static void california_component_icalendar_class_init (CaliforniaComponentiCalendarClass * klass) {
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	california_component_icalendar_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaComponentiCalendarPrivate));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_component_icalendar_real_to_string;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_component_icalendar_get_property;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_component_icalendar_set_property;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	G_OBJECT_CLASS (klass)->finalize = california_component_icalendar_finalize;
#line 839 "component-icalendar.c"
	/**
	     * The VCALENDAR's PRODID.
	     *
	     * See [[https://tools.ietf.org/html/rfc5545#section-3.7.3]]
	     */
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_ICALENDAR_PRODID, g_param_spec_string ("prodid", "prodid", "prodid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 847 "component-icalendar.c"
	/**
	     * The VCALENDAR's VERSION.
	     *
	     * See [[https://tools.ietf.org/html/rfc5545#section-3.7.4].  In particular,
	     * read the Purpose section.
	     */
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_ICALENDAR_VERSION, g_param_spec_string ("version", "version", "version", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 856 "component-icalendar.c"
	/**
	     * The VCALENDAR's METHOD.
	     *
	     * See [[https://tools.ietf.org/html/rfc5545#section-3.7.2]]
	     */
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_ICALENDAR_METHOD, g_param_spec_int ("method", "method", "method", G_MININT, G_MAXINT, CALIFORNIA_COMPONENT_ICALENDAR_DEFAULT_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 864 "component-icalendar.c"
	/**
	     * The VCALENDAR's CALSCALE.
	     *
	     * See [[https://tools.ietf.org/html/rfc5545#section-3.7.1]]
	     */
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_ICALENDAR_CALSCALE, g_param_spec_string ("calscale", "calscale", "calscale", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 872 "component-icalendar.c"
	/**
	     * VEVENTS within the VCALENDAR.
	     */
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_ICALENDAR_EVENTS, g_param_spec_object ("events", "events", "events", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_ICALENDAR_ICAL_COMPONENT, g_param_spec_pointer ("ical-component", "ical-component", "ical-component", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 880 "component-icalendar.c"
}


static void california_component_icalendar_instance_init (CaliforniaComponentiCalendar * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv = CALIFORNIA_COMPONENT_ICALENDAR_GET_PRIVATE (self);
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_prodid = NULL;
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_version = NULL;
#line 54 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_method = CALIFORNIA_COMPONENT_ICALENDAR_DEFAULT_METHOD;
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_calscale = NULL;
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	_tmp0_ = gee_array_list_new (CALIFORNIA_COMPONENT_TYPE_EVENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	self->priv->_events = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
#line 900 "component-icalendar.c"
}


static void california_component_icalendar_finalize (GObject* obj) {
	CaliforniaComponentiCalendar * self;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendar);
#line 39 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_free0 (self->priv->_prodid);
#line 47 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_free0 (self->priv->_version);
#line 61 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_free0 (self->priv->_calscale);
#line 66 "/home/jim/git/california/src/component/component-icalendar.vala"
	_g_object_unref0 (self->priv->_events);
#line 71 "/home/jim/git/california/src/component/component-icalendar.vala"
	_icalcomponent_free0 (self->priv->_ical_component);
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	G_OBJECT_CLASS (california_component_icalendar_parent_class)->finalize (obj);
#line 920 "component-icalendar.c"
}


/**
 * An immutable representation of an iCalendar VCALENDAR component.
 *
 * Note that a iCalendar is not considered an {@link Instance}; it's a container which holds
 * Instances.  Although iCalendar is immutable, there is no guarantee that the Instances it
 * hold will be.
 *
 * Also note that iCalendar currently is not associated with a {@link Backing.CalendarSource}.
 * If the feature is ever added where a CalendarSource can cough up its entire VCALENDAR,
 * then that might make sense.
 *
 * See [[https://tools.ietf.org/html/rfc5545#section-3.6]].
 */
GType california_component_icalendar_get_type (void) {
	static volatile gsize california_component_icalendar_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_icalendar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaComponentiCalendarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_component_icalendar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaComponentiCalendar), 0, (GInstanceInitFunc) california_component_icalendar_instance_init, NULL };
		GType california_component_icalendar_type_id;
		california_component_icalendar_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaComponentiCalendar", &g_define_type_info, 0);
		g_once_init_leave (&california_component_icalendar_type_id__volatile, california_component_icalendar_type_id);
	}
	return california_component_icalendar_type_id__volatile;
}


static void _vala_california_component_icalendar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaComponentiCalendar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendar);
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_PRODID:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_value_set_string (value, california_component_icalendar_get_prodid (self));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_VERSION:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_value_set_string (value, california_component_icalendar_get_version (self));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_METHOD:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_value_set_int (value, california_component_icalendar_get_method (self));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_CALSCALE:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_value_set_string (value, california_component_icalendar_get_calscale (self));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_EVENTS:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_value_set_object (value, california_component_icalendar_get_events (self));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_ICAL_COMPONENT:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		g_value_set_pointer (value, california_component_icalendar_get_ical_component (self));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 990 "component-icalendar.c"
		default:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 996 "component-icalendar.c"
	}
}


static void _vala_california_component_icalendar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaComponentiCalendar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_ICALENDAR, CaliforniaComponentiCalendar);
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_PRODID:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_prodid (self, g_value_get_string (value));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_VERSION:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_version (self, g_value_get_string (value));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_METHOD:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_method (self, g_value_get_int (value));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_CALSCALE:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_calscale (self, g_value_get_string (value));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		case CALIFORNIA_COMPONENT_ICALENDAR_EVENTS:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		california_component_icalendar_set_events (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 1036 "component-icalendar.c"
		default:
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/component/component-icalendar.vala"
		break;
#line 1042 "component-icalendar.c"
	}
}



