/* calendar-system.c generated by valac 0.26.0, the Vala compiler
 * generated from calendar-system.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdio.h>
#include <langinfo.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SYSTEM (california_calendar_system_get_type ())
#define CALIFORNIA_CALENDAR_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystem))
#define CALIFORNIA_CALENDAR_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystemClass))
#define CALIFORNIA_CALENDAR_IS_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SYSTEM))
#define CALIFORNIA_CALENDAR_IS_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SYSTEM))
#define CALIFORNIA_CALENDAR_SYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystemClass))

typedef struct _CaliforniaCalendarSystem CaliforniaCalendarSystem;
typedef struct _CaliforniaCalendarSystemClass CaliforniaCalendarSystemClass;
typedef struct _CaliforniaCalendarSystemPrivate CaliforniaCalendarSystemPrivate;

#define CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK (california_calendar_first_of_week_get_type ())

#define CALIFORNIA_TYPE_SCHEDULED (california_scheduled_get_type ())
#define CALIFORNIA_SCHEDULED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduled))
#define CALIFORNIA_SCHEDULED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduledClass))
#define CALIFORNIA_IS_SCHEDULED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_SCHEDULED))
#define CALIFORNIA_IS_SCHEDULED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_SCHEDULED))
#define CALIFORNIA_SCHEDULED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_SCHEDULED, CaliforniaScheduledClass))

typedef struct _CaliforniaScheduled CaliforniaScheduled;
typedef struct _CaliforniaScheduledClass CaliforniaScheduledClass;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_ORDERING (california_calendar_date_ordering_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE (california_calendar_olson_zone_get_type ())
#define CALIFORNIA_CALENDAR_OLSON_ZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE, CaliforniaCalendarOlsonZone))
#define CALIFORNIA_CALENDAR_OLSON_ZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE, CaliforniaCalendarOlsonZoneClass))
#define CALIFORNIA_CALENDAR_IS_OLSON_ZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE))
#define CALIFORNIA_CALENDAR_IS_OLSON_ZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE))
#define CALIFORNIA_CALENDAR_OLSON_ZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE, CaliforniaCalendarOlsonZoneClass))

typedef struct _CaliforniaCalendarOlsonZone CaliforniaCalendarOlsonZone;
typedef struct _CaliforniaCalendarOlsonZoneClass CaliforniaCalendarOlsonZoneClass;

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_DBUS_TYPE_TIMEDATED (california_calendar_dbus_timedated_get_type ())
#define CALIFORNIA_CALENDAR_DBUS_TIMEDATED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_DBUS_TYPE_TIMEDATED, CaliforniaCalendarDBustimedated))
#define CALIFORNIA_CALENDAR_DBUS_IS_TIMEDATED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_DBUS_TYPE_TIMEDATED))
#define CALIFORNIA_CALENDAR_DBUS_TIMEDATED_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_CALENDAR_DBUS_TYPE_TIMEDATED, CaliforniaCalendarDBustimedatedIface))

typedef struct _CaliforniaCalendarDBustimedated CaliforniaCalendarDBustimedated;
typedef struct _CaliforniaCalendarDBustimedatedIface CaliforniaCalendarDBustimedatedIface;

#define CALIFORNIA_CALENDAR_DBUS_TYPE_TIMEDATED_PROXY (california_calendar_dbus_timedated_proxy_get_type ())

#define CALIFORNIA_CALENDAR_DBUS_TYPE_PROPERTIES (california_calendar_dbus_properties_get_type ())
#define CALIFORNIA_CALENDAR_DBUS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_DBUS_TYPE_PROPERTIES, CaliforniaCalendarDBusProperties))
#define CALIFORNIA_CALENDAR_DBUS_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_DBUS_TYPE_PROPERTIES))
#define CALIFORNIA_CALENDAR_DBUS_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_CALENDAR_DBUS_TYPE_PROPERTIES, CaliforniaCalendarDBusPropertiesIface))

typedef struct _CaliforniaCalendarDBusProperties CaliforniaCalendarDBusProperties;
typedef struct _CaliforniaCalendarDBusPropertiesIface CaliforniaCalendarDBusPropertiesIface;

#define CALIFORNIA_CALENDAR_DBUS_TYPE_PROPERTIES_PROXY (california_calendar_dbus_properties_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH (california_calendar_day_of_month_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonth))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))

typedef struct _CaliforniaCalendarDayOfMonth CaliforniaCalendarDayOfMonth;
typedef struct _CaliforniaCalendarDayOfMonthClass CaliforniaCalendarDayOfMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH (california_calendar_month_get_type ())
#define CALIFORNIA_CALENDAR_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonth))
#define CALIFORNIA_CALENDAR_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))
#define CALIFORNIA_CALENDAR_IS_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_IS_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))

typedef struct _CaliforniaCalendarMonth CaliforniaCalendarMonth;
typedef struct _CaliforniaCalendarMonthClass CaliforniaCalendarMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSystem {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSystemPrivate * priv;
};

struct _CaliforniaCalendarSystemClass {
	CaliforniaBaseObjectClass parent_class;
};

typedef enum  {
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_DEFAULT = CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY
} CaliforniaCalendarFirstOfWeek;

struct _CaliforniaCalendarSystemPrivate {
	CaliforniaCalendarFirstOfWeek _system_first_of_week;
	GSettings* system_clock_format_schema;
	CaliforniaScheduled* scheduled_date_timer;
};

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_ORDERING_DMY,
	CALIFORNIA_CALENDAR_DATE_ORDERING_MDY,
	CALIFORNIA_CALENDAR_DATE_ORDERING_YMD,
	CALIFORNIA_CALENDAR_DATE_ORDERING_YDM,
	CALIFORNIA_CALENDAR_DATE_ORDERING_DEFAULT = CALIFORNIA_CALENDAR_DATE_ORDERING_DMY
} CaliforniaCalendarDateOrdering;

struct _CaliforniaCalendarDBustimedatedIface {
	GTypeInterface parent_iface;
	void (*set_time) (CaliforniaCalendarDBustimedated* self, gint64 usec_etc, gboolean relative, gboolean user_interaction, GError** error);
	void (*set_timezone) (CaliforniaCalendarDBustimedated* self, const gchar* timezone, gboolean user_interaction, GError** error);
	void (*set_local_rtc) (CaliforniaCalendarDBustimedated* self, gboolean local_rtc, gboolean fix_system, gboolean user_interaction, GError** error);
	void (*set_ntp) (CaliforniaCalendarDBustimedated* self, gboolean use_ntp, gboolean user_interaction, GError** error);
	gchar* (*get_timezone) (CaliforniaCalendarDBustimedated* self);
	gboolean (*get_local_rtc) (CaliforniaCalendarDBustimedated* self);
	gboolean (*get_ntp) (CaliforniaCalendarDBustimedated* self);
};

struct _CaliforniaCalendarDBusPropertiesIface {
	GTypeInterface parent_iface;
	GVariant* (*get) (CaliforniaCalendarDBusProperties* self, const gchar* interf, const gchar* property, GError** error);
	void (*get_all) (CaliforniaCalendarDBusProperties* self, const gchar* interf, GHashTable* properties, GError** error);
	void (*set) (CaliforniaCalendarDBusProperties* self, const gchar* interf, const gchar* property, GVariant* value, GError** error);
};

typedef void (*CaliforniaScheduledScheduleOnce) (void* user_data);
typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()

static gpointer california_calendar_system_parent_class = NULL;
static CaliforniaCalendarSystem* california_calendar_system__instance;
static CaliforniaCalendarSystem* california_calendar_system__instance = NULL;
static CaliforniaCalendarDate* california_calendar_system__today;
static CaliforniaCalendarDate* california_calendar_system__today = NULL;
static gboolean california_calendar_system__is_24hr;
static gboolean california_calendar_system__is_24hr = FALSE;
static CaliforniaCalendarDateOrdering california_calendar_system__date_ordering;
static CaliforniaCalendarDateOrdering california_calendar_system__date_ordering = 0;
static gchar* california_calendar_system__date_separator;
static gchar* california_calendar_system__date_separator = NULL;
static CaliforniaCalendarOlsonZone* california_calendar_system__zone;
static CaliforniaCalendarOlsonZone* california_calendar_system__zone = NULL;
static CaliforniaCalendarTimezone* california_calendar_system__timezone;
static CaliforniaCalendarTimezone* california_calendar_system__timezone = NULL;
static CaliforniaCalendarFirstOfWeek california_calendar_system__first_of_week;
static CaliforniaCalendarFirstOfWeek california_calendar_system__first_of_week = CALIFORNIA_CALENDAR_FIRST_OF_WEEK_DEFAULT;
static CaliforniaCalendarDBustimedated* california_calendar_system_timedated_service;
static CaliforniaCalendarDBustimedated* california_calendar_system_timedated_service = NULL;
static CaliforniaCalendarDBusProperties* california_calendar_system_timedated_properties;
static CaliforniaCalendarDBusProperties* california_calendar_system_timedated_properties = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_system_get_type (void) G_GNUC_CONST;
GType california_calendar_first_of_week_get_type (void) G_GNUC_CONST;
GType california_scheduled_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_SYSTEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystemPrivate))
enum  {
	CALIFORNIA_CALENDAR_SYSTEM_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_SYSTEM_SYSTEM_FIRST_OF_WEEK
};
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_calendar_date_ordering_get_type (void) G_GNUC_CONST;
GType california_calendar_olson_zone_get_type (void) G_GNUC_CONST;
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
GType california_calendar_dbus_timedated_proxy_get_type (void) G_GNUC_CONST;
guint california_calendar_dbus_timedated_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType california_calendar_dbus_timedated_get_type (void) G_GNUC_CONST;
GType california_calendar_dbus_properties_proxy_get_type (void) G_GNUC_CONST;
guint california_calendar_dbus_properties_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType california_calendar_dbus_properties_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_SCHEMA "org.gnome.desktop.interface"
#define CALIFORNIA_CALENDAR_SYSTEM_PROP_SYSTEM_FIRST_OF_WEEK "system-first-of-week"
#define CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_KEY "clock-format"
#define CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_24H "24h"
#define CALIFORNIA_CALENDAR_SYSTEM_CHECK_DATE_PRIORITY G_PRIORITY_LOW
#define CALIFORNIA_CALENDAR_SYSTEM_MIN_CHECK_DATE_INTERVAL_SEC 1
#define CALIFORNIA_CALENDAR_SYSTEM_MAX_CHECK_DATE_INTERVAL_SEC 30
static CaliforniaCalendarSystem* california_calendar_system_new (void);
static CaliforniaCalendarSystem* california_calendar_system_construct (GType object_type);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
CaliforniaCalendarOlsonZone* california_calendar_system_get_zone (void);
gchar* california_calendar_dbus_timedated_get_timezone (CaliforniaCalendarDBustimedated* self);
CaliforniaCalendarOlsonZone* california_calendar_olson_zone_new (const gchar* area_location);
CaliforniaCalendarOlsonZone* california_calendar_olson_zone_construct (GType object_type, const gchar* area_location);
static void california_calendar_system_set_zone (CaliforniaCalendarOlsonZone* value);
CaliforniaCalendarTimezone* california_calendar_system_get_timezone (void);
CaliforniaCalendarTimezone* california_calendar_timezone_new (CaliforniaCalendarOlsonZone* zone);
CaliforniaCalendarTimezone* california_calendar_timezone_construct (GType object_type, CaliforniaCalendarOlsonZone* zone);
static void california_calendar_system_set_timezone (CaliforniaCalendarTimezone* value);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
static void california_calendar_system_on_timedated_properties_changed (CaliforniaCalendarSystem* self, const gchar* interf, GHashTable* changed_properties_values, gchar** changed_properties, int changed_properties_length1);
static void _california_calendar_system_on_timedated_properties_changed_california_calendar_dbus_properties_properties_changed (CaliforniaCalendarDBusProperties* _sender, const gchar* interf, GHashTable* changed_properties_values, gchar** changed_properties, int changed_properties_length1, gpointer self);
gboolean california_calendar_system_get_is_24hr (void);
static void california_calendar_system_set_is_24hr (gboolean value);
static void __lambda4_ (CaliforniaCalendarSystem* self);
static void ___lambda4__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
CaliforniaCalendarDate* california_calendar_system_get_today (void);
CaliforniaCalendarTimezone* california_calendar_timezone_get_local (void);
CaliforniaCalendarDate* california_calendar_date_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_date_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
static void california_calendar_system_set_today (CaliforniaCalendarDate* value);
static gint california_calendar_system_next_check_today_interval_sec (CaliforniaCalendarSystem* self);
static void california_calendar_system_check_today_changed (CaliforniaCalendarSystem* self);
static void _california_calendar_system_check_today_changed_california_scheduled_schedule_once (gpointer self);
CaliforniaScheduled* california_scheduled_new_once_after_sec (guint sec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
CaliforniaScheduled* california_scheduled_construct_once_after_sec (GType object_type, guint sec, CaliforniaScheduledScheduleOnce cb, void* cb_target, gint priority);
GType california_calendar_day_of_month_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_for_checked (gint value);
GType california_calendar_month_get_type (void) G_GNUC_CONST;
CaliforniaCalendarMonth* california_calendar_month_for_checked (gint value);
CaliforniaCalendarYear* california_calendar_year_new (gint value);
CaliforniaCalendarYear* california_calendar_year_construct (GType object_type, gint value);
GType california_calendar_year_get_type (void) G_GNUC_CONST;
GQuark california_calendar_error_quark (void);
CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt);
CaliforniaCalendarDateOrdering california_calendar_system_get_date_ordering (void);
void california_calendar_system_set_date_ordering (CaliforniaCalendarDateOrdering value);
const gchar* california_calendar_system_get_date_separator (void);
void california_calendar_system_set_date_separator (const gchar* value);
gchar* california_calendar_date_ordering_to_string (CaliforniaCalendarDateOrdering self);
static void california_calendar_system_set_system_first_of_week (CaliforniaCalendarSystem* self, CaliforniaCalendarFirstOfWeek value);
CaliforniaCalendarFirstOfWeek california_calendar_system_get_system_first_of_week (CaliforniaCalendarSystem* self);
gchar* california_calendar_first_of_week_to_string (CaliforniaCalendarFirstOfWeek self);
void california_calendar_system_preinit (GError** error);
#define CALIFORNIA_CALENDAR_DBUS_TIMEDATED_NAME "org.freedesktop.timedate1"
#define CALIFORNIA_CALENDAR_DBUS_TIMEDATED_OBJECT_PATH "/org/freedesktop/timedate1"
#define CALIFORNIA_CALENDAR_DBUS_PROPERTIES_NAME "org.freedesktop.DBus.Properties"
void california_calendar_system_init (void);
CaliforniaCalendarSystem* california_calendar_system_get_instance (void);
static void california_calendar_system_set_instance (CaliforniaCalendarSystem* value);
CaliforniaCalendarFirstOfWeek california_calendar_system_get_first_of_week (void);
void california_calendar_system_set_first_of_week (CaliforniaCalendarFirstOfWeek value);
void california_calendar_system_terminate (void);
#define CALIFORNIA_CALENDAR_DBUS_TIMEDATED_PROP_TIMEZONE "Timezone"
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void california_calendar_system_update_today (CaliforniaCalendarSystem* self);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void);
CaliforniaCalendarExactTime* california_calendar_exact_time_new (CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct (GType object_type, CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
gint64 california_calendar_exact_time_difference (CaliforniaCalendarExactTime* self, CaliforniaCalendarExactTime* other);
CaliforniaCalendarExactTime* california_calendar_exact_time_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
static gchar* california_calendar_system_real_to_string (CaliforniaBaseObject* base);
CaliforniaCalendarExactTime* california_calendar_system_get_now (void);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__ENUM_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void california_calendar_system_finalize (GObject* obj);
static void _vala_california_calendar_system_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_system_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _california_calendar_system_on_timedated_properties_changed_california_calendar_dbus_properties_properties_changed (CaliforniaCalendarDBusProperties* _sender, const gchar* interf, GHashTable* changed_properties_values, gchar** changed_properties, int changed_properties_length1, gpointer self) {
#line 177 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_on_timedated_properties_changed ((CaliforniaCalendarSystem*) self, interf, changed_properties_values, changed_properties, changed_properties_length1);
#line 374 "calendar-system.c"
}


static void __lambda4_ (CaliforniaCalendarSystem* self) {
	gboolean new_is_24hr = FALSE;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 182 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = self->priv->system_clock_format_schema;
#line 182 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_KEY);
#line 182 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = _tmp1_;
#line 182 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_24H) == 0;
#line 182 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp2_);
#line 182 "/home/jim/git/california/src/calendar/calendar-system.vala"
	new_is_24hr = _tmp3_;
#line 183 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp4_ = new_is_24hr;
#line 183 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp5_ = california_calendar_system_get_is_24hr ();
#line 183 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp6_ = _tmp5_;
#line 183 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (_tmp4_ != _tmp6_) {
#line 407 "calendar-system.c"
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 184 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp7_ = california_calendar_system_get_is_24hr ();
#line 184 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp8_ = _tmp7_;
#line 184 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp9_ = new_is_24hr;
#line 184 "/home/jim/git/california/src/calendar/calendar-system.vala"
		california_calendar_system_set_is_24hr (_tmp9_);
#line 185 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp10_ = california_calendar_system_get_is_24hr ();
#line 185 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp11_ = _tmp10_;
#line 185 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_signal_emit_by_name (self, "is-24hr-changed", _tmp11_);
#line 427 "calendar-system.c"
	}
}


static void ___lambda4__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 181 "/home/jim/git/california/src/calendar/calendar-system.vala"
	__lambda4_ ((CaliforniaCalendarSystem*) self);
#line 435 "calendar-system.c"
}


static void _california_calendar_system_check_today_changed_california_scheduled_schedule_once (gpointer self) {
#line 195 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_check_today_changed ((CaliforniaCalendarSystem*) self);
#line 442 "calendar-system.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 454 "calendar-system.c"
}


/**
 * Use for {@link Langinfo.Item}s prefixed with INT_.
 */
static gint langinfo_lookup_int (nl_item item) {
	gint result = 0;
	gchar* ptr = NULL;
	nl_item _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	gchar* _tmp3_ = NULL;
#line 15 "../vapi/langinfo.vapi"
	_tmp0_ = item;
#line 15 "../vapi/langinfo.vapi"
	_tmp1_ = nl_langinfo (_tmp0_);
#line 15 "../vapi/langinfo.vapi"
	ptr = (gchar*) _tmp1_;
#line 17 "../vapi/langinfo.vapi"
	_tmp3_ = ptr;
#line 17 "../vapi/langinfo.vapi"
	if (_tmp3_ != NULL) {
#line 478 "calendar-system.c"
		gchar* _tmp4_ = NULL;
#line 17 "../vapi/langinfo.vapi"
		_tmp4_ = ptr;
#line 17 "../vapi/langinfo.vapi"
		_tmp2_ = *_tmp4_;
#line 484 "calendar-system.c"
	} else {
#line 17 "../vapi/langinfo.vapi"
		_tmp2_ = (gchar) 0;
#line 488 "calendar-system.c"
	}
#line 17 "../vapi/langinfo.vapi"
	result = (gint) _tmp2_;
#line 17 "../vapi/langinfo.vapi"
	return result;
#line 494 "calendar-system.c"
}


static CaliforniaCalendarSystem* california_calendar_system_construct (GType object_type) {
	CaliforniaCalendarSystem * self = NULL;
	CaliforniaCalendarOlsonZone* _tmp0_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp1_ = NULL;
	CaliforniaCalendarDBustimedated* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp6_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp7_ = NULL;
	CaliforniaCalendarTimezone* _tmp8_ = NULL;
	CaliforniaCalendarTimezone* _tmp9_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp10_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp11_ = NULL;
	CaliforniaCalendarTimezone* _tmp12_ = NULL;
	CaliforniaCalendarTimezone* _tmp13_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp14_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	CaliforniaCalendarDBusProperties* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GSettings* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GSettings* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	CaliforniaCalendarDate* _tmp26_ = NULL;
	CaliforniaCalendarDate* _tmp27_ = NULL;
	CaliforniaCalendarTimezone* _tmp28_ = NULL;
	CaliforniaCalendarTimezone* _tmp29_ = NULL;
	CaliforniaCalendarDate* _tmp30_ = NULL;
	CaliforniaCalendarDate* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	CaliforniaScheduled* _tmp33_ = NULL;
	CaliforniaCalendarDate* unique_date = NULL;
	gchar* formatted = NULL;
	CaliforniaCalendarDate* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gint a = 0;
	gint b = 0;
	gint c = 0;
	gchar first_separator = '\0';
	gchar second_separator = '\0';
	const gchar* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gchar _tmp90_ = '\0';
	CaliforniaCalendarDateOrdering _tmp98_ = 0;
	CaliforniaCalendarDateOrdering _tmp99_ = 0;
	gchar* _tmp100_ = NULL;
	gchar* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	const gchar* _tmp105_ = NULL;
	gint first_weekday = 0;
	gint _tmp106_ = 0;
	gint week_origin = 0;
	const gchar* _tmp107_ = NULL;
	gint week_1stday = 0;
	gint _tmp108_ = 0;
	gint week_start = 0;
	gint _tmp111_ = 0;
	gint _tmp112_ = 0;
	gint _tmp113_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp115_ = 0;
	gchar* _tmp116_ = NULL;
	gchar* _tmp117_ = NULL;
	GError * _inner_error_ = NULL;
#line 171 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self = (CaliforniaCalendarSystem*) california_base_object_construct (object_type);
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system_get_zone ();
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _tmp0_;
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = california_calendar_system_timedated_service;
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = california_calendar_dbus_timedated_get_timezone (_tmp2_);
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp4_ = _tmp3_;
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp5_ = _tmp4_;
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp6_ = california_calendar_olson_zone_new (_tmp5_);
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp7_ = _tmp6_;
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_zone (_tmp7_);
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (_tmp7_);
#line 172 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp5_);
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp8_ = california_calendar_system_get_timezone ();
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp9_ = _tmp8_;
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp10_ = california_calendar_system_get_zone ();
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp11_ = _tmp10_;
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp12_ = california_calendar_timezone_new (_tmp11_);
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp13_ = _tmp12_;
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_timezone (_tmp13_);
#line 173 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (_tmp13_);
#line 174 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp14_ = california_calendar_system_get_zone ();
#line 174 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp15_ = _tmp14_;
#line 174 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp16_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 174 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp17_ = _tmp16_;
#line 174 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_debug ("calendar-system.vala:174: Local zone: %s", _tmp17_);
#line 174 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp17_);
#line 177 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp18_ = california_calendar_system_timedated_properties;
#line 177 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_connect_object (_tmp18_, "properties-changed", (GCallback) _california_calendar_system_on_timedated_properties_changed_california_calendar_dbus_properties_properties_changed, self, 0);
#line 180 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp19_ = california_calendar_system_get_is_24hr ();
#line 180 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp20_ = _tmp19_;
#line 180 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp21_ = self->priv->system_clock_format_schema;
#line 180 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp22_ = g_settings_get_string (_tmp21_, CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_KEY);
#line 180 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp23_ = _tmp22_;
#line 180 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_is_24hr (g_strcmp0 (_tmp23_, CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_24H) == 0);
#line 180 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp23_);
#line 181 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp24_ = self->priv->system_clock_format_schema;
#line 181 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp25_ = g_strconcat ("changed::", CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_KEY, NULL);
#line 181 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_connect_object (_tmp24_, _tmp25_, (GCallback) ___lambda4__g_settings_changed, self, 0);
#line 181 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp25_);
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp26_ = california_calendar_system_get_today ();
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp27_ = _tmp26_;
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp28_ = california_calendar_timezone_get_local ();
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp29_ = _tmp28_;
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp30_ = california_calendar_date_new_now (_tmp29_);
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp31_ = _tmp30_;
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_today (_tmp31_);
#line 194 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (_tmp31_);
#line 195 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp32_ = california_calendar_system_next_check_today_interval_sec (self);
#line 195 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp33_ = california_scheduled_new_once_after_sec ((guint) _tmp32_, _california_calendar_system_check_today_changed_california_scheduled_schedule_once, self, CALIFORNIA_CALENDAR_SYSTEM_CHECK_DATE_PRIORITY);
#line 195 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (self->priv->scheduled_date_timer);
#line 195 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self->priv->scheduled_date_timer = _tmp33_;
#line 670 "calendar-system.c"
	{
		CaliforniaCalendarDate* _tmp34_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp35_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp36_ = NULL;
		CaliforniaCalendarMonth* _tmp37_ = NULL;
		CaliforniaCalendarMonth* _tmp38_ = NULL;
		CaliforniaCalendarYear* _tmp39_ = NULL;
		CaliforniaCalendarYear* _tmp40_ = NULL;
		CaliforniaCalendarDate* _tmp41_ = NULL;
		CaliforniaCalendarDate* _tmp42_ = NULL;
		CaliforniaCalendarDate* _tmp43_ = NULL;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp35_ = california_calendar_day_of_month_for_checked (3);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp36_ = _tmp35_;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp37_ = california_calendar_month_for_checked (4);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp38_ = _tmp37_;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp39_ = california_calendar_year_new (2001);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp40_ = _tmp39_;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp41_ = california_calendar_date_new (_tmp36_, _tmp38_, _tmp40_, &_inner_error_);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp42_ = _tmp41_;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (_tmp40_);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (_tmp38_);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (_tmp36_);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp34_ = _tmp42_;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 708 "calendar-system.c"
			goto __catch34_g_error;
		}
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp43_ = _tmp34_;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp34_ = NULL;
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (unique_date);
#line 201 "/home/jim/git/california/src/calendar/calendar-system.vala"
		unique_date = _tmp43_;
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (_tmp34_);
#line 721 "calendar-system.c"
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp44_ = NULL;
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		err = _inner_error_;
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_inner_error_ = NULL;
#line 204 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp44_ = err->message;
#line 204 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_error ("calendar-system.vala:204: Unable to generate test date 3/4/2001: %s", _tmp44_);
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_error_free0 (err);
#line 738 "calendar-system.c"
	}
	__finally34:
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (unique_date);
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_clear_error (&_inner_error_);
#line 200 "/home/jim/git/california/src/calendar/calendar-system.vala"
		return NULL;
#line 751 "calendar-system.c"
	}
#line 207 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp45_ = unique_date;
#line 207 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp46_ = california_calendar_date_format (_tmp45_, "%x");
#line 207 "/home/jim/git/california/src/calendar/calendar-system.vala"
	formatted = _tmp46_;
#line 211 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp47_ = formatted;
#line 211 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp48_ = sscanf (_tmp47_, "%d%c%d%c%d", &a, &first_separator, &b, &second_separator, &c);
#line 211 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (_tmp48_ == 5) {
#line 765 "calendar-system.c"
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		gint _tmp60_ = 0;
#line 213 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp50_ = a;
#line 213 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_tmp50_ == 2001) {
#line 213 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp49_ = 1;
#line 781 "calendar-system.c"
		} else {
			gint _tmp51_ = 0;
#line 213 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp51_ = a;
#line 213 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp49_ = _tmp51_;
#line 788 "calendar-system.c"
		}
#line 213 "/home/jim/git/california/src/calendar/calendar-system.vala"
		a = _tmp49_;
#line 214 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp53_ = b;
#line 214 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_tmp53_ == 2001) {
#line 214 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp52_ = 1;
#line 798 "calendar-system.c"
		} else {
			gint _tmp54_ = 0;
#line 214 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp54_ = b;
#line 214 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp52_ = _tmp54_;
#line 805 "calendar-system.c"
		}
#line 214 "/home/jim/git/california/src/calendar/calendar-system.vala"
		b = _tmp52_;
#line 215 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp56_ = c;
#line 215 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_tmp56_ == 2001) {
#line 215 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp55_ = 1;
#line 815 "calendar-system.c"
		} else {
			gint _tmp57_ = 0;
#line 215 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp57_ = c;
#line 215 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp55_ = _tmp57_;
#line 822 "calendar-system.c"
		}
#line 215 "/home/jim/git/california/src/calendar/calendar-system.vala"
		c = _tmp55_;
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp60_ = a;
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_tmp60_ == 3) {
#line 830 "calendar-system.c"
			gint _tmp61_ = 0;
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp61_ = b;
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp59_ = _tmp61_ == 4;
#line 836 "calendar-system.c"
		} else {
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp59_ = FALSE;
#line 840 "calendar-system.c"
		}
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_tmp59_) {
#line 844 "calendar-system.c"
			gint _tmp62_ = 0;
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp62_ = c;
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp58_ = _tmp62_ == 1;
#line 850 "calendar-system.c"
		} else {
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp58_ = FALSE;
#line 854 "calendar-system.c"
		}
#line 217 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_tmp58_) {
#line 858 "calendar-system.c"
			CaliforniaCalendarDateOrdering _tmp63_ = 0;
			CaliforniaCalendarDateOrdering _tmp64_ = 0;
#line 218 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp63_ = california_calendar_system_get_date_ordering ();
#line 218 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp64_ = _tmp63_;
#line 218 "/home/jim/git/california/src/calendar/calendar-system.vala"
			california_calendar_system_set_date_ordering (CALIFORNIA_CALENDAR_DATE_ORDERING_DMY);
#line 867 "calendar-system.c"
		} else {
			gboolean _tmp65_ = FALSE;
			gboolean _tmp66_ = FALSE;
			gint _tmp67_ = 0;
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp67_ = a;
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
			if (_tmp67_ == 4) {
#line 876 "calendar-system.c"
				gint _tmp68_ = 0;
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp68_ = b;
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp66_ = _tmp68_ == 3;
#line 882 "calendar-system.c"
			} else {
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp66_ = FALSE;
#line 886 "calendar-system.c"
			}
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
			if (_tmp66_) {
#line 890 "calendar-system.c"
				gint _tmp69_ = 0;
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp69_ = c;
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp65_ = _tmp69_ == 1;
#line 896 "calendar-system.c"
			} else {
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp65_ = FALSE;
#line 900 "calendar-system.c"
			}
#line 219 "/home/jim/git/california/src/calendar/calendar-system.vala"
			if (_tmp65_) {
#line 904 "calendar-system.c"
				CaliforniaCalendarDateOrdering _tmp70_ = 0;
				CaliforniaCalendarDateOrdering _tmp71_ = 0;
#line 220 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp70_ = california_calendar_system_get_date_ordering ();
#line 220 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp71_ = _tmp70_;
#line 220 "/home/jim/git/california/src/calendar/calendar-system.vala"
				california_calendar_system_set_date_ordering (CALIFORNIA_CALENDAR_DATE_ORDERING_MDY);
#line 913 "calendar-system.c"
			} else {
				gboolean _tmp72_ = FALSE;
				gboolean _tmp73_ = FALSE;
				gint _tmp74_ = 0;
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
				_tmp74_ = a;
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
				if (_tmp74_ == 1) {
#line 922 "calendar-system.c"
					gint _tmp75_ = 0;
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp75_ = b;
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp73_ = _tmp75_ == 3;
#line 928 "calendar-system.c"
				} else {
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp73_ = FALSE;
#line 932 "calendar-system.c"
				}
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
				if (_tmp73_) {
#line 936 "calendar-system.c"
					gint _tmp76_ = 0;
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp76_ = c;
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp72_ = _tmp76_ == 4;
#line 942 "calendar-system.c"
				} else {
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp72_ = FALSE;
#line 946 "calendar-system.c"
				}
#line 221 "/home/jim/git/california/src/calendar/calendar-system.vala"
				if (_tmp72_) {
#line 950 "calendar-system.c"
					CaliforniaCalendarDateOrdering _tmp77_ = 0;
					CaliforniaCalendarDateOrdering _tmp78_ = 0;
#line 222 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp77_ = california_calendar_system_get_date_ordering ();
#line 222 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp78_ = _tmp77_;
#line 222 "/home/jim/git/california/src/calendar/calendar-system.vala"
					california_calendar_system_set_date_ordering (CALIFORNIA_CALENDAR_DATE_ORDERING_YDM);
#line 959 "calendar-system.c"
				} else {
					gboolean _tmp79_ = FALSE;
					gboolean _tmp80_ = FALSE;
					gint _tmp81_ = 0;
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
					_tmp81_ = a;
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
					if (_tmp81_ == 1) {
#line 968 "calendar-system.c"
						gint _tmp82_ = 0;
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp82_ = b;
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp80_ = _tmp82_ == 4;
#line 974 "calendar-system.c"
					} else {
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp80_ = FALSE;
#line 978 "calendar-system.c"
					}
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
					if (_tmp80_) {
#line 982 "calendar-system.c"
						gint _tmp83_ = 0;
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp83_ = c;
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp79_ = _tmp83_ == 3;
#line 988 "calendar-system.c"
					} else {
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp79_ = FALSE;
#line 992 "calendar-system.c"
					}
#line 223 "/home/jim/git/california/src/calendar/calendar-system.vala"
					if (_tmp79_) {
#line 996 "calendar-system.c"
						CaliforniaCalendarDateOrdering _tmp84_ = 0;
						CaliforniaCalendarDateOrdering _tmp85_ = 0;
#line 224 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp84_ = california_calendar_system_get_date_ordering ();
#line 224 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp85_ = _tmp84_;
#line 224 "/home/jim/git/california/src/calendar/calendar-system.vala"
						california_calendar_system_set_date_ordering (CALIFORNIA_CALENDAR_DATE_ORDERING_YMD);
#line 1005 "calendar-system.c"
					} else {
						CaliforniaCalendarDateOrdering _tmp86_ = 0;
						CaliforniaCalendarDateOrdering _tmp87_ = 0;
#line 226 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp86_ = california_calendar_system_get_date_ordering ();
#line 226 "/home/jim/git/california/src/calendar/calendar-system.vala"
						_tmp87_ = _tmp86_;
#line 226 "/home/jim/git/california/src/calendar/calendar-system.vala"
						california_calendar_system_set_date_ordering (CALIFORNIA_CALENDAR_DATE_ORDERING_DEFAULT);
#line 1015 "calendar-system.c"
					}
				}
			}
		}
	} else {
		CaliforniaCalendarDateOrdering _tmp88_ = 0;
		CaliforniaCalendarDateOrdering _tmp89_ = 0;
#line 229 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp88_ = california_calendar_system_get_date_ordering ();
#line 229 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp89_ = _tmp88_;
#line 229 "/home/jim/git/california/src/calendar/calendar-system.vala"
		california_calendar_system_set_date_ordering (CALIFORNIA_CALENDAR_DATE_ORDERING_DEFAULT);
#line 1029 "calendar-system.c"
	}
#line 233 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp90_ = first_separator;
#line 233 "/home/jim/git/california/src/calendar/calendar-system.vala"
	switch (_tmp90_) {
#line 233 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case '/':
#line 233 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case '.':
#line 233 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case '-':
#line 1041 "calendar-system.c"
		{
			const gchar* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			gchar _tmp93_ = '\0';
			gchar* _tmp94_ = NULL;
			gchar* _tmp95_ = NULL;
#line 237 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp91_ = california_calendar_system_get_date_separator ();
#line 237 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp92_ = _tmp91_;
#line 237 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp93_ = first_separator;
#line 237 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp94_ = g_strdup_printf ("%c", _tmp93_);
#line 237 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp95_ = _tmp94_;
#line 237 "/home/jim/git/california/src/calendar/calendar-system.vala"
			california_calendar_system_set_date_separator (_tmp95_);
#line 237 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_g_free0 (_tmp95_);
#line 238 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1064 "calendar-system.c"
		}
		default:
		{
			const gchar* _tmp96_ = NULL;
			const gchar* _tmp97_ = NULL;
#line 241 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp96_ = california_calendar_system_get_date_separator ();
#line 241 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp97_ = _tmp96_;
#line 241 "/home/jim/git/california/src/calendar/calendar-system.vala"
			california_calendar_system_set_date_separator ("/");
#line 242 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1078 "calendar-system.c"
		}
	}
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp98_ = california_calendar_system_get_date_ordering ();
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp99_ = _tmp98_;
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp100_ = california_calendar_date_ordering_to_string (_tmp99_);
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp101_ = _tmp100_;
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp102_ = california_calendar_system_get_date_separator ();
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp103_ = _tmp102_;
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp104_ = string_to_string (_tmp103_);
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp105_ = formatted;
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_debug ("calendar-system.vala:245: Date ordering: %s, separator: %s (formatted=" \
"%s)", _tmp101_, _tmp104_, _tmp105_);
#line 245 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp101_);
#line 250 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_debug ("calendar-system.vala:250: Using _NL_TIME_FIRST_WEEKDAY for system firs" \
"t of week");
#line 253 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp106_ = langinfo_lookup_int (_NL_TIME_FIRST_WEEKDAY);
#line 253 "/home/jim/git/california/src/calendar/calendar-system.vala"
	first_weekday = _tmp106_;
#line 257 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp107_ = nl_langinfo (_NL_TIME_WEEK_1STDAY);
#line 257 "/home/jim/git/california/src/calendar/calendar-system.vala"
	week_origin = (gint) _tmp107_;
#line 261 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp108_ = week_origin;
#line 261 "/home/jim/git/california/src/calendar/calendar-system.vala"
	switch (_tmp108_) {
#line 261 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case 19971130:
#line 1117 "calendar-system.c"
		{
#line 263 "/home/jim/git/california/src/calendar/calendar-system.vala"
			week_1stday = 0;
#line 264 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1123 "calendar-system.c"
		}
#line 261 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case 19971201:
#line 1127 "calendar-system.c"
		{
#line 267 "/home/jim/git/california/src/calendar/calendar-system.vala"
			week_1stday = 1;
#line 268 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1133 "calendar-system.c"
		}
		default:
		{
			gint _tmp109_ = 0;
			gint _tmp110_ = 0;
#line 271 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp109_ = week_origin;
#line 271 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp110_ = week_origin;
#line 271 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_warning ("calendar-system.vala:271: Unknown value of _NL_TIME_WEEK_1STDAY: %d (%" \
"Xh)", _tmp109_, (guint) _tmp110_);
#line 272 "/home/jim/git/california/src/calendar/calendar-system.vala"
			week_1stday = 0;
#line 273 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1149 "calendar-system.c"
		}
	}
#line 277 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp111_ = week_1stday;
#line 277 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp112_ = first_weekday;
#line 277 "/home/jim/git/california/src/calendar/calendar-system.vala"
	week_start = ((_tmp111_ + _tmp112_) - 1) % 7;
#line 280 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp113_ = week_start;
#line 280 "/home/jim/git/california/src/calendar/calendar-system.vala"
	switch (_tmp113_) {
#line 280 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case 0:
#line 1164 "calendar-system.c"
		{
#line 282 "/home/jim/git/california/src/calendar/calendar-system.vala"
			california_calendar_system_set_system_first_of_week (self, CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY);
#line 283 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1170 "calendar-system.c"
		}
#line 280 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case 1:
#line 1174 "calendar-system.c"
		{
#line 286 "/home/jim/git/california/src/calendar/calendar-system.vala"
			california_calendar_system_set_system_first_of_week (self, CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY);
#line 287 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1180 "calendar-system.c"
		}
		default:
		{
			gint _tmp114_ = 0;
#line 290 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_tmp114_ = week_start;
#line 290 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_warning ("calendar-system.vala:290: Unknown week start value, using default: %d", _tmp114_);
#line 291 "/home/jim/git/california/src/calendar/calendar-system.vala"
			california_calendar_system_set_system_first_of_week (self, CALIFORNIA_CALENDAR_FIRST_OF_WEEK_DEFAULT);
#line 292 "/home/jim/git/california/src/calendar/calendar-system.vala"
			break;
#line 1193 "calendar-system.c"
		}
	}
#line 301 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp115_ = self->priv->_system_first_of_week;
#line 301 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp116_ = california_calendar_first_of_week_to_string (_tmp115_);
#line 301 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp117_ = _tmp116_;
#line 301 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_debug ("calendar-system.vala:301: System first day of week: %s", _tmp117_);
#line 301 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp117_);
#line 171 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (formatted);
#line 171 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (unique_date);
#line 171 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return self;
#line 1212 "calendar-system.c"
}


static CaliforniaCalendarSystem* california_calendar_system_new (void) {
#line 171 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return california_calendar_system_construct (CALIFORNIA_CALENDAR_TYPE_SYSTEM);
#line 1219 "calendar-system.c"
}


void california_calendar_system_preinit (GError** error) {
	CaliforniaCalendarDBustimedated* _tmp0_ = NULL;
	CaliforniaCalendarDBustimedated* _tmp1_ = NULL;
	CaliforniaCalendarDBustimedated* _tmp2_ = NULL;
	CaliforniaCalendarDBusProperties* _tmp3_ = NULL;
	CaliforniaCalendarDBusProperties* _tmp4_ = NULL;
	CaliforniaCalendarDBusProperties* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = g_initable_new (CALIFORNIA_CALENDAR_DBUS_TYPE_TIMEDATED_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", CALIFORNIA_CALENDAR_DBUS_TIMEDATED_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", CALIFORNIA_CALENDAR_DBUS_TIMEDATED_OBJECT_PATH, "g-interface-name", "org.freedesktop.timedate1", "g-interface-info", g_type_get_qdata (CALIFORNIA_CALENDAR_DBUS_TYPE_TIMEDATED, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = (CaliforniaCalendarDBustimedated*) _tmp1_;
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_propagate_error (error, _inner_error_);
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
			return;
#line 1243 "calendar-system.c"
		} else {
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_clear_error (&_inner_error_);
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
			return;
#line 1251 "calendar-system.c"
		}
	}
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = _tmp0_;
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = NULL;
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system_timedated_service);
#line 305 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_timedated_service = _tmp2_;
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp4_ = g_initable_new (CALIFORNIA_CALENDAR_DBUS_TYPE_PROPERTIES_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", CALIFORNIA_CALENDAR_DBUS_PROPERTIES_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", CALIFORNIA_CALENDAR_DBUS_TIMEDATED_OBJECT_PATH, "g-interface-name", "org.freedesktop.DBus.Properties", "g-interface-info", g_type_get_qdata (CALIFORNIA_CALENDAR_DBUS_TYPE_PROPERTIES, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = (CaliforniaCalendarDBusProperties*) _tmp4_;
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_propagate_error (error, _inner_error_);
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_g_object_unref0 (_tmp0_);
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
			return;
#line 1276 "calendar-system.c"
		} else {
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
			_g_object_unref0 (_tmp0_);
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
			g_clear_error (&_inner_error_);
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
			return;
#line 1286 "calendar-system.c"
		}
	}
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp5_ = _tmp3_;
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = NULL;
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system_timedated_properties);
#line 307 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_timedated_properties = _tmp5_;
#line 304 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (_tmp3_);
#line 304 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (_tmp0_);
#line 1301 "calendar-system.c"
}


void california_calendar_system_init (void) {
	CaliforniaCalendarSystem* _tmp0_ = NULL;
	CaliforniaCalendarSystem* _tmp1_ = NULL;
	CaliforniaCalendarSystem* _tmp2_ = NULL;
	CaliforniaCalendarSystem* _tmp3_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp4_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp5_ = 0;
	CaliforniaCalendarSystem* _tmp6_ = NULL;
	CaliforniaCalendarSystem* _tmp7_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp8_ = 0;
#line 312 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system_get_instance ();
#line 312 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _tmp0_;
#line 312 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = california_calendar_system_new ();
#line 312 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = _tmp2_;
#line 312 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_instance (_tmp3_);
#line 312 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (_tmp3_);
#line 316 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp4_ = california_calendar_system_get_first_of_week ();
#line 316 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp5_ = _tmp4_;
#line 316 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp6_ = california_calendar_system_get_instance ();
#line 316 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp7_ = _tmp6_;
#line 316 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp8_ = _tmp7_->priv->_system_first_of_week;
#line 316 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_first_of_week (_tmp8_);
#line 1339 "calendar-system.c"
}


void california_calendar_system_terminate (void) {
	CaliforniaCalendarSystem* _tmp0_ = NULL;
	CaliforniaCalendarSystem* _tmp1_ = NULL;
#line 320 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system_get_instance ();
#line 320 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _tmp0_;
#line 320 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_instance (NULL);
#line 321 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system_timedated_service);
#line 321 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_timedated_service = NULL;
#line 322 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system_timedated_properties);
#line 322 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_timedated_properties = NULL;
#line 1360 "calendar-system.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 328 "/home/jim/git/california/src/calendar/calendar-system.vala"
	for (i = 0; i < stack_length; i++) {
#line 328 "/home/jim/git/california/src/calendar/calendar-system.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 328 "/home/jim/git/california/src/calendar/calendar-system.vala"
			return TRUE;
#line 1372 "calendar-system.c"
		}
	}
#line 328 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return FALSE;
#line 1377 "calendar-system.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 329 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return self ? g_object_ref (self) : NULL;
#line 1384 "calendar-system.c"
}


static void california_calendar_system_on_timedated_properties_changed (CaliforniaCalendarSystem* self, const gchar* interf, GHashTable* changed_properties_values, gchar** changed_properties, int changed_properties_length1) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 325 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_SYSTEM (self));
#line 325 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (interf != NULL);
#line 325 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (changed_properties_values != NULL);
#line 327 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = changed_properties_values;
#line 327 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = g_hash_table_contains (_tmp1_, CALIFORNIA_CALENDAR_DBUS_TIMEDATED_PROP_TIMEZONE);
#line 327 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (_tmp2_) {
#line 327 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp0_ = TRUE;
#line 1406 "calendar-system.c"
	} else {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 328 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp3_ = changed_properties;
#line 328 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp3__length1 = changed_properties_length1;
#line 328 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp0_ = _vala_string_array_contains (_tmp3_, _tmp3__length1, CALIFORNIA_CALENDAR_DBUS_TIMEDATED_PROP_TIMEZONE);
#line 1416 "calendar-system.c"
	}
#line 327 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (_tmp0_) {
#line 1420 "calendar-system.c"
		CaliforniaCalendarOlsonZone* old_zone = NULL;
		CaliforniaCalendarOlsonZone* _tmp4_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp5_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp6_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp7_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp8_ = NULL;
		CaliforniaCalendarDBustimedated* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp13_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp14_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp15_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		CaliforniaCalendarTimezone* old_timezone = NULL;
		CaliforniaCalendarTimezone* _tmp19_ = NULL;
		CaliforniaCalendarTimezone* _tmp20_ = NULL;
		CaliforniaCalendarTimezone* _tmp21_ = NULL;
		CaliforniaCalendarTimezone* _tmp22_ = NULL;
		CaliforniaCalendarTimezone* _tmp23_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp24_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp25_ = NULL;
		CaliforniaCalendarTimezone* _tmp26_ = NULL;
		CaliforniaCalendarTimezone* _tmp27_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp28_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp29_ = NULL;
		CaliforniaCalendarOlsonZone* _tmp30_ = NULL;
		CaliforniaCalendarTimezone* _tmp31_ = NULL;
		CaliforniaCalendarTimezone* _tmp32_ = NULL;
		CaliforniaCalendarTimezone* _tmp33_ = NULL;
#line 329 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp4_ = california_calendar_system_get_zone ();
#line 329 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp5_ = _tmp4_;
#line 329 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 329 "/home/jim/git/california/src/calendar/calendar-system.vala"
		old_zone = _tmp6_;
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp7_ = california_calendar_system_get_zone ();
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp8_ = _tmp7_;
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp9_ = california_calendar_system_timedated_service;
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp10_ = california_calendar_dbus_timedated_get_timezone (_tmp9_);
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp11_ = _tmp10_;
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp12_ = _tmp11_;
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp13_ = california_calendar_olson_zone_new (_tmp12_);
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp14_ = _tmp13_;
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		california_calendar_system_set_zone (_tmp14_);
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (_tmp14_);
#line 330 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_free0 (_tmp12_);
#line 331 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp15_ = california_calendar_system_get_zone ();
#line 331 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp16_ = _tmp15_;
#line 331 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp17_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 331 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp18_ = _tmp17_;
#line 331 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_debug ("calendar-system.vala:331: New local zone: %s", _tmp18_);
#line 331 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_free0 (_tmp18_);
#line 333 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp19_ = california_calendar_system_get_timezone ();
#line 333 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp20_ = _tmp19_;
#line 333 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 333 "/home/jim/git/california/src/calendar/calendar-system.vala"
		old_timezone = _tmp21_;
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp22_ = california_calendar_system_get_timezone ();
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp23_ = _tmp22_;
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp24_ = california_calendar_system_get_zone ();
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp25_ = _tmp24_;
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp26_ = california_calendar_timezone_new (_tmp25_);
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp27_ = _tmp26_;
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		california_calendar_system_set_timezone (_tmp27_);
#line 334 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (_tmp27_);
#line 338 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp28_ = old_zone;
#line 338 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp29_ = california_calendar_system_get_zone ();
#line 338 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp30_ = _tmp29_;
#line 338 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_signal_emit_by_name (self, "zone-changed", _tmp28_, _tmp30_);
#line 339 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp31_ = old_timezone;
#line 339 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp32_ = california_calendar_system_get_timezone ();
#line 339 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_tmp33_ = _tmp32_;
#line 339 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_signal_emit_by_name (self, "timezone-changed", _tmp31_, _tmp33_);
#line 342 "/home/jim/git/california/src/calendar/calendar-system.vala"
		california_calendar_system_update_today (self);
#line 327 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (old_timezone);
#line 327 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (old_zone);
#line 1541 "calendar-system.c"
	}
}


static gint california_calendar_system_next_check_today_interval_sec (CaliforniaCalendarSystem* self) {
	gint result = 0;
	CaliforniaCalendarExactTime* last_sec_of_day = NULL;
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
	CaliforniaCalendarTimezone* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	CaliforniaCalendarWallTime* _tmp5_ = NULL;
	CaliforniaCalendarExactTime* _tmp6_ = NULL;
	gint64 sec_to_midnight = 0LL;
	CaliforniaCalendarTimezone* _tmp7_ = NULL;
	CaliforniaCalendarTimezone* _tmp8_ = NULL;
	CaliforniaCalendarExactTime* _tmp9_ = NULL;
	CaliforniaCalendarExactTime* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	gint64 _tmp13_ = 0LL;
#line 346 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SYSTEM (self), 0);
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_timezone_get_local ();
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _tmp0_;
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = california_calendar_system_get_today ();
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = _tmp2_;
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp4_ = california_calendar_wall_time_get_latest ();
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp5_ = _tmp4_;
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp6_ = california_calendar_exact_time_new (_tmp1_, _tmp3_, _tmp5_);
#line 350 "/home/jim/git/california/src/calendar/calendar-system.vala"
	last_sec_of_day = _tmp6_;
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp7_ = california_calendar_timezone_get_local ();
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp8_ = _tmp7_;
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp9_ = california_calendar_exact_time_new_now (_tmp8_);
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp10_ = _tmp9_;
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp11_ = california_calendar_exact_time_difference (last_sec_of_day, _tmp10_);
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp12_ = _tmp11_ + 2;
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (_tmp10_);
#line 351 "/home/jim/git/california/src/calendar/calendar-system.vala"
	sec_to_midnight = _tmp12_;
#line 357 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp13_ = CLAMP (sec_to_midnight, (gint64) CALIFORNIA_CALENDAR_SYSTEM_MIN_CHECK_DATE_INTERVAL_SEC, (gint64) CALIFORNIA_CALENDAR_SYSTEM_MAX_CHECK_DATE_INTERVAL_SEC);
#line 357 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = (gint) _tmp13_;
#line 357 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (last_sec_of_day);
#line 357 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1606 "calendar-system.c"
}


static void california_calendar_system_check_today_changed (CaliforniaCalendarSystem* self) {
	gint _tmp0_ = 0;
	CaliforniaScheduled* _tmp1_ = NULL;
#line 361 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_SYSTEM (self));
#line 362 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_update_today (self);
#line 365 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system_next_check_today_interval_sec (self);
#line 365 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = california_scheduled_new_once_after_sec ((guint) _tmp0_, _california_calendar_system_check_today_changed_california_scheduled_schedule_once, self, CALIFORNIA_CALENDAR_SYSTEM_CHECK_DATE_PRIORITY);
#line 365 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (self->priv->scheduled_date_timer);
#line 365 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self->priv->scheduled_date_timer = _tmp1_;
#line 1625 "calendar-system.c"
}


static void california_calendar_system_update_today (CaliforniaCalendarSystem* self) {
	CaliforniaCalendarDate* new_today = NULL;
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
	CaliforniaCalendarTimezone* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	CaliforniaCalendarDate* old_today = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDate* _tmp9_ = NULL;
	CaliforniaCalendarDate* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarDate* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	CaliforniaCalendarDate* _tmp16_ = NULL;
	CaliforniaCalendarDate* _tmp17_ = NULL;
#line 369 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_SYSTEM (self));
#line 370 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_timezone_get_local ();
#line 370 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _tmp0_;
#line 370 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = california_calendar_date_new_now (_tmp1_);
#line 370 "/home/jim/git/california/src/calendar/calendar-system.vala"
	new_today = _tmp2_;
#line 371 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = new_today;
#line 371 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp4_ = california_calendar_system_get_today ();
#line 371 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp5_ = _tmp4_;
#line 371 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp6_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_HASHABLE, GeeHashable), _tmp5_);
#line 371 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (_tmp6_) {
#line 372 "/home/jim/git/california/src/calendar/calendar-system.vala"
		_g_object_unref0 (new_today);
#line 372 "/home/jim/git/california/src/calendar/calendar-system.vala"
		return;
#line 1674 "calendar-system.c"
	}
#line 374 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp7_ = california_calendar_system_get_today ();
#line 374 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp8_ = _tmp7_;
#line 374 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 374 "/home/jim/git/california/src/calendar/calendar-system.vala"
	old_today = _tmp9_;
#line 375 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp10_ = california_calendar_system_get_today ();
#line 375 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp11_ = _tmp10_;
#line 375 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp12_ = new_today;
#line 375 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_set_today (_tmp12_);
#line 376 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp13_ = new_today;
#line 376 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp14_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 376 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp15_ = _tmp14_;
#line 376 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_debug ("calendar-system.vala:376: Date changed: %s", _tmp15_);
#line 376 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (_tmp15_);
#line 378 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp16_ = old_today;
#line 378 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp17_ = new_today;
#line 378 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_emit_by_name (self, "today-changed", _tmp16_, _tmp17_);
#line 369 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (old_today);
#line 369 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (new_today);
#line 1712 "calendar-system.c"
}


static gchar* california_calendar_system_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarSystem * self;
	gchar* result = NULL;
	GObjectClass* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 381 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystem);
#line 382 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = G_OBJECT_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 382 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp0_);
#line 382 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = g_type_name (_tmp1_);
#line 382 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 382 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp3_;
#line 382 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1737 "calendar-system.c"
}


CaliforniaCalendarSystem* california_calendar_system_get_instance (void) {
	CaliforniaCalendarSystem* result;
	CaliforniaCalendarSystem* _tmp0_ = NULL;
#line 29 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__instance;
#line 29 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 29 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1750 "calendar-system.c"
}


static void california_calendar_system_set_instance (CaliforniaCalendarSystem* value) {
	CaliforniaCalendarSystem* _tmp0_ = NULL;
	CaliforniaCalendarSystem* _tmp1_ = NULL;
#line 29 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 29 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 29 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system__instance);
#line 29 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__instance = _tmp1_;
#line 1765 "calendar-system.c"
}


CaliforniaCalendarDate* california_calendar_system_get_today (void) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* _tmp0_ = NULL;
#line 36 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__today;
#line 36 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 36 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1778 "calendar-system.c"
}


static void california_calendar_system_set_today (CaliforniaCalendarDate* value) {
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 36 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 36 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 36 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system__today);
#line 36 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__today = _tmp1_;
#line 1793 "calendar-system.c"
}


CaliforniaCalendarExactTime* california_calendar_system_get_now (void) {
	CaliforniaCalendarExactTime* result;
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
	CaliforniaCalendarTimezone* _tmp1_ = NULL;
	CaliforniaCalendarExactTime* _tmp2_ = NULL;
#line 43 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_timezone_get_local ();
#line 43 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _tmp0_;
#line 43 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = california_calendar_exact_time_new_now (_tmp1_);
#line 43 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp2_;
#line 43 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1812 "calendar-system.c"
}


gboolean california_calendar_system_get_is_24hr (void) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 50 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__is_24hr;
#line 50 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 50 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1825 "calendar-system.c"
}


static void california_calendar_system_set_is_24hr (gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 50 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 50 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__is_24hr = _tmp0_;
#line 1835 "calendar-system.c"
}


CaliforniaCalendarDateOrdering california_calendar_system_get_date_ordering (void) {
	CaliforniaCalendarDateOrdering result;
	CaliforniaCalendarDateOrdering _tmp0_ = 0;
#line 61 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__date_ordering;
#line 61 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 61 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1848 "calendar-system.c"
}


void california_calendar_system_set_date_ordering (CaliforniaCalendarDateOrdering value) {
	CaliforniaCalendarDateOrdering _tmp0_ = 0;
#line 61 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 61 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__date_ordering = _tmp0_;
#line 1858 "calendar-system.c"
}


const gchar* california_calendar_system_get_date_separator (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 74 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__date_separator;
#line 74 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 74 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1871 "calendar-system.c"
}


void california_calendar_system_set_date_separator (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 74 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 74 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 74 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_free0 (california_calendar_system__date_separator);
#line 74 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__date_separator = _tmp1_;
#line 1886 "calendar-system.c"
}


CaliforniaCalendarOlsonZone* california_calendar_system_get_zone (void) {
	CaliforniaCalendarOlsonZone* result;
	CaliforniaCalendarOlsonZone* _tmp0_ = NULL;
#line 79 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__zone;
#line 79 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 79 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1899 "calendar-system.c"
}


static void california_calendar_system_set_zone (CaliforniaCalendarOlsonZone* value) {
	CaliforniaCalendarOlsonZone* _tmp0_ = NULL;
	CaliforniaCalendarOlsonZone* _tmp1_ = NULL;
#line 79 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 79 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 79 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system__zone);
#line 79 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__zone = _tmp1_;
#line 1914 "calendar-system.c"
}


CaliforniaCalendarTimezone* california_calendar_system_get_timezone (void) {
	CaliforniaCalendarTimezone* result;
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
#line 87 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__timezone;
#line 87 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 87 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1927 "calendar-system.c"
}


static void california_calendar_system_set_timezone (CaliforniaCalendarTimezone* value) {
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
	CaliforniaCalendarTimezone* _tmp1_ = NULL;
#line 87 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 87 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 87 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (california_calendar_system__timezone);
#line 87 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__timezone = _tmp1_;
#line 1942 "calendar-system.c"
}


CaliforniaCalendarFirstOfWeek california_calendar_system_get_first_of_week (void) {
	CaliforniaCalendarFirstOfWeek result;
	CaliforniaCalendarFirstOfWeek _tmp0_ = 0;
#line 111 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__first_of_week;
#line 111 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 111 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 1955 "calendar-system.c"
}


void california_calendar_system_set_first_of_week (CaliforniaCalendarFirstOfWeek value) {
	CaliforniaCalendarFirstOfWeek _tmp0_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp1_ = 0;
	CaliforniaCalendarFirstOfWeek old_fow = 0;
	CaliforniaCalendarFirstOfWeek _tmp2_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp3_ = 0;
	CaliforniaCalendarSystem* _tmp4_ = NULL;
	CaliforniaCalendarSystem* _tmp5_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp6_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp7_ = 0;
#line 115 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = california_calendar_system__first_of_week;
#line 115 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp1_ = value;
#line 115 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (_tmp0_ == _tmp1_) {
#line 116 "/home/jim/git/california/src/calendar/calendar-system.vala"
		return;
#line 1977 "calendar-system.c"
	}
#line 118 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp2_ = california_calendar_system__first_of_week;
#line 118 "/home/jim/git/california/src/calendar/calendar-system.vala"
	old_fow = _tmp2_;
#line 119 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp3_ = value;
#line 119 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system__first_of_week = _tmp3_;
#line 121 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp4_ = california_calendar_system_get_instance ();
#line 121 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp5_ = _tmp4_;
#line 121 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp6_ = old_fow;
#line 121 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp7_ = california_calendar_system__first_of_week;
#line 121 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_emit_by_name (_tmp5_, "first-of-week-changed", _tmp6_, _tmp7_);
#line 1997 "calendar-system.c"
}


CaliforniaCalendarFirstOfWeek california_calendar_system_get_system_first_of_week (CaliforniaCalendarSystem* self) {
	CaliforniaCalendarFirstOfWeek result;
	CaliforniaCalendarFirstOfWeek _tmp0_ = 0;
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SYSTEM (self), 0);
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = self->priv->_system_first_of_week;
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	result = _tmp0_;
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	return result;
#line 2012 "calendar-system.c"
}


static void california_calendar_system_set_system_first_of_week (CaliforniaCalendarSystem* self, CaliforniaCalendarFirstOfWeek value) {
	CaliforniaCalendarFirstOfWeek _tmp0_ = 0;
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_SYSTEM (self));
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = value;
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self->priv->_system_first_of_week = _tmp0_;
#line 130 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_object_notify ((GObject *) self, "system-first-of-week");
#line 2026 "calendar-system.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (n_param_values == 3);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data1 = closure->data;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data2 = param_values->data[0].v_pointer;
#line 2045 "calendar-system.c"
	} else {
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data1 = param_values->data[0].v_pointer;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data2 = closure->data;
#line 2051 "calendar-system.c"
	}
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 2057 "calendar-system.c"
}


static void g_cclosure_user_marshal_VOID__ENUM_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__ENUM_ENUM) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_return_if_fail (n_param_values == 3);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data1 = closure->data;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data2 = param_values->data[0].v_pointer;
#line 2076 "calendar-system.c"
	} else {
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data1 = param_values->data[0].v_pointer;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		data2 = closure->data;
#line 2082 "calendar-system.c"
	}
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	callback = (GMarshalFunc_VOID__ENUM_ENUM) (marshal_data ? marshal_data : cc->callback);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_enum (param_values + 2), data2);
#line 2088 "calendar-system.c"
}


static void california_calendar_system_class_init (CaliforniaCalendarSystemClass * klass) {
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	california_calendar_system_parent_class = g_type_class_peek_parent (klass);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarSystemPrivate));
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_calendar_system_real_to_string;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_system_get_property;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_system_set_property;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_system_finalize;
#line 2105 "calendar-system.c"
	/**
	     * System-defined (or locale-defined) start of the week.
	     *
	     * @see first_of_week
	     */
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_SYSTEM_SYSTEM_FIRST_OF_WEEK, g_param_spec_enum ("system-first-of-week", "system-first-of-week", "system-first-of-week", CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2113 "calendar-system.c"
	/**
	     * Fired when {@link today} changes.
	     *
	     * This indicates that the system time has crossed midnight (potentially either direction since
	     * clock adjustments can happen for a variety of reasons).
	     */
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_new ("today_changed", CALIFORNIA_CALENDAR_TYPE_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, CALIFORNIA_CALENDAR_TYPE_DATE, CALIFORNIA_CALENDAR_TYPE_DATE);
#line 2122 "calendar-system.c"
	/**
	     * Fired when {@link is_24hr} changes.
	     *
	     * This means the user has changed the their clock format configuration.
	     */
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_new ("is_24hr_changed", CALIFORNIA_CALENDAR_TYPE_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 2130 "calendar-system.c"
	/**
	     * Fired when {@link zone} changes.
	     *
	     * This generally indicates that the user has changed system time zone manually or that the
	     * system detected the change through geolocation services.
	     */
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_new ("zone_changed", CALIFORNIA_CALENDAR_TYPE_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE, CALIFORNIA_CALENDAR_TYPE_OLSON_ZONE);
#line 2139 "calendar-system.c"
	/**
	     * Fired when {@link local_timezone} changes due to system configuration changes.
	     */
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_new ("timezone_changed", CALIFORNIA_CALENDAR_TYPE_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CALIFORNIA_CALENDAR_TYPE_TIMEZONE);
#line 2145 "calendar-system.c"
	/**
	     * Fired when {@link first_of_week} changes due to user configuration.
	     */
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	g_signal_new ("first_of_week_changed", CALIFORNIA_CALENDAR_TYPE_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_ENUM, G_TYPE_NONE, 2, CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK, CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK);
#line 2151 "calendar-system.c"
}


static void california_calendar_system_instance_init (CaliforniaCalendarSystem * self) {
	GSettings* _tmp0_ = NULL;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self->priv = CALIFORNIA_CALENDAR_SYSTEM_GET_PRIVATE (self);
#line 168 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_tmp0_ = g_settings_new (CALIFORNIA_CALENDAR_SYSTEM_CLOCK_FORMAT_SCHEMA);
#line 168 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self->priv->system_clock_format_schema = _tmp0_;
#line 2163 "calendar-system.c"
}


static void california_calendar_system_finalize (GObject* obj) {
	CaliforniaCalendarSystem * self;
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystem);
#line 168 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (self->priv->system_clock_format_schema);
#line 169 "/home/jim/git/california/src/calendar/calendar-system.vala"
	_g_object_unref0 (self->priv->scheduled_date_timer);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	G_OBJECT_CLASS (california_calendar_system_parent_class)->finalize (obj);
#line 2177 "calendar-system.c"
}


/**
 * A singleton offering system-based calendar and time information and updates of important changes.
 *
 * Most of System's properties are static as a convenience for callers (to avoid having to always
 * reference {@link instance}).  Since static properties have no notification mechanism, callers
 * interested in being notified of changes must subscribe to the instance's particular signals,
 * i.e. {@link zone_changed}.
 */
GType california_calendar_system_get_type (void) {
	static volatile gsize california_calendar_system_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_system_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarSystem), 0, (GInstanceInitFunc) california_calendar_system_instance_init, NULL };
		GType california_calendar_system_type_id;
		california_calendar_system_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarSystem", &g_define_type_info, 0);
		g_once_init_leave (&california_calendar_system_type_id__volatile, california_calendar_system_type_id);
	}
	return california_calendar_system_type_id__volatile;
}


static void _vala_california_calendar_system_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystem);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	switch (property_id) {
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case CALIFORNIA_CALENDAR_SYSTEM_SYSTEM_FIRST_OF_WEEK:
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		g_value_set_enum (value, california_calendar_system_get_system_first_of_week (self));
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		break;
#line 2212 "calendar-system.c"
		default:
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		break;
#line 2218 "calendar-system.c"
	}
}


static void _vala_california_calendar_system_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_SYSTEM, CaliforniaCalendarSystem);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
	switch (property_id) {
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		case CALIFORNIA_CALENDAR_SYSTEM_SYSTEM_FIRST_OF_WEEK:
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		california_calendar_system_set_system_first_of_week (self, g_value_get_enum (value));
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		break;
#line 2234 "calendar-system.c"
		default:
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 18 "/home/jim/git/california/src/calendar/calendar-system.vala"
		break;
#line 2240 "calendar-system.c"
	}
}



