/* calendar-date.c generated by valac 0.26.0, the Vala compiler
 * generated from calendar-date.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;
typedef struct _CaliforniaCalendarSpanPrivate CaliforniaCalendarSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;
typedef struct _CaliforniaCalendarUnitPrivate CaliforniaCalendarUnitPrivate;
typedef struct _CaliforniaCalendarDatePrivate CaliforniaCalendarDatePrivate;

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK (california_calendar_day_of_week_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeek))
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeekClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_WEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK))
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeekClass))

typedef struct _CaliforniaCalendarDayOfWeek CaliforniaCalendarDayOfWeek;
typedef struct _CaliforniaCalendarDayOfWeekClass CaliforniaCalendarDayOfWeekClass;

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH (california_calendar_day_of_month_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonth))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))

typedef struct _CaliforniaCalendarDayOfMonth CaliforniaCalendarDayOfMonth;
typedef struct _CaliforniaCalendarDayOfMonthClass CaliforniaCalendarDayOfMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH (california_calendar_month_get_type ())
#define CALIFORNIA_CALENDAR_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonth))
#define CALIFORNIA_CALENDAR_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))
#define CALIFORNIA_CALENDAR_IS_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_IS_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))

typedef struct _CaliforniaCalendarMonth CaliforniaCalendarMonth;
typedef struct _CaliforniaCalendarMonthClass CaliforniaCalendarMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;

#define CALIFORNIA_CALENDAR_DATE_TYPE_PRETTY_FLAG (california_calendar_date_pretty_flag_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK (california_calendar_first_of_week_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_WEEK (california_calendar_week_get_type ())
#define CALIFORNIA_CALENDAR_WEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek))
#define CALIFORNIA_CALENDAR_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))
#define CALIFORNIA_CALENDAR_IS_WEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_IS_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_WEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))

typedef struct _CaliforniaCalendarWeek CaliforniaCalendarWeek;
typedef struct _CaliforniaCalendarWeekClass CaliforniaCalendarWeekClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR (california_calendar_month_of_year_get_type ())
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))

typedef struct _CaliforniaCalendarMonthOfYear CaliforniaCalendarMonthOfYear;
typedef struct _CaliforniaCalendarMonthOfYearClass CaliforniaCalendarMonthOfYearClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSpanPrivate * priv;
};

struct _CaliforniaCalendarSpanClass {
	CaliforniaBaseObjectClass parent_class;
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (CaliforniaCollectionSimpleIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (CaliforniaCollectionSimpleIterable* self);
	GDestroyNotify (*get_g_destroy_func) (CaliforniaCollectionSimpleIterable* self);
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarUnit {
	CaliforniaCalendarSpan parent_instance;
	CaliforniaCalendarUnitPrivate * priv;
};

struct _CaliforniaCalendarUnitClass {
	CaliforniaCalendarSpanClass parent_class;
	gpointer (*adjust) (CaliforniaCalendarUnit* self, gint quantity);
	gint (*difference) (CaliforniaCalendarUnit* self, gconstpointer other);
};

struct _CaliforniaCalendarDate {
	CaliforniaCalendarUnit parent_instance;
	CaliforniaCalendarDatePrivate * priv;
};

struct _CaliforniaCalendarDateClass {
	CaliforniaCalendarUnitClass parent_class;
};

struct _CaliforniaCalendarDatePrivate {
	CaliforniaCalendarDayOfWeek* _day_of_week;
	CaliforniaCalendarDayOfMonth* _day_of_month;
	gint _day_of_year;
	CaliforniaCalendarMonth* _month;
	CaliforniaCalendarYear* _year;
	GDate gdate;
};

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV = 1 << 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT = 1 << 1,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR = 1 << 2,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR = 1 << 3,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY = 1 << 4,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK = 1 << 5
} CaliforniaCalendarDatePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;

typedef enum  {
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_DEFAULT = CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY
} CaliforniaCalendarFirstOfWeek;


static gpointer california_calendar_date_parent_class = NULL;
extern const gchar* california_calendar_FMT_FULL_DATE;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_YEAR;
static GeeComparableIface* california_calendar_date_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_date_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_day_of_week_get_type (void) G_GNUC_CONST;
GType california_calendar_day_of_month_get_type (void) G_GNUC_CONST;
GType california_calendar_month_get_type (void) G_GNUC_CONST;
GType california_calendar_year_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDatePrivate))
enum  {
	CALIFORNIA_CALENDAR_DATE_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_DATE_START_DATE,
	CALIFORNIA_CALENDAR_DATE_END_DATE,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR,
	CALIFORNIA_CALENDAR_DATE_MONTH,
	CALIFORNIA_CALENDAR_DATE_YEAR
};
GType california_calendar_date_pretty_flag_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DATE_PROP_DAY_OF_WEEK "day-of-week"
#define CALIFORNIA_CALENDAR_DATE_PROP_DAY_OF_MONTH "day-of-month"
#define CALIFORNIA_CALENDAR_DATE_PROP_MONTH "month"
#define CALIFORNIA_CALENDAR_DATE_PROP_YEAR "year"
GQuark california_calendar_error_quark (void);
CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarUnit* california_calendar_unit_construct_uninitialized (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit);
GDateDay california_calendar_day_of_month_to_date_day (CaliforniaCalendarDayOfMonth* self);
GDateMonth california_calendar_month_to_date_month (CaliforniaCalendarMonth* self);
GDateYear california_calendar_year_to_date_year (CaliforniaCalendarYear* self);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
CaliforniaCalendarDayOfWeek* california_calendar_day_of_week_from_gdate (GDate* date);
static void california_calendar_date_set_day_of_week (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfWeek* value);
static void california_calendar_date_set_day_of_month (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfMonth* value);
static void california_calendar_date_set_day_of_year (CaliforniaCalendarDate* self, gint value);
static void california_calendar_date_set_month (CaliforniaCalendarDate* self, CaliforniaCalendarMonth* value);
static void california_calendar_date_set_year (CaliforniaCalendarDate* self, CaliforniaCalendarYear* value);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDayOfMonth* california_calendar_exact_time_get_day_of_month (CaliforniaCalendarExactTime* self);
CaliforniaCalendarMonth* california_calendar_exact_time_get_month (CaliforniaCalendarExactTime* self);
CaliforniaCalendarYear* california_calendar_exact_time_get_year (CaliforniaCalendarExactTime* self);
CaliforniaCalendarDayOfMonth* california_calendar_date_get_day_of_month (CaliforniaCalendarDate* self);
CaliforniaCalendarMonth* california_calendar_date_get_month (CaliforniaCalendarDate* self);
CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_date_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_exact_time_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_date_new_from_gdate (GDate* gdate);
CaliforniaCalendarDate* california_calendar_date_construct_from_gdate (GType object_type, GDate* gdate);
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_from_gdate (GDate* gdate);
CaliforniaCalendarMonth* california_calendar_month_from_gdate (GDate* gdate);
CaliforniaCalendarYear* california_calendar_year_new_from_gdate (GDate* gdate);
CaliforniaCalendarYear* california_calendar_year_construct_from_gdate (GType object_type, GDate* gdate);
GType california_calendar_first_of_week_get_type (void) G_GNUC_CONST;
GType california_calendar_week_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWeek* california_calendar_date_week_of (CaliforniaCalendarDate* self, CaliforniaCalendarFirstOfWeek first);
CaliforniaCalendarDayOfWeek* california_calendar_date_get_day_of_week (CaliforniaCalendarDate* self);
gint california_calendar_day_of_week_ordinal (CaliforniaCalendarDayOfWeek* self, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarDayOfWeek* california_calendar_first_of_week_as_day_of_week (CaliforniaCalendarFirstOfWeek self);
CaliforniaCalendarDate* california_calendar_date_adjust_by (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit);
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_MAX 7
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_MIN 1
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT ((CALIFORNIA_CALENDAR_DAY_OF_WEEK_MAX - CALIFORNIA_CALENDAR_DAY_OF_WEEK_MIN) + 1)
GType california_calendar_month_of_year_get_type (void) G_GNUC_CONST;
CaliforniaCalendarMonthOfYear* california_calendar_date_month_of_year (CaliforniaCalendarDate* self);
CaliforniaCalendarWeek* california_calendar_week_new (CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarWeek* california_calendar_week_construct (GType object_type, CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_new (CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_construct (GType object_type, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
static CaliforniaCalendarDate* california_calendar_date_real_adjust (CaliforniaCalendarUnit* base, gint quantity);
CaliforniaCalendarDate* california_calendar_date_upcoming (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target);
static CaliforniaCalendarDate* california_calendar_date_upcoming_prior (CaliforniaCalendarDate* self, gboolean inclusive, gint adjustment, GeePredicate predicate, void* predicate_target);
CaliforniaCalendarDate* california_calendar_date_prior (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target);
gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity);
static gint california_calendar_date_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarDate* other);
CaliforniaCalendarDate* california_calendar_date_clamp (CaliforniaCalendarDate* self, CaliforniaCalendarDate* min, CaliforniaCalendarDate* max);
static gint california_calendar_date_real_compare_to (GeeComparable* base, CaliforniaCalendarDate* other);
static gboolean california_calendar_date_real_equal_to (GeeHashable* base, CaliforniaCalendarDate* other);
static guint california_calendar_date_real_hash (GeeHashable* base);
gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt);
gchar* california_calendar_date_to_standard_string (CaliforniaCalendarDate* self);
gchar* california_calendar_date_to_pretty_string (CaliforniaCalendarDate* self, CaliforniaCalendarDatePrettyFlag flags);
CaliforniaCalendarDate* california_calendar_system_get_today (void);
gchar* california_string_reduce_whitespace (const gchar* str);
gchar* california_string_remove_leading_chars (const gchar* str, gunichar ch, const gchar* delims);
static gchar* california_calendar_date_real_to_string (CaliforniaBaseObject* base);
gint california_calendar_date_get_day_of_year (CaliforniaCalendarDate* self);
static void california_calendar_date_finalize (GObject* obj);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
static void _vala_california_calendar_date_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_date_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Options for {@link to_pretty_string}.
     */
GType california_calendar_date_pretty_flag_get_type (void) {
	static volatile gsize california_calendar_date_pretty_flag_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_pretty_flag_type_id__volatile)) {
		static const GFlagsValue values[] = {{CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE", "none"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV", "abbrev"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT", "compact"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR", "include-year"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR", "include-other-year"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY", "no-today"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK", "no-day-of-week"}, {0, NULL, NULL}};
		GType california_calendar_date_pretty_flag_type_id;
		california_calendar_date_pretty_flag_type_id = g_flags_register_static ("CaliforniaCalendarDatePrettyFlag", values);
		g_once_init_leave (&california_calendar_date_pretty_flag_type_id__volatile, california_calendar_date_pretty_flag_type_id);
	}
	return california_calendar_date_pretty_flag_type_id__volatile;
}


/**
     * Creates a new {@link Date} object for the day, month, and year.
     *
     * @throws CalendarError if an invalid calendar day
     */
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
	GDateDay _tmp1_ = '\0';
	CaliforniaCalendarMonth* _tmp2_ = NULL;
	GDateMonth _tmp3_ = 0;
	CaliforniaCalendarYear* _tmp4_ = NULL;
	GDateYear _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	GDate _tmp18_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp19_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp20_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	CaliforniaCalendarMonth* _tmp23_ = NULL;
	CaliforniaCalendarYear* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH (day_of_month), NULL);
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH (month), NULL);
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (year), NULL);
#line 94 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = day_of_month;
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_day_of_month_to_date_day (_tmp0_);
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = month;
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = california_calendar_month_to_date_month (_tmp2_);
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = year;
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = california_calendar_year_to_date_year (_tmp4_);
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&self->priv->gdate, _tmp1_, (gint) _tmp3_, _tmp5_);
#line 97 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = g_date_valid (&self->priv->gdate);
#line 97 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp6_) {
#line 442 "calendar-date.c"
		CaliforniaCalendarDayOfMonth* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		CaliforniaCalendarMonth* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		CaliforniaCalendarYear* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = day_of_month;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp8_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = _tmp8_;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = month;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = _tmp11_;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = year;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = _tmp14_;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp16_ = g_error_new (CALIFORNIA_CALENDAR_ERROR, CALIFORNIA_CALENDAR_ERROR_INVALID, "Invalid day/month/year %s/%s/%s", _tmp9_, _tmp12_, _tmp15_);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp17_ = _tmp16_;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp15_);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp12_);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp9_);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_inner_error_ = _tmp17_;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_propagate_error (error, _inner_error_);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_g_object_unref0 (self);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return NULL;
#line 492 "calendar-date.c"
		} else {
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_clear_error (&_inner_error_);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return NULL;
#line 500 "calendar-date.c"
		}
	}
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = self->priv->gdate;
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp19_ = california_calendar_day_of_week_from_gdate (&_tmp18_);
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp20_ = _tmp19_;
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp20_);
#line 102 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp20_);
#line 103 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = day_of_month;
#line 103 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp21_);
#line 104 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = g_date_get_day_of_year (&self->priv->gdate);
#line 104 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp22_);
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp23_ = month;
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp23_);
#line 106 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = year;
#line 106 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp24_);
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 531 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error) {
#line 93 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct (CALIFORNIA_CALENDAR_TYPE_DATE, day_of_month, month, year, error);
#line 538 "calendar-date.c"
}


/**
     * Creates a {@link Date} for the {@link ExactTime}.
     */
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarExactTime* _tmp0_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp2_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp3_ = NULL;
	CaliforniaCalendarExactTime* _tmp4_ = NULL;
	CaliforniaCalendarMonth* _tmp5_ = NULL;
	CaliforniaCalendarMonth* _tmp6_ = NULL;
	CaliforniaCalendarMonth* _tmp7_ = NULL;
	CaliforniaCalendarExactTime* _tmp8_ = NULL;
	CaliforniaCalendarYear* _tmp9_ = NULL;
	CaliforniaCalendarYear* _tmp10_ = NULL;
	CaliforniaCalendarYear* _tmp11_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp12_ = NULL;
	GDateDay _tmp13_ = '\0';
	CaliforniaCalendarMonth* _tmp14_ = NULL;
	GDateMonth _tmp15_ = 0;
	CaliforniaCalendarYear* _tmp16_ = NULL;
	GDateYear _tmp17_ = 0U;
	gboolean _tmp18_ = FALSE;
	GDate _tmp19_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp20_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
#line 112 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME (exact_time), NULL);
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = exact_time;
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_exact_time_get_day_of_month (_tmp0_);
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_;
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = _tmp2_;
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp3_);
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp3_);
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = exact_time;
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = california_calendar_exact_time_get_month (_tmp4_);
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = _tmp5_;
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = _tmp6_;
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp7_);
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp7_);
#line 118 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = exact_time;
#line 118 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = california_calendar_exact_time_get_year (_tmp8_);
#line 118 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = _tmp9_;
#line 118 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp11_ = _tmp10_;
#line 118 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp11_);
#line 118 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp11_);
#line 120 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp12_ = self->priv->_day_of_month;
#line 120 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp13_ = california_calendar_day_of_month_to_date_day (_tmp12_);
#line 120 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = self->priv->_month;
#line 120 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp15_ = california_calendar_month_to_date_month (_tmp14_);
#line 120 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = self->priv->_year;
#line 120 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_year_to_date_year (_tmp16_);
#line 120 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&self->priv->gdate, _tmp13_, (gint) _tmp15_, _tmp17_);
#line 121 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = g_date_valid (&self->priv->gdate);
#line 121 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp18_, "gdate.valid()");
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp19_ = self->priv->gdate;
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp20_ = california_calendar_day_of_week_from_gdate (&_tmp19_);
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = _tmp20_;
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp21_);
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp21_);
#line 124 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = g_date_get_day_of_year (&self->priv->gdate);
#line 124 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp22_);
#line 112 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 644 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time) {
#line 112 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_from_exact_time (CALIFORNIA_CALENDAR_TYPE_DATE, exact_time);
#line 651 "calendar-date.c"
}


/**
     * Creates a {@link Date} that corresponds to the current time in the specified {@link Timezone}.
     */
CaliforniaCalendarDate* california_calendar_date_construct_now (GType object_type, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
	CaliforniaCalendarExactTime* _tmp1_ = NULL;
	CaliforniaCalendarExactTime* _tmp2_ = NULL;
#line 130 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 131 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = tz;
#line 131 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_exact_time_new_now (_tmp0_);
#line 131 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_;
#line 131 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_date_construct_from_exact_time (object_type, _tmp2_);
#line 131 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp2_);
#line 130 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 677 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_now (CaliforniaCalendarTimezone* tz) {
#line 130 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_now (CALIFORNIA_CALENDAR_TYPE_DATE, tz);
#line 684 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_construct_from_gdate (GType object_type, GDate* gdate) {
	CaliforniaCalendarDate * self = NULL;
	gboolean _tmp0_ = FALSE;
	GDate _tmp1_ = {0};
	GDate _tmp2_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp3_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp4_ = NULL;
	GDate _tmp5_ = {0};
	CaliforniaCalendarDayOfMonth* _tmp6_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	GDate _tmp9_ = {0};
	CaliforniaCalendarMonth* _tmp10_ = NULL;
	CaliforniaCalendarMonth* _tmp11_ = NULL;
	GDate _tmp12_ = {0};
	CaliforniaCalendarYear* _tmp13_ = NULL;
	CaliforniaCalendarYear* _tmp14_ = NULL;
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (gdate != NULL, NULL);
#line 135 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 137 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_date_valid (gdate);
#line 137 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp0_, "gdate.valid()");
#line 139 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = *gdate;
#line 139 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->gdate = _tmp1_;
#line 141 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = *gdate;
#line 141 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = california_calendar_day_of_week_from_gdate (&_tmp2_);
#line 141 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = _tmp3_;
#line 141 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp4_);
#line 141 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp4_);
#line 142 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = *gdate;
#line 142 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = california_calendar_day_of_month_from_gdate (&_tmp5_);
#line 142 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = _tmp6_;
#line 142 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp7_);
#line 142 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp7_);
#line 143 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = g_date_get_day_of_year (gdate);
#line 143 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp8_);
#line 144 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = *gdate;
#line 144 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = california_calendar_month_from_gdate (&_tmp9_);
#line 144 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp11_ = _tmp10_;
#line 144 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp11_);
#line 144 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp11_);
#line 145 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp12_ = *gdate;
#line 145 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp13_ = california_calendar_year_new_from_gdate (&_tmp12_);
#line 145 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = _tmp13_;
#line 145 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp14_);
#line 145 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp14_);
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 763 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_from_gdate (GDate* gdate) {
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_from_gdate (CALIFORNIA_CALENDAR_TYPE_DATE, gdate);
#line 770 "calendar-date.c"
}


/**
     * Returns the {@link Week} the {@link Date} falls in.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 158 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self ? g_object_ref (self) : NULL;
#line 780 "calendar-date.c"
}


CaliforniaCalendarWeek* california_calendar_date_week_of (CaliforniaCalendarDate* self, CaliforniaCalendarFirstOfWeek first) {
	CaliforniaCalendarWeek* result = NULL;
	gint ahead = 0;
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp1_ = 0;
	gint _tmp2_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp3_ = 0;
	CaliforniaCalendarDayOfWeek* _tmp4_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp5_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	CaliforniaCalendarDate* start = NULL;
	gint _tmp10_ = 0;
	CaliforniaCalendarDate* end = NULL;
	CaliforniaCalendarDate* _tmp16_ = NULL;
	CaliforniaCalendarDate* _tmp17_ = NULL;
	gint week_of_year = 0;
	CaliforniaCalendarFirstOfWeek _tmp18_ = 0;
	GDate first_of_month = {0};
	CaliforniaCalendarMonth* _tmp21_ = NULL;
	GDateMonth _tmp22_ = 0;
	CaliforniaCalendarYear* _tmp23_ = NULL;
	GDateYear _tmp24_ = 0U;
	gboolean _tmp25_ = FALSE;
	gint week_of_month = 0;
	CaliforniaCalendarFirstOfWeek _tmp26_ = 0;
	CaliforniaCalendarDate* _tmp31_ = NULL;
	CaliforniaCalendarDate* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	CaliforniaCalendarMonthOfYear* _tmp35_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp36_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp37_ = 0;
	CaliforniaCalendarWeek* _tmp38_ = NULL;
	CaliforniaCalendarWeek* _tmp39_ = NULL;
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_week;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = first;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_day_of_week_ordinal (_tmp0_, _tmp1_);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = first;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = california_calendar_first_of_week_as_day_of_week (_tmp3_);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = _tmp4_;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = first;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = california_calendar_day_of_week_ordinal (_tmp5_, _tmp6_);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = _tmp2_ - _tmp7_;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp5_);
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
	ahead = _tmp8_;
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = ahead;
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp9_ >= 0, "ahead >= 0");
#line 157 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = ahead;
#line 157 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp10_ == 0) {
#line 853 "calendar-date.c"
		CaliforniaCalendarDate* _tmp11_ = NULL;
#line 158 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = _g_object_ref0 (self);
#line 158 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (start);
#line 158 "/home/jim/git/california/src/calendar/calendar-date.vala"
		start = _tmp11_;
#line 861 "calendar-date.c"
	} else {
		GDate clone = {0};
		GDate _tmp12_ = {0};
		gint _tmp13_ = 0;
		GDate _tmp14_ = {0};
		CaliforniaCalendarDate* _tmp15_ = NULL;
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = self->priv->gdate;
#line 160 "/home/jim/git/california/src/calendar/calendar-date.vala"
		clone = _tmp12_;
#line 161 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = ahead;
#line 161 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_date_subtract_days (&clone, (guint) _tmp13_);
#line 162 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = clone;
#line 162 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = california_calendar_date_new_from_gdate (&_tmp14_);
#line 162 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (start);
#line 162 "/home/jim/git/california/src/calendar/calendar-date.vala"
		start = _tmp15_;
#line 884 "calendar-date.c"
	}
#line 166 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = start;
#line 166 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_date_adjust_by (_tmp16_, CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT - 1, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 166 "/home/jim/git/california/src/calendar/calendar-date.vala"
	end = _tmp17_;
#line 170 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = first;
#line 170 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp18_) {
#line 170 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY:
#line 898 "calendar-date.c"
		{
			guint _tmp19_ = 0U;
#line 172 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp19_ = g_date_get_monday_week_of_year (&self->priv->gdate);
#line 172 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_year = (gint) _tmp19_;
#line 173 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 907 "calendar-date.c"
		}
#line 170 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY:
#line 911 "calendar-date.c"
		{
			guint _tmp20_ = 0U;
#line 176 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp20_ = g_date_get_sunday_week_of_year (&self->priv->gdate);
#line 176 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_year = (gint) _tmp20_;
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 920 "calendar-date.c"
		}
		default:
		{
#line 180 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 926 "calendar-date.c"
		}
	}
#line 184 "/home/jim/git/california/src/calendar/calendar-date.vala"
	memset (&first_of_month, 0, sizeof (GDate));
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = self->priv->_month;
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = california_calendar_month_to_date_month (_tmp21_);
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp23_ = self->priv->_year;
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = california_calendar_year_to_date_year (_tmp23_);
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&first_of_month, (GDateDay) 1, (gint) _tmp22_, _tmp24_);
#line 186 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp25_ = g_date_valid (&first_of_month);
#line 186 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp25_, "first_of_month.valid()");
#line 189 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp26_ = first;
#line 189 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp26_) {
#line 189 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY:
#line 951 "calendar-date.c"
		{
			gint _tmp27_ = 0;
			guint _tmp28_ = 0U;
#line 191 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp27_ = week_of_year;
#line 191 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp28_ = g_date_get_monday_week_of_year (&first_of_month);
#line 191 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_month = (_tmp27_ - ((gint) _tmp28_)) + 1;
#line 192 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 963 "calendar-date.c"
		}
#line 189 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY:
#line 967 "calendar-date.c"
		{
			gint _tmp29_ = 0;
			guint _tmp30_ = 0U;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp29_ = week_of_year;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp30_ = g_date_get_sunday_week_of_year (&first_of_month);
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_month = (_tmp29_ - ((gint) _tmp30_)) + 1;
#line 196 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 979 "calendar-date.c"
		}
		default:
		{
#line 199 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 985 "calendar-date.c"
		}
	}
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp31_ = start;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp32_ = end;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp33_ = week_of_month;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp34_ = week_of_year;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp35_ = california_calendar_date_month_of_year (self);
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp36_ = _tmp35_;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp37_ = first;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp38_ = california_calendar_week_new (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp36_, _tmp37_);
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp39_ = _tmp38_;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp36_);
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp39_;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (end);
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (start);
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1016 "calendar-date.c"
}


/**
     * Returns the {@link MonthOfYear} the {@link Date} falls in.
     */
CaliforniaCalendarMonthOfYear* california_calendar_date_month_of_year (CaliforniaCalendarDate* self) {
	CaliforniaCalendarMonthOfYear* result = NULL;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp2_ = NULL;
#line 208 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_month;
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = self->priv->_year;
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_month_of_year_new (_tmp0_, _tmp1_);
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1040 "calendar-date.c"
}


/**
     * @inheritDoc
     */
static CaliforniaCalendarDate* california_calendar_date_real_adjust (CaliforniaCalendarUnit* base, gint quantity) {
	CaliforniaCalendarDate * self;
	CaliforniaCalendarDate* result = NULL;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 215 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 216 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = quantity;
#line 216 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_date_adjust_by (self, _tmp0_, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 216 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_;
#line 216 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1062 "calendar-date.c"
}


/**
     * Returns a new {@link Date} adjusted from this Date by the specifed quantity of time.
     *
     * Subtraction (adjusting to a past date) is acheived by using a negative quantity.
     */
CaliforniaCalendarDate* california_calendar_date_adjust_by (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit) {
	CaliforniaCalendarDate* result = NULL;
	gint _tmp0_ = 0;
	GDate clone = {0};
	GDate _tmp2_ = {0};
	CaliforniaCalendarDateUnit _tmp3_ = 0;
	GDate _tmp16_ = {0};
	CaliforniaCalendarDate* _tmp17_ = NULL;
#line 224 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 225 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = quantity;
#line 225 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp0_ == 0) {
#line 1085 "calendar-date.c"
		CaliforniaCalendarDate* _tmp1_ = NULL;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
		result = _tmp1_;
#line 226 "/home/jim/git/california/src/calendar/calendar-date.vala"
		return result;
#line 1093 "calendar-date.c"
	}
#line 228 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = self->priv->gdate;
#line 228 "/home/jim/git/california/src/calendar/calendar-date.vala"
	clone = _tmp2_;
#line 229 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = unit;
#line 229 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp3_) {
#line 229 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_DAY:
#line 1105 "calendar-date.c"
		{
			gint _tmp4_ = 0;
#line 231 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp4_ = quantity;
#line 231 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp4_ > 0) {
#line 1112 "calendar-date.c"
				gint _tmp5_ = 0;
#line 232 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp5_ = quantity;
#line 232 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_days (&clone, (guint) _tmp5_);
#line 1118 "calendar-date.c"
			} else {
				gint _tmp6_ = 0;
#line 234 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp6_ = quantity;
#line 234 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_days (&clone, (guint) (-_tmp6_));
#line 1125 "calendar-date.c"
			}
#line 235 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1129 "calendar-date.c"
		}
#line 229 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_WEEK:
#line 1133 "calendar-date.c"
		{
			gint _tmp7_ = 0;
#line 238 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp7_ = quantity;
#line 238 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp7_ > 0) {
#line 1140 "calendar-date.c"
				gint _tmp8_ = 0;
#line 239 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp8_ = quantity;
#line 239 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_days (&clone, (guint) (_tmp8_ * CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT));
#line 1146 "calendar-date.c"
			} else {
				gint _tmp9_ = 0;
#line 241 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp9_ = quantity;
#line 241 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_days (&clone, (guint) ((-_tmp9_) * CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT));
#line 1153 "calendar-date.c"
			}
#line 242 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1157 "calendar-date.c"
		}
#line 229 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_MONTH:
#line 1161 "calendar-date.c"
		{
			gint _tmp10_ = 0;
#line 245 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp10_ = quantity;
#line 245 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp10_ > 0) {
#line 1168 "calendar-date.c"
				gint _tmp11_ = 0;
#line 246 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp11_ = quantity;
#line 246 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_months (&clone, (guint) _tmp11_);
#line 1174 "calendar-date.c"
			} else {
				gint _tmp12_ = 0;
#line 248 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp12_ = quantity;
#line 248 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_months (&clone, (guint) (-_tmp12_));
#line 1181 "calendar-date.c"
			}
#line 249 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1185 "calendar-date.c"
		}
#line 229 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_YEAR:
#line 1189 "calendar-date.c"
		{
			gint _tmp13_ = 0;
#line 252 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp13_ = quantity;
#line 252 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp13_ > 0) {
#line 1196 "calendar-date.c"
				gint _tmp14_ = 0;
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp14_ = quantity;
#line 253 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_years (&clone, (guint) _tmp14_);
#line 1202 "calendar-date.c"
			} else {
				gint _tmp15_ = 0;
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp15_ = quantity;
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_years (&clone, (guint) (-_tmp15_));
#line 1209 "calendar-date.c"
			}
#line 256 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1213 "calendar-date.c"
		}
		default:
		{
#line 259 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 1219 "calendar-date.c"
		}
	}
#line 262 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = clone;
#line 262 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_date_new_from_gdate (&_tmp16_);
#line 262 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp17_;
#line 262 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1230 "calendar-date.c"
}


/**
     * Returns the {@link Date} of the upcoming (next chronological) Date that matches
     * the predicate's requirements.
     *
     * inclusive indicates if this Date is included in the search.
     *
     * @see prior
     */
CaliforniaCalendarDate* california_calendar_date_upcoming (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeePredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
#line 273 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 274 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = inclusive;
#line 274 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = predicate;
#line 274 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1__target = predicate_target;
#line 274 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_date_upcoming_prior (self, _tmp0_, 1, _tmp1_, _tmp1__target);
#line 274 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 274 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1262 "calendar-date.c"
}


/**
     * Returns the {@link Date} of the prior (next chronological) Date that matches
     * the predicate's requirements.
     *
     * inclusive indicates if this Date is included in the search.
     *
     * @see upcoming
     */
CaliforniaCalendarDate* california_calendar_date_prior (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeePredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
#line 285 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = inclusive;
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = predicate;
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1__target = predicate_target;
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_date_upcoming_prior (self, _tmp0_, -1, _tmp1_, _tmp1__target);
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 286 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1294 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_upcoming_prior (CaliforniaCalendarDate* self, gboolean inclusive, gint adjustment, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarDate* current = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
#line 289 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = inclusive;
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp1_) {
#line 1310 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = _g_object_ref0 (self);
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (_tmp0_);
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp2_;
#line 1318 "calendar-date.c"
	} else {
		gint _tmp3_ = 0;
		gpointer _tmp4_ = NULL;
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = adjustment;
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp3_);
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (_tmp0_);
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = (CaliforniaCalendarDate*) _tmp4_;
#line 1330 "calendar-date.c"
	}
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = _g_object_ref0 (_tmp0_);
#line 290 "/home/jim/git/california/src/calendar/calendar-date.vala"
	current = _tmp5_;
#line 291 "/home/jim/git/california/src/calendar/calendar-date.vala"
	while (TRUE) {
#line 1338 "calendar-date.c"
		GeePredicate _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		CaliforniaCalendarDate* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		CaliforniaCalendarDate* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gpointer _tmp11_ = NULL;
#line 291 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = predicate;
#line 291 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6__target = predicate_target;
#line 291 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = current;
#line 291 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp8_ = _tmp6_ (_tmp7_, _tmp6__target);
#line 291 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (!(!_tmp8_)) {
#line 291 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1358 "calendar-date.c"
		}
#line 292 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = current;
#line 292 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = adjustment;
#line 292 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp10_);
#line 292 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (current);
#line 292 "/home/jim/git/california/src/calendar/calendar-date.vala"
		current = (CaliforniaCalendarDate*) _tmp11_;
#line 1370 "calendar-date.c"
	}
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = current;
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp0_);
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1378 "calendar-date.c"
}


/**
     * @inheritDoc
     */
static gint california_calendar_date_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 300 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 300 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), 0);
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = other;
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (self != _tmp1_) {
#line 1398 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		GDate _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = other;
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = _tmp2_->priv->gdate;
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = g_date_days_between (&self->priv->gdate, &_tmp3_);
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp4_;
#line 1410 "calendar-date.c"
	} else {
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = 0;
#line 1414 "calendar-date.c"
	}
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1420 "calendar-date.c"
}


/**
     * Returns a {@link Date} clamped between the two supplied Dates, inclusive.
     *
     * @see Span.clamp_between
     */
CaliforniaCalendarDate* california_calendar_date_clamp (CaliforniaCalendarDate* self, CaliforniaCalendarDate* min, CaliforniaCalendarDate* max) {
	CaliforniaCalendarDate* result = NULL;
	GDate clone = {0};
	GDate _tmp0_ = {0};
	CaliforniaCalendarDate* _tmp1_ = NULL;
	GDate _tmp2_ = {0};
	CaliforniaCalendarDate* _tmp3_ = NULL;
	GDate _tmp4_ = {0};
	GDate _tmp5_ = {0};
	CaliforniaCalendarDate* _tmp6_ = NULL;
#line 309 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 309 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (min), NULL);
#line 309 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (max), NULL);
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->gdate;
#line 310 "/home/jim/git/california/src/calendar/calendar-date.vala"
	clone = _tmp0_;
#line 311 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = min;
#line 311 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_->priv->gdate;
#line 311 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = max;
#line 311 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = _tmp3_->priv->gdate;
#line 311 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_clamp (&clone, &_tmp2_, &_tmp4_);
#line 313 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = clone;
#line 313 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = california_calendar_date_new_from_gdate (&_tmp5_);
#line 313 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp6_;
#line 313 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1467 "calendar-date.c"
}


static gint california_calendar_date_real_compare_to (GeeComparable* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), 0);
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = other;
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (self != _tmp1_) {
#line 1484 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		GDate _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = other;
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = _tmp2_->priv->gdate;
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = g_date_compare (&self->priv->gdate, &_tmp3_);
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp4_;
#line 1496 "calendar-date.c"
	} else {
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = 0;
#line 1500 "calendar-date.c"
	}
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 317 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1506 "calendar-date.c"
}


static gboolean california_calendar_date_real_equal_to (GeeHashable* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gboolean result = FALSE;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 320 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 320 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), FALSE);
#line 321 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = other;
#line 321 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 321 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_ == 0;
#line 321 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1527 "calendar-date.c"
}


static guint california_calendar_date_real_hash (GeeHashable* base) {
	CaliforniaCalendarDate * self;
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 324 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_date_get_julian (&self->priv->gdate);
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1543 "calendar-date.c"
}


gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt) {
	gchar* result = NULL;
	gchar* buf = NULL;
	gchar* _tmp0_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 328 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 328 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 331 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_new0 (gchar, 256);
#line 331 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf = _tmp0_;
#line 331 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf_length1 = 256;
#line 331 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_buf_size_ = buf_length1;
#line 332 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = fmt;
#line 332 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_strftime (buf, buf_length1, _tmp1_, &self->priv->gdate);
#line 334 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = g_strdup ((const gchar*) buf);
#line 334 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 334 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf = (g_free (buf), NULL);
#line 334 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1579 "calendar-date.c"
}


/**
     * Returns the {@link Date} in a localized standardized format, i.e. "08/23/01"
     */
gchar* california_calendar_date_to_standard_string (CaliforniaCalendarDate* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 340 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_FMT_FULL_DATE;
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_date_format (self, _tmp0_);
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_;
#line 341 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1600 "calendar-date.c"
}


/**
     * Returns the {@link Date} in a prettified, localized format according to supplied
     * {@link PrettyFlag}s.
     *
     * Returns "Today" (localized) if this matches {@link System.today} unless the NO_TODAY flag
     * or INCLUDE_YEAR flag is specified.
     */
gchar* california_calendar_date_to_pretty_string (CaliforniaCalendarDate* self, CaliforniaCalendarDatePrettyFlag flags) {
	gchar* result = NULL;
	gboolean compact = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp0_ = 0;
	gboolean abbrev = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp1_ = 0;
	gboolean with_year = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp2_ = 0;
	gboolean with_other_year = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp3_ = 0;
	gboolean no_today = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp4_ = 0;
	gboolean no_dow = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	const gchar* fmt = NULL;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
#line 351 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 352 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = flags;
#line 352 "/home/jim/git/california/src/calendar/calendar-date.vala"
	compact = (_tmp0_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT) != 0;
#line 353 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = flags;
#line 353 "/home/jim/git/california/src/calendar/calendar-date.vala"
	abbrev = (_tmp1_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV) != 0;
#line 354 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = flags;
#line 354 "/home/jim/git/california/src/calendar/calendar-date.vala"
	with_year = (_tmp2_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR) != 0;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = flags;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
	with_other_year = (_tmp3_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR) != 0;
#line 356 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = flags;
#line 356 "/home/jim/git/california/src/calendar/calendar-date.vala"
	no_today = (_tmp4_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY) != 0;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = flags;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
	no_dow = (_tmp5_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK) != 0;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = no_today;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp8_) {
#line 1670 "calendar-date.c"
		gboolean _tmp9_ = FALSE;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = with_year;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = !_tmp9_;
#line 1676 "calendar-date.c"
	} else {
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = FALSE;
#line 1680 "calendar-date.c"
	}
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp7_) {
#line 1684 "calendar-date.c"
		CaliforniaCalendarDate* _tmp10_ = NULL;
		CaliforniaCalendarDate* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = california_calendar_system_get_today ();
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = _tmp10_;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_HASHABLE, GeeHashable), _tmp11_);
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = _tmp12_;
#line 1696 "calendar-date.c"
	} else {
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = FALSE;
#line 1700 "calendar-date.c"
	}
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp6_) {
#line 1704 "calendar-date.c"
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = _ ("Today");
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
		result = _tmp14_;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
		return result;
#line 1715 "calendar-date.c"
	}
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = with_year;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp17_) {
#line 1721 "calendar-date.c"
		gboolean _tmp18_ = FALSE;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp18_ = with_other_year;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp16_ = _tmp18_;
#line 1727 "calendar-date.c"
	} else {
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp16_ = FALSE;
#line 1731 "calendar-date.c"
	}
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp16_) {
#line 1735 "calendar-date.c"
		CaliforniaCalendarYear* _tmp19_ = NULL;
		CaliforniaCalendarDate* _tmp20_ = NULL;
		CaliforniaCalendarDate* _tmp21_ = NULL;
		CaliforniaCalendarYear* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp19_ = self->priv->_year;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp20_ = california_calendar_system_get_today ();
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp21_ = _tmp20_;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp22_ = _tmp21_->priv->_year;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp23_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_HASHABLE, GeeHashable), _tmp22_);
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = !_tmp23_;
#line 1753 "calendar-date.c"
	} else {
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = FALSE;
#line 1757 "calendar-date.c"
	}
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp15_) {
#line 363 "/home/jim/git/california/src/calendar/calendar-date.vala"
		with_year = TRUE;
#line 1763 "calendar-date.c"
	}
#line 366 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = abbrev;
#line 366 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp24_) {
#line 1769 "calendar-date.c"
		gboolean _tmp25_ = FALSE;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp25_ = no_dow;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_tmp25_) {
#line 1775 "calendar-date.c"
			const gchar* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
#line 368 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp27_ = with_year;
#line 368 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp27_) {
#line 1782 "calendar-date.c"
				const gchar* _tmp28_ = NULL;
#line 368 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp28_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW;
#line 368 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp26_ = _tmp28_;
#line 1788 "calendar-date.c"
			} else {
				const gchar* _tmp29_ = NULL;
#line 368 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp29_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW_NO_YEAR;
#line 368 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp26_ = _tmp29_;
#line 1795 "calendar-date.c"
			}
#line 368 "/home/jim/git/california/src/calendar/calendar-date.vala"
			fmt = _tmp26_;
#line 1799 "calendar-date.c"
		} else {
			const gchar* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
#line 370 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp31_ = with_year;
#line 370 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp31_) {
#line 1807 "calendar-date.c"
				const gchar* _tmp32_ = NULL;
#line 370 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp32_ = california_calendar_FMT_PRETTY_DATE_ABBREV;
#line 370 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp30_ = _tmp32_;
#line 1813 "calendar-date.c"
			} else {
				const gchar* _tmp33_ = NULL;
#line 370 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp33_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_YEAR;
#line 370 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp30_ = _tmp33_;
#line 1820 "calendar-date.c"
			}
#line 370 "/home/jim/git/california/src/calendar/calendar-date.vala"
			fmt = _tmp30_;
#line 1824 "calendar-date.c"
		}
	} else {
		gboolean _tmp34_ = FALSE;
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp34_ = compact;
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_tmp34_) {
#line 1832 "calendar-date.c"
			gboolean _tmp35_ = FALSE;
#line 372 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp35_ = no_dow;
#line 372 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp35_) {
#line 1838 "calendar-date.c"
				const gchar* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
#line 373 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp37_ = with_year;
#line 373 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp37_) {
#line 1845 "calendar-date.c"
					const gchar* _tmp38_ = NULL;
#line 373 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp38_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW;
#line 373 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp36_ = _tmp38_;
#line 1851 "calendar-date.c"
				} else {
					const gchar* _tmp39_ = NULL;
#line 373 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp39_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW_NO_YEAR;
#line 373 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp36_ = _tmp39_;
#line 1858 "calendar-date.c"
				}
#line 373 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp36_;
#line 1862 "calendar-date.c"
			} else {
				const gchar* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp41_ = with_year;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp41_) {
#line 1870 "calendar-date.c"
					const gchar* _tmp42_ = NULL;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp42_ = california_calendar_FMT_PRETTY_DATE_COMPACT;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp40_ = _tmp42_;
#line 1876 "calendar-date.c"
				} else {
					const gchar* _tmp43_ = NULL;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp43_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_YEAR;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp40_ = _tmp43_;
#line 1883 "calendar-date.c"
				}
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp40_;
#line 1887 "calendar-date.c"
			}
		} else {
			gboolean _tmp44_ = FALSE;
#line 377 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp44_ = no_dow;
#line 377 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp44_) {
#line 1895 "calendar-date.c"
				const gchar* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp46_ = with_year;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp46_) {
#line 1902 "calendar-date.c"
					const gchar* _tmp47_ = NULL;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp47_ = california_calendar_FMT_PRETTY_DATE_NO_DOW;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp45_ = _tmp47_;
#line 1908 "calendar-date.c"
				} else {
					const gchar* _tmp48_ = NULL;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp48_ = california_calendar_FMT_PRETTY_DATE_NO_DOW_NO_YEAR;
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp45_ = _tmp48_;
#line 1915 "calendar-date.c"
				}
#line 378 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp45_;
#line 1919 "calendar-date.c"
			} else {
				const gchar* _tmp49_ = NULL;
				gboolean _tmp50_ = FALSE;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp50_ = with_year;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp50_) {
#line 1927 "calendar-date.c"
					const gchar* _tmp51_ = NULL;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp51_ = california_calendar_FMT_PRETTY_DATE;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp49_ = _tmp51_;
#line 1933 "calendar-date.c"
				} else {
					const gchar* _tmp52_ = NULL;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp52_ = california_calendar_FMT_PRETTY_DATE_NO_YEAR;
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp49_ = _tmp52_;
#line 1940 "calendar-date.c"
				}
#line 380 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp49_;
#line 1944 "calendar-date.c"
			}
		}
	}
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp53_ = fmt;
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp54_ = california_calendar_date_format (self, _tmp53_);
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp55_ = _tmp54_;
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp56_ = california_string_remove_leading_chars (_tmp55_, (gunichar) '0', " /-:;,.");
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp57_ = _tmp56_;
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp58_ = california_string_reduce_whitespace (_tmp57_);
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp59_ = _tmp58_;
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_free0 (_tmp57_);
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_free0 (_tmp55_);
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp59_;
#line 384 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1970 "calendar-date.c"
}


static gchar* california_calendar_date_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarDate * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 387 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 388 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_date_format (self, "%x");
#line 388 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 388 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1986 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_real_get_start_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* self;
#line 71 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 71 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = self;
#line 71 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1999 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_real_get_end_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* self;
#line 78 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 78 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = self;
#line 78 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2012 "calendar-date.c"
}


CaliforniaCalendarDayOfWeek* california_calendar_date_get_day_of_week (CaliforniaCalendarDate* self) {
	CaliforniaCalendarDayOfWeek* result;
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_week;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2027 "calendar-date.c"
}


static void california_calendar_date_set_day_of_week (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfWeek* value) {
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp1_ = NULL;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_week);
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_week = _tmp1_;
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-week");
#line 2046 "calendar-date.c"
}


CaliforniaCalendarDayOfMonth* california_calendar_date_get_day_of_month (CaliforniaCalendarDate* self) {
	CaliforniaCalendarDayOfMonth* result;
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_month;
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2061 "calendar-date.c"
}


static void california_calendar_date_set_day_of_month (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfMonth* value) {
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_month);
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_month = _tmp1_;
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-month");
#line 2080 "calendar-date.c"
}


gint california_calendar_date_get_day_of_year (CaliforniaCalendarDate* self) {
	gint result;
	gint _tmp0_ = 0;
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), 0);
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_year;
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2095 "calendar-date.c"
}


static void california_calendar_date_set_day_of_year (CaliforniaCalendarDate* self, gint value) {
	gint _tmp0_ = 0;
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_year = _tmp0_;
#line 82 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-year");
#line 2109 "calendar-date.c"
}


CaliforniaCalendarMonth* california_calendar_date_get_month (CaliforniaCalendarDate* self) {
	CaliforniaCalendarMonth* result;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_month;
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2124 "calendar-date.c"
}


static void california_calendar_date_set_month (CaliforniaCalendarDate* self, CaliforniaCalendarMonth* value) {
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarMonth* _tmp1_ = NULL;
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_month);
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_month = _tmp1_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "month");
#line 2143 "calendar-date.c"
}


CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self) {
	CaliforniaCalendarYear* result;
	CaliforniaCalendarYear* _tmp0_ = NULL;
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_year;
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2158 "calendar-date.c"
}


static void california_calendar_date_set_year (CaliforniaCalendarDate* self, CaliforniaCalendarYear* value) {
	CaliforniaCalendarYear* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_year);
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_year = _tmp1_;
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "year");
#line 2177 "calendar-date.c"
}


static void california_calendar_date_class_init (CaliforniaCalendarDateClass * klass) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarDatePrivate));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	((CaliforniaCalendarUnitClass *) klass)->adjust = california_calendar_date_real_adjust;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	((CaliforniaCalendarUnitClass *) klass)->difference = california_calendar_date_real_difference;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_calendar_date_real_to_string;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_SPAN_CLASS (klass)->get_start_date = california_calendar_date_real_get_start_date;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_SPAN_CLASS (klass)->get_end_date = california_calendar_date_real_get_end_date;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_date_get_property;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_date_set_property;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_date_finalize;
#line 2202 "calendar-date.c"
	/**
	     * @inheritDoc
	     *
	     * Overridden to prevent a reference cycle in {@link Span.start_date}.
	     */
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_START_DATE, g_param_spec_object ("start-date", "start-date", "start-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2210 "calendar-date.c"
	/**
	     * @inheritDoc
	     *
	     * Overridden to prevent a reference cycle in {@link Span.end_date}.
	     */
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_END_DATE, g_param_spec_object ("end-date", "end-date", "end-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK, g_param_spec_object ("day-of-week", "day-of-week", "day-of-week", CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH, g_param_spec_object ("day-of-month", "day-of-month", "day-of-month", CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR, g_param_spec_int ("day-of-year", "day-of-year", "day-of-year", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_MONTH, g_param_spec_object ("month", "month", "month", CALIFORNIA_CALENDAR_TYPE_MONTH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_YEAR, g_param_spec_object ("year", "year", "year", CALIFORNIA_CALENDAR_TYPE_YEAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2228 "calendar-date.c"
}


static void california_calendar_date_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_date_real_compare_to;
#line 2237 "calendar-date.c"
}


static void california_calendar_date_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_date_real_equal_to;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_date_real_hash;
#line 2248 "calendar-date.c"
}


static void california_calendar_date_instance_init (CaliforniaCalendarDate * self) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv = CALIFORNIA_CALENDAR_DATE_GET_PRIVATE (self);
#line 2255 "calendar-date.c"
}


static void california_calendar_date_finalize (GObject* obj) {
	CaliforniaCalendarDate * self;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 80 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_week);
#line 81 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_month);
#line 83 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_month);
#line 84 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_year);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (california_calendar_date_parent_class)->finalize (obj);
#line 2273 "calendar-date.c"
}


/**
 * An immutable representation of a single date in time (year/month/day).
 *
 * This is primarily a GObject-ification of GLib's Date struct, with the added restriction that
 * this class is immutable.  This means this object is incapable of representing a DMY prior to
 * Year 1 (BCE).
 *
 * GLib.Date has many powerful features for representing a calendar day, but it's interface is
 * inconvenient when working in Vala.  It can also exist in an uninitialized and an invalid
 * state.  It's desired to avoid both of those.  It is also not an Object, has no signals or
 * properties, doesn't work well with Gee, and is mutable.  This class attempts to solve these
 * issues.
 */
GType california_calendar_date_get_type (void) {
	static volatile gsize california_calendar_date_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarDate), 0, (GInstanceInitFunc) california_calendar_date_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_date_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_date_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_date_type_id;
		california_calendar_date_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_UNIT, "CaliforniaCalendarDate", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_date_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_date_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_date_type_id__volatile, california_calendar_date_type_id);
	}
	return california_calendar_date_type_id__volatile;
}


static void _vala_california_calendar_date_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_START_DATE:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_END_DATE:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_day_of_week (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_day_of_month (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_int (value, california_calendar_date_get_day_of_year (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_month (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_year (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2353 "calendar-date.c"
		default:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2359 "calendar-date.c"
	}
}


static void _vala_california_calendar_date_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_week (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_month (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_year (self, g_value_get_int (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_month (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_year (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2399 "calendar-date.c"
		default:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2405 "calendar-date.c"
	}
}



