/* util-uri.c generated by valac 0.25.1, the Vala compiler
 * generated from util-uri.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>

typedef struct _Block25Data Block25Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CALIFORNIA_TYPE_ITERABLE (california_iterable_get_type ())
#define CALIFORNIA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterable))
#define CALIFORNIA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))
#define CALIFORNIA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))

typedef struct _CaliforniaIterable CaliforniaIterable;
typedef struct _CaliforniaIterableClass CaliforniaIterableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))

typedef enum  {
	URI_ERROR_INVALID
} URIError;
#define URI_ERROR uri_error_quark ()
struct _Block25Data {
	int _ref_count_;
	gchar* stripped;
};



GQuark uri_error_quark (void);
gboolean california_uri_is_valid (const gchar* uri, GeeSet* supported_schemes);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
gboolean california_string_is_empty (const gchar* str);
GType california_iterable_get_type (void) G_GNUC_CONST;
CaliforniaIterable* california_traverse (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeIterable* gee_iterable);
gboolean california_iterable_any (CaliforniaIterable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
static gboolean __lambda15_ (Block25Data* _data25_, const gchar* scheme);
static gboolean ___lambda15__gee_predicate (gconstpointer g, gpointer self);
static void _vala_SoupURI_free (SoupURI* self);
SoupURI* california_uri_parse (const gchar* uri, GError** error);


GQuark uri_error_quark (void) {
	return g_quark_from_static_string ("uri_error-quark");
}


/**
 * Basic validation of a string intended to be parsed as an absolute URI.
 *
 * If null or an empty array is passed for "supported_schemes", then the only character checked
 * for is the presence of a colon separating the scheme from the remainder of the URI.
 *
 * If "supported_schemes" are specified, then the entire scheme (name and separator) should be
 * included, i.e. "http://", "mailto:", etc.
 */
static Block25Data* block25_data_ref (Block25Data* _data25_) {
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
	g_atomic_int_inc (&_data25_->_ref_count_);
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
	return _data25_;
#line 77 "util-uri.c"
}


static void block25_data_unref (void * _userdata_) {
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_data25_->stripped);
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
		g_slice_free (Block25Data, _data25_);
#line 90 "util-uri.c"
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 114 "util-uri.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 134 "util-uri.c"
}


static gboolean __lambda15_ (Block25Data* _data25_, const gchar* scheme) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	g_return_val_if_fail (scheme != NULL, FALSE);
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp0_ = _data25_->stripped;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp1_ = scheme;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	result = _tmp2_;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	return result;
#line 155 "util-uri.c"
}


static gboolean ___lambda15__gee_predicate (gconstpointer g, gpointer self) {
	gboolean result;
	result = __lambda15_ (self, (const gchar*) g);
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	return result;
#line 164 "util-uri.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 171 "util-uri.c"
}


gboolean california_uri_is_valid (const gchar* uri, GeeSet* supported_schemes) {
	gboolean result = FALSE;
	Block25Data* _data25_;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GeeSet* _tmp9_ = NULL;
	CaliforniaIterable* _tmp10_ = NULL;
	CaliforniaIterable* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	SoupURI* parsed = NULL;
	const gchar* _tmp14_ = NULL;
	SoupURI* _tmp15_ = NULL;
	SoupURI* _tmp16_ = NULL;
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
	g_return_val_if_fail ((supported_schemes == NULL) || GEE_IS_SET (supported_schemes), FALSE);
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
	_data25_ = g_slice_new0 (Block25Data);
#line 26 "/home/jim/git/california/src/util/util-uri.vala"
	_data25_->_ref_count_ = 1;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp1_ = uri;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp1_ != NULL) {
#line 204 "util-uri.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp2_ = uri;
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp3_ = string_strip (_tmp2_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp0_ = _tmp3_;
#line 215 "util-uri.c"
	} else {
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp0_ = NULL;
#line 221 "util-uri.c"
	}
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp4_ = g_strdup (_tmp0_);
#line 28 "/home/jim/git/california/src/util/util-uri.vala"
	_data25_->stripped = _tmp4_;
#line 29 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp5_ = _data25_->stripped;
#line 29 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp6_ = california_string_is_empty (_tmp5_);
#line 29 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp6_) {
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		result = FALSE;
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		block25_data_unref (_data25_);
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		_data25_ = NULL;
#line 30 "/home/jim/git/california/src/util/util-uri.vala"
		return result;
#line 243 "util-uri.c"
	}
#line 33 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp7_ = _data25_->stripped;
#line 33 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp8_ = string_contains (_tmp7_, ":");
#line 33 "/home/jim/git/california/src/util/util-uri.vala"
	if (!_tmp8_) {
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
		result = FALSE;
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
		block25_data_unref (_data25_);
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
		_data25_ = NULL;
#line 34 "/home/jim/git/california/src/util/util-uri.vala"
		return result;
#line 261 "util-uri.c"
	}
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp9_ = supported_schemes;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp10_ = california_traverse (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp11_ = _tmp10_;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp12_ = california_iterable_any (_tmp11_, ___lambda15__gee_predicate, block25_data_ref (_data25_), block25_data_unref);
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp13_ = !_tmp12_;
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	_g_object_unref0 (_tmp11_);
#line 36 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp13_) {
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
		result = FALSE;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
		_g_free0 (_tmp0_);
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
		block25_data_unref (_data25_);
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
		_data25_ = NULL;
#line 37 "/home/jim/git/california/src/util/util-uri.vala"
		return result;
#line 287 "util-uri.c"
	}
#line 40 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp14_ = uri;
#line 40 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp15_ = soup_uri_new (_tmp14_);
#line 40 "/home/jim/git/california/src/util/util-uri.vala"
	parsed = _tmp15_;
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp16_ = parsed;
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	result = _tmp16_ != NULL;
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	__vala_SoupURI_free0 (parsed);
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	_g_free0 (_tmp0_);
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	block25_data_unref (_data25_);
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	_data25_ = NULL;
#line 42 "/home/jim/git/california/src/util/util-uri.vala"
	return result;
#line 309 "util-uri.c"
}


/**
 * Checked creation of a Soup.URI object.
 *
 * This shouldn't be used to create "empty" Soup.URI objects.
 *
 * @throws URIError
 */
SoupURI* california_uri_parse (const gchar* uri, GError** error) {
	SoupURI* result = NULL;
	SoupURI* parsed = NULL;
	const gchar* _tmp0_ = NULL;
	SoupURI* _tmp1_ = NULL;
	SoupURI* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 52 "/home/jim/git/california/src/util/util-uri.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 53 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp0_ = uri;
#line 53 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp1_ = soup_uri_new (_tmp0_);
#line 53 "/home/jim/git/california/src/util/util-uri.vala"
	parsed = _tmp1_;
#line 54 "/home/jim/git/california/src/util/util-uri.vala"
	_tmp2_ = parsed;
#line 54 "/home/jim/git/california/src/util/util-uri.vala"
	if (_tmp2_ == NULL) {
#line 339 "util-uri.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 55 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp3_ = uri;
#line 55 "/home/jim/git/california/src/util/util-uri.vala"
		_tmp4_ = g_error_new (URI_ERROR, URI_ERROR_INVALID, "Invalid URI: %s", _tmp3_);
#line 55 "/home/jim/git/california/src/util/util-uri.vala"
		_inner_error_ = _tmp4_;
#line 55 "/home/jim/git/california/src/util/util-uri.vala"
		g_propagate_error (error, _inner_error_);
#line 55 "/home/jim/git/california/src/util/util-uri.vala"
		__vala_SoupURI_free0 (parsed);
#line 55 "/home/jim/git/california/src/util/util-uri.vala"
		return NULL;
#line 354 "util-uri.c"
	}
#line 57 "/home/jim/git/california/src/util/util-uri.vala"
	result = parsed;
#line 57 "/home/jim/git/california/src/util/util-uri.vala"
	return result;
#line 360 "util-uri.c"
}



