/* toolkit-deck.c generated by valac 0.24.0, the Vala compiler
 * generated from toolkit-deck.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TOOLKIT_TYPE_DECK (california_toolkit_deck_get_type ())
#define CALIFORNIA_TOOLKIT_DECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck))
#define CALIFORNIA_TOOLKIT_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))
#define CALIFORNIA_TOOLKIT_IS_DECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_IS_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_DECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))

typedef struct _CaliforniaToolkitDeck CaliforniaToolkitDeck;
typedef struct _CaliforniaToolkitDeckClass CaliforniaToolkitDeckClass;
typedef struct _CaliforniaToolkitDeckPrivate CaliforniaToolkitDeckPrivate;

#define CALIFORNIA_TOOLKIT_TYPE_CARD (california_toolkit_card_get_type ())
#define CALIFORNIA_TOOLKIT_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard))
#define CALIFORNIA_TOOLKIT_IS_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD))
#define CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCardIface))

typedef struct _CaliforniaToolkitCard CaliforniaToolkitCard;
typedef struct _CaliforniaToolkitCardIface CaliforniaToolkitCardIface;

#define CALIFORNIA_TOOLKIT_CARD_TYPE_JUMP (california_toolkit_card_jump_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_TYPE_ITERABLE (california_iterable_get_type ())
#define CALIFORNIA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterable))
#define CALIFORNIA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))
#define CALIFORNIA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))

typedef struct _CaliforniaIterable CaliforniaIterable;
typedef struct _CaliforniaIterableClass CaliforniaIterableClass;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaToolkitDeck {
	GtkStack parent_instance;
	CaliforniaToolkitDeckPrivate * priv;
};

struct _CaliforniaToolkitDeckClass {
	GtkStackClass parent_class;
};

typedef enum  {
	CALIFORNIA_TOOLKIT_CARD_JUMP_HOME,
	CALIFORNIA_TOOLKIT_CARD_JUMP_BACK,
	CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT
} CaliforniaToolkitCardJump;

struct _CaliforniaToolkitCardIface {
	GTypeInterface parent_iface;
	void (*jumped_to) (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
	const gchar* (*get_card_id) (CaliforniaToolkitCard* self);
	const gchar* (*get_title) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_default_widget) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_initial_focus) (CaliforniaToolkitCard* self);
};

struct _CaliforniaToolkitDeckPrivate {
	CaliforniaToolkitCard* _top;
	GeeList* list;
	GeeDeque* navigation_stack;
	GeeHashMap* names;
};


static gpointer california_toolkit_deck_parent_class = NULL;

GType california_toolkit_deck_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_jump_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_TOOLKIT_DECK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckPrivate))
enum  {
	CALIFORNIA_TOOLKIT_DECK_DUMMY_PROPERTY,
	CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET,
	CALIFORNIA_TOOLKIT_DECK_SIZE,
	CALIFORNIA_TOOLKIT_DECK_CARDS,
	CALIFORNIA_TOOLKIT_DECK_HOME,
	CALIFORNIA_TOOLKIT_DECK_TOP
};
static void california_toolkit_deck_on_card_mapped (CaliforniaToolkitDeck* self, GtkWidget* widget);
static void _california_toolkit_deck_on_card_mapped_gtk_widget_map (GtkWidget* _sender, gpointer self);
CaliforniaToolkitDeck* california_toolkit_deck_new (void);
CaliforniaToolkitDeck* california_toolkit_deck_construct (GType object_type);
#define CALIFORNIA_TOOLKIT_DEFAULT_STACK_TRANSITION_DURATION_MSEC 300
static void california_toolkit_deck_on_child_to_top (CaliforniaToolkitDeck* self);
static void _california_toolkit_deck_on_child_to_top_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
CaliforniaToolkitCard* california_toolkit_deck_get_top (CaliforniaToolkitDeck* self);
static void california_toolkit_deck_on_jump_to_card_instance (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, GValue* message);
static void _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card (CaliforniaToolkitCard* _sender, CaliforniaToolkitCard* next, GValue* message, gpointer self);
static void california_toolkit_deck_on_jump_to_card_by_name (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, const gchar* name, GValue* message);
static void _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name (CaliforniaToolkitCard* _sender, const gchar* name, GValue* message, gpointer self);
static void california_toolkit_deck_on_jump_back (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
static void _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back (CaliforniaToolkitCard* _sender, gpointer self);
static void california_toolkit_deck_on_jump_home (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
static void _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home (CaliforniaToolkitCard* _sender, gpointer self);
static void california_toolkit_deck_on_dismiss (CaliforniaToolkitDeck* self, gboolean user_request, gboolean final);
static void _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss (CaliforniaToolkitCard* _sender, gboolean user_request, gboolean final, gpointer self);
static void california_toolkit_deck_on_success (CaliforniaToolkitDeck* self);
static void _california_toolkit_deck_on_success_california_toolkit_card_success (CaliforniaToolkitCard* _sender, gpointer self);
static void california_toolkit_deck_on_failure (CaliforniaToolkitDeck* self, const gchar* user_message);
static void _california_toolkit_deck_on_failure_california_toolkit_card_failure (CaliforniaToolkitCard* _sender, const gchar* user_message, gpointer self);
static void california_toolkit_deck_set_top (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* value);
void california_toolkit_deck_add_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
void california_toolkit_deck_add_cards (CaliforniaToolkitDeck* self, GeeList* cards);
GType california_iterable_get_type (void) G_GNUC_CONST;
CaliforniaIterable* california_iterate (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer g, ...);
GeeArrayList* california_iterable_to_array_list (CaliforniaIterable* self, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
gint california_toolkit_deck_get_size (CaliforniaToolkitDeck* self);
gboolean california_string_is_empty (const gchar* str);
const gchar* california_toolkit_card_get_card_id (CaliforniaToolkitCard* self);
const gchar* california_toolkit_card_get_title (CaliforniaToolkitCard* self);
CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self);
void california_toolkit_card_jumped_to (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, CaliforniaToolkitCardJump reason, GValue* message);
void california_toolkit_deck_remove_cards (CaliforniaToolkitDeck* self, GeeIterable* cards);
static GValue* california_toolkit_deck_strip_null_value (CaliforniaToolkitDeck* self, GValue* message);
static GValue* _g_value_dup (GValue* self);
void california_toolkit_deck_go_home (CaliforniaToolkitDeck* self, GValue* message);
static void _vala_GValue_free (GValue* self);
static void california_toolkit_deck_on_jump_to_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, CaliforniaToolkitCardJump reason, GValue* message);
GtkWidget* california_toolkit_card_get_default_widget (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_card_get_initial_focus (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_deck_get_default_widget (CaliforniaToolkitDeck* self);
GeeList* california_toolkit_deck_get_cards (CaliforniaToolkitDeck* self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void california_toolkit_deck_finalize (GObject* obj);
static void _vala_california_toolkit_deck_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_toolkit_deck_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _california_toolkit_deck_on_card_mapped_gtk_widget_map (GtkWidget* _sender, gpointer self) {
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_card_mapped ((CaliforniaToolkitDeck*) self, _sender);
#line 152 "toolkit-deck.c"
}


/**
     * Create a new {@link Deck}.
     *
     * By default the Deck configures the underlying Gtk.Stack to slide left and right, depending
     * on the position of the {@link Card}s.  This can be changed, but the recommended
     * transition types are SLIDE_LEFT_RIGHT and SLIDE_UP_DOWN.
     */
static void _california_toolkit_deck_on_child_to_top_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 72 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_child_to_top ((CaliforniaToolkitDeck*) self);
#line 166 "toolkit-deck.c"
}


CaliforniaToolkitDeck* california_toolkit_deck_construct (GType object_type) {
	CaliforniaToolkitDeck * self = NULL;
#line 68 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self = (CaliforniaToolkitDeck*) g_object_new (object_type, NULL);
#line 69 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_transition_type (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
#line 70 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_transition_duration (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), (guint) CALIFORNIA_TOOLKIT_DEFAULT_STACK_TRANSITION_DURATION_MSEC);
#line 72 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::visible-child", (GCallback) _california_toolkit_deck_on_child_to_top_g_object_notify, self, 0);
#line 68 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self;
#line 182 "toolkit-deck.c"
}


CaliforniaToolkitDeck* california_toolkit_deck_new (void) {
#line 68 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return california_toolkit_deck_construct (CALIFORNIA_TOOLKIT_TYPE_DECK);
#line 189 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card (CaliforniaToolkitCard* _sender, CaliforniaToolkitCard* next, GValue* message, gpointer self) {
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card_instance ((CaliforniaToolkitDeck*) self, _sender, next, message);
#line 196 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name (CaliforniaToolkitCard* _sender, const gchar* name, GValue* message, gpointer self) {
#line 84 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card_by_name ((CaliforniaToolkitDeck*) self, _sender, name, message);
#line 203 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back (CaliforniaToolkitCard* _sender, gpointer self) {
#line 85 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_back ((CaliforniaToolkitDeck*) self, _sender);
#line 210 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home (CaliforniaToolkitCard* _sender, gpointer self) {
#line 86 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_home ((CaliforniaToolkitDeck*) self, _sender);
#line 217 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss (CaliforniaToolkitCard* _sender, gboolean user_request, gboolean final, gpointer self) {
#line 87 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_dismiss ((CaliforniaToolkitDeck*) self, user_request, final);
#line 224 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_success_california_toolkit_card_success (CaliforniaToolkitCard* _sender, gpointer self) {
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_success ((CaliforniaToolkitDeck*) self);
#line 231 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_failure_california_toolkit_card_failure (CaliforniaToolkitCard* _sender, const gchar* user_message, gpointer self) {
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_failure ((CaliforniaToolkitDeck*) self, user_message);
#line 238 "toolkit-deck.c"
}


static void california_toolkit_deck_on_child_to_top (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	GtkWidget* _tmp17_ = NULL;
	GtkWidget* _tmp18_ = NULL;
	CaliforniaToolkitCard* _tmp19_ = NULL;
#line 80 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ != NULL) {
#line 253 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		CaliforniaToolkitCard* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		CaliforniaToolkitCard* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		CaliforniaToolkitCard* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		CaliforniaToolkitCard* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		CaliforniaToolkitCard* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		CaliforniaToolkitCard* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		GeeDeque* _tmp15_ = NULL;
		CaliforniaToolkitCard* _tmp16_ = NULL;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = self->priv->_top;
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-to-card", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp2_, NULL, FALSE);
#line 83 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card, self);
#line 84 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = self->priv->_top;
#line 84 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-to-card-by-name", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp4_, NULL, FALSE);
#line 84 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name, self);
#line 85 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = self->priv->_top;
#line 85 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-back", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp6_, NULL, FALSE);
#line 85 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back, self);
#line 86 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = self->priv->_top;
#line 86 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-home", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp8_, NULL, FALSE);
#line 86 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home, self);
#line 87 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = self->priv->_top;
#line 87 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("dismiss", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp10_, NULL, FALSE);
#line 87 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss, self);
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp11_ = self->priv->_top;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("success", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp12_, NULL, FALSE);
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _california_toolkit_deck_on_success_california_toolkit_card_success, self);
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = self->priv->_top;
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("failure", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp14_, NULL, FALSE);
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _california_toolkit_deck_on_failure_california_toolkit_card_failure, self);
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp15_ = self->priv->navigation_stack;
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp16_ = self->priv->_top;
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gee_deque_offer_head (_tmp15_, _tmp16_);
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_set_top (self, NULL);
#line 320 "toolkit-deck.c"
	}
#line 96 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack));
#line 96 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp18_ = _tmp17_;
#line 96 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_set_top (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, CALIFORNIA_TOOLKIT_TYPE_CARD) ? ((CaliforniaToolkitCard*) _tmp18_) : NULL);
#line 97 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp19_ = self->priv->_top;
#line 97 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp19_ != NULL) {
#line 332 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp20_ = NULL;
		CaliforniaToolkitCard* _tmp21_ = NULL;
		CaliforniaToolkitCard* _tmp22_ = NULL;
		CaliforniaToolkitCard* _tmp23_ = NULL;
		CaliforniaToolkitCard* _tmp24_ = NULL;
		CaliforniaToolkitCard* _tmp25_ = NULL;
		CaliforniaToolkitCard* _tmp26_ = NULL;
#line 98 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp20_ = self->priv->_top;
#line 98 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp20_, "jump-to-card", (GCallback) _california_toolkit_deck_on_jump_to_card_instance_california_toolkit_card_jump_to_card, self, 0);
#line 99 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp21_ = self->priv->_top;
#line 99 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp21_, "jump-to-card-by-name", (GCallback) _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name, self, 0);
#line 100 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp22_ = self->priv->_top;
#line 100 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp22_, "jump-back", (GCallback) _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back, self, 0);
#line 101 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp23_ = self->priv->_top;
#line 101 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp23_, "jump-home", (GCallback) _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home, self, 0);
#line 102 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp24_ = self->priv->_top;
#line 102 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp24_, "dismiss", (GCallback) _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss, self, 0);
#line 103 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp25_ = self->priv->_top;
#line 103 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp25_, "success", (GCallback) _california_toolkit_deck_on_success_california_toolkit_card_success, self, 0);
#line 104 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp26_ = self->priv->_top;
#line 104 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp26_, "failure", (GCallback) _california_toolkit_deck_on_failure_california_toolkit_card_failure, self, 0);
#line 368 "toolkit-deck.c"
	}
}


/**
     * A helper method for {@link add_cards}.
     */
void california_toolkit_deck_add_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaIterable* _tmp1_ = NULL;
	CaliforniaIterable* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 111 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 111 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = card;
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = california_iterate (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, NULL);
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = california_iterable_to_array_list (_tmp2_, NULL, NULL, NULL);
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_;
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_add_cards (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_LIST, GeeList));
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp4_);
#line 112 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp2_);
#line 402 "toolkit-deck.c"
}


/**
     * Add {@link Card}s to the {@link Deck}.
     *
     * Cards can be added in multiple batches, but the ordering is important as it dictates how
     * they're presented to the user via transitions and slides.
     *
     * The first Card added is the "home" Card.  The Deck will automatically show it first.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self ? g_object_ref (self) : NULL;
#line 417 "toolkit-deck.c"
}


void california_toolkit_deck_add_cards (CaliforniaToolkitDeck* self, GeeList* cards) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean set_home_visible = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
#line 123 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 123 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GEE_IS_LIST (cards));
#line 124 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = cards;
#line 124 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 124 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 124 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp2_ == 0) {
#line 125 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 444 "toolkit-deck.c"
	}
#line 128 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = california_toolkit_deck_get_size (self);
#line 128 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_;
#line 128 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	set_home_visible = _tmp4_ == 0;
#line 452 "toolkit-deck.c"
	{
		GeeList* _card_list = NULL;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		gint _card_size = 0;
		GeeList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _card_index = 0;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = cards;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_list = _tmp6_;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = _card_list;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = _tmp8_;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_size = _tmp9_;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_index = -1;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 480 "toolkit-deck.c"
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			CaliforniaToolkitCard* card = NULL;
			GeeList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			CaliforniaToolkitCard* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			GeeHashMap* _tmp20_ = NULL;
			CaliforniaToolkitCard* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			CaliforniaToolkitCard* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			GeeHashMap* _tmp40_ = NULL;
			CaliforniaToolkitCard* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			CaliforniaToolkitCard* _tmp44_ = NULL;
			CaliforniaToolkitCard* _tmp45_ = NULL;
			GeeList* _tmp46_ = NULL;
			CaliforniaToolkitCard* _tmp47_ = NULL;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = _card_index;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_card_index = _tmp10_ + 1;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp11_ = _card_index;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp12_ = _card_size;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!(_tmp11_ < _tmp12_)) {
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 521 "toolkit-deck.c"
			}
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp13_ = _card_list;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp14_ = _card_index;
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp15_ = gee_list_get (_tmp13_, _tmp14_);
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp15_;
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp16_ = card;
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = california_toolkit_card_get_card_id (_tmp16_);
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp18_ = _tmp17_;
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp19_ = california_string_is_empty (_tmp18_);
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_vala_assert (!_tmp19_, "!String.is_empty(card.card_id)");
#line 134 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = self->priv->names;
#line 134 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp21_ = card;
#line 134 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp22_ = california_toolkit_card_get_card_id (_tmp21_);
#line 134 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp23_ = _tmp22_;
#line 134 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp24_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp23_);
#line 134 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_vala_assert (!_tmp24_, "!names.has_key(card.card_id)");
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp25_ = card;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp26_ = california_toolkit_card_get_title (_tmp25_);
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp27_ = _tmp26_;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp28_ = california_string_is_empty (_tmp27_);
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (_tmp28_) {
#line 563 "toolkit-deck.c"
				CaliforniaToolkitCard* _tmp29_ = NULL;
				CaliforniaToolkitCard* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
#line 137 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp29_ = card;
#line 137 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp30_ = card;
#line 137 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp31_ = california_toolkit_card_get_card_id (_tmp30_);
#line 137 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp32_ = _tmp31_;
#line 137 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				gtk_stack_add_named (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GTK_TYPE_WIDGET, GtkWidget), _tmp32_);
#line 578 "toolkit-deck.c"
			} else {
				CaliforniaToolkitCard* _tmp33_ = NULL;
				CaliforniaToolkitCard* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				CaliforniaToolkitCard* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp33_ = card;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp34_ = card;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp35_ = california_toolkit_card_get_card_id (_tmp34_);
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp36_ = _tmp35_;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp37_ = card;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp38_ = california_toolkit_card_get_title (_tmp37_);
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp39_ = _tmp38_;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				gtk_stack_add_titled (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GTK_TYPE_WIDGET, GtkWidget), _tmp36_, _tmp39_);
#line 603 "toolkit-deck.c"
			}
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp40_ = self->priv->names;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp41_ = card;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp42_ = california_toolkit_card_get_card_id (_tmp41_);
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp43_ = _tmp42_;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp44_ = card;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp43_, _tmp44_);
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp45_ = card;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GTK_TYPE_WIDGET, GtkWidget), "map", (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self, 0);
#line 149 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp46_ = self->priv->list;
#line 149 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp47_ = card;
#line 149 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_COLLECTION, GeeCollection), _tmp47_);
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 629 "toolkit-deck.c"
		}
#line 131 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_list);
#line 633 "toolkit-deck.c"
	}
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp49_ = set_home_visible;
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp49_) {
#line 639 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp50_ = NULL;
		CaliforniaToolkitCard* _tmp51_ = NULL;
		CaliforniaToolkitCard* _tmp52_ = NULL;
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp50_ = california_toolkit_deck_get_home (self);
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp51_ = _tmp50_;
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp52_ = _tmp51_;
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp48_ = _tmp52_ != NULL;
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp52_);
#line 653 "toolkit-deck.c"
	} else {
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp48_ = FALSE;
#line 657 "toolkit-deck.c"
	}
#line 152 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp48_) {
#line 661 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp53_ = NULL;
		CaliforniaToolkitCard* _tmp54_ = NULL;
		CaliforniaToolkitCard* _tmp55_ = NULL;
		CaliforniaToolkitCard* _tmp56_ = NULL;
		CaliforniaToolkitCard* _tmp57_ = NULL;
		CaliforniaToolkitCard* _tmp58_ = NULL;
#line 153 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp53_ = california_toolkit_deck_get_home (self);
#line 153 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp54_ = _tmp53_;
#line 153 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp55_ = _tmp54_;
#line 153 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_WIDGET, GtkWidget));
#line 153 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp55_);
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp56_ = california_toolkit_deck_get_home (self);
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp57_ = _tmp56_;
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp58_ = _tmp57_;
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_card_jumped_to (_tmp58_, NULL, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, NULL);
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp58_);
#line 688 "toolkit-deck.c"
	}
}


/**
     * Removes {@link Card}s from the {@link Deck}.
     *
     * If the {@link top} card is removed, the Deck will return {@link home}, clearing the
     * navigation stack in the process.
     */
void california_toolkit_deck_remove_cards (CaliforniaToolkitDeck* self, GeeIterable* cards) {
	gboolean displaying = FALSE;
	CaliforniaToolkitCard* _tmp0_ = NULL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
#line 164 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 164 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GEE_IS_ITERABLE (cards));
#line 165 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 165 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	displaying = _tmp0_ != NULL;
#line 713 "toolkit-deck.c"
	{
		GeeIterator* _card_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = cards;
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_it = _tmp2_;
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 726 "toolkit-deck.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			CaliforniaToolkitCard* card = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			GeeHashMap* _tmp7_ = NULL;
			CaliforniaToolkitCard* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			CaliforniaToolkitCard* _tmp15_ = NULL;
			guint _tmp16_ = 0U;
			CaliforniaToolkitCard* _tmp17_ = NULL;
			CaliforniaToolkitCard* _tmp18_ = NULL;
			CaliforniaToolkitCard* _tmp19_ = NULL;
			GeeDeque* _tmp20_ = NULL;
			CaliforniaToolkitCard* _tmp21_ = NULL;
			GeeHashMap* _tmp22_ = NULL;
			CaliforniaToolkitCard* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			GeeList* _tmp26_ = NULL;
			CaliforniaToolkitCard* _tmp27_ = NULL;
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp3_ = _card_it;
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp4_) {
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 758 "toolkit-deck.c"
			}
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp5_ = _card_it;
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp6_;
#line 168 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp7_ = self->priv->names;
#line 168 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp8_ = card;
#line 168 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp9_ = california_toolkit_card_get_card_id (_tmp8_);
#line 168 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = _tmp9_;
#line 168 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp11_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_);
#line 168 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp11_) {
#line 778 "toolkit-deck.c"
				CaliforniaToolkitCard* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 169 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp12_ = card;
#line 169 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp13_ = california_toolkit_card_get_card_id (_tmp12_);
#line 169 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp14_ = _tmp13_;
#line 169 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				g_message ("toolkit-deck.vala:169: Card %s not found in Deck", _tmp14_);
#line 171 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_g_object_unref0 (card);
#line 171 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				continue;
#line 794 "toolkit-deck.c"
			}
#line 174 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp15_ = card;
#line 174 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("map", GTK_TYPE_WIDGET, &_tmp16_, NULL, FALSE);
#line 174 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GTK_TYPE_WIDGET, GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self);
#line 176 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = card;
#line 176 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GTK_TYPE_WIDGET, GtkWidget));
#line 178 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp18_ = self->priv->_top;
#line 178 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp19_ = card;
#line 178 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (_tmp18_ == _tmp19_) {
#line 179 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				california_toolkit_deck_set_top (self, NULL);
#line 814 "toolkit-deck.c"
			}
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = self->priv->navigation_stack;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp21_ = card;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), _tmp21_);
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp22_ = self->priv->names;
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp23_ = card;
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp24_ = california_toolkit_card_get_card_id (_tmp23_);
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp25_ = _tmp24_;
#line 182 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp25_, NULL);
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp26_ = self->priv->list;
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp27_ = card;
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_);
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 840 "toolkit-deck.c"
		}
#line 167 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_it);
#line 844 "toolkit-deck.c"
	}
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp30_ = displaying;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp30_) {
#line 850 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp31_ = NULL;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp31_ = self->priv->_top;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp29_ = _tmp31_ == NULL;
#line 856 "toolkit-deck.c"
	} else {
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp29_ = FALSE;
#line 860 "toolkit-deck.c"
	}
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp29_) {
#line 864 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp32_ = NULL;
		CaliforniaToolkitCard* _tmp33_ = NULL;
		CaliforniaToolkitCard* _tmp34_ = NULL;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp32_ = california_toolkit_deck_get_home (self);
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp33_ = _tmp32_;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp34_ = _tmp33_;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp28_ = _tmp34_ != NULL;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp34_);
#line 878 "toolkit-deck.c"
	} else {
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp28_ = FALSE;
#line 882 "toolkit-deck.c"
	}
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp28_) {
#line 886 "toolkit-deck.c"
		GeeDeque* _tmp35_ = NULL;
		CaliforniaToolkitCard* _tmp36_ = NULL;
		CaliforniaToolkitCard* _tmp37_ = NULL;
		CaliforniaToolkitCard* _tmp38_ = NULL;
		CaliforniaToolkitCard* _tmp39_ = NULL;
		CaliforniaToolkitCard* _tmp40_ = NULL;
		CaliforniaToolkitCard* _tmp41_ = NULL;
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp35_ = self->priv->navigation_stack;
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_COLLECTION, GeeCollection));
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp36_ = california_toolkit_deck_get_home (self);
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp37_ = _tmp36_;
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp38_ = _tmp37_;
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GTK_TYPE_WIDGET, GtkWidget));
#line 189 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp38_);
#line 190 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp39_ = california_toolkit_deck_get_home (self);
#line 190 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp40_ = _tmp39_;
#line 190 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp41_ = _tmp40_;
#line 190 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_card_jumped_to (_tmp41_, NULL, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, NULL);
#line 190 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp41_);
#line 918 "toolkit-deck.c"
	}
}


static GValue* _g_value_dup (GValue* self) {
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 926 "toolkit-deck.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self ? _g_value_dup (self) : NULL;
#line 933 "toolkit-deck.c"
}


static GValue* california_toolkit_deck_strip_null_value (CaliforniaToolkitDeck* self, GValue* message) {
	GValue* result = NULL;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GValue* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GValue* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GValue* _tmp22_ = NULL;
	GValue* _tmp23_ = NULL;
#line 194 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 195 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = message;
#line 195 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ == NULL) {
#line 196 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = NULL;
#line 196 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 958 "toolkit-deck.c"
	}
#line 198 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = message;
#line 198 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = G_VALUE_HOLDS (_tmp1_, G_TYPE_STRING);
#line 198 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp2_) {
#line 966 "toolkit-deck.c"
		GValue* _tmp3_ = NULL;
		GValue* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GValue* _tmp7_ = NULL;
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = message;
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = g_value_get_string (_tmp4_);
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp5_ != NULL) {
#line 977 "toolkit-deck.c"
			GValue* _tmp6_ = NULL;
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = message;
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp3_ = _tmp6_;
#line 983 "toolkit-deck.c"
		} else {
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp3_ = NULL;
#line 987 "toolkit-deck.c"
		}
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = __g_value_dup0 (_tmp3_);
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = _tmp7_;
#line 199 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 995 "toolkit-deck.c"
	}
#line 201 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = message;
#line 201 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = G_VALUE_HOLDS (_tmp8_, G_TYPE_OBJECT);
#line 201 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp9_) {
#line 1003 "toolkit-deck.c"
		GValue* _tmp10_ = NULL;
		GValue* _tmp11_ = NULL;
		GObject* _tmp12_ = NULL;
		GValue* _tmp14_ = NULL;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp11_ = message;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp12_ = g_value_get_object (_tmp11_);
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp12_ != NULL) {
#line 1014 "toolkit-deck.c"
			GValue* _tmp13_ = NULL;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp13_ = message;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = _tmp13_;
#line 1020 "toolkit-deck.c"
		} else {
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = NULL;
#line 1024 "toolkit-deck.c"
		}
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = __g_value_dup0 (_tmp10_);
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = _tmp14_;
#line 202 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 1032 "toolkit-deck.c"
	}
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = message;
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = G_VALUE_HOLDS (_tmp15_, G_TYPE_POINTER);
#line 204 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp16_) {
#line 1040 "toolkit-deck.c"
		GValue* _tmp17_ = NULL;
		GValue* _tmp18_ = NULL;
		void* _tmp19_ = NULL;
		GValue* _tmp21_ = NULL;
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp18_ = message;
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp19_ = g_value_get_pointer (_tmp18_);
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		if (_tmp19_ != NULL) {
#line 1051 "toolkit-deck.c"
			GValue* _tmp20_ = NULL;
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = message;
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = _tmp20_;
#line 1057 "toolkit-deck.c"
		} else {
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = NULL;
#line 1061 "toolkit-deck.c"
		}
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp21_ = __g_value_dup0 (_tmp17_);
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		result = _tmp21_;
#line 205 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return result;
#line 1069 "toolkit-deck.c"
	}
#line 207 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp22_ = message;
#line 207 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp23_ = __g_value_dup0 (_tmp22_);
#line 207 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp23_;
#line 207 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1079 "toolkit-deck.c"
}


/**
     * Force the {@link Deck} to jump to the {@link home} {@link Card}.
     *
     * In general, Deck avoids jumping to a Card if it's already displayed (on top).  However, for
     * this call it will call the Card's {@link Card.jumped_to} method and pass the supplied
     * message every time, even if already on top.  This allows for this call to be used for Deck
     * initialization.
     */
static void _vala_GValue_free (GValue* self) {
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_value_unset (self);
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_free (self);
#line 1096 "toolkit-deck.c"
}


void california_toolkit_deck_go_home (CaliforniaToolkitDeck* self, GValue* message) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeDeque* _tmp4_ = NULL;
	CaliforniaToolkitCard* _tmp5_ = NULL;
	CaliforniaToolkitCard* _tmp6_ = NULL;
	CaliforniaToolkitCard* _tmp7_ = NULL;
	CaliforniaToolkitCard* _tmp8_ = NULL;
	CaliforniaToolkitCard* _tmp9_ = NULL;
	CaliforniaToolkitCard* _tmp10_ = NULL;
	GValue* _tmp11_ = NULL;
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
#line 218 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = california_toolkit_deck_get_home (self);
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _tmp0_;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_ == NULL;
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp2_);
#line 219 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_) {
#line 220 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1131 "toolkit-deck.c"
	}
#line 223 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = self->priv->navigation_stack;
#line 223 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 225 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = california_toolkit_deck_get_home (self);
#line 225 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp6_ = _tmp5_;
#line 225 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp7_ = _tmp6_;
#line 225 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_WIDGET, GtkWidget));
#line 225 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp7_);
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = california_toolkit_deck_get_home (self);
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = _tmp8_;
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp10_ = _tmp9_;
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp11_ = message;
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp12_ = california_toolkit_deck_strip_null_value (self, _tmp11_);
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp13_ = _tmp12_;
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_card_jumped_to (_tmp10_, NULL, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, _tmp13_);
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	__vala_GValue_free0 (_tmp13_);
#line 226 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp10_);
#line 1165 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, CaliforniaToolkitCardJump reason, GValue* message) {
	GtkWidget* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeCollection* _tmp7_ = NULL;
	GeeCollection* _tmp8_ = NULL;
	CaliforniaToolkitCard* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	CaliforniaToolkitCard* _tmp15_ = NULL;
	CaliforniaToolkitCard* _tmp16_ = NULL;
	CaliforniaToolkitCard* _tmp17_ = NULL;
	CaliforniaToolkitCardJump _tmp18_ = 0;
	GValue* _tmp19_ = NULL;
	GValue* _tmp20_ = NULL;
	GValue* _tmp21_ = NULL;
#line 229 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 229 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 229 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (next));
#line 231 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack));
#line 231 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = next;
#line 231 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ == _tmp1_) {
#line 1198 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 232 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = next;
#line 232 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = california_toolkit_card_get_card_id (_tmp2_);
#line 232 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = _tmp3_;
#line 232 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_debug ("toolkit-deck.vala:232: Already showing card %s", _tmp4_);
#line 234 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1212 "toolkit-deck.c"
	}
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = self->priv->names;
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp6_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_MAP, GeeMap));
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp7_ = _tmp6_;
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = _tmp7_;
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = next;
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp11_ = !_tmp10_;
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp8_);
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp11_) {
#line 1232 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 239 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp12_ = next;
#line 239 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = california_toolkit_card_get_card_id (_tmp12_);
#line 239 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = _tmp13_;
#line 239 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:239: Card %s not registered with Deck", _tmp14_);
#line 241 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1246 "toolkit-deck.c"
	}
#line 244 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = next;
#line 244 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GTK_TYPE_WIDGET, GtkWidget));
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = next;
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = card;
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp18_ = reason;
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp19_ = message;
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp20_ = california_toolkit_deck_strip_null_value (self, _tmp19_);
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp21_ = _tmp20_;
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_card_jumped_to (_tmp16_, _tmp17_, _tmp18_, _tmp21_);
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	__vala_GValue_free0 (_tmp21_);
#line 1268 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card_instance (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, GValue* message) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	GValue* _tmp2_ = NULL;
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (next));
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = card;
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = next;
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = message;
#line 249 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card (self, _tmp0_, _tmp1_, CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT, _tmp2_);
#line 1290 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card_by_name (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, const gchar* name, GValue* message) {
	CaliforniaToolkitCard* next = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
#line 252 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 252 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 252 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (name != NULL);
#line 253 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->names;
#line 253 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = name;
#line 253 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 253 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	next = (CaliforniaToolkitCard*) _tmp2_;
#line 254 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = next;
#line 254 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_ != NULL) {
#line 1318 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp4_ = NULL;
		CaliforniaToolkitCard* _tmp5_ = NULL;
		GValue* _tmp6_ = NULL;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = card;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = next;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = message;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp4_, _tmp5_, CALIFORNIA_TOOLKIT_CARD_JUMP_DIRECT, _tmp6_);
#line 1330 "toolkit-deck.c"
	} else {
		const gchar* _tmp7_ = NULL;
#line 257 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = name;
#line 257 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:257: Card %s not found in Deck", _tmp7_);
#line 1337 "toolkit-deck.c"
	}
#line 252 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (next);
#line 1341 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_back (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	GeeDeque* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 260 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 260 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->navigation_stack;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (!_tmp2_) {
#line 1361 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp3_ = NULL;
		GeeDeque* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		CaliforniaToolkitCard* _tmp6_ = NULL;
#line 263 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = card;
#line 263 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = self->priv->navigation_stack;
#line 263 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = gee_deque_poll_head (_tmp4_);
#line 263 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = (CaliforniaToolkitCard*) _tmp5_;
#line 263 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp3_, _tmp6_, CALIFORNIA_TOOLKIT_CARD_JUMP_BACK, NULL);
#line 263 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp6_);
#line 1378 "toolkit-deck.c"
	}
}


static void california_toolkit_deck_on_jump_home (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	GeeDeque* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 266 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 266 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 268 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->navigation_stack;
#line 268 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = california_toolkit_deck_get_home (self);
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_;
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp3_);
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp4_) {
#line 1409 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp5_ = NULL;
		CaliforniaToolkitCard* _tmp6_ = NULL;
		CaliforniaToolkitCard* _tmp7_ = NULL;
		CaliforniaToolkitCard* _tmp8_ = NULL;
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = card;
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = california_toolkit_deck_get_home (self);
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = _tmp6_;
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = _tmp7_;
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp5_, _tmp8_, CALIFORNIA_TOOLKIT_CARD_JUMP_HOME, NULL);
#line 271 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp8_);
#line 1426 "toolkit-deck.c"
	} else {
#line 273 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:273: No home card in Deck");
#line 1430 "toolkit-deck.c"
	}
}


static void california_toolkit_deck_on_dismiss (CaliforniaToolkitDeck* self, gboolean user_request, gboolean final) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = user_request;
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = final;
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "dismiss", _tmp0_, _tmp1_);
#line 1446 "toolkit-deck.c"
}


static void california_toolkit_deck_on_success (CaliforniaToolkitDeck* self) {
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 281 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "success");
#line 1455 "toolkit-deck.c"
}


static void california_toolkit_deck_on_failure (CaliforniaToolkitDeck* self, const gchar* user_message) {
	const gchar* _tmp0_ = NULL;
#line 284 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 285 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = user_message;
#line 285 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "failure", _tmp0_);
#line 1467 "toolkit-deck.c"
}


static void california_toolkit_deck_on_card_mapped (CaliforniaToolkitDeck* self, GtkWidget* widget) {
	CaliforniaToolkitCard* card = NULL;
	GtkWidget* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CaliforniaToolkitCard* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	gboolean _tmp14_ = FALSE;
	CaliforniaToolkitCard* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	GtkWidget* _tmp17_ = NULL;
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 289 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = widget;
#line 289 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard));
#line 289 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	card = _tmp1_;
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = card;
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = california_toolkit_card_get_default_widget (_tmp3_);
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = _tmp4_;
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp5_ != NULL) {
#line 1501 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = card;
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = california_toolkit_card_get_default_widget (_tmp6_);
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = _tmp7_;
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = gtk_widget_get_can_default (_tmp8_);
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp10_ = _tmp9_;
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = _tmp10_;
#line 1519 "toolkit-deck.c"
	} else {
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = FALSE;
#line 1523 "toolkit-deck.c"
	}
#line 291 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp2_) {
#line 1527 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
#line 292 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp11_ = card;
#line 292 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp12_ = california_toolkit_card_get_default_widget (_tmp11_);
#line 292 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = _tmp12_;
#line 292 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_widget_grab_default (_tmp13_);
#line 1539 "toolkit-deck.c"
	}
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = card;
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = california_toolkit_card_get_initial_focus (_tmp15_);
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = _tmp16_;
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp17_ != NULL) {
#line 1549 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp18_ = NULL;
		GtkWidget* _tmp19_ = NULL;
		GtkWidget* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp18_ = card;
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp19_ = california_toolkit_card_get_initial_focus (_tmp18_);
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp20_ = _tmp19_;
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_object_get (_tmp20_, "can-focus", &_tmp21_, NULL);
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp22_ = _tmp21_;
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = _tmp22_;
#line 1567 "toolkit-deck.c"
	} else {
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = FALSE;
#line 1571 "toolkit-deck.c"
	}
#line 294 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp14_) {
#line 1575 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp23_ = NULL;
		GtkWidget* _tmp24_ = NULL;
		GtkWidget* _tmp25_ = NULL;
#line 295 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp23_ = card;
#line 295 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp24_ = california_toolkit_card_get_initial_focus (_tmp23_);
#line 295 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp25_ = _tmp24_;
#line 295 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_widget_grab_focus (_tmp25_);
#line 1587 "toolkit-deck.c"
	}
#line 288 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (card);
#line 1591 "toolkit-deck.c"
}


GtkWidget* california_toolkit_deck_get_default_widget (CaliforniaToolkitDeck* self) {
	GtkWidget* result;
#line 20 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 20 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = NULL;
#line 20 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1603 "toolkit-deck.c"
}


gint california_toolkit_deck_get_size (CaliforniaToolkitDeck* self) {
	gint result;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), 0);
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->list;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp2_;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1624 "toolkit-deck.c"
}


GeeList* california_toolkit_deck_get_cards (CaliforniaToolkitDeck* self) {
	GeeList* result;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->list;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp2_;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1645 "toolkit-deck.c"
}


CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* result;
	CaliforniaToolkitCard* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = self->priv->list;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_ > 0) {
#line 1665 "toolkit-deck.c"
		GeeList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = self->priv->list;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = gee_list_get (_tmp4_, 0);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp0_);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = (CaliforniaToolkitCard*) _tmp5_;
#line 1676 "toolkit-deck.c"
	} else {
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp0_);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = NULL;
#line 1682 "toolkit-deck.c"
	}
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp0_;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1688 "toolkit-deck.c"
}


CaliforniaToolkitCard* california_toolkit_deck_get_top (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* result;
	CaliforniaToolkitCard* _tmp0_ = NULL;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp0_;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1703 "toolkit-deck.c"
}


static void california_toolkit_deck_set_top (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* value) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = value;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->_top);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->_top = _tmp1_;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_notify ((GObject *) self, "top");
#line 1722 "toolkit-deck.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (n_param_values == 3);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data1 = closure->data;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data2 = param_values->data[0].v_pointer;
#line 1741 "toolkit-deck.c"
	} else {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data1 = param_values->data[0].v_pointer;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data2 = closure->data;
#line 1747 "toolkit-deck.c"
	}
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
#line 1753 "toolkit-deck.c"
}


static void california_toolkit_deck_class_init (CaliforniaToolkitDeckClass * klass) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaToolkitDeckPrivate));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_toolkit_deck_get_property;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_toolkit_deck_set_property;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->finalize = california_toolkit_deck_finalize;
#line 1768 "toolkit-deck.c"
	/**
	     * @inheritedDoc
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET, g_param_spec_object ("default-widget", "default-widget", "default-widget", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1774 "toolkit-deck.c"
	/**
	     * The number of {@link Card}s registered to the {@link Deck}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1780 "toolkit-deck.c"
	/**
	     * All registered {@link Card}s returned as a read-only List.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_CARDS, g_param_spec_object ("cards", "cards", "cards", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1786 "toolkit-deck.c"
	/**
	     * The home {@link Card}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_HOME, g_param_spec_object ("home", "home", "home", CALIFORNIA_TOOLKIT_TYPE_CARD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1792 "toolkit-deck.c"
	/**
	     * The current displayed {@link Card}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_TOP, g_param_spec_object ("top", "top", "top", CALIFORNIA_TOOLKIT_TYPE_CARD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1798 "toolkit-deck.c"
	/**
	     * @see Card.dismiss
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("dismiss", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
#line 1804 "toolkit-deck.c"
	/**
	     * @see Card.success
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("success", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1810 "toolkit-deck.c"
	/**
	     * @see Card.failure
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("failure", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 1816 "toolkit-deck.c"
}


static void california_toolkit_deck_instance_init (CaliforniaToolkitDeck * self) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv = CALIFORNIA_TOOLKIT_DECK_GET_PRIVATE (self);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->_top = NULL;
#line 42 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = gee_linked_list_new (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 42 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
#line 43 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_linked_list_new (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 43 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->navigation_stack = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_DEQUE, GeeDeque);
#line 44 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 44 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->names = _tmp2_;
#line 1840 "toolkit-deck.c"
}


static void california_toolkit_deck_finalize (GObject* obj) {
	CaliforniaToolkitDeck * self;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 1848 "toolkit-deck.c"
	{
		GeeIterator* _card_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = self->priv->names;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap));
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = _tmp1_;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = _tmp2_;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = _tmp4_;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp3_);
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_it = _tmp5_;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 1875 "toolkit-deck.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			CaliforniaToolkitCard* card = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			CaliforniaToolkitCard* _tmp10_ = NULL;
			guint _tmp11_ = 0U;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = _card_it;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp7_) {
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 1891 "toolkit-deck.c"
			}
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp8_ = _card_it;
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp9_;
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = card;
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("map", GTK_TYPE_WIDGET, &_tmp11_, NULL, FALSE);
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_WIDGET, GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self);
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 1907 "toolkit-deck.c"
		}
#line 76 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_it);
#line 1911 "toolkit-deck.c"
	}
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->_top);
#line 42 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->list);
#line 43 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->navigation_stack);
#line 44 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->names);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (california_toolkit_deck_parent_class)->finalize (obj);
#line 1923 "toolkit-deck.c"
}


/**
 * A Deck is a collection of {@link Card}s maintained within a Gtk.Stack.
 *
 * Cards control navigation through their various signals, which Deck monitors and acts upon.
 * It also notifies Cards of nagivation changes which affect them via their abstract methods.
 */
GType california_toolkit_deck_get_type (void) {
	static volatile gsize california_toolkit_deck_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_deck_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaToolkitDeckClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_toolkit_deck_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaToolkitDeck), 0, (GInstanceInitFunc) california_toolkit_deck_instance_init, NULL };
		GType california_toolkit_deck_type_id;
		california_toolkit_deck_type_id = g_type_register_static (GTK_TYPE_STACK, "CaliforniaToolkitDeck", &g_define_type_info, 0);
		g_once_init_leave (&california_toolkit_deck_type_id__volatile, california_toolkit_deck_type_id);
	}
	return california_toolkit_deck_type_id__volatile;
}


static void _vala_california_toolkit_deck_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitDeck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_object (value, california_toolkit_deck_get_default_widget (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_SIZE:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_int (value, california_toolkit_deck_get_size (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_CARDS:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_take_object (value, california_toolkit_deck_get_cards (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_HOME:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_take_object (value, california_toolkit_deck_get_home (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_TOP:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_object (value, california_toolkit_deck_get_top (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 1980 "toolkit-deck.c"
		default:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 1986 "toolkit-deck.c"
	}
}


static void _vala_california_toolkit_deck_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitDeck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_TOP:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_set_top (self, g_value_get_object (value));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 2002 "toolkit-deck.c"
		default:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 2008 "toolkit-deck.c"
	}
}



