/* calendar-date.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-date.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;
typedef struct _CaliforniaCalendarSpanPrivate CaliforniaCalendarSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;
typedef struct _CaliforniaCalendarUnitPrivate CaliforniaCalendarUnitPrivate;
typedef struct _CaliforniaCalendarDatePrivate CaliforniaCalendarDatePrivate;

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK (california_calendar_day_of_week_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeek))
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeekClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_WEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK))
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, CaliforniaCalendarDayOfWeekClass))

typedef struct _CaliforniaCalendarDayOfWeek CaliforniaCalendarDayOfWeek;
typedef struct _CaliforniaCalendarDayOfWeekClass CaliforniaCalendarDayOfWeekClass;

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH (california_calendar_day_of_month_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonth))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))

typedef struct _CaliforniaCalendarDayOfMonth CaliforniaCalendarDayOfMonth;
typedef struct _CaliforniaCalendarDayOfMonthClass CaliforniaCalendarDayOfMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH (california_calendar_month_get_type ())
#define CALIFORNIA_CALENDAR_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonth))
#define CALIFORNIA_CALENDAR_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))
#define CALIFORNIA_CALENDAR_IS_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_IS_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))

typedef struct _CaliforniaCalendarMonth CaliforniaCalendarMonth;
typedef struct _CaliforniaCalendarMonthClass CaliforniaCalendarMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;

#define CALIFORNIA_CALENDAR_DATE_TYPE_PRETTY_FLAG (california_calendar_date_pretty_flag_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK (california_calendar_first_of_week_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_WEEK (california_calendar_week_get_type ())
#define CALIFORNIA_CALENDAR_WEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek))
#define CALIFORNIA_CALENDAR_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))
#define CALIFORNIA_CALENDAR_IS_WEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_IS_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_WEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))

typedef struct _CaliforniaCalendarWeek CaliforniaCalendarWeek;
typedef struct _CaliforniaCalendarWeekClass CaliforniaCalendarWeekClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR (california_calendar_month_of_year_get_type ())
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))

typedef struct _CaliforniaCalendarMonthOfYear CaliforniaCalendarMonthOfYear;
typedef struct _CaliforniaCalendarMonthOfYearClass CaliforniaCalendarMonthOfYearClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSpanPrivate * priv;
};

struct _CaliforniaCalendarSpanClass {
	CaliforniaBaseObjectClass parent_class;
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (CaliforniaCollectionSimpleIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (CaliforniaCollectionSimpleIterable* self);
	GDestroyNotify (*get_g_destroy_func) (CaliforniaCollectionSimpleIterable* self);
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarUnit {
	CaliforniaCalendarSpan parent_instance;
	CaliforniaCalendarUnitPrivate * priv;
};

struct _CaliforniaCalendarUnitClass {
	CaliforniaCalendarSpanClass parent_class;
	gpointer (*adjust) (CaliforniaCalendarUnit* self, gint quantity);
	gint (*difference) (CaliforniaCalendarUnit* self, gconstpointer other);
};

struct _CaliforniaCalendarDate {
	CaliforniaCalendarUnit parent_instance;
	CaliforniaCalendarDatePrivate * priv;
};

struct _CaliforniaCalendarDateClass {
	CaliforniaCalendarUnitClass parent_class;
};

struct _CaliforniaCalendarDatePrivate {
	CaliforniaCalendarDayOfWeek* _day_of_week;
	CaliforniaCalendarDayOfMonth* _day_of_month;
	gint _day_of_year;
	CaliforniaCalendarMonth* _month;
	CaliforniaCalendarYear* _year;
	GDate gdate;
};

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV = 1 << 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT = 1 << 1,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR = 1 << 2,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY = 1 << 3,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK = 1 << 4
} CaliforniaCalendarDatePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;

typedef enum  {
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_DEFAULT = CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY
} CaliforniaCalendarFirstOfWeek;


static gpointer california_calendar_date_parent_class = NULL;
extern const gchar* california_calendar_FMT_FULL_DATE;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV;
extern const gchar* california_calendar_FMT_PRETTY_DATE_ABBREV_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT;
extern const gchar* california_calendar_FMT_PRETTY_DATE_COMPACT_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_DOW;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_DOW_NO_YEAR;
extern const gchar* california_calendar_FMT_PRETTY_DATE;
extern const gchar* california_calendar_FMT_PRETTY_DATE_NO_YEAR;
static GeeComparableIface* california_calendar_date_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_date_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_day_of_week_get_type (void) G_GNUC_CONST;
GType california_calendar_day_of_month_get_type (void) G_GNUC_CONST;
GType california_calendar_month_get_type (void) G_GNUC_CONST;
GType california_calendar_year_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDatePrivate))
enum  {
	CALIFORNIA_CALENDAR_DATE_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_DATE_START_DATE,
	CALIFORNIA_CALENDAR_DATE_END_DATE,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH,
	CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR,
	CALIFORNIA_CALENDAR_DATE_MONTH,
	CALIFORNIA_CALENDAR_DATE_YEAR
};
GType california_calendar_date_pretty_flag_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DATE_PROP_DAY_OF_WEEK "day-of-week"
#define CALIFORNIA_CALENDAR_DATE_PROP_DAY_OF_MONTH "day-of-month"
#define CALIFORNIA_CALENDAR_DATE_PROP_MONTH "month"
#define CALIFORNIA_CALENDAR_DATE_PROP_YEAR "year"
GQuark california_calendar_error_quark (void);
CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarUnit* california_calendar_unit_construct_uninitialized (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit);
GDateDay california_calendar_day_of_month_to_date_day (CaliforniaCalendarDayOfMonth* self);
GDateMonth california_calendar_month_to_date_month (CaliforniaCalendarMonth* self);
GDateYear california_calendar_year_to_date_year (CaliforniaCalendarYear* self);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
CaliforniaCalendarDayOfWeek* california_calendar_day_of_week_from_gdate (GDate* date);
static void california_calendar_date_set_day_of_week (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfWeek* value);
static void california_calendar_date_set_day_of_month (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfMonth* value);
static void california_calendar_date_set_day_of_year (CaliforniaCalendarDate* self, gint value);
static void california_calendar_date_set_month (CaliforniaCalendarDate* self, CaliforniaCalendarMonth* value);
static void california_calendar_date_set_year (CaliforniaCalendarDate* self, CaliforniaCalendarYear* value);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDayOfMonth* california_calendar_exact_time_get_day_of_month (CaliforniaCalendarExactTime* self);
CaliforniaCalendarMonth* california_calendar_exact_time_get_month (CaliforniaCalendarExactTime* self);
CaliforniaCalendarYear* california_calendar_exact_time_get_year (CaliforniaCalendarExactTime* self);
CaliforniaCalendarDayOfMonth* california_calendar_date_get_day_of_month (CaliforniaCalendarDate* self);
CaliforniaCalendarMonth* california_calendar_date_get_month (CaliforniaCalendarDate* self);
CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_date_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_exact_time_new_now (CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct_now (GType object_type, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_date_new_from_gdate (GDate* gdate);
CaliforniaCalendarDate* california_calendar_date_construct_from_gdate (GType object_type, GDate* gdate);
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_from_gdate (GDate* gdate);
CaliforniaCalendarMonth* california_calendar_month_from_gdate (GDate* gdate);
CaliforniaCalendarYear* california_calendar_year_new_from_gdate (GDate* gdate);
CaliforniaCalendarYear* california_calendar_year_construct_from_gdate (GType object_type, GDate* gdate);
GType california_calendar_first_of_week_get_type (void) G_GNUC_CONST;
GType california_calendar_week_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWeek* california_calendar_date_week_of (CaliforniaCalendarDate* self, CaliforniaCalendarFirstOfWeek first);
CaliforniaCalendarDayOfWeek* california_calendar_date_get_day_of_week (CaliforniaCalendarDate* self);
gint california_calendar_day_of_week_ordinal (CaliforniaCalendarDayOfWeek* self, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarDayOfWeek* california_calendar_first_of_week_as_day_of_week (CaliforniaCalendarFirstOfWeek self);
CaliforniaCalendarDate* california_calendar_date_adjust_by (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit);
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_MAX 7
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_MIN 1
#define CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT ((CALIFORNIA_CALENDAR_DAY_OF_WEEK_MAX - CALIFORNIA_CALENDAR_DAY_OF_WEEK_MIN) + 1)
GType california_calendar_month_of_year_get_type (void) G_GNUC_CONST;
CaliforniaCalendarMonthOfYear* california_calendar_date_month_of_year (CaliforniaCalendarDate* self);
CaliforniaCalendarWeek* california_calendar_week_new (CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarWeek* california_calendar_week_construct (GType object_type, CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_new (CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_construct (GType object_type, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
static CaliforniaCalendarDate* california_calendar_date_real_adjust (CaliforniaCalendarUnit* base, gint quantity);
CaliforniaCalendarDate* california_calendar_date_upcoming (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target);
static CaliforniaCalendarDate* california_calendar_date_upcoming_prior (CaliforniaCalendarDate* self, gboolean inclusive, gint adjustment, GeePredicate predicate, void* predicate_target);
CaliforniaCalendarDate* california_calendar_date_prior (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target);
gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity);
static gint california_calendar_date_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarDate* other);
CaliforniaCalendarDate* california_calendar_date_clamp (CaliforniaCalendarDate* self, CaliforniaCalendarDate* min, CaliforniaCalendarDate* max);
static gint california_calendar_date_real_compare_to (GeeComparable* base, CaliforniaCalendarDate* other);
static gboolean california_calendar_date_real_equal_to (GeeHashable* base, CaliforniaCalendarDate* other);
static guint california_calendar_date_real_hash (GeeHashable* base);
gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt);
gchar* california_calendar_date_to_standard_string (CaliforniaCalendarDate* self);
gchar* california_calendar_date_to_pretty_string (CaliforniaCalendarDate* self, CaliforniaCalendarDatePrettyFlag flags);
CaliforniaCalendarDate* california_calendar_system_get_today (void);
gchar* california_string_reduce_whitespace (const gchar* str);
gchar* california_string_remove_leading_chars (const gchar* str, gunichar ch, const gchar* delims);
static gchar* california_calendar_date_real_to_string (CaliforniaBaseObject* base);
gint california_calendar_date_get_day_of_year (CaliforniaCalendarDate* self);
static void california_calendar_date_finalize (GObject* obj);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
static void _vala_california_calendar_date_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_date_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Options for {@link to_pretty_string}.
     */
GType california_calendar_date_pretty_flag_get_type (void) {
	static volatile gsize california_calendar_date_pretty_flag_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_pretty_flag_type_id__volatile)) {
		static const GFlagsValue values[] = {{CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE", "none"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV", "abbrev"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT", "compact"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR", "include-year"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY", "no-today"}, {CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK, "CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK", "no-day-of-week"}, {0, NULL, NULL}};
		GType california_calendar_date_pretty_flag_type_id;
		california_calendar_date_pretty_flag_type_id = g_flags_register_static ("CaliforniaCalendarDatePrettyFlag", values);
		g_once_init_leave (&california_calendar_date_pretty_flag_type_id__volatile, california_calendar_date_pretty_flag_type_id);
	}
	return california_calendar_date_pretty_flag_type_id__volatile;
}


/**
     * Creates a new {@link Date} object for the day, month, and year.
     *
     * @throws CalendarError if an invalid calendar day
     */
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
	GDateDay _tmp1_ = '\0';
	CaliforniaCalendarMonth* _tmp2_ = NULL;
	GDateMonth _tmp3_ = 0;
	CaliforniaCalendarYear* _tmp4_ = NULL;
	GDateYear _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	GDate _tmp18_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp19_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp20_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	CaliforniaCalendarMonth* _tmp23_ = NULL;
	CaliforniaCalendarYear* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 86 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH (day_of_month), NULL);
#line 86 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH (month), NULL);
#line 86 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (year), NULL);
#line 87 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = day_of_month;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_day_of_month_to_date_day (_tmp0_);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = month;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = california_calendar_month_to_date_month (_tmp2_);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = year;
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = california_calendar_year_to_date_year (_tmp4_);
#line 89 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&self->priv->gdate, _tmp1_, (gint) _tmp3_, _tmp5_);
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = g_date_valid (&self->priv->gdate);
#line 90 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp6_) {
#line 441 "calendar-date.c"
		CaliforniaCalendarDayOfMonth* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		CaliforniaCalendarMonth* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		CaliforniaCalendarYear* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = day_of_month;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp8_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = _tmp8_;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = month;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = _tmp11_;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = year;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = _tmp14_;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp16_ = g_error_new (CALIFORNIA_CALENDAR_ERROR, CALIFORNIA_CALENDAR_ERROR_INVALID, "Invalid day/month/year %s/%s/%s", _tmp9_, _tmp12_, _tmp15_);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp17_ = _tmp16_;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp15_);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp12_);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_free0 (_tmp9_);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_inner_error_ = _tmp17_;
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_propagate_error (error, _inner_error_);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_g_object_unref0 (self);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return NULL;
#line 491 "calendar-date.c"
		} else {
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_clear_error (&_inner_error_);
#line 91 "/home/jim/git/california/src/calendar/calendar-date.vala"
			return NULL;
#line 499 "calendar-date.c"
		}
	}
#line 95 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = self->priv->gdate;
#line 95 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp19_ = california_calendar_day_of_week_from_gdate (&_tmp18_);
#line 95 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp20_ = _tmp19_;
#line 95 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp20_);
#line 95 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp20_);
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = day_of_month;
#line 96 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp21_);
#line 97 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = g_date_get_day_of_year (&self->priv->gdate);
#line 97 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp22_);
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp23_ = month;
#line 98 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp23_);
#line 99 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = year;
#line 99 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp24_);
#line 86 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 530 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error) {
#line 86 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct (CALIFORNIA_CALENDAR_TYPE_DATE, day_of_month, month, year, error);
#line 537 "calendar-date.c"
}


/**
     * Creates a {@link Date} for the {@link ExactTime}.
     */
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarExactTime* _tmp0_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp2_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp3_ = NULL;
	CaliforniaCalendarExactTime* _tmp4_ = NULL;
	CaliforniaCalendarMonth* _tmp5_ = NULL;
	CaliforniaCalendarMonth* _tmp6_ = NULL;
	CaliforniaCalendarMonth* _tmp7_ = NULL;
	CaliforniaCalendarExactTime* _tmp8_ = NULL;
	CaliforniaCalendarYear* _tmp9_ = NULL;
	CaliforniaCalendarYear* _tmp10_ = NULL;
	CaliforniaCalendarYear* _tmp11_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp12_ = NULL;
	GDateDay _tmp13_ = '\0';
	CaliforniaCalendarMonth* _tmp14_ = NULL;
	GDateMonth _tmp15_ = 0;
	CaliforniaCalendarYear* _tmp16_ = NULL;
	GDateYear _tmp17_ = 0U;
	gboolean _tmp18_ = FALSE;
	GDate _tmp19_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp20_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME (exact_time), NULL);
#line 106 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 109 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = exact_time;
#line 109 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_exact_time_get_day_of_month (_tmp0_);
#line 109 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_;
#line 109 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = _tmp2_;
#line 109 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp3_);
#line 109 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp3_);
#line 110 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = exact_time;
#line 110 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = california_calendar_exact_time_get_month (_tmp4_);
#line 110 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = _tmp5_;
#line 110 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp7_);
#line 110 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp7_);
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = exact_time;
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = california_calendar_exact_time_get_year (_tmp8_);
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = _tmp9_;
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp11_ = _tmp10_;
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp11_);
#line 111 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp11_);
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp12_ = self->priv->_day_of_month;
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp13_ = california_calendar_day_of_month_to_date_day (_tmp12_);
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = self->priv->_month;
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp15_ = california_calendar_month_to_date_month (_tmp14_);
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = self->priv->_year;
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_year_to_date_year (_tmp16_);
#line 113 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&self->priv->gdate, _tmp13_, (gint) _tmp15_, _tmp17_);
#line 114 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = g_date_valid (&self->priv->gdate);
#line 114 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp18_, "gdate.valid()");
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp19_ = self->priv->gdate;
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp20_ = california_calendar_day_of_week_from_gdate (&_tmp19_);
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = _tmp20_;
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp21_);
#line 116 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp21_);
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = g_date_get_day_of_year (&self->priv->gdate);
#line 117 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp22_);
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 643 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time) {
#line 105 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_from_exact_time (CALIFORNIA_CALENDAR_TYPE_DATE, exact_time);
#line 650 "calendar-date.c"
}


/**
     * Creates a {@link Date} that corresponds to the current time in the specified {@link Timezone}.
     */
CaliforniaCalendarDate* california_calendar_date_construct_now (GType object_type, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarDate * self = NULL;
	CaliforniaCalendarTimezone* _tmp0_ = NULL;
	CaliforniaCalendarExactTime* _tmp1_ = NULL;
	CaliforniaCalendarExactTime* _tmp2_ = NULL;
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 124 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = tz;
#line 124 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_exact_time_new_now (_tmp0_);
#line 124 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_;
#line 124 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_date_construct_from_exact_time (object_type, _tmp2_);
#line 124 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp2_);
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 676 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_now (CaliforniaCalendarTimezone* tz) {
#line 123 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_now (CALIFORNIA_CALENDAR_TYPE_DATE, tz);
#line 683 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_construct_from_gdate (GType object_type, GDate* gdate) {
	CaliforniaCalendarDate * self = NULL;
	gboolean _tmp0_ = FALSE;
	GDate _tmp1_ = {0};
	GDate _tmp2_ = {0};
	CaliforniaCalendarDayOfWeek* _tmp3_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp4_ = NULL;
	GDate _tmp5_ = {0};
	CaliforniaCalendarDayOfMonth* _tmp6_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	GDate _tmp9_ = {0};
	CaliforniaCalendarMonth* _tmp10_ = NULL;
	CaliforniaCalendarMonth* _tmp11_ = NULL;
	GDate _tmp12_ = {0};
	CaliforniaCalendarYear* _tmp13_ = NULL;
	CaliforniaCalendarYear* _tmp14_ = NULL;
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (gdate != NULL, NULL);
#line 128 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = (CaliforniaCalendarDate*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 130 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_date_valid (gdate);
#line 130 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp0_, "gdate.valid()");
#line 132 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = *gdate;
#line 132 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->gdate = _tmp1_;
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = *gdate;
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = california_calendar_day_of_week_from_gdate (&_tmp2_);
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = _tmp3_;
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_week (self, _tmp4_);
#line 134 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp4_);
#line 135 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = *gdate;
#line 135 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = california_calendar_day_of_month_from_gdate (&_tmp5_);
#line 135 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = _tmp6_;
#line 135 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_month (self, _tmp7_);
#line 135 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp7_);
#line 136 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = g_date_get_day_of_year (gdate);
#line 136 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_day_of_year (self, (gint) _tmp8_);
#line 137 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = *gdate;
#line 137 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = california_calendar_month_from_gdate (&_tmp9_);
#line 137 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp11_ = _tmp10_;
#line 137 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_month (self, _tmp11_);
#line 137 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp11_);
#line 138 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp12_ = *gdate;
#line 138 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp13_ = california_calendar_year_new_from_gdate (&_tmp12_);
#line 138 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = _tmp13_;
#line 138 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_set_year (self, _tmp14_);
#line 138 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp14_);
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self;
#line 762 "calendar-date.c"
}


CaliforniaCalendarDate* california_calendar_date_new_from_gdate (GDate* gdate) {
#line 127 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return california_calendar_date_construct_from_gdate (CALIFORNIA_CALENDAR_TYPE_DATE, gdate);
#line 769 "calendar-date.c"
}


/**
     * Returns the {@link Week} the {@link Date} falls in.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return self ? g_object_ref (self) : NULL;
#line 779 "calendar-date.c"
}


CaliforniaCalendarWeek* california_calendar_date_week_of (CaliforniaCalendarDate* self, CaliforniaCalendarFirstOfWeek first) {
	CaliforniaCalendarWeek* result = NULL;
	gint ahead = 0;
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp1_ = 0;
	gint _tmp2_ = 0;
	CaliforniaCalendarFirstOfWeek _tmp3_ = 0;
	CaliforniaCalendarDayOfWeek* _tmp4_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp5_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	CaliforniaCalendarDate* start = NULL;
	gint _tmp10_ = 0;
	CaliforniaCalendarDate* end = NULL;
	CaliforniaCalendarDate* _tmp16_ = NULL;
	CaliforniaCalendarDate* _tmp17_ = NULL;
	gint week_of_year = 0;
	CaliforniaCalendarFirstOfWeek _tmp18_ = 0;
	GDate first_of_month = {0};
	CaliforniaCalendarMonth* _tmp21_ = NULL;
	GDateMonth _tmp22_ = 0;
	CaliforniaCalendarYear* _tmp23_ = NULL;
	GDateYear _tmp24_ = 0U;
	gboolean _tmp25_ = FALSE;
	gint week_of_month = 0;
	CaliforniaCalendarFirstOfWeek _tmp26_ = 0;
	CaliforniaCalendarDate* _tmp31_ = NULL;
	CaliforniaCalendarDate* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	CaliforniaCalendarMonthOfYear* _tmp35_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp36_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp37_ = 0;
	CaliforniaCalendarWeek* _tmp38_ = NULL;
	CaliforniaCalendarWeek* _tmp39_ = NULL;
#line 144 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_week;
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = first;
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_day_of_week_ordinal (_tmp0_, _tmp1_);
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = first;
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = california_calendar_first_of_week_as_day_of_week (_tmp3_);
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = _tmp4_;
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = first;
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = california_calendar_day_of_week_ordinal (_tmp5_, _tmp6_);
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp8_ = _tmp2_ - _tmp7_;
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp5_);
#line 146 "/home/jim/git/california/src/calendar/calendar-date.vala"
	ahead = _tmp8_;
#line 147 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp9_ = ahead;
#line 147 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp9_ >= 0, "ahead >= 0");
#line 150 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp10_ = ahead;
#line 150 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp10_ == 0) {
#line 852 "calendar-date.c"
		CaliforniaCalendarDate* _tmp11_ = NULL;
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = _g_object_ref0 (self);
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (start);
#line 151 "/home/jim/git/california/src/calendar/calendar-date.vala"
		start = _tmp11_;
#line 860 "calendar-date.c"
	} else {
		GDate clone = {0};
		GDate _tmp12_ = {0};
		gint _tmp13_ = 0;
		GDate _tmp14_ = {0};
		CaliforniaCalendarDate* _tmp15_ = NULL;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = self->priv->gdate;
#line 153 "/home/jim/git/california/src/calendar/calendar-date.vala"
		clone = _tmp12_;
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = ahead;
#line 154 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_date_subtract_days (&clone, (guint) _tmp13_);
#line 155 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp14_ = clone;
#line 155 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = california_calendar_date_new_from_gdate (&_tmp14_);
#line 155 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (start);
#line 155 "/home/jim/git/california/src/calendar/calendar-date.vala"
		start = _tmp15_;
#line 883 "calendar-date.c"
	}
#line 159 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = start;
#line 159 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_date_adjust_by (_tmp16_, CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT - 1, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 159 "/home/jim/git/california/src/calendar/calendar-date.vala"
	end = _tmp17_;
#line 163 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp18_ = first;
#line 163 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp18_) {
#line 163 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY:
#line 897 "calendar-date.c"
		{
			guint _tmp19_ = 0U;
#line 165 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp19_ = g_date_get_monday_week_of_year (&self->priv->gdate);
#line 165 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_year = (gint) _tmp19_;
#line 166 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 906 "calendar-date.c"
		}
#line 163 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY:
#line 910 "calendar-date.c"
		{
			guint _tmp20_ = 0U;
#line 169 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp20_ = g_date_get_sunday_week_of_year (&self->priv->gdate);
#line 169 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_year = (gint) _tmp20_;
#line 170 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 919 "calendar-date.c"
		}
		default:
		{
#line 173 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 925 "calendar-date.c"
		}
	}
#line 177 "/home/jim/git/california/src/calendar/calendar-date.vala"
	memset (&first_of_month, 0, sizeof (GDate));
#line 178 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp21_ = self->priv->_month;
#line 178 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp22_ = california_calendar_month_to_date_month (_tmp21_);
#line 178 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp23_ = self->priv->_year;
#line 178 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp24_ = california_calendar_year_to_date_year (_tmp23_);
#line 178 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_set_dmy (&first_of_month, (GDateDay) 1, (gint) _tmp22_, _tmp24_);
#line 179 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp25_ = g_date_valid (&first_of_month);
#line 179 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_vala_assert (_tmp25_, "first_of_month.valid()");
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp26_ = first;
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp26_) {
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY:
#line 950 "calendar-date.c"
		{
			gint _tmp27_ = 0;
			guint _tmp28_ = 0U;
#line 184 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp27_ = week_of_year;
#line 184 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp28_ = g_date_get_monday_week_of_year (&first_of_month);
#line 184 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_month = (_tmp27_ - ((gint) _tmp28_)) + 1;
#line 185 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 962 "calendar-date.c"
		}
#line 182 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY:
#line 966 "calendar-date.c"
		{
			gint _tmp29_ = 0;
			guint _tmp30_ = 0U;
#line 188 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp29_ = week_of_year;
#line 188 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp30_ = g_date_get_sunday_week_of_year (&first_of_month);
#line 188 "/home/jim/git/california/src/calendar/calendar-date.vala"
			week_of_month = (_tmp29_ - ((gint) _tmp30_)) + 1;
#line 189 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 978 "calendar-date.c"
		}
		default:
		{
#line 192 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 984 "calendar-date.c"
		}
	}
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp31_ = start;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp32_ = end;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp33_ = week_of_month;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp34_ = week_of_year;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp35_ = california_calendar_date_month_of_year (self);
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp36_ = _tmp35_;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp37_ = first;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp38_ = california_calendar_week_new (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp36_, _tmp37_);
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp39_ = _tmp38_;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp36_);
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp39_;
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (end);
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (start);
#line 195 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1015 "calendar-date.c"
}


/**
     * Returns the {@link MonthOfYear} the {@link Date} falls in.
     */
CaliforniaCalendarMonthOfYear* california_calendar_date_month_of_year (CaliforniaCalendarDate* self) {
	CaliforniaCalendarMonthOfYear* result = NULL;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp2_ = NULL;
#line 201 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_month;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = self->priv->_year;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_month_of_year_new (_tmp0_, _tmp1_);
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 202 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1039 "calendar-date.c"
}


/**
     * @inheritDoc
     */
static CaliforniaCalendarDate* california_calendar_date_real_adjust (CaliforniaCalendarUnit* base, gint quantity) {
	CaliforniaCalendarDate * self;
	CaliforniaCalendarDate* result = NULL;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 208 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = quantity;
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_date_adjust_by (self, _tmp0_, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_;
#line 209 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1061 "calendar-date.c"
}


/**
     * Returns a new {@link Date} adjusted from this Date by the specifed quantity of time.
     *
     * Subtraction (adjusting to a past date) is acheived by using a negative quantity.
     */
CaliforniaCalendarDate* california_calendar_date_adjust_by (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit) {
	CaliforniaCalendarDate* result = NULL;
	gint _tmp0_ = 0;
	GDate clone = {0};
	GDate _tmp2_ = {0};
	CaliforniaCalendarDateUnit _tmp3_ = 0;
	GDate _tmp16_ = {0};
	CaliforniaCalendarDate* _tmp17_ = NULL;
#line 217 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 218 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = quantity;
#line 218 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp0_ == 0) {
#line 1084 "calendar-date.c"
		CaliforniaCalendarDate* _tmp1_ = NULL;
#line 219 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 219 "/home/jim/git/california/src/calendar/calendar-date.vala"
		result = _tmp1_;
#line 219 "/home/jim/git/california/src/calendar/calendar-date.vala"
		return result;
#line 1092 "calendar-date.c"
	}
#line 221 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = self->priv->gdate;
#line 221 "/home/jim/git/california/src/calendar/calendar-date.vala"
	clone = _tmp2_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = unit;
#line 222 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (_tmp3_) {
#line 222 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_DAY:
#line 1104 "calendar-date.c"
		{
			gint _tmp4_ = 0;
#line 224 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp4_ = quantity;
#line 224 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp4_ > 0) {
#line 1111 "calendar-date.c"
				gint _tmp5_ = 0;
#line 225 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp5_ = quantity;
#line 225 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_days (&clone, (guint) _tmp5_);
#line 1117 "calendar-date.c"
			} else {
				gint _tmp6_ = 0;
#line 227 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp6_ = quantity;
#line 227 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_days (&clone, (guint) (-_tmp6_));
#line 1124 "calendar-date.c"
			}
#line 228 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1128 "calendar-date.c"
		}
#line 222 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_WEEK:
#line 1132 "calendar-date.c"
		{
			gint _tmp7_ = 0;
#line 231 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp7_ = quantity;
#line 231 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp7_ > 0) {
#line 1139 "calendar-date.c"
				gint _tmp8_ = 0;
#line 232 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp8_ = quantity;
#line 232 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_days (&clone, (guint) (_tmp8_ * CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT));
#line 1145 "calendar-date.c"
			} else {
				gint _tmp9_ = 0;
#line 234 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp9_ = quantity;
#line 234 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_days (&clone, (guint) ((-_tmp9_) * CALIFORNIA_CALENDAR_DAY_OF_WEEK_COUNT));
#line 1152 "calendar-date.c"
			}
#line 235 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1156 "calendar-date.c"
		}
#line 222 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_MONTH:
#line 1160 "calendar-date.c"
		{
			gint _tmp10_ = 0;
#line 238 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp10_ = quantity;
#line 238 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp10_ > 0) {
#line 1167 "calendar-date.c"
				gint _tmp11_ = 0;
#line 239 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp11_ = quantity;
#line 239 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_months (&clone, (guint) _tmp11_);
#line 1173 "calendar-date.c"
			} else {
				gint _tmp12_ = 0;
#line 241 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp12_ = quantity;
#line 241 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_months (&clone, (guint) (-_tmp12_));
#line 1180 "calendar-date.c"
			}
#line 242 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1184 "calendar-date.c"
		}
#line 222 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_UNIT_YEAR:
#line 1188 "calendar-date.c"
		{
			gint _tmp13_ = 0;
#line 245 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp13_ = quantity;
#line 245 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp13_ > 0) {
#line 1195 "calendar-date.c"
				gint _tmp14_ = 0;
#line 246 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp14_ = quantity;
#line 246 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_add_years (&clone, (guint) _tmp14_);
#line 1201 "calendar-date.c"
			} else {
				gint _tmp15_ = 0;
#line 248 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp15_ = quantity;
#line 248 "/home/jim/git/california/src/calendar/calendar-date.vala"
				g_date_subtract_years (&clone, (guint) (-_tmp15_));
#line 1208 "calendar-date.c"
			}
#line 249 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1212 "calendar-date.c"
		}
		default:
		{
#line 252 "/home/jim/git/california/src/calendar/calendar-date.vala"
			g_assert_not_reached ();
#line 1218 "calendar-date.c"
		}
	}
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp16_ = clone;
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp17_ = california_calendar_date_new_from_gdate (&_tmp16_);
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp17_;
#line 255 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1229 "calendar-date.c"
}


/**
     * Returns the {@link Date} of the upcoming (next chronological) Date that matches
     * the predicate's requirements.
     *
     * inclusive indicates if this Date is included in the search.
     *
     * @see prior
     */
CaliforniaCalendarDate* california_calendar_date_upcoming (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeePredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
#line 266 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 267 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = inclusive;
#line 267 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = predicate;
#line 267 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1__target = predicate_target;
#line 267 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_date_upcoming_prior (self, _tmp0_, 1, _tmp1_, _tmp1__target);
#line 267 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 267 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1261 "calendar-date.c"
}


/**
     * Returns the {@link Date} of the prior (next chronological) Date that matches
     * the predicate's requirements.
     *
     * inclusive indicates if this Date is included in the search.
     *
     * @see upcoming
     */
CaliforniaCalendarDate* california_calendar_date_prior (CaliforniaCalendarDate* self, gboolean inclusive, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeePredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
#line 278 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = inclusive;
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = predicate;
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1__target = predicate_target;
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = california_calendar_date_upcoming_prior (self, _tmp0_, -1, _tmp1_, _tmp1__target);
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 279 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1293 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_upcoming_prior (CaliforniaCalendarDate* self, gboolean inclusive, gint adjustment, GeePredicate predicate, void* predicate_target) {
	CaliforniaCalendarDate* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarDate* current = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
#line 282 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = inclusive;
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp1_) {
#line 1309 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = _g_object_ref0 (self);
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (_tmp0_);
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp2_;
#line 1317 "calendar-date.c"
	} else {
		gint _tmp3_ = 0;
		gpointer _tmp4_ = NULL;
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = adjustment;
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp3_);
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (_tmp0_);
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = (CaliforniaCalendarDate*) _tmp4_;
#line 1329 "calendar-date.c"
	}
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = _g_object_ref0 (_tmp0_);
#line 283 "/home/jim/git/california/src/calendar/calendar-date.vala"
	current = _tmp5_;
#line 284 "/home/jim/git/california/src/calendar/calendar-date.vala"
	while (TRUE) {
#line 1337 "calendar-date.c"
		GeePredicate _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		CaliforniaCalendarDate* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		CaliforniaCalendarDate* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gpointer _tmp11_ = NULL;
#line 284 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = predicate;
#line 284 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6__target = predicate_target;
#line 284 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp7_ = current;
#line 284 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp8_ = _tmp6_ (_tmp7_, _tmp6__target);
#line 284 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (!(!_tmp8_)) {
#line 284 "/home/jim/git/california/src/calendar/calendar-date.vala"
			break;
#line 1357 "calendar-date.c"
		}
#line 285 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = current;
#line 285 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = adjustment;
#line 285 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp10_);
#line 285 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_g_object_unref0 (current);
#line 285 "/home/jim/git/california/src/calendar/calendar-date.vala"
		current = (CaliforniaCalendarDate*) _tmp11_;
#line 1369 "calendar-date.c"
	}
#line 287 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = current;
#line 287 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (_tmp0_);
#line 287 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1377 "calendar-date.c"
}


/**
     * @inheritDoc
     */
static gint california_calendar_date_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 293 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 293 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), 0);
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = other;
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (self != _tmp1_) {
#line 1397 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		GDate _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = other;
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = _tmp2_->priv->gdate;
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = g_date_days_between (&self->priv->gdate, &_tmp3_);
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp4_;
#line 1409 "calendar-date.c"
	} else {
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = 0;
#line 1413 "calendar-date.c"
	}
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 294 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1419 "calendar-date.c"
}


/**
     * Returns a {@link Date} clamped between the two supplied Dates, inclusive.
     */
CaliforniaCalendarDate* california_calendar_date_clamp (CaliforniaCalendarDate* self, CaliforniaCalendarDate* min, CaliforniaCalendarDate* max) {
	CaliforniaCalendarDate* result = NULL;
	GDate clone = {0};
	GDate _tmp0_ = {0};
	CaliforniaCalendarDate* _tmp1_ = NULL;
	GDate _tmp2_ = {0};
	CaliforniaCalendarDate* _tmp3_ = NULL;
	GDate _tmp4_ = {0};
	GDate _tmp5_ = {0};
	CaliforniaCalendarDate* _tmp6_ = NULL;
#line 300 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 300 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (min), NULL);
#line 300 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (max), NULL);
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->gdate;
#line 301 "/home/jim/git/california/src/calendar/calendar-date.vala"
	clone = _tmp0_;
#line 302 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = min;
#line 302 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = _tmp1_->priv->gdate;
#line 302 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = max;
#line 302 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = _tmp3_->priv->gdate;
#line 302 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_clamp (&clone, &_tmp2_, &_tmp4_);
#line 304 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp5_ = clone;
#line 304 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp6_ = california_calendar_date_new_from_gdate (&_tmp5_);
#line 304 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp6_;
#line 304 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1464 "calendar-date.c"
}


static gint california_calendar_date_real_compare_to (GeeComparable* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 307 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 307 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), 0);
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = other;
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (self != _tmp1_) {
#line 1481 "calendar-date.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		GDate _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp2_ = other;
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp3_ = _tmp2_->priv->gdate;
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp4_ = g_date_compare (&self->priv->gdate, &_tmp3_);
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = _tmp4_;
#line 1493 "calendar-date.c"
	} else {
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp0_ = 0;
#line 1497 "calendar-date.c"
	}
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 308 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1503 "calendar-date.c"
}


static gboolean california_calendar_date_real_equal_to (GeeHashable* base, CaliforniaCalendarDate* other) {
	CaliforniaCalendarDate * self;
	gboolean result = FALSE;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 311 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 311 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (other), FALSE);
#line 312 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = other;
#line 312 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 312 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_ == 0;
#line 312 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1524 "calendar-date.c"
}


static guint california_calendar_date_real_hash (GeeHashable* base) {
	CaliforniaCalendarDate * self;
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 315 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_date_get_julian (&self->priv->gdate);
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 316 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1540 "calendar-date.c"
}


gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt) {
	gchar* result = NULL;
	gchar* buf = NULL;
	gchar* _tmp0_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 319 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 319 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 322 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = g_new0 (gchar, 256);
#line 322 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf = _tmp0_;
#line 322 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf_length1 = 256;
#line 322 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_buf_size_ = buf_length1;
#line 323 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = fmt;
#line 323 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_date_strftime (buf, buf_length1, _tmp1_, &self->priv->gdate);
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = g_strdup ((const gchar*) buf);
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp2_;
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	buf = (g_free (buf), NULL);
#line 325 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1576 "calendar-date.c"
}


/**
     * Returns the {@link Date} in a localized standardized format, i.e. "08/23/01"
     */
gchar* california_calendar_date_to_standard_string (CaliforniaCalendarDate* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 331 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 332 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_FMT_FULL_DATE;
#line 332 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = california_calendar_date_format (self, _tmp0_);
#line 332 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp1_;
#line 332 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1597 "calendar-date.c"
}


/**
     * Returns the {@link Date} in a prettified, localized format according to supplied
     * {@link PrettyFlag}s.
     *
     * Returns "Today" (localized) if this matches {@link System.today} unless the NO_TODAY flag
     * or INCLUDE_YEAR flag is specified.
     */
gchar* california_calendar_date_to_pretty_string (CaliforniaCalendarDate* self, CaliforniaCalendarDatePrettyFlag flags) {
	gchar* result = NULL;
	gboolean compact = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp0_ = 0;
	gboolean abbrev = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp1_ = 0;
	gboolean with_year = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp2_ = 0;
	gboolean no_today = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp3_ = 0;
	gboolean no_dow = FALSE;
	CaliforniaCalendarDatePrettyFlag _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* fmt = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
#line 342 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 343 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = flags;
#line 343 "/home/jim/git/california/src/calendar/calendar-date.vala"
	compact = (_tmp0_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT) != 0;
#line 344 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = flags;
#line 344 "/home/jim/git/california/src/calendar/calendar-date.vala"
	abbrev = (_tmp1_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV) != 0;
#line 345 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp2_ = flags;
#line 345 "/home/jim/git/california/src/calendar/calendar-date.vala"
	with_year = (_tmp2_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR) != 0;
#line 346 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp3_ = flags;
#line 346 "/home/jim/git/california/src/calendar/calendar-date.vala"
	no_today = (_tmp3_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY) != 0;
#line 347 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp4_ = flags;
#line 347 "/home/jim/git/california/src/calendar/calendar-date.vala"
	no_dow = (_tmp4_ & CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK) != 0;
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp7_ = no_today;
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (!_tmp7_) {
#line 1658 "calendar-date.c"
		gboolean _tmp8_ = FALSE;
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp8_ = with_year;
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = !_tmp8_;
#line 1664 "calendar-date.c"
	} else {
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp6_ = FALSE;
#line 1668 "calendar-date.c"
	}
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp6_) {
#line 1672 "calendar-date.c"
		CaliforniaCalendarDate* _tmp9_ = NULL;
		CaliforniaCalendarDate* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp9_ = california_calendar_system_get_today ();
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp10_ = _tmp9_;
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp11_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_HASHABLE, GeeHashable), _tmp10_);
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp5_ = _tmp11_;
#line 1684 "calendar-date.c"
	} else {
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp5_ = FALSE;
#line 1688 "calendar-date.c"
	}
#line 349 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp5_) {
#line 1692 "calendar-date.c"
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 350 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp12_ = _ ("Today");
#line 350 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 350 "/home/jim/git/california/src/calendar/calendar-date.vala"
		result = _tmp13_;
#line 350 "/home/jim/git/california/src/calendar/calendar-date.vala"
		return result;
#line 1703 "calendar-date.c"
	}
#line 353 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp14_ = abbrev;
#line 353 "/home/jim/git/california/src/calendar/calendar-date.vala"
	if (_tmp14_) {
#line 1709 "calendar-date.c"
		gboolean _tmp15_ = FALSE;
#line 354 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp15_ = no_dow;
#line 354 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_tmp15_) {
#line 1715 "calendar-date.c"
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp17_ = with_year;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp17_) {
#line 1722 "calendar-date.c"
				const gchar* _tmp18_ = NULL;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp18_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp16_ = _tmp18_;
#line 1728 "calendar-date.c"
			} else {
				const gchar* _tmp19_ = NULL;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp19_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_DOW_NO_YEAR;
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp16_ = _tmp19_;
#line 1735 "calendar-date.c"
			}
#line 355 "/home/jim/git/california/src/calendar/calendar-date.vala"
			fmt = _tmp16_;
#line 1739 "calendar-date.c"
		} else {
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp21_ = with_year;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp21_) {
#line 1747 "calendar-date.c"
				const gchar* _tmp22_ = NULL;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp22_ = california_calendar_FMT_PRETTY_DATE_ABBREV;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp20_ = _tmp22_;
#line 1753 "calendar-date.c"
			} else {
				const gchar* _tmp23_ = NULL;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp23_ = california_calendar_FMT_PRETTY_DATE_ABBREV_NO_YEAR;
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp20_ = _tmp23_;
#line 1760 "calendar-date.c"
			}
#line 357 "/home/jim/git/california/src/calendar/calendar-date.vala"
			fmt = _tmp20_;
#line 1764 "calendar-date.c"
		}
	} else {
		gboolean _tmp24_ = FALSE;
#line 358 "/home/jim/git/california/src/calendar/calendar-date.vala"
		_tmp24_ = compact;
#line 358 "/home/jim/git/california/src/calendar/calendar-date.vala"
		if (_tmp24_) {
#line 1772 "calendar-date.c"
			gboolean _tmp25_ = FALSE;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp25_ = no_dow;
#line 359 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp25_) {
#line 1778 "calendar-date.c"
				const gchar* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp27_ = with_year;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp27_) {
#line 1785 "calendar-date.c"
					const gchar* _tmp28_ = NULL;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp28_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp26_ = _tmp28_;
#line 1791 "calendar-date.c"
				} else {
					const gchar* _tmp29_ = NULL;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp29_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_DOW_NO_YEAR;
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp26_ = _tmp29_;
#line 1798 "calendar-date.c"
				}
#line 360 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp26_;
#line 1802 "calendar-date.c"
			} else {
				const gchar* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp31_ = with_year;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp31_) {
#line 1810 "calendar-date.c"
					const gchar* _tmp32_ = NULL;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp32_ = california_calendar_FMT_PRETTY_DATE_COMPACT;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp30_ = _tmp32_;
#line 1816 "calendar-date.c"
				} else {
					const gchar* _tmp33_ = NULL;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp33_ = california_calendar_FMT_PRETTY_DATE_COMPACT_NO_YEAR;
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp30_ = _tmp33_;
#line 1823 "calendar-date.c"
				}
#line 362 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp30_;
#line 1827 "calendar-date.c"
			}
		} else {
			gboolean _tmp34_ = FALSE;
#line 364 "/home/jim/git/california/src/calendar/calendar-date.vala"
			_tmp34_ = no_dow;
#line 364 "/home/jim/git/california/src/calendar/calendar-date.vala"
			if (_tmp34_) {
#line 1835 "calendar-date.c"
				const gchar* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp36_ = with_year;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp36_) {
#line 1842 "calendar-date.c"
					const gchar* _tmp37_ = NULL;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp37_ = california_calendar_FMT_PRETTY_DATE_NO_DOW;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp35_ = _tmp37_;
#line 1848 "calendar-date.c"
				} else {
					const gchar* _tmp38_ = NULL;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp38_ = california_calendar_FMT_PRETTY_DATE_NO_DOW_NO_YEAR;
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp35_ = _tmp38_;
#line 1855 "calendar-date.c"
				}
#line 365 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp35_;
#line 1859 "calendar-date.c"
			} else {
				const gchar* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
				_tmp40_ = with_year;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
				if (_tmp40_) {
#line 1867 "calendar-date.c"
					const gchar* _tmp41_ = NULL;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp41_ = california_calendar_FMT_PRETTY_DATE;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp39_ = _tmp41_;
#line 1873 "calendar-date.c"
				} else {
					const gchar* _tmp42_ = NULL;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp42_ = california_calendar_FMT_PRETTY_DATE_NO_YEAR;
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
					_tmp39_ = _tmp42_;
#line 1880 "calendar-date.c"
				}
#line 367 "/home/jim/git/california/src/calendar/calendar-date.vala"
				fmt = _tmp39_;
#line 1884 "calendar-date.c"
			}
		}
	}
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp43_ = fmt;
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp44_ = california_calendar_date_format (self, _tmp43_);
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp45_ = _tmp44_;
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp46_ = california_string_remove_leading_chars (_tmp45_, (gunichar) '0', " /-:;,.");
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp47_ = _tmp46_;
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp48_ = california_string_reduce_whitespace (_tmp47_);
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp49_ = _tmp48_;
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_free0 (_tmp47_);
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_free0 (_tmp45_);
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp49_;
#line 371 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1910 "calendar-date.c"
}


static gchar* california_calendar_date_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarDate * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 374 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = california_calendar_date_format (self, "%x");
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 375 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1926 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_real_get_start_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* self;
#line 64 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 64 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = self;
#line 64 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1939 "calendar-date.c"
}


static CaliforniaCalendarDate* california_calendar_date_real_get_end_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDate* self;
#line 71 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 71 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = self;
#line 71 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1952 "calendar-date.c"
}


CaliforniaCalendarDayOfWeek* california_calendar_date_get_day_of_week (CaliforniaCalendarDate* self) {
	CaliforniaCalendarDayOfWeek* result;
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_week;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 1967 "calendar-date.c"
}


static void california_calendar_date_set_day_of_week (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfWeek* value) {
	CaliforniaCalendarDayOfWeek* _tmp0_ = NULL;
	CaliforniaCalendarDayOfWeek* _tmp1_ = NULL;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_week);
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_week = _tmp1_;
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-week");
#line 1986 "calendar-date.c"
}


CaliforniaCalendarDayOfMonth* california_calendar_date_get_day_of_month (CaliforniaCalendarDate* self) {
	CaliforniaCalendarDayOfMonth* result;
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_month;
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2001 "calendar-date.c"
}


static void california_calendar_date_set_day_of_month (CaliforniaCalendarDate* self, CaliforniaCalendarDayOfMonth* value) {
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_month);
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_month = _tmp1_;
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-month");
#line 2020 "calendar-date.c"
}


gint california_calendar_date_get_day_of_year (CaliforniaCalendarDate* self) {
	gint result;
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), 0);
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_day_of_year;
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2035 "calendar-date.c"
}


static void california_calendar_date_set_day_of_year (CaliforniaCalendarDate* self, gint value) {
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_day_of_year = _tmp0_;
#line 75 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "day-of-year");
#line 2049 "calendar-date.c"
}


CaliforniaCalendarMonth* california_calendar_date_get_month (CaliforniaCalendarDate* self) {
	CaliforniaCalendarMonth* result;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_month;
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2064 "calendar-date.c"
}


static void california_calendar_date_set_month (CaliforniaCalendarDate* self, CaliforniaCalendarMonth* value) {
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarMonth* _tmp1_ = NULL;
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_month);
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_month = _tmp1_;
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "month");
#line 2083 "calendar-date.c"
}


CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self) {
	CaliforniaCalendarYear* result;
	CaliforniaCalendarYear* _tmp0_ = NULL;
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self), NULL);
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = self->priv->_year;
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	result = _tmp0_;
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	return result;
#line 2098 "calendar-date.c"
}


static void california_calendar_date_set_year (CaliforniaCalendarDate* self, CaliforniaCalendarYear* value) {
	CaliforniaCalendarYear* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (self));
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp0_ = value;
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_year);
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv->_year = _tmp1_;
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_notify ((GObject *) self, "year");
#line 2117 "calendar-date.c"
}


static void california_calendar_date_class_init (CaliforniaCalendarDateClass * klass) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarDatePrivate));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_UNIT_CLASS (klass)->adjust = california_calendar_date_real_adjust;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_UNIT_CLASS (klass)->difference = california_calendar_date_real_difference;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_date_real_to_string;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_SPAN_CLASS (klass)->get_start_date = california_calendar_date_real_get_start_date;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	CALIFORNIA_CALENDAR_SPAN_CLASS (klass)->get_end_date = california_calendar_date_real_get_end_date;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_date_get_property;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_date_set_property;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_date_finalize;
#line 2142 "calendar-date.c"
	/**
	     * @inheritDoc
	     *
	     * Overridden to prevent a reference cycle in {@link Span.start_date}.
	     */
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_START_DATE, g_param_spec_object ("start-date", "start-date", "start-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2150 "calendar-date.c"
	/**
	     * @inheritDoc
	     *
	     * Overridden to prevent a reference cycle in {@link Span.end_date}.
	     */
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_END_DATE, g_param_spec_object ("end-date", "end-date", "end-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK, g_param_spec_object ("day-of-week", "day-of-week", "day-of-week", CALIFORNIA_CALENDAR_TYPE_DAY_OF_WEEK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH, g_param_spec_object ("day-of-month", "day-of-month", "day-of-month", CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR, g_param_spec_int ("day-of-year", "day-of-year", "day-of-year", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_MONTH, g_param_spec_object ("month", "month", "month", CALIFORNIA_CALENDAR_TYPE_MONTH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_YEAR, g_param_spec_object ("year", "year", "year", CALIFORNIA_CALENDAR_TYPE_YEAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2168 "calendar-date.c"
}


static void california_calendar_date_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_date_real_compare_to;
#line 2177 "calendar-date.c"
}


static void california_calendar_date_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	california_calendar_date_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_date_real_equal_to;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_date_real_hash;
#line 2188 "calendar-date.c"
}


static void california_calendar_date_instance_init (CaliforniaCalendarDate * self) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self->priv = CALIFORNIA_CALENDAR_DATE_GET_PRIVATE (self);
#line 2195 "calendar-date.c"
}


static void california_calendar_date_finalize (GObject* obj) {
	CaliforniaCalendarDate * self;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 73 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_week);
#line 74 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_day_of_month);
#line 76 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_month);
#line 77 "/home/jim/git/california/src/calendar/calendar-date.vala"
	_g_object_unref0 (self->priv->_year);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	G_OBJECT_CLASS (california_calendar_date_parent_class)->finalize (obj);
#line 2213 "calendar-date.c"
}


/**
 * An immutable representation of a single date in time (year/month/day).
 *
 * This is primarily a GObject-ification of GLib's Date struct, with the added restriction that
 * this class is immutable.  This means this object is incapable of representing a DMY prior to
 * Year 1 (BCE).
 *
 * GLib.Date has many powerful features for representing a calendar day, but it's interface is
 * inconvenient when working in Vala.  It can also exist in an uninitialized and an invalid
 * state.  It's desired to avoid both of those.  It is also not an Object, has no signals or
 * properties, doesn't work well with Gee, and is mutable.  This class attempts to solve these
 * issues.
 */
GType california_calendar_date_get_type (void) {
	static volatile gsize california_calendar_date_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarDate), 0, (GInstanceInitFunc) california_calendar_date_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_date_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_date_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_date_type_id;
		california_calendar_date_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_UNIT, "CaliforniaCalendarDate", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_date_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_date_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_date_type_id__volatile, california_calendar_date_type_id);
	}
	return california_calendar_date_type_id__volatile;
}


static void _vala_california_calendar_date_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_START_DATE:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_END_DATE:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_day_of_week (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_day_of_month (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_int (value, california_calendar_date_get_day_of_year (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_month (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		g_value_set_object (value, california_calendar_date_get_year (self));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2293 "calendar-date.c"
		default:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2299 "calendar-date.c"
	}
}


static void _vala_california_calendar_date_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
	switch (property_id) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_WEEK:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_week (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_month (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_DAY_OF_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_day_of_year (self, g_value_get_int (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_MONTH:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_month (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		case CALIFORNIA_CALENDAR_DATE_YEAR:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		california_calendar_date_set_year (self, g_value_get_object (value));
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2339 "calendar-date.c"
		default:
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jim/git/california/src/calendar/calendar-date.vala"
		break;
#line 2345 "calendar-date.c"
	}
}



