/* component-event.c generated by valac 0.24.0, the Vala compiler
 * generated from component-event.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libical/ical.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COMPONENT_TYPE_INSTANCE (california_component_instance_get_type ())
#define CALIFORNIA_COMPONENT_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance))
#define CALIFORNIA_COMPONENT_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))
#define CALIFORNIA_COMPONENT_IS_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_IS_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))

typedef struct _CaliforniaComponentInstance CaliforniaComponentInstance;
typedef struct _CaliforniaComponentInstanceClass CaliforniaComponentInstanceClass;
typedef struct _CaliforniaComponentInstancePrivate CaliforniaComponentInstancePrivate;

#define CALIFORNIA_COMPONENT_TYPE_UID (california_component_uid_get_type ())
#define CALIFORNIA_COMPONENT_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUID))
#define CALIFORNIA_COMPONENT_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))
#define CALIFORNIA_COMPONENT_IS_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_IS_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_UID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))

typedef struct _CaliforniaComponentUID CaliforniaComponentUID;
typedef struct _CaliforniaComponentUIDClass CaliforniaComponentUIDClass;

#define CALIFORNIA_COMPONENT_TYPE_EVENT (california_component_event_get_type ())
#define CALIFORNIA_COMPONENT_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent))
#define CALIFORNIA_COMPONENT_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))
#define CALIFORNIA_COMPONENT_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))

typedef struct _CaliforniaComponentEvent CaliforniaComponentEvent;
typedef struct _CaliforniaComponentEventClass CaliforniaComponentEventClass;
typedef struct _CaliforniaComponentEventPrivate CaliforniaComponentEventPrivate;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN (california_calendar_exact_time_span_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpan))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))

typedef struct _CaliforniaCalendarExactTimeSpan CaliforniaCalendarExactTimeSpan;
typedef struct _CaliforniaCalendarExactTimeSpanClass CaliforniaCalendarExactTimeSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN (california_calendar_unit_span_get_type ())
#define CALIFORNIA_CALENDAR_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))

typedef struct _CaliforniaCalendarUnitSpan CaliforniaCalendarUnitSpan;
typedef struct _CaliforniaCalendarUnitSpanClass CaliforniaCalendarUnitSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;

#define CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS (california_component_event_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_BACKING_TYPE_SOURCE (california_backing_source_get_type ())
#define CALIFORNIA_BACKING_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource))
#define CALIFORNIA_BACKING_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))
#define CALIFORNIA_BACKING_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))

typedef struct _CaliforniaBackingSource CaliforniaBackingSource;
typedef struct _CaliforniaBackingSourceClass CaliforniaBackingSourceClass;

#define CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE (california_backing_calendar_source_get_type ())
#define CALIFORNIA_BACKING_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSource))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))

typedef struct _CaliforniaBackingCalendarSource CaliforniaBackingCalendarSource;
typedef struct _CaliforniaBackingCalendarSourceClass CaliforniaBackingCalendarSourceClass;

#define CALIFORNIA_COMPONENT_TYPE_DATE_TIME (california_component_date_time_get_type ())
#define CALIFORNIA_COMPONENT_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTime))
#define CALIFORNIA_COMPONENT_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))

typedef struct _CaliforniaComponentDateTime CaliforniaComponentDateTime;
typedef struct _CaliforniaComponentDateTimeClass CaliforniaComponentDateTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_DURATION (california_calendar_duration_get_type ())
#define CALIFORNIA_CALENDAR_DURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration))
#define CALIFORNIA_CALENDAR_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))
#define CALIFORNIA_CALENDAR_IS_DURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_IS_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_DURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))

typedef struct _CaliforniaCalendarDuration CaliforniaCalendarDuration;
typedef struct _CaliforniaCalendarDurationClass CaliforniaCalendarDurationClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaComponentInstance {
	CaliforniaBaseObject parent_instance;
	CaliforniaComponentInstancePrivate * priv;
};

struct _CaliforniaComponentInstanceClass {
	CaliforniaBaseObjectClass parent_class;
	void (*notify_altered) (CaliforniaComponentInstance* self, gboolean from_full_update);
	void (*update_from_component) (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
	gboolean (*is_valid) (CaliforniaComponentInstance* self);
	gboolean (*equal_to) (CaliforniaComponentInstance* self, CaliforniaComponentInstance* other);
	guint (*hash) (CaliforniaComponentInstance* self);
};

struct _CaliforniaComponentEvent {
	CaliforniaComponentInstance parent_instance;
	CaliforniaComponentEventPrivate * priv;
};

struct _CaliforniaComponentEventClass {
	CaliforniaComponentInstanceClass parent_class;
};

typedef enum  {
	CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED
} CaliforniaComponentEventStatus;

struct _CaliforniaComponentEventPrivate {
	gchar* _summary;
	gchar* _description;
	CaliforniaCalendarExactTimeSpan* _exact_time_span;
	CaliforniaCalendarDateSpan* _date_span;
	gboolean _is_all_day;
	gchar* _location;
	CaliforniaComponentEventStatus _status;
};

typedef enum  {
	CALIFORNIA_COMPONENT_ERROR_INVALID,
	CALIFORNIA_COMPONENT_ERROR_MISMATCH,
	CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE
} CaliforniaComponentError;
#define CALIFORNIA_COMPONENT_ERROR california_component_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()

static gpointer california_component_event_parent_class = NULL;
static GeeComparableIface* california_component_event_gee_comparable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_component_instance_get_type (void) G_GNUC_CONST;
GType california_component_uid_get_type (void) G_GNUC_CONST;
GType california_component_event_get_type (void) G_GNUC_CONST;
GType california_calendar_exact_time_span_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
GType california_component_event_status_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventPrivate))
enum  {
	CALIFORNIA_COMPONENT_EVENT_DUMMY_PROPERTY,
	CALIFORNIA_COMPONENT_EVENT_SUMMARY,
	CALIFORNIA_COMPONENT_EVENT_DESCRIPTION,
	CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN,
	CALIFORNIA_COMPONENT_EVENT_DATE_SPAN,
	CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY,
	CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING,
	CALIFORNIA_COMPONENT_EVENT_LOCATION,
	CALIFORNIA_COMPONENT_EVENT_STATUS
};
#define CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY "summary"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION "description"
#define CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN "exact-time-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN "date-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_IS_ALL_DAY "is-all-day"
#define CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION "location"
#define CALIFORNIA_COMPONENT_EVENT_PROP_STATUS "status"
GType california_backing_source_get_type (void) G_GNUC_CONST;
GType california_backing_calendar_source_get_type (void) G_GNUC_CONST;
CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentInstance* california_component_instance_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, icalcomponent_kind kind, GError** error);
static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec);
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
CaliforniaComponentEvent* california_component_event_new_blank (void);
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type);
CaliforniaComponentInstance* california_component_instance_construct_blank (GType object_type, icalcomponent_kind kind);
static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_instance_update_from_component (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value);
GType california_component_date_time_get_type (void) G_GNUC_CONST;
GQuark california_component_error_quark (void);
CaliforniaComponentDateTime* california_component_date_time_new (icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
CaliforniaComponentDateTime* california_component_date_time_construct (GType object_type, icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
GQuark california_calendar_error_quark (void);
void california_component_date_time_to_span (CaliforniaComponentDateTime* dt_start, CaliforniaComponentDateTime* dt_end, gboolean dtend_inclusive, CaliforniaCalendarDateSpan** date_span, CaliforniaCalendarExactTimeSpan** exact_time_span, GError** error);
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span);
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span);
static void california_component_event_set_is_all_day (CaliforniaComponentEvent* self, gboolean value);
void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value);
gboolean california_component_instance_get_in_full_update (CaliforniaComponentInstance* self);
icalcomponent* california_component_instance_get_ical_component (CaliforniaComponentInstance* self);
const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self);
const gchar* california_component_event_get_description (CaliforniaComponentEvent* self);
CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self);
CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self);
void california_component_instance_exact_time_span_to_ical (CaliforniaCalendarExactTimeSpan* exact_time_span, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
void california_component_instance_date_span_to_ical (CaliforniaCalendarDateSpan* date_span, gboolean dtend_inclusive, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
const gchar* california_component_event_get_location (CaliforniaComponentEvent* self);
CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self);
void california_component_instance_notify_altered (CaliforniaComponentInstance* self, gboolean from_full_update);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_to_timezone (CaliforniaCalendarExactTimeSpan* self, CaliforniaCalendarTimezone* new_tz);
CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span);
static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value);
static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value);
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base);
gboolean california_component_instance_is_valid (CaliforniaComponentInstance* self);
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other);
gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarExactTime* california_component_instance_get_dtstamp (CaliforniaComponentInstance* self);
gboolean california_component_instance_get_is_recurring (CaliforniaComponentInstance* self);
gint california_component_instance_get_sequence (CaliforniaComponentInstance* self);
CaliforniaComponentUID* california_component_instance_get_uid (CaliforniaComponentInstance* self);
static gboolean california_component_event_real_equal_to (CaliforniaComponentInstance* base, CaliforniaComponentInstance* other);
CaliforniaComponentDateTime* california_component_instance_get_rid (CaliforniaComponentInstance* self);
gboolean california_component_instance_equal_to (CaliforniaComponentInstance* self, CaliforniaComponentInstance* other);
static guint california_component_event_real_hash (CaliforniaComponentInstance* base);
static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self);
GType california_calendar_duration_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDuration* california_calendar_exact_time_span_get_duration (CaliforniaCalendarExactTimeSpan* self);
guint64 california_calendar_duration_get_days (CaliforniaCalendarDuration* self);
static void california_component_event_finalize (GObject* obj);
static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType california_component_event_status_get_type (void) {
	static volatile gsize california_component_event_status_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_status_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE, "CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE", "tentative"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED", "confirmed"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED", "cancelled"}, {0, NULL, NULL}};
		GType california_component_event_status_type_id;
		california_component_event_status_type_id = g_enum_register_static ("CaliforniaComponentEventStatus", values);
		g_once_init_leave (&california_component_event_status_type_id__volatile, california_component_event_status_type_id);
	}
	return california_component_event_status_type_id__volatile;
}


/**
     * Create an {@link Event} {@link Component} from an EDS CalComponent object.
     *
     * Throws a BackingError if the E.CalComponent's VTYPE is not VEVENT.
     */
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 95 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_on_notify ((CaliforniaComponentEvent*) self, pspec);
#line 345 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
	CaliforniaComponentEvent * self = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
	icalcomponent* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 89 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((calendar_source == NULL) || CALIFORNIA_BACKING_IS_CALENDAR_SOURCE (calendar_source), NULL);
#line 89 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (ical_component != NULL, NULL);
#line 90 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = calendar_source;
#line 90 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = ical_component;
#line 90 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct (object_type, _tmp0_, _tmp1_, ICAL_VEVENT_COMPONENT, &_inner_error_);
#line 90 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 90 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 90 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (self);
#line 90 "/home/jim/git/california/src/component/component-event.vala"
		return NULL;
#line 372 "component-event.c"
	}
#line 95 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 89 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 378 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
#line 89 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct (CALIFORNIA_COMPONENT_TYPE_EVENT, calendar_source, ical_component, error);
#line 385 "component-event.c"
}


/**
     * Creates a "blank" {@link Event} with a generated {@link uid}.
     *
     * A {@link Calendar.DateSpan} or a {@link Calendar.ExactTimeSpan} must be specified in order
     * to generate a minimally-valid Event.
     */
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type) {
	CaliforniaComponentEvent * self = NULL;
#line 105 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct_blank (object_type, ICAL_VEVENT_COMPONENT);
#line 107 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 104 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 403 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new_blank (void) {
#line 104 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct_blank (CALIFORNIA_COMPONENT_TYPE_EVENT);
#line 410 "component-event.c"
}


/**
     * @inheritDoc
     */
static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error) {
	CaliforniaComponentEvent * self;
	icalcomponent* _tmp0_ = NULL;
	CaliforniaComponentUID* _tmp1_ = NULL;
	icalcomponent* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	icalcomponent* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	CaliforniaComponentDateTime* dt_start = NULL;
	icalcomponent* _tmp6_ = NULL;
	CaliforniaComponentDateTime* _tmp7_ = NULL;
	CaliforniaComponentDateTime* dt_end = NULL;
	icalcomponent* _tmp8_ = NULL;
	CaliforniaComponentDateTime* _tmp9_ = NULL;
	CaliforniaCalendarDateSpan* date_span = NULL;
	CaliforniaCalendarExactTimeSpan* exact_time_span = NULL;
	CaliforniaComponentDateTime* _tmp10_ = NULL;
	CaliforniaComponentDateTime* _tmp11_ = NULL;
	CaliforniaCalendarDateSpan* _tmp12_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp13_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp14_ = NULL;
	CaliforniaCalendarDateSpan* _tmp18_ = NULL;
	icalcomponent* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	icalcomponent* _tmp21_ = NULL;
	icalproperty_status _tmp22_ = 0;
	GError * _inner_error_ = NULL;
#line 113 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 113 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (ical_component != NULL);
#line 113 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail ((supplied_uid == NULL) || CALIFORNIA_COMPONENT_IS_UID (supplied_uid));
#line 115 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = ical_component;
#line 115 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = supplied_uid;
#line 115 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->update_from_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp0_, _tmp1_, &_inner_error_);
#line 115 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 115 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 115 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 462 "component-event.c"
	}
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = ical_component;
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = icalcomponent_get_summary (_tmp2_);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_summary (self, _tmp3_);
#line 118 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = ical_component;
#line 118 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = icalcomponent_get_description (_tmp4_);
#line 118 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_description (self, _tmp5_);
#line 120 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = ical_component;
#line 120 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_component_date_time_new (_tmp6_, ICAL_DTSTART_PROPERTY, &_inner_error_);
#line 120 "/home/jim/git/california/src/component/component-event.vala"
	dt_start = _tmp7_;
#line 120 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 120 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 120 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 488 "component-event.c"
	}
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = ical_component;
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_component_date_time_new (_tmp8_, ICAL_DTEND_PROPERTY, &_inner_error_);
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	dt_end = _tmp9_;
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 121 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 121 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 121 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 504 "component-event.c"
	}
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = dt_start;
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = dt_end;
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	california_component_date_time_to_span (_tmp10_, _tmp11_, FALSE, &_tmp12_, &_tmp13_, &_inner_error_);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	date_span = _tmp12_;
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	exact_time_span = _tmp13_;
#line 126 "/home/jim/git/california/src/component/component-event.vala"
	if (_inner_error_ != NULL) {
#line 126 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (exact_time_span);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (date_span);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 126 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 534 "component-event.c"
	}
#line 127 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = exact_time_span;
#line 127 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp14_ != NULL) {
#line 540 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp15_ = NULL;
#line 128 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = exact_time_span;
#line 128 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_exact_time_span (self, _tmp15_);
#line 546 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp16_ = NULL;
		CaliforniaCalendarDateSpan* _tmp17_ = NULL;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = date_span;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_vala_assert (_tmp16_ != NULL, "date_span != null");
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = date_span;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp17_);
#line 558 "component-event.c"
	}
#line 135 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = date_span;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_is_all_day (self, _tmp18_ != NULL);
#line 137 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = ical_component;
#line 137 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = icalcomponent_get_location (_tmp19_);
#line 137 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_location (self, _tmp20_);
#line 139 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = ical_component;
#line 139 "/home/jim/git/california/src/component/component-event.vala"
	_tmp22_ = icalcomponent_get_status (_tmp21_);
#line 139 "/home/jim/git/california/src/component/component-event.vala"
	switch (_tmp22_) {
#line 139 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_TENTATIVE:
#line 578 "component-event.c"
		{
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE);
#line 142 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 584 "component-event.c"
		}
#line 139 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CANCELLED:
#line 588 "component-event.c"
		{
#line 145 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED);
#line 146 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 594 "component-event.c"
		}
		default:
#line 139 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CONFIRMED:
#line 599 "component-event.c"
		{
#line 150 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED);
#line 151 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 605 "component-event.c"
		}
	}
#line 113 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 113 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 113 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_end);
#line 113 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_start);
#line 616 "component-event.c"
}


static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean altered = FALSE;
	GParamSpec* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	gboolean _tmp42_ = FALSE;
#line 155 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 155 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (G_IS_PARAM_SPEC (pspec));
#line 157 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_instance_get_in_full_update (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 157 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 157 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 158 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 641 "component-event.c"
	}
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	altered = TRUE;
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = pspec;
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_->name;
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = _tmp3_;
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY)) {
#line 161 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 657 "component-event.c"
			default:
			{
				icalcomponent* _tmp7_ = NULL;
				icalcomponent* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 163 "/home/jim/git/california/src/component/component-event.vala"
				_tmp7_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 163 "/home/jim/git/california/src/component/component-event.vala"
				_tmp8_ = _tmp7_;
#line 163 "/home/jim/git/california/src/component/component-event.vala"
				_tmp9_ = self->priv->_summary;
#line 163 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_summary (_tmp8_, _tmp9_);
#line 164 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 673 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION)) {
#line 161 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 679 "component-event.c"
			default:
			{
				icalcomponent* _tmp10_ = NULL;
				icalcomponent* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 167 "/home/jim/git/california/src/component/component-event.vala"
				_tmp10_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 167 "/home/jim/git/california/src/component/component-event.vala"
				_tmp11_ = _tmp10_;
#line 167 "/home/jim/git/california/src/component/component-event.vala"
				_tmp12_ = self->priv->_description;
#line 167 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_description (_tmp11_, _tmp12_);
#line 168 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 695 "component-event.c"
			}
		}
	} else if ((_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN)) || (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN))) {
#line 161 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 701 "component-event.c"
			default:
			{
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				CaliforniaCalendarDateSpan* _tmp15_ = NULL;
				icaltimetype ical_dtstart = {0};
				icaltimetype _tmp20_ = {0};
				icaltimetype ical_dtend = {0};
				icaltimetype _tmp21_ = {0};
				CaliforniaCalendarExactTimeSpan* _tmp22_ = NULL;
				icalcomponent* _tmp25_ = NULL;
				icalcomponent* _tmp26_ = NULL;
				icaltimetype _tmp27_ = {0};
				icalcomponent* _tmp28_ = NULL;
				icalcomponent* _tmp29_ = NULL;
				icaltimetype _tmp30_ = {0};
				CaliforniaCalendarDateSpan* _tmp31_ = NULL;
#line 175 "/home/jim/git/california/src/component/component-event.vala"
				_tmp15_ = self->priv->_date_span;
#line 175 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp15_ == NULL) {
#line 723 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
#line 175 "/home/jim/git/california/src/component/component-event.vala"
					_tmp16_ = self->priv->_exact_time_span;
#line 175 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = _tmp16_ == NULL;
#line 729 "component-event.c"
				} else {
#line 175 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = FALSE;
#line 733 "component-event.c"
				}
#line 175 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp14_) {
#line 175 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = TRUE;
#line 739 "component-event.c"
				} else {
					gboolean _tmp17_ = FALSE;
					CaliforniaCalendarDateSpan* _tmp18_ = NULL;
#line 176 "/home/jim/git/california/src/component/component-event.vala"
					_tmp18_ = self->priv->_date_span;
#line 176 "/home/jim/git/california/src/component/component-event.vala"
					if (_tmp18_ != NULL) {
#line 747 "component-event.c"
						CaliforniaCalendarExactTimeSpan* _tmp19_ = NULL;
#line 176 "/home/jim/git/california/src/component/component-event.vala"
						_tmp19_ = self->priv->_exact_time_span;
#line 176 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = _tmp19_ != NULL;
#line 753 "component-event.c"
					} else {
#line 176 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = FALSE;
#line 757 "component-event.c"
					}
#line 176 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = _tmp17_;
#line 761 "component-event.c"
				}
#line 175 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp13_) {
#line 177 "/home/jim/git/california/src/component/component-event.vala"
					return;
#line 767 "component-event.c"
				}
#line 182 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtstart = _tmp20_;
#line 183 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtend = _tmp21_;
#line 184 "/home/jim/git/california/src/component/component-event.vala"
				_tmp22_ = self->priv->_exact_time_span;
#line 184 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp22_ != NULL) {
#line 777 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp23_ = NULL;
#line 185 "/home/jim/git/california/src/component/component-event.vala"
					_tmp23_ = self->priv->_exact_time_span;
#line 185 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_exact_time_span_to_ical (_tmp23_, &ical_dtstart, &ical_dtend);
#line 783 "component-event.c"
				} else {
					CaliforniaCalendarDateSpan* _tmp24_ = NULL;
#line 187 "/home/jim/git/california/src/component/component-event.vala"
					_tmp24_ = self->priv->_date_span;
#line 187 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_date_span_to_ical (_tmp24_, FALSE, &ical_dtstart, &ical_dtend);
#line 790 "component-event.c"
				}
#line 189 "/home/jim/git/california/src/component/component-event.vala"
				_tmp25_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 189 "/home/jim/git/california/src/component/component-event.vala"
				_tmp26_ = _tmp25_;
#line 189 "/home/jim/git/california/src/component/component-event.vala"
				_tmp27_ = ical_dtstart;
#line 189 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtstart (_tmp26_, _tmp27_);
#line 190 "/home/jim/git/california/src/component/component-event.vala"
				_tmp28_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 190 "/home/jim/git/california/src/component/component-event.vala"
				_tmp29_ = _tmp28_;
#line 190 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = ical_dtend;
#line 190 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtend (_tmp29_, _tmp30_);
#line 193 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = self->priv->_date_span;
#line 193 "/home/jim/git/california/src/component/component-event.vala"
				california_component_event_set_is_all_day (self, _tmp31_ != NULL);
#line 194 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 814 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION)) {
#line 161 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 820 "component-event.c"
			default:
			{
				icalcomponent* _tmp32_ = NULL;
				icalcomponent* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
#line 197 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 197 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = _tmp32_;
#line 197 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = self->priv->_location;
#line 197 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_location (_tmp33_, _tmp34_);
#line 198 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 836 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_STATUS)) {
#line 161 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 842 "component-event.c"
			default:
			{
				CaliforniaComponentEventStatus _tmp35_ = 0;
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				_tmp35_ = self->priv->_status;
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				switch (_tmp35_) {
#line 201 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE:
#line 852 "component-event.c"
					{
						icalcomponent* _tmp36_ = NULL;
						icalcomponent* _tmp37_ = NULL;
#line 203 "/home/jim/git/california/src/component/component-event.vala"
						_tmp36_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 203 "/home/jim/git/california/src/component/component-event.vala"
						_tmp37_ = _tmp36_;
#line 203 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp37_, ICAL_STATUS_TENTATIVE);
#line 204 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 864 "component-event.c"
					}
#line 201 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED:
#line 868 "component-event.c"
					{
						icalcomponent* _tmp38_ = NULL;
						icalcomponent* _tmp39_ = NULL;
#line 207 "/home/jim/git/california/src/component/component-event.vala"
						_tmp38_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 207 "/home/jim/git/california/src/component/component-event.vala"
						_tmp39_ = _tmp38_;
#line 207 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp39_, ICAL_STATUS_CANCELLED);
#line 208 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 880 "component-event.c"
					}
					default:
#line 201 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED:
#line 885 "component-event.c"
					{
						icalcomponent* _tmp40_ = NULL;
						icalcomponent* _tmp41_ = NULL;
#line 212 "/home/jim/git/california/src/component/component-event.vala"
						_tmp40_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 212 "/home/jim/git/california/src/component/component-event.vala"
						_tmp41_ = _tmp40_;
#line 212 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp41_, ICAL_STATUS_CONFIRMED);
#line 213 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 897 "component-event.c"
					}
				}
#line 215 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 902 "component-event.c"
			}
		}
	} else {
#line 161 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 908 "component-event.c"
			default:
			{
#line 218 "/home/jim/git/california/src/component/component-event.vala"
				altered = FALSE;
#line 219 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 915 "component-event.c"
			}
		}
	}
#line 222 "/home/jim/git/california/src/component/component-event.vala"
	_tmp42_ = altered;
#line 222 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp42_) {
#line 223 "/home/jim/git/california/src/component/component-event.vala"
		california_component_instance_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), FALSE);
#line 925 "component-event.c"
	}
}


/**
     * Returns a {@link Calendar.DateSpan} for the {@link Event}.
     *
     * This will return a DateSpan whether the Event is a DATE or DATE-TIME VEVENT.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 233 "/home/jim/git/california/src/component/component-event.vala"
	return self ? g_object_ref (self) : NULL;
#line 938 "component-event.c"
}


CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarDateSpan* result = NULL;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
	CaliforniaCalendarTimezone* _tmp4_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
#line 231 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 231 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((tz == NULL) || CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 232 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 232 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_ != NULL) {
#line 956 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp1_ = NULL;
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
#line 233 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = self->priv->_date_span;
#line 233 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 233 "/home/jim/git/california/src/component/component-event.vala"
		result = _tmp2_;
#line 233 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 967 "component-event.c"
	}
#line 236 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = tz;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp4_ != NULL) {
#line 973 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp5_ = NULL;
		CaliforniaCalendarTimezone* _tmp6_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp7_ = NULL;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = self->priv->_exact_time_span;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = tz;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = california_calendar_exact_time_span_to_timezone (_tmp5_, _tmp6_);
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp7_;
#line 987 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = self->priv->_exact_time_span;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 236 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp9_;
#line 999 "component-event.c"
	}
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = california_calendar_date_span_new_from_exact_time_span (_tmp3_);
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp10_;
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp3_);
#line 235 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1009 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE VEVENT.
     *
     * {@link date_span} will be set and {@link exact_time_span} will be unset.
     *
     * @see set_event_exact_time_span
     */
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 246 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 246 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (date_span));
#line 247 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = date_span;
#line 247 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, _tmp0_);
#line 248 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, NULL);
#line 1032 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE-TIME VEVENT.
     *
     * {@link exact_time_span} will be set and {@link date_span} will be unset.
     *
     * @see set_event_date_span
     */
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 258 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 258 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN (exact_time_span));
#line 259 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = exact_time_span;
#line 259 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, _tmp0_);
#line 260 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, NULL);
#line 1055 "component-event.c"
}


/**
     * @inheritDoc
     */
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base) {
	CaliforniaComponentEvent * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 266 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->is_valid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 267 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 1073 "component-event.c"
		gboolean _tmp2_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp3_ = NULL;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = self->priv->_date_span;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp3_ != NULL) {
#line 267 "/home/jim/git/california/src/component/component-event.vala"
			_tmp2_ = TRUE;
#line 1082 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp4_ = NULL;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
			_tmp4_ = self->priv->_exact_time_span;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
			_tmp2_ = _tmp4_ != NULL;
#line 1089 "component-event.c"
		}
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp2_;
#line 1093 "component-event.c"
	} else {
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 1097 "component-event.c"
	}
#line 267 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1103 "component-event.c"
}


/**
     * Compares an {@link Event} to another and returns which is chronologically first.
     *
     * The method attempts to compare DATE-TIMEs first, then DATEs, coercing a DATE-TIME into a DATE
     * if necessary.
     *
     * If both events have the same chronological time, they're sorted by summary in lexographical
     * order.
     *
     * {@link dtstamp} is the third comparison attempted.  In general, dtstamp is the time the
     * {@link Component} was created.
     *
     * Finally, UIDs are used to stabilize the sort.
     *
     * @inheritDoc
     */
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other) {
	CaliforniaComponentEvent * self;
	gint result = 0;
	CaliforniaComponentEvent* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint compare = 0;
	gboolean _tmp9_ = FALSE;
	CaliforniaCalendarExactTimeSpan* _tmp10_ = NULL;
	gint _tmp38_ = 0;
	GCompareFunc _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	CaliforniaComponentEvent* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	CaliforniaCalendarExactTime* _tmp45_ = NULL;
	CaliforniaCalendarExactTime* _tmp46_ = NULL;
	CaliforniaComponentEvent* _tmp47_ = NULL;
	CaliforniaCalendarExactTime* _tmp48_ = NULL;
	CaliforniaCalendarExactTime* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	CaliforniaComponentUID* _tmp60_ = NULL;
	CaliforniaComponentUID* _tmp61_ = NULL;
	CaliforniaComponentEvent* _tmp62_ = NULL;
	CaliforniaComponentUID* _tmp63_ = NULL;
	CaliforniaComponentUID* _tmp64_ = NULL;
	gint _tmp65_ = 0;
#line 286 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 286 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (other), 0);
#line 287 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = other;
#line 287 "/home/jim/git/california/src/component/component-event.vala"
	if (self == _tmp0_) {
#line 288 "/home/jim/git/california/src/component/component-event.vala"
		result = 0;
#line 288 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1168 "component-event.c"
	}
#line 291 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = self->priv->_is_all_day;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_) {
#line 1174 "component-event.c"
		CaliforniaComponentEvent* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = other;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp3_->priv->_is_all_day;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = !_tmp4_;
#line 1183 "component-event.c"
	} else {
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = FALSE;
#line 1187 "component-event.c"
	}
#line 291 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 292 "/home/jim/git/california/src/component/component-event.vala"
		result = -1;
#line 292 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1195 "component-event.c"
	}
#line 294 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = self->priv->_is_all_day;
#line 294 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp6_) {
#line 1201 "component-event.c"
		CaliforniaComponentEvent* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 294 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = other;
#line 294 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = _tmp7_->priv->_is_all_day;
#line 294 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = _tmp8_;
#line 1210 "component-event.c"
	} else {
#line 294 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = FALSE;
#line 1214 "component-event.c"
	}
#line 294 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp5_) {
#line 295 "/home/jim/git/california/src/component/component-event.vala"
		result = 1;
#line 295 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1222 "component-event.c"
	}
#line 299 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = self->priv->_exact_time_span;
#line 299 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp10_ != NULL) {
#line 1228 "component-event.c"
		CaliforniaComponentEvent* _tmp11_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp12_ = NULL;
#line 299 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = other;
#line 299 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = _tmp11_->priv->_exact_time_span;
#line 299 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = _tmp12_ != NULL;
#line 1237 "component-event.c"
	} else {
#line 299 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = FALSE;
#line 1241 "component-event.c"
	}
#line 299 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp9_) {
#line 1245 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp13_ = NULL;
		CaliforniaComponentEvent* _tmp14_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 300 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = self->priv->_exact_time_span;
#line 300 "/home/jim/git/california/src/component/component-event.vala"
		_tmp14_ = other;
#line 300 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = _tmp14_->priv->_exact_time_span;
#line 300 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp15_);
#line 300 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp16_;
#line 1260 "component-event.c"
	} else {
		gboolean _tmp17_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp18_ = NULL;
#line 301 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = self->priv->_date_span;
#line 301 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp18_ != NULL) {
#line 1268 "component-event.c"
			CaliforniaComponentEvent* _tmp19_ = NULL;
			CaliforniaCalendarDateSpan* _tmp20_ = NULL;
#line 301 "/home/jim/git/california/src/component/component-event.vala"
			_tmp19_ = other;
#line 301 "/home/jim/git/california/src/component/component-event.vala"
			_tmp20_ = _tmp19_->priv->_date_span;
#line 301 "/home/jim/git/california/src/component/component-event.vala"
			_tmp17_ = _tmp20_ != NULL;
#line 1277 "component-event.c"
		} else {
#line 301 "/home/jim/git/california/src/component/component-event.vala"
			_tmp17_ = FALSE;
#line 1281 "component-event.c"
		}
#line 301 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp17_) {
#line 1285 "component-event.c"
			CaliforniaCalendarDateSpan* _tmp21_ = NULL;
			CaliforniaComponentEvent* _tmp22_ = NULL;
			CaliforniaCalendarDateSpan* _tmp23_ = NULL;
			gint _tmp24_ = 0;
#line 302 "/home/jim/git/california/src/component/component-event.vala"
			_tmp21_ = self->priv->_date_span;
#line 302 "/home/jim/git/california/src/component/component-event.vala"
			_tmp22_ = other;
#line 302 "/home/jim/git/california/src/component/component-event.vala"
			_tmp23_ = _tmp22_->priv->_date_span;
#line 302 "/home/jim/git/california/src/component/component-event.vala"
			_tmp24_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 302 "/home/jim/git/california/src/component/component-event.vala"
			compare = _tmp24_;
#line 1300 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp25_ = NULL;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
			_tmp25_ = self->priv->_exact_time_span;
#line 303 "/home/jim/git/california/src/component/component-event.vala"
			if (_tmp25_ != NULL) {
#line 1307 "component-event.c"
				CaliforniaCalendarExactTimeSpan* _tmp26_ = NULL;
				CaliforniaCalendarDateSpan* _tmp27_ = NULL;
				CaliforniaCalendarDateSpan* _tmp28_ = NULL;
				CaliforniaComponentEvent* _tmp29_ = NULL;
				CaliforniaCalendarDateSpan* _tmp30_ = NULL;
				gint _tmp31_ = 0;
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				_tmp26_ = self->priv->_exact_time_span;
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				_tmp27_ = california_calendar_date_span_new_from_exact_time_span (_tmp26_);
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				_tmp28_ = _tmp27_;
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				_tmp29_ = other;
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = _tmp29_->priv->_date_span;
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp31_;
#line 304 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp28_);
#line 1330 "component-event.c"
			} else {
				CaliforniaCalendarDateSpan* _tmp32_ = NULL;
				CaliforniaComponentEvent* _tmp33_ = NULL;
				CaliforniaCalendarExactTimeSpan* _tmp34_ = NULL;
				CaliforniaCalendarDateSpan* _tmp35_ = NULL;
				CaliforniaCalendarDateSpan* _tmp36_ = NULL;
				gint _tmp37_ = 0;
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = self->priv->_date_span;
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = other;
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = _tmp33_->priv->_exact_time_span;
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				_tmp35_ = california_calendar_date_span_new_from_exact_time_span (_tmp34_);
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				_tmp36_ = _tmp35_;
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				_tmp37_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp37_;
#line 306 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp36_);
#line 1354 "component-event.c"
			}
		}
	}
#line 308 "/home/jim/git/california/src/component/component-event.vala"
	_tmp38_ = compare;
#line 308 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp38_ != 0) {
#line 309 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 309 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1366 "component-event.c"
	}
#line 312 "/home/jim/git/california/src/component/component-event.vala"
	_tmp39_ = g_strcmp0;
#line 312 "/home/jim/git/california/src/component/component-event.vala"
	_tmp40_ = self->priv->_summary;
#line 312 "/home/jim/git/california/src/component/component-event.vala"
	_tmp41_ = other;
#line 312 "/home/jim/git/california/src/component/component-event.vala"
	_tmp42_ = _tmp41_->priv->_summary;
#line 312 "/home/jim/git/california/src/component/component-event.vala"
	_tmp43_ = _tmp39_ (_tmp40_, _tmp42_);
#line 312 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp43_;
#line 313 "/home/jim/git/california/src/component/component-event.vala"
	_tmp44_ = compare;
#line 313 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp44_ != 0) {
#line 314 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 314 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1388 "component-event.c"
	}
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	_tmp45_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	_tmp46_ = _tmp45_;
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	_tmp47_ = other;
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	_tmp48_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	_tmp49_ = _tmp48_;
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	_tmp50_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp49_);
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp50_;
#line 318 "/home/jim/git/california/src/component/component-event.vala"
	_tmp51_ = compare;
#line 318 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp51_ != 0) {
#line 319 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 319 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1412 "component-event.c"
	}
#line 322 "/home/jim/git/california/src/component/component-event.vala"
	_tmp52_ = california_component_instance_get_is_recurring (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 322 "/home/jim/git/california/src/component/component-event.vala"
	_tmp53_ = _tmp52_;
#line 322 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp53_) {
#line 1420 "component-event.c"
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		CaliforniaComponentEvent* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
#line 323 "/home/jim/git/california/src/component/component-event.vala"
		_tmp54_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 323 "/home/jim/git/california/src/component/component-event.vala"
		_tmp55_ = _tmp54_;
#line 323 "/home/jim/git/california/src/component/component-event.vala"
		_tmp56_ = other;
#line 323 "/home/jim/git/california/src/component/component-event.vala"
		_tmp57_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 323 "/home/jim/git/california/src/component/component-event.vala"
		_tmp58_ = _tmp57_;
#line 323 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp55_ - _tmp58_;
#line 324 "/home/jim/git/california/src/component/component-event.vala"
		_tmp59_ = compare;
#line 324 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp59_ != 0) {
#line 325 "/home/jim/git/california/src/component/component-event.vala"
			result = compare;
#line 325 "/home/jim/git/california/src/component/component-event.vala"
			return result;
#line 1447 "component-event.c"
		}
	}
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp60_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp61_ = _tmp60_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp62_ = other;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp63_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp64_ = _tmp63_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	_tmp65_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp64_);
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp65_;
#line 329 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1466 "component-event.c"
}


static gboolean california_component_event_real_equal_to (CaliforniaComponentInstance* base, CaliforniaComponentInstance* other) {
	CaliforniaComponentEvent * self;
	gboolean result = FALSE;
	CaliforniaComponentEvent* other_event = NULL;
	CaliforniaComponentInstance* _tmp0_ = NULL;
	CaliforniaComponentEvent* _tmp1_ = NULL;
	CaliforniaComponentEvent* _tmp2_ = NULL;
	CaliforniaComponentEvent* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	CaliforniaComponentEvent* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	CaliforniaComponentEvent* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	CaliforniaComponentInstance* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
#line 332 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 332 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_INSTANCE (other), FALSE);
#line 333 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = other;
#line 333 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CALIFORNIA_COMPONENT_TYPE_EVENT) ? ((CaliforniaComponentEvent*) _tmp0_) : NULL);
#line 333 "/home/jim/git/california/src/component/component-event.vala"
	other_event = _tmp1_;
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = other_event;
#line 334 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_ == NULL) {
#line 335 "/home/jim/git/california/src/component/component-event.vala"
		result = FALSE;
#line 335 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (other_event);
#line 335 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1513 "component-event.c"
	}
#line 337 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = other_event;
#line 337 "/home/jim/git/california/src/component/component-event.vala"
	if (self == _tmp3_) {
#line 338 "/home/jim/git/california/src/component/component-event.vala"
		result = TRUE;
#line 338 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (other_event);
#line 338 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1525 "component-event.c"
	}
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_component_instance_get_is_recurring (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = _tmp4_;
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = other_event;
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_component_instance_get_is_recurring (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = _tmp7_;
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp5_ != _tmp8_) {
#line 341 "/home/jim/git/california/src/component/component-event.vala"
		result = FALSE;
#line 341 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (other_event);
#line 341 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1545 "component-event.c"
	}
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = california_component_instance_get_is_recurring (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = _tmp10_;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp11_) {
#line 1553 "component-event.c"
		CaliforniaComponentDateTime* _tmp12_ = NULL;
		CaliforniaComponentDateTime* _tmp13_ = NULL;
		CaliforniaComponentEvent* _tmp14_ = NULL;
		CaliforniaComponentDateTime* _tmp15_ = NULL;
		CaliforniaComponentDateTime* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = _tmp12_;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp14_ = other_event;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = _tmp15_;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_HASHABLE, GeeHashable), _tmp16_);
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = !_tmp17_;
#line 1574 "component-event.c"
	} else {
#line 343 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = FALSE;
#line 1578 "component-event.c"
	}
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp9_) {
#line 344 "/home/jim/git/california/src/component/component-event.vala"
		result = FALSE;
#line 344 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (other_event);
#line 344 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1588 "component-event.c"
	}
#line 346 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 346 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = _tmp18_;
#line 346 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = other_event;
#line 346 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 346 "/home/jim/git/california/src/component/component-event.vala"
	_tmp22_ = _tmp21_;
#line 346 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp19_ != _tmp22_) {
#line 347 "/home/jim/git/california/src/component/component-event.vala"
		result = FALSE;
#line 347 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (other_event);
#line 347 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1608 "component-event.c"
	}
#line 349 "/home/jim/git/california/src/component/component-event.vala"
	_tmp23_ = other;
#line 349 "/home/jim/git/california/src/component/component-event.vala"
	_tmp24_ = CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->equal_to (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp23_);
#line 349 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp24_;
#line 349 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (other_event);
#line 349 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1620 "component-event.c"
}


static guint california_component_event_real_hash (CaliforniaComponentInstance* base) {
	CaliforniaComponentEvent * self;
	guint result = 0U;
	guint _tmp0_ = 0U;
	CaliforniaComponentDateTime* _tmp1_ = NULL;
	CaliforniaComponentDateTime* _tmp2_ = NULL;
	CaliforniaComponentUID* _tmp6_ = NULL;
	CaliforniaComponentUID* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 352 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_ != NULL) {
#line 1643 "component-event.c"
		CaliforniaComponentDateTime* _tmp3_ = NULL;
		CaliforniaComponentDateTime* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
#line 353 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 353 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp3_;
#line 353 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_HASHABLE, GeeHashable));
#line 353 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp5_;
#line 1655 "component-event.c"
	} else {
#line 353 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = (guint) 0;
#line 1659 "component-event.c"
	}
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = _tmp6_;
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_HASHABLE, GeeHashable));
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = _tmp9_;
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	result = (_tmp8_ ^ _tmp0_) ^ _tmp10_;
#line 353 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1675 "component-event.c"
}


static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaComponentEvent * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CaliforniaComponentDateTime* _tmp1_ = NULL;
	CaliforniaComponentDateTime* _tmp2_ = NULL;
	gchar* _tmp7_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
	CaliforniaComponentUID* _tmp13_ = NULL;
	CaliforniaComponentUID* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
#line 356 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 359 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 359 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 359 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_ != NULL) {
#line 1704 "component-event.c"
		CaliforniaComponentDateTime* _tmp3_ = NULL;
		CaliforniaComponentDateTime* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp3_;
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp5_;
#line 1718 "component-event.c"
	} else {
		gchar* _tmp6_ = NULL;
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = g_strdup ("(no-recurring)");
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 359 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp6_;
#line 1727 "component-event.c"
	}
#line 362 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = self->priv->_exact_time_span;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp8_ != NULL) {
#line 1733 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = self->priv->_exact_time_span;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp10_;
#line 1744 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = self->priv->_date_span;
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 362 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp12_;
#line 1756 "component-event.c"
	}
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = _tmp13_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = _tmp15_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = _tmp17_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = self->priv->_summary;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = g_strdup_printf ("Event %s/rid=%s/%d \"%s\" (%s)", _tmp16_, _tmp0_, _tmp18_, _tmp19_, _tmp7_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = _tmp20_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp16_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp21_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp7_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp0_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1786 "component-event.c"
}


const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_summary;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1801 "component-event.c"
}


void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = _tmp1_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "summary");
#line 1820 "component-event.c"
}


const gchar* california_component_event_get_description (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_description;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1835 "component-event.c"
}


void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = _tmp1_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "description");
#line 1854 "component-event.c"
}


CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarExactTimeSpan* result;
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_exact_time_span;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1869 "component-event.c"
}


static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp1_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = _tmp1_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "exact-time-span");
#line 1888 "component-event.c"
}


CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarDateSpan* result;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1903 "component-event.c"
}


static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = _tmp1_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "date-span");
#line 1922 "component-event.c"
}


gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_is_all_day;
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1937 "component-event.c"
}


static void california_component_event_set_is_all_day (CaliforniaComponentEvent* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_is_all_day = _tmp0_;
#line 63 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "is-all-day");
#line 1951 "component-event.c"
}


gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 69 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 70 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = self->priv->_is_all_day;
#line 70 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = TRUE;
#line 1967 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp2_ = NULL;
		CaliforniaCalendarDuration* _tmp3_ = NULL;
		CaliforniaCalendarDuration* _tmp4_ = NULL;
		CaliforniaCalendarDuration* _tmp5_ = NULL;
		guint64 _tmp6_ = 0ULL;
		guint64 _tmp7_ = 0ULL;
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_exact_time_span;
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_calendar_exact_time_span_get_duration (_tmp2_);
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp3_;
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = _tmp4_;
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = california_calendar_duration_get_days (_tmp5_);
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp6_;
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp7_ >= ((guint64) 1);
#line 70 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp5_);
#line 1991 "component-event.c"
	}
#line 70 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 70 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1997 "component-event.c"
}


const gchar* california_component_event_get_location (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_location;
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2012 "component-event.c"
}


void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = _tmp1_;
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "location");
#line 2031 "component-event.c"
}


CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self) {
	CaliforniaComponentEventStatus result;
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), 0);
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_status;
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2046 "component-event.c"
}


void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value) {
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = _tmp0_;
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "status");
#line 2060 "component-event.c"
}


static void california_component_event_class_init (CaliforniaComponentEventClass * klass) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaComponentEventPrivate));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (klass)->update_from_component = california_component_event_real_update_from_component;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (klass)->is_valid = california_component_event_real_is_valid;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (klass)->equal_to = california_component_event_real_equal_to;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (klass)->hash = california_component_event_real_hash;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_component_event_real_to_string;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_component_event_get_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_component_event_set_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->finalize = california_component_event_finalize;
#line 2085 "component-event.c"
	/**
	     * Summary (title) of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_SUMMARY, g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2091 "component-event.c"
	/**
	     * Description of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2097 "component-event.c"
	/**
	     * {@link Calendar.ExactTimeSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT specifies a DATE-TIME for both properties, otherwise
	     * {@link date_span} will be specified.
	     *
	     * @see set_exact_time_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN, g_param_spec_object ("exact-time-span", "exact-time-span", "exact-time-span", CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2108 "component-event.c"
	/**
	     * {@link Calendar.DateSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT defines a DATE for one or both properties.  Generally
	     * this indicates an "all day" or multi-day event.
	     *
	     * @see set_date_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DATE_SPAN, g_param_spec_object ("date-span", "date-span", "date-span", CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2119 "component-event.c"
	/**
	     * Convenience property for determining if an all-day event or not.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY, g_param_spec_boolean ("is-all-day", "is-all-day", "is-all-day", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2125 "component-event.c"
	/**
	     * Convenience property for determining if {@link Event} spans one or more full days.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING, g_param_spec_boolean ("is-day-spanning", "is-day-spanning", "is-day-spanning", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2131 "component-event.c"
	/**
	     * Location of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_LOCATION, g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2137 "component-event.c"
	/**
	     * Status (confirmation) of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_STATUS, g_param_spec_enum ("status", "status", "status", CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2143 "component-event.c"
}


static void california_component_event_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_component_event_real_compare_to;
#line 2152 "component-event.c"
}


static void california_component_event_instance_init (CaliforniaComponentEvent * self) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self->priv = CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE (self);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = NULL;
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = NULL;
#line 82 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED;
#line 2171 "component-event.c"
}


static void california_component_event_finalize (GObject* obj) {
	CaliforniaComponentEvent * self;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 77 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (california_component_event_parent_class)->finalize (obj);
#line 2191 "component-event.c"
}


/**
 * A mutable representation of an iCalendar Event.
 *
 * See [[https://tools.ietf.org/html/rfc5545#section-3.6.1]]
 */
GType california_component_event_get_type (void) {
	static volatile gsize california_component_event_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaComponentEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_component_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaComponentEvent), 0, (GInstanceInitFunc) california_component_event_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_component_event_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_component_event_type_id;
		california_component_event_type_id = g_type_register_static (CALIFORNIA_COMPONENT_TYPE_INSTANCE, "CaliforniaComponentEvent", &g_define_type_info, 0);
		g_type_add_interface_static (california_component_event_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_once_init_leave (&california_component_event_type_id__volatile, california_component_event_type_id);
	}
	return california_component_event_type_id__volatile;
}


static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_summary (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_description (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_exact_time_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_date_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_all_day (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_day_spanning (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_location (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_enum (value, california_component_event_get_status (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 2267 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 2273 "component-event.c"
	}
}


static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_summary (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_description (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_exact_time_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_date_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_is_all_day (self, g_value_get_boolean (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_location (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_status (self, g_value_get_enum (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 2325 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 2331 "component-event.c"
	}
}



