/* calendar-date-span.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-date-span.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;
typedef struct _CaliforniaCalendarSpanPrivate CaliforniaCalendarSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;

#define CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN (california_calendar_unit_span_get_type ())
#define CALIFORNIA_CALENDAR_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))

typedef struct _CaliforniaCalendarUnitSpan CaliforniaCalendarUnitSpan;
typedef struct _CaliforniaCalendarUnitSpanClass CaliforniaCalendarUnitSpanClass;
typedef struct _CaliforniaCalendarUnitSpanPrivate CaliforniaCalendarUnitSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;
typedef struct _CaliforniaCalendarDateSpanPrivate CaliforniaCalendarDateSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN (california_calendar_exact_time_span_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpan))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))

typedef struct _CaliforniaCalendarExactTimeSpan CaliforniaCalendarExactTimeSpan;
typedef struct _CaliforniaCalendarExactTimeSpanClass CaliforniaCalendarExactTimeSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSpanPrivate * priv;
};

struct _CaliforniaCalendarSpanClass {
	CaliforniaBaseObjectClass parent_class;
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (CaliforniaCollectionSimpleIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (CaliforniaCollectionSimpleIterable* self);
	GDestroyNotify (*get_g_destroy_func) (CaliforniaCollectionSimpleIterable* self);
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarUnitSpan {
	CaliforniaCalendarSpan parent_instance;
	CaliforniaCalendarUnitSpanPrivate * priv;
};

struct _CaliforniaCalendarUnitSpanClass {
	CaliforniaCalendarSpanClass parent_class;
	gboolean (*contains) (CaliforniaCalendarUnitSpan* self, gconstpointer unit);
};

struct _CaliforniaCalendarDateSpan {
	CaliforniaCalendarUnitSpan parent_instance;
	CaliforniaCalendarDateSpanPrivate * priv;
};

struct _CaliforniaCalendarDateSpanClass {
	CaliforniaCalendarUnitSpanClass parent_class;
};


static gpointer california_calendar_date_span_parent_class = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
enum  {
	CALIFORNIA_CALENDAR_DATE_SPAN_DUMMY_PROPERTY
};
CaliforniaCalendarDateSpan* california_calendar_date_span_new (CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarUnitSpan* california_calendar_unit_span_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer first, gconstpointer last, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_span (CaliforniaCalendarSpan* span);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_span (GType object_type, CaliforniaCalendarSpan* span);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
GType california_calendar_exact_time_span_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_start_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_end_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_start_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_start_date);
gint california_calendar_unit_difference (CaliforniaCalendarUnit* self, gconstpointer other);
gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity);
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_end_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_end_date);
static gboolean california_calendar_date_span_real_contains (CaliforniaCalendarUnitSpan* base, CaliforniaCalendarDate* date);
gboolean california_calendar_span_has_date (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date);
static gchar* california_calendar_date_span_real_to_string (CaliforniaBaseObject* base);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);


/**
     * Create a {@link DateSpan} with the specified start and end dates.
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date) {
	CaliforniaCalendarDateSpan * self = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (start_date), NULL);
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (end_date), NULL);
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = start_date;
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = end_date;
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = start_date;
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = end_date;
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = (CaliforniaCalendarDateSpan*) california_calendar_unit_span_construct (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self;
#line 238 "calendar-date-span.c"
}


CaliforniaCalendarDateSpan* california_calendar_date_span_new (CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date) {
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return california_calendar_date_span_construct (CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, start_date, end_date);
#line 245 "calendar-date-span.c"
}


/**
     * Create a {@link DateSpan} from a {@link Span}.
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_span (GType object_type, CaliforniaCalendarSpan* span) {
	CaliforniaCalendarDateSpan * self = NULL;
	CaliforniaCalendarSpan* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarSpan* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarSpan* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarSpan* _tmp9_ = NULL;
	CaliforniaCalendarDate* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
#line 31 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SPAN (span), NULL);
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = span;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_span_get_start_date (_tmp0_);
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = span;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_calendar_span_get_end_date (_tmp3_);
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = span;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = california_calendar_span_get_start_date (_tmp6_);
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = _tmp7_;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = span;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp10_ = california_calendar_span_get_end_date (_tmp9_);
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp11_ = _tmp10_;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = (CaliforniaCalendarDateSpan*) california_calendar_unit_span_construct (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp2_, _tmp5_, _tmp8_, _tmp11_);
#line 31 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self;
#line 296 "calendar-date-span.c"
}


CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_span (CaliforniaCalendarSpan* span) {
#line 31 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return california_calendar_date_span_construct_from_span (CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, span);
#line 303 "calendar-date-span.c"
}


/**
     * Create a {@link DateSpan} from the {@link ExactTimeSpan}.
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span) {
	CaliforniaCalendarDateSpan * self = NULL;
	CaliforniaCalendarDate* start_date = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTime* _tmp1_ = NULL;
	CaliforniaCalendarExactTime* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* end_date = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp4_ = NULL;
	CaliforniaCalendarExactTime* _tmp5_ = NULL;
	CaliforniaCalendarExactTime* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
#line 38 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN (exact_time_span), NULL);
#line 39 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = exact_time_span;
#line 39 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_exact_time_span_get_start_exact_time (_tmp0_);
#line 39 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 39 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = california_calendar_date_new_from_exact_time (_tmp2_);
#line 39 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	start_date = _tmp3_;
#line 40 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = exact_time_span;
#line 40 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = california_calendar_exact_time_span_get_end_exact_time (_tmp4_);
#line 40 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = _tmp5_;
#line 40 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = california_calendar_date_new_from_exact_time (_tmp6_);
#line 40 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	end_date = _tmp7_;
#line 42 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = (CaliforniaCalendarDateSpan*) california_calendar_unit_span_construct (object_type, CALIFORNIA_CALENDAR_TYPE_DATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, start_date, end_date, start_date, end_date);
#line 38 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (end_date);
#line 38 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (start_date);
#line 38 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self;
#line 352 "calendar-date-span.c"
}


CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span) {
#line 38 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return california_calendar_date_span_construct_from_exact_time_span (CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, exact_time_span);
#line 359 "calendar-date-span.c"
}


/**
     * Adjusts the start of the {@link DateSpan} preserving the span duration.
     *
     * Since DateSpan always guarantees the {@link start_date} will be before the {@link end_date},
     * it's sometimes desirable to manipulate the start_date and preserve the duration between its
     * original value and the end_date.
     *
     * @see adjust_end_date
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_start_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_start_date) {
	CaliforniaCalendarDateSpan* result = NULL;
	gint diff = 0;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarDate* _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDateSpan* _tmp9_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
#line 54 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), NULL);
#line 54 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (new_start_date), NULL);
#line 55 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 55 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 55 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 55 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = _tmp2_;
#line 55 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_calendar_unit_difference (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp3_);
#line 55 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	diff = _tmp4_;
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = new_start_date;
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = new_start_date;
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), diff);
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = (CaliforniaCalendarDate*) _tmp7_;
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = california_calendar_date_span_new (_tmp5_, _tmp8_);
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp10_ = _tmp9_;
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp8_);
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp10_;
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 420 "calendar-date-span.c"
}


/**
     * Adjusts the end of the {@link DateSpan} preserving the span duration.
     *
     * Since DateSpan always guarantees the {@link start_date} will be before the {@link end_date},
     * it's sometimes desirable to manipulate the end_date and preserve the duration between its
     * original value and the start_date.
     *
     * @see adjust_start_date
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_end_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_end_date) {
	CaliforniaCalendarDateSpan* result = NULL;
	gint diff = 0;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDateSpan* _tmp9_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
#line 69 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), NULL);
#line 69 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (new_end_date), NULL);
#line 70 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 70 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 70 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = _tmp2_;
#line 70 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_calendar_unit_difference (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp3_);
#line 70 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	diff = _tmp4_;
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = new_end_date;
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), diff);
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = (CaliforniaCalendarDate*) _tmp6_;
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = new_end_date;
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = california_calendar_date_span_new (_tmp7_, _tmp8_);
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp10_ = _tmp9_;
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp7_);
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp10_;
#line 72 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 481 "calendar-date-span.c"
}


/**
     * @inheritDoc
     */
static gboolean california_calendar_date_span_real_contains (CaliforniaCalendarUnitSpan* base, CaliforniaCalendarDate* date) {
	CaliforniaCalendarDateSpan * self;
	gboolean result = FALSE;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 78 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 78 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (date), FALSE);
#line 79 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = date;
#line 79 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_span_has_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan), _tmp0_);
#line 79 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 79 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 505 "calendar-date-span.c"
}


static gchar* california_calendar_date_span_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarDateSpan * self;
	gchar* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 82 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = _tmp2_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = g_strdup_printf ("%s::%s", _tmp3_, _tmp7_);
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = _tmp8_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_free0 (_tmp7_);
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_free0 (_tmp3_);
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp9_;
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 552 "calendar-date-span.c"
}


static void california_calendar_date_span_class_init (CaliforniaCalendarDateSpanClass * klass) {
#line 20 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	CALIFORNIA_CALENDAR_UNIT_SPAN_CLASS (klass)->contains = california_calendar_date_span_real_contains;
#line 20 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_date_span_real_to_string;
#line 563 "calendar-date-span.c"
}


static void california_calendar_date_span_instance_init (CaliforniaCalendarDateSpan * self) {
}


/**
 * Represents an immutable arbitrary span of consecutive {@link Date}s.
 *
 * Although DateSpan is technically a {@link UnitSpan} of Dates, it's such a fundamental way of
 * representing any unit of dates that {@link Span} offers a conversion method.  Thus, a
 * {@link Week} is a {@link DiscreteUnit} but it can easily be converted into a {@link DateSpan}.
 * The only reason Week does not inherit from DateSpan -- indeed, all units of calendar time don't
 * inherit from DateSpan -- is to avoid inheritance problems and circularities.  (Another way to
 * look at things is that Span is a lightweight DateSpan.)
 */
GType california_calendar_date_span_get_type (void) {
	static volatile gsize california_calendar_date_span_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_span_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarDateSpanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_date_span_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarDateSpan), 0, (GInstanceInitFunc) california_calendar_date_span_instance_init, NULL };
		GType california_calendar_date_span_type_id;
		california_calendar_date_span_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, "CaliforniaCalendarDateSpan", &g_define_type_info, 0);
		g_once_init_leave (&california_calendar_date_span_type_id__volatile, california_calendar_date_span_type_id);
	}
	return california_calendar_date_span_type_id__volatile;
}



