/* calendar-wall-time.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-wall-time.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;
typedef struct _CaliforniaCalendarWallTimePrivate CaliforniaCalendarWallTimePrivate;

#define CALIFORNIA_CALENDAR_WALL_TIME_TYPE_PRETTY_FLAG (california_calendar_wall_time_pretty_flag_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIME_UNIT (california_calendar_time_unit_get_type ())

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarWallTime {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarWallTimePrivate * priv;
};

struct _CaliforniaCalendarWallTimeClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaCalendarWallTimePrivate {
	gint _hour;
	gint _12hour;
	gint _minute;
	gint _second;
};

typedef enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS = 1 << 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES = 1 << 1,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY = 1 << 2,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM = 1 << 3
} CaliforniaCalendarWallTimePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_TIME_UNIT_SECOND,
	CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE,
	CALIFORNIA_CALENDAR_TIME_UNIT_HOUR
} CaliforniaCalendarTimeUnit;


static gpointer california_calendar_wall_time_parent_class = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest = NULL;
extern const gchar* california_calendar_MIDNIGHT;
extern const gchar* california_calendar_NOON;
extern const gchar* california_calendar_FMT_AM;
extern const gchar* california_calendar_FMT_BRIEF_AM;
extern const gchar* california_calendar_FMT_PM;
extern const gchar* california_calendar_FMT_BRIEF_PM;
extern const gchar* california_calendar_FMT_24HOUR_MIN;
extern const gchar* california_calendar_FMT_12HOUR_MIN_MERIDIEM;
extern const gchar* california_calendar_FMT_24HOUR_MIN_SEC;
extern const gchar* california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
static GeeComparableIface* california_calendar_wall_time_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_wall_time_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimePrivate))
enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_WALL_TIME_HOUR,
	CALIFORNIA_CALENDAR_WALL_TIME_MINUTE,
	CALIFORNIA_CALENDAR_WALL_TIME_SECOND,
	CALIFORNIA_CALENDAR_WALL_TIME_IS_PM
};
GType california_calendar_wall_time_pretty_flag_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY 24
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR (CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE (CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND (CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - 1)
CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second);
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value);
void california_calendar_wall_time_init (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void);
static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void);
static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value);
void california_calendar_wall_time_terminate (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed);
gboolean california_string_is_empty (const gchar* str);
gboolean california_string_is_numeric (const gchar* str);
GType california_calendar_time_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover);
gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self);
static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover);
CaliforniaCalendarWallTime* california_calendar_wall_time_round_down (CaliforniaCalendarWallTime* self, gint multiple, CaliforniaCalendarTimeUnit time_unit);
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags);
gboolean california_calendar_system_get_is_24hr (void);
gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self);
gchar* california_string_reduce_whitespace (const gchar* str);
static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other);
static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other);
static guint california_calendar_wall_time_real_hash (GeeHashable* base);
static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base);
static void california_calendar_wall_time_finalize (GObject* obj);
static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Options for {@link to_pretty_string}.
     */
GType california_calendar_wall_time_pretty_flag_get_type (void) {
	static volatile gsize california_calendar_wall_time_pretty_flag_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_pretty_flag_type_id__volatile)) {
		static const GFlagsValue values[] = {{CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE", "none"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS", "include-seconds"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES", "optional-minutes"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY", "meridiem-post-only"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM", "brief-meridiem"}, {0, NULL, NULL}};
		GType california_calendar_wall_time_pretty_flag_type_id;
		california_calendar_wall_time_pretty_flag_type_id = g_flags_register_static ("CaliforniaCalendarWallTimePrettyFlag", values);
		g_once_init_leave (&california_calendar_wall_time_pretty_flag_type_id__volatile, california_calendar_wall_time_pretty_flag_type_id);
	}
	return california_calendar_wall_time_pretty_flag_type_id__volatile;
}


/**
     * Generate a new {@link WallTime} object with the specified values.
     *
     * Note that hour must be in 24-hour time.
     *
     * Values will be clamped to create a valid time.
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second) {
	CaliforniaCalendarWallTime * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = (CaliforniaCalendarWallTime*) california_base_object_construct (object_type);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = hour;
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = CLAMP (_tmp0_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_hour (self, _tmp1_);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = minute;
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = CLAMP (_tmp2_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_minute (self, _tmp3_);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = second;
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = CLAMP (_tmp4_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_second (self, _tmp5_);
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = hour;
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_ == 0) {
#line 105 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_12hour (self, 12);
#line 223 "calendar-wall-time.c"
	} else {
		gint _tmp7_ = 0;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp7_ = hour;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp7_ > 12) {
#line 230 "calendar-wall-time.c"
			gint _tmp8_ = 0;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = hour;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp8_ - 12);
#line 236 "calendar-wall-time.c"
		} else {
			gint _tmp9_ = 0;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp9_ = hour;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp9_);
#line 243 "calendar-wall-time.c"
		}
	}
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self;
#line 248 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second) {
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return california_calendar_wall_time_construct (CALIFORNIA_CALENDAR_TYPE_WALL_TIME, hour, minute, second);
#line 255 "calendar-wall-time.c"
}


/**
     * Called from Calendar.init().
     */
void california_calendar_wall_time_init (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	CaliforniaCalendarWallTime* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarWallTime* _tmp7_ = NULL;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND);
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (_tmp3_);
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp3_);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_wall_time_get_latest ();
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_;
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (_tmp7_);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp7_);
#line 295 "calendar-wall-time.c"
}


/**
     * Called from Calendar.terminate().
     */
void california_calendar_wall_time_terminate (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (NULL);
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_get_latest ();
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (NULL);
#line 319 "calendar-wall-time.c"
}


/**
     * Attempt to convert a string into {@link WallTime}.
     *
     * 24-hour and 12-hour time is recognized, as are localized versions of AM and PM.  If the time
     * was "liberally" parsed (in other words, "8" is converted to 8am), the returned flag is
     * cleared.
     */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 349 "calendar-wall-time.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1226 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1227 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1227 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1227 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1228 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1228 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 382 "calendar-wall-time.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1229 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1229 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1229 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 391 "calendar-wall-time.c"
	}
#line 1231 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1231 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 397 "calendar-wall-time.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1232 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1232 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1232 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 406 "calendar-wall-time.c"
	}
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 412 "calendar-wall-time.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 421 "calendar-wall-time.c"
	} else {
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 425 "calendar-wall-time.c"
	}
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 433 "calendar-wall-time.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 442 "calendar-wall-time.c"
	} else {
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 446 "calendar-wall-time.c"
	}
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1236 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1236 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1236 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 468 "calendar-wall-time.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 481 "calendar-wall-time.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 512 "calendar-wall-time.c"
				goto __catch27_g_regex_error;
			}
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 521 "calendar-wall-time.c"
		}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 537 "calendar-wall-time.c"
				goto __catch27_g_regex_error;
			}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 548 "calendar-wall-time.c"
		}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 562 "calendar-wall-time.c"
	}
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError* e = NULL;
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1283 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 576 "calendar-wall-time.c"
	}
	__finally27:
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return NULL;
#line 587 "calendar-wall-time.c"
	}
}


CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed) {
	gboolean _vala_strictly_parsed = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gchar* token = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean pm = FALSE;
	gboolean meridiem_unknown = FALSE;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gint length = 0;
	const gchar* _tmp85_ = NULL;
	gint _tmp86_ = 0;
	gint _tmp87_ = 0;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp89_ = FALSE;
	const gchar* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp94_ = FALSE;
	gint _tmp95_ = 0;
	gint h = 0;
	const gchar* _tmp121_ = NULL;
	gint _tmp122_ = 0;
	gboolean _tmp123_ = FALSE;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp127_ = FALSE;
	gint _tmp128_ = 0;
	CaliforniaCalendarWallTime* _tmp129_ = NULL;
#line 135 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 136 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = FALSE;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = str;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = string_strip (_tmp0_);
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = _tmp1_;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) (-1));
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = _tmp3_;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp2_);
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp4_;
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = token;
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_string_is_empty (_tmp5_);
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_) {
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 668 "calendar-wall-time.c"
		}
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 672 "calendar-wall-time.c"
	}
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = token;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = california_calendar_MIDNIGHT;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) (-1));
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = _tmp9_;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp10_);
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 688 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp12_ = NULL;
#line 144 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_wall_time_new (0, 0, 0);
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp12_;
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 702 "calendar-wall-time.c"
		}
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 706 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = token;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp14_ = california_calendar_NOON;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = g_utf8_casefold (_tmp14_, (gssize) (-1));
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = _tmp15_;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp16_);
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp17_) {
#line 727 "calendar-wall-time.c"
			CaliforniaCalendarWallTime* _tmp18_ = NULL;
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_strictly_parsed = TRUE;
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = california_calendar_wall_time_new (12, 0, 0);
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp18_;
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (strictly_parsed) {
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				*strictly_parsed = _vala_strictly_parsed;
#line 741 "calendar-wall-time.c"
			}
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 745 "calendar-wall-time.c"
		}
	}
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = FALSE;
#line 155 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_unknown = FALSE;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp19_ = token;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp20_ = california_calendar_FMT_AM;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) (-1));
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp22_ = _tmp21_;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp23_ = g_str_has_suffix (_tmp19_, _tmp22_);
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp24_ = _tmp23_;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp22_);
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp24_) {
#line 768 "calendar-wall-time.c"
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gchar* _tmp34_ = NULL;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = token;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = token;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp27_ = strlen (_tmp26_);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp28_ = _tmp27_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp29_ = california_calendar_FMT_AM;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp30_ = g_utf8_casefold (_tmp29_, (gssize) (-1));
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = _tmp30_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp32_ = strlen (_tmp31_);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp33_ = _tmp32_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp34_ = string_slice (_tmp25_, (glong) 0, (glong) (_tmp28_ - _tmp33_));
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		token = _tmp34_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp31_);
#line 805 "calendar-wall-time.c"
	} else {
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = token;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp36_ = california_calendar_FMT_BRIEF_AM;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp37_ = g_utf8_casefold (_tmp36_, (gssize) (-1));
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp38_ = _tmp37_;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp39_ = g_str_has_suffix (_tmp35_, _tmp38_);
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp40_ = _tmp39_;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp38_);
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp40_) {
#line 829 "calendar-wall-time.c"
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			const gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gchar* _tmp50_ = NULL;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = token;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = token;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp43_ = strlen (_tmp42_);
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp44_ = _tmp43_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp45_ = california_calendar_FMT_BRIEF_AM;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp46_ = g_utf8_casefold (_tmp45_, (gssize) (-1));
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp47_ = _tmp46_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp48_ = strlen (_tmp47_);
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp49_ = _tmp48_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp50_ = string_slice (_tmp41_, (glong) 0, (glong) (_tmp44_ - _tmp49_));
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			token = _tmp50_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp47_);
#line 866 "calendar-wall-time.c"
		} else {
			const gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_ = FALSE;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp51_ = token;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp52_ = california_calendar_FMT_PM;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp53_ = g_utf8_casefold (_tmp52_, (gssize) (-1));
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp54_ = _tmp53_;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp55_ = g_str_has_suffix (_tmp51_, _tmp54_);
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp56_ = _tmp55_;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp54_);
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp56_) {
#line 890 "calendar-wall-time.c"
				const gchar* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				const gchar* _tmp61_ = NULL;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				gchar* _tmp66_ = NULL;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp57_ = token;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp58_ = token;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp59_ = strlen (_tmp58_);
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp60_ = _tmp59_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp61_ = california_calendar_FMT_PM;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp62_ = g_utf8_casefold (_tmp61_, (gssize) (-1));
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp63_ = _tmp62_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp64_ = strlen (_tmp63_);
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp65_ = _tmp64_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp66_ = string_slice (_tmp57_, (glong) 0, (glong) (_tmp60_ - _tmp65_));
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (token);
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				token = _tmp66_;
#line 161 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (_tmp63_);
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				pm = TRUE;
#line 929 "calendar-wall-time.c"
			} else {
				const gchar* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_ = NULL;
				gboolean _tmp71_ = FALSE;
				gboolean _tmp72_ = FALSE;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp67_ = token;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp68_ = california_calendar_FMT_BRIEF_PM;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp69_ = g_utf8_casefold (_tmp68_, (gssize) (-1));
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp70_ = _tmp69_;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp71_ = g_str_has_suffix (_tmp67_, _tmp70_);
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp72_ = _tmp71_;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (_tmp70_);
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				if (_tmp72_) {
#line 953 "calendar-wall-time.c"
					const gchar* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					gint _tmp75_ = 0;
					gint _tmp76_ = 0;
					const gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
					gchar* _tmp79_ = NULL;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gchar* _tmp82_ = NULL;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp73_ = token;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp74_ = token;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp75_ = strlen (_tmp74_);
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp76_ = _tmp75_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp77_ = california_calendar_FMT_BRIEF_PM;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp78_ = g_utf8_casefold (_tmp77_, (gssize) (-1));
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp79_ = _tmp78_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp80_ = strlen (_tmp79_);
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp81_ = _tmp80_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp82_ = string_slice (_tmp73_, (glong) 0, (glong) (_tmp76_ - _tmp81_));
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_g_free0 (token);
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					token = _tmp82_;
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_g_free0 (_tmp79_);
#line 165 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					pm = TRUE;
#line 992 "calendar-wall-time.c"
				} else {
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					meridiem_unknown = TRUE;
#line 996 "calendar-wall-time.c"
				}
			}
		}
	}
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp83_ = token;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp84_ = string_replace (_tmp83_, ":", "");
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp84_;
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp85_ = token;
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp86_ = strlen (_tmp85_);
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp87_ = _tmp86_;
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	length = _tmp87_;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp90_ = token;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp91_ = california_string_is_numeric (_tmp90_);
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp91_) {
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp89_ = TRUE;
#line 1025 "calendar-wall-time.c"
	} else {
		gint _tmp92_ = 0;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp92_ = length;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp89_ = _tmp92_ == 0;
#line 1032 "calendar-wall-time.c"
	}
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp89_) {
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp88_ = TRUE;
#line 1038 "calendar-wall-time.c"
	} else {
		gint _tmp93_ = 0;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp93_ = length;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp88_ = _tmp93_ > 4;
#line 1045 "calendar-wall-time.c"
	}
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp88_) {
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1057 "calendar-wall-time.c"
		}
#line 176 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1061 "calendar-wall-time.c"
	}
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp95_ = length;
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp95_ == 3) {
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp94_ = TRUE;
#line 1069 "calendar-wall-time.c"
	} else {
		gint _tmp96_ = 0;
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp96_ = length;
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp94_ = _tmp96_ == 4;
#line 1076 "calendar-wall-time.c"
	}
#line 179 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp94_) {
#line 1080 "calendar-wall-time.c"
		gint h = 0;
		gint m = 0;
		gint _tmp97_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_ = FALSE;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		CaliforniaCalendarWallTime* _tmp120_ = NULL;
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp97_ = length;
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp97_ == 3) {
#line 1093 "calendar-wall-time.c"
			const gchar* _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			gint _tmp101_ = 0;
			const gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gint _tmp105_ = 0;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp98_ = token;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp99_ = string_slice (_tmp98_, (glong) 0, (glong) 1);
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp100_ = _tmp99_;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp101_ = atoi (_tmp100_);
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp101_;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp100_);
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp102_ = token;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp103_ = string_slice (_tmp102_, (glong) 1, (glong) 3);
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp104_ = _tmp103_;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp105_ = atoi (_tmp104_);
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp105_;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp104_);
#line 1126 "calendar-wall-time.c"
		} else {
			const gchar* _tmp106_ = NULL;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gint _tmp109_ = 0;
			const gchar* _tmp110_ = NULL;
			gchar* _tmp111_ = NULL;
			gchar* _tmp112_ = NULL;
			gint _tmp113_ = 0;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp106_ = token;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp107_ = string_slice (_tmp106_, (glong) 0, (glong) 2);
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp108_ = _tmp107_;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp109_ = atoi (_tmp108_);
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp109_;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp108_);
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp110_ = token;
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp111_ = string_slice (_tmp110_, (glong) 2, (glong) 4);
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp112_ = _tmp111_;
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp113_ = atoi (_tmp112_);
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp113_;
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp112_);
#line 1160 "calendar-wall-time.c"
		}
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp115_ = meridiem_unknown;
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (!_tmp115_) {
#line 1166 "calendar-wall-time.c"
			gboolean _tmp116_ = FALSE;
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp116_ = pm;
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp114_ = _tmp116_;
#line 1172 "calendar-wall-time.c"
		} else {
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp114_ = FALSE;
#line 1176 "calendar-wall-time.c"
		}
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp114_) {
#line 1180 "calendar-wall-time.c"
			gint _tmp117_ = 0;
#line 190 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp117_ = h;
#line 190 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp117_ + 12;
#line 1186 "calendar-wall-time.c"
		}
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp118_ = h;
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp119_ = m;
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp120_ = california_calendar_wall_time_new (_tmp118_, _tmp119_, 0);
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp120_;
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1204 "calendar-wall-time.c"
		}
#line 194 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1208 "calendar-wall-time.c"
	}
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp121_ = token;
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp122_ = atoi (_tmp121_);
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	h = _tmp122_;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp124_ = meridiem_unknown;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp124_) {
#line 1220 "calendar-wall-time.c"
		gboolean _tmp125_ = FALSE;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp125_ = pm;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp123_ = _tmp125_;
#line 1226 "calendar-wall-time.c"
	} else {
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp123_ = FALSE;
#line 1230 "calendar-wall-time.c"
	}
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp123_) {
#line 1234 "calendar-wall-time.c"
		gint _tmp126_ = 0;
#line 201 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp126_ = h;
#line 201 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		h = _tmp126_ + 12;
#line 1240 "calendar-wall-time.c"
	}
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp127_ = meridiem_unknown;
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = !_tmp127_;
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp128_ = h;
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp129_ = california_calendar_wall_time_new (_tmp128_, 0, 0);
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp129_;
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (strictly_parsed) {
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*strictly_parsed = _vala_strictly_parsed;
#line 1258 "calendar-wall-time.c"
	}
#line 205 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1262 "calendar-wall-time.c"
}


/**
     * Returns {@link WallTime} adjusted before or after this one.
     *
     * To subtract time, use a negative value.
     *
     * Like a wall clock, this will rollover to the next or previous day if enough time is
     * specified.  When this occurs, it's indicated in the rollover bool as an out result.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self ? g_object_ref (self) : NULL;
#line 1277 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	gint new_hour = 0;
	gint _tmp2_ = 0;
	gint new_minute = 0;
	gint _tmp3_ = 0;
	gint new_second = 0;
	gint _tmp4_ = 0;
	CaliforniaCalendarTimeUnit _tmp5_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	CaliforniaCalendarWallTime* _tmp15_ = NULL;
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 217 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 217 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 1302 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 218 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1314 "calendar-wall-time.c"
		}
#line 220 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1318 "calendar-wall-time.c"
	}
#line 223 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_hour;
#line 223 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_hour = _tmp2_;
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = self->priv->_minute;
#line 224 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_minute = _tmp3_;
#line 225 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = self->priv->_second;
#line 225 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_second = _tmp4_;
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = unit;
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp5_) {
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 1338 "calendar-wall-time.c"
		{
			gint _tmp6_ = 0;
			gboolean _tmp7_ = FALSE;
#line 229 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp6_ = value;
#line 229 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, &new_hour, _tmp6_, &_tmp7_);
#line 229 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp7_;
#line 230 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1350 "calendar-wall-time.c"
		}
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 1354 "calendar-wall-time.c"
		{
			gint _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
#line 233 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = value;
#line 233 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, &new_hour, &new_minute, _tmp8_, &_tmp9_);
#line 233 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp9_;
#line 234 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1366 "calendar-wall-time.c"
		}
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 1370 "calendar-wall-time.c"
		{
			gint _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp10_ = value;
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_second (self, &new_hour, &new_minute, &new_second, _tmp10_, &_tmp11_);
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp11_;
#line 238 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1382 "calendar-wall-time.c"
		}
		default:
		{
#line 241 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 1388 "calendar-wall-time.c"
		}
	}
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp12_ = new_hour;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp13_ = new_minute;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = new_second;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = california_calendar_wall_time_new (_tmp12_, _tmp13_, _tmp14_);
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp15_;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1405 "calendar-wall-time.c"
	}
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1409 "calendar-wall-time.c"
}


static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint rem = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 247 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 249 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 251 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 251 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1435 "calendar-wall-time.c"
		}
#line 251 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1439 "calendar-wall-time.c"
	}
#line 256 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 256 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 256 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp2_ % CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1451 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = rem;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1457 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = rem;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1464 "calendar-wall-time.c"
	}
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = *current_hour;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_hour = _tmp7_ + _tmp3_;
#line 260 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = *current_hour;
#line 260 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ < 0) {
#line 1474 "calendar-wall-time.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 261 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = *current_hour;
#line 261 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = abs (_tmp9_);
#line 261 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_hour = CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - _tmp10_;
#line 262 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = TRUE;
#line 1485 "calendar-wall-time.c"
	} else {
		gint _tmp11_ = 0;
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp11_ = *current_hour;
#line 263 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp11_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 1492 "calendar-wall-time.c"
			gint _tmp12_ = 0;
#line 264 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp12_ = *current_hour;
#line 264 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_hour = _tmp12_ - CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 265 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = TRUE;
#line 1500 "calendar-wall-time.c"
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp13_ = value;
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp14_ = abs (_tmp13_);
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp14_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = TRUE;
#line 1512 "calendar-wall-time.c"
			} else {
#line 269 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = FALSE;
#line 1516 "calendar-wall-time.c"
			}
		}
	}
#line 247 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 247 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1524 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint hours = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 273 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 274 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 274 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 275 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 277 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 277 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1557 "calendar-wall-time.c"
		}
#line 277 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1561 "calendar-wall-time.c"
	}
#line 280 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 280 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 280 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	hours = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1573 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = hours;
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1579 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = hours;
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1586 "calendar-wall-time.c"
	}
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_hour (self, current_hour, _tmp3_, &_tmp7_);
#line 281 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1602 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1608 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1615 "calendar-wall-time.c"
	}
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_minute;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_minute = _tmp14_ + _tmp10_;
#line 287 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_minute;
#line 287 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1625 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 288 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_minute;
#line 288 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 288 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_minute = CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - _tmp17_;
#line 290 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_hour (self, current_hour, -1, &_tmp18_);
#line 290 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1648 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1655 "calendar-wall-time.c"
		}
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1659 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_minute;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR) {
#line 1666 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 293 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_minute;
#line 293 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_minute = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, current_hour, 1, &_tmp24_);
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 1686 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 1693 "calendar-wall-time.c"
			}
#line 296 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 1697 "calendar-wall-time.c"
		}
	}
#line 273 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 273 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1704 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint minutes = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 305 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 305 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1737 "calendar-wall-time.c"
		}
#line 305 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1741 "calendar-wall-time.c"
	}
#line 308 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 308 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 308 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	minutes = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1753 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = minutes;
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1759 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = minutes;
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1766 "calendar-wall-time.c"
	}
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, _tmp3_, &_tmp7_);
#line 309 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 312 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 312 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 312 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1782 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1788 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1795 "calendar-wall-time.c"
	}
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_second;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_second = _tmp14_ + _tmp10_;
#line 316 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_second;
#line 316 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1805 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 317 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_second;
#line 317 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 317 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_second = CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - _tmp17_;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, -1, &_tmp18_);
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1828 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1835 "calendar-wall-time.c"
		}
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1839 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 321 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_second;
#line 321 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE) {
#line 1846 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 322 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_second;
#line 322 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_second = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, 1, &_tmp24_);
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 325 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 325 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 325 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 1866 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 325 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 325 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 1873 "calendar-wall-time.c"
			}
#line 325 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 1877 "calendar-wall-time.c"
		}
	}
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1884 "calendar-wall-time.c"
	}
}


/**
     * Round a unit of the {@link WallTime} to a multiple of a supplied value.
     *
     * By rounding wall-clock time, not only is the unit in question rounded down to a multiple of
     * the supplied value, but the lesser units are truncated to zero.  Thus, 17:23:54 rounded down
     * to a multiple of 10 minutes returns 17:20:00.
     *
     * If the {@link TimeUnit} is already a multiple of the value, no change is made (although
     * there's no guarantee that the same WallTime instance will be returned, especially if the
     * lesser units are truncated).
     *
     * A multiple of zero or a negative value is always rounded to the current WallTime.
     *
     * TODO: An interface to round up (which will need to deal with overflow).
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_round_down (CaliforniaCalendarWallTime* self, gint multiple, CaliforniaCalendarTimeUnit time_unit) {
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	gint current = 0;
	CaliforniaCalendarTimeUnit _tmp2_ = 0;
	gint rounded = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	CaliforniaCalendarTimeUnit _tmp11_ = 0;
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 345 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = multiple;
#line 345 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ <= 0) {
#line 1922 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 346 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 346 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 346 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1930 "calendar-wall-time.c"
	}
#line 350 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = time_unit;
#line 350 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp2_) {
#line 350 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 1938 "calendar-wall-time.c"
		{
			gint _tmp3_ = 0;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp3_ = self->priv->_hour;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp3_;
#line 353 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1947 "calendar-wall-time.c"
		}
#line 350 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 1951 "calendar-wall-time.c"
		{
			gint _tmp4_ = 0;
#line 356 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp4_ = self->priv->_minute;
#line 356 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp4_;
#line 357 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1960 "calendar-wall-time.c"
		}
#line 350 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 1964 "calendar-wall-time.c"
		{
			gint _tmp5_ = 0;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp5_ = self->priv->_second;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp5_;
#line 361 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1973 "calendar-wall-time.c"
		}
		default:
		{
#line 364 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 1979 "calendar-wall-time.c"
		}
	}
#line 368 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = current;
#line 368 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = current;
#line 368 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = multiple;
#line 368 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 368 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rounded = _tmp6_ - (_tmp7_ % _tmp9_);
#line 369 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = rounded;
#line 369 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp10_ < 0) {
#line 370 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		rounded = 0;
#line 1998 "calendar-wall-time.c"
	}
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = time_unit;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp11_) {
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 2006 "calendar-wall-time.c"
		{
			gint _tmp12_ = 0;
			CaliforniaCalendarWallTime* _tmp13_ = NULL;
#line 375 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp12_ = rounded;
#line 375 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp13_ = california_calendar_wall_time_new (_tmp12_, 0, 0);
#line 375 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp13_;
#line 375 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2018 "calendar-wall-time.c"
		}
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 2022 "calendar-wall-time.c"
		{
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			CaliforniaCalendarWallTime* _tmp16_ = NULL;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp14_ = self->priv->_hour;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp15_ = rounded;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp16_ = california_calendar_wall_time_new (_tmp14_, _tmp15_, 0);
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp16_;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2037 "calendar-wall-time.c"
		}
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 2041 "calendar-wall-time.c"
		{
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			CaliforniaCalendarWallTime* _tmp20_ = NULL;
#line 381 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = self->priv->_hour;
#line 381 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = self->priv->_minute;
#line 381 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = rounded;
#line 381 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp20_ = california_calendar_wall_time_new (_tmp17_, _tmp18_, _tmp19_);
#line 381 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp20_;
#line 381 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2059 "calendar-wall-time.c"
		}
		default:
		{
#line 384 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 2065 "calendar-wall-time.c"
		}
	}
}


/**
     * Returns a prettified, localized user-visible string.
     *
     * The string respects {@link System.is_24hr}.
     */
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags) {
	gchar* result = NULL;
	gboolean include_sec = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp0_ = 0;
	gboolean optional_min = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp1_ = 0;
	gboolean meridiem_post_only = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp2_ = 0;
	gboolean brief_meridiem = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp3_ = 0;
	gboolean is_24hr = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* pm = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* am = NULL;
	const gchar* meridiem = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp53_ = FALSE;
	const gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	const gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
#line 393 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = flags;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	include_sec = (_tmp0_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS) != 0;
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = flags;
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	optional_min = (_tmp1_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES) != 0;
#line 396 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = flags;
#line 396 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_post_only = (_tmp2_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY) != 0;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = flags;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	brief_meridiem = (_tmp3_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM) != 0;
#line 398 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_system_get_is_24hr ();
#line 398 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 398 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	is_24hr = _tmp5_;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = brief_meridiem;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp7_) {
#line 2139 "calendar-wall-time.c"
		const gchar* _tmp8_ = NULL;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp8_ = california_calendar_FMT_BRIEF_PM;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp8_;
#line 2145 "calendar-wall-time.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = california_calendar_FMT_PM;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp9_;
#line 2152 "calendar-wall-time.c"
	}
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = _tmp6_;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = brief_meridiem;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 2160 "calendar-wall-time.c"
		const gchar* _tmp12_ = NULL;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_FMT_BRIEF_AM;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 2166 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = california_calendar_FMT_AM;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp13_;
#line 2173 "calendar-wall-time.c"
	}
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	am = _tmp10_;
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = is_24hr;
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp14_) {
#line 405 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		meridiem = "";
#line 2183 "calendar-wall-time.c"
	} else {
		gboolean _tmp15_ = FALSE;
#line 406 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = meridiem_post_only;
#line 406 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp15_) {
#line 2190 "calendar-wall-time.c"
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = california_calendar_wall_time_get_is_pm (self);
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = _tmp17_;
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp18_) {
#line 2200 "calendar-wall-time.c"
				const gchar* _tmp19_ = NULL;
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp19_ = pm;
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = _tmp19_;
#line 2206 "calendar-wall-time.c"
			} else {
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = "";
#line 2210 "calendar-wall-time.c"
			}
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp16_;
#line 2214 "calendar-wall-time.c"
		} else {
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = california_calendar_wall_time_get_is_pm (self);
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp22_ = _tmp21_;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp22_) {
#line 2225 "calendar-wall-time.c"
				const gchar* _tmp23_ = NULL;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp23_ = pm;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp23_;
#line 2231 "calendar-wall-time.c"
			} else {
				const gchar* _tmp24_ = NULL;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp24_ = am;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp24_;
#line 2238 "calendar-wall-time.c"
			}
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp20_;
#line 2242 "calendar-wall-time.c"
		}
	}
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp27_ = optional_min;
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp27_) {
#line 2249 "calendar-wall-time.c"
		gint _tmp28_ = 0;
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp28_ = self->priv->_minute;
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = _tmp28_ == 0;
#line 2255 "calendar-wall-time.c"
	} else {
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = FALSE;
#line 2259 "calendar-wall-time.c"
	}
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp26_) {
#line 2263 "calendar-wall-time.c"
		gboolean _tmp29_ = FALSE;
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp29_ = is_24hr;
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = !_tmp29_;
#line 2269 "calendar-wall-time.c"
	} else {
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = FALSE;
#line 2273 "calendar-wall-time.c"
	}
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp25_) {
#line 2277 "calendar-wall-time.c"
		gint _tmp30_ = 0;
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = is_24hr;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp31_) {
#line 2286 "calendar-wall-time.c"
			gint _tmp32_ = 0;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp32_ = self->priv->_hour;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp30_ = _tmp32_;
#line 2292 "calendar-wall-time.c"
		} else {
			gint _tmp33_ = 0;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp33_ = self->priv->_12hour;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp30_ = _tmp33_;
#line 2299 "calendar-wall-time.c"
		}
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp34_ = meridiem;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = g_strdup_printf ("%d%s", _tmp30_, _tmp34_);
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp35_;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2309 "calendar-wall-time.c"
	}
#line 418 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp36_ = include_sec;
#line 418 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp36_) {
#line 2315 "calendar-wall-time.c"
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp37_ = is_24hr;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp37_) {
#line 2329 "calendar-wall-time.c"
			const gchar* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp38_ = california_calendar_FMT_24HOUR_MIN;
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp39_ = self->priv->_hour;
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp40_ = self->priv->_minute;
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = g_strdup_printf (_tmp38_, _tmp39_, _tmp40_);
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = _tmp41_;
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp43_ = california_string_reduce_whitespace (_tmp42_);
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp44_ = _tmp43_;
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp42_);
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp44_;
#line 421 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2357 "calendar-wall-time.c"
		}
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp45_ = california_calendar_FMT_12HOUR_MIN_MERIDIEM;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp46_ = self->priv->_12hour;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp47_ = self->priv->_minute;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp48_ = meridiem;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp49_ = g_strdup_printf (_tmp45_, _tmp46_, _tmp47_, _tmp48_);
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp50_ = _tmp49_;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp51_ = california_string_reduce_whitespace (_tmp50_);
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp52_ = _tmp51_;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp50_);
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp52_;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2381 "calendar-wall-time.c"
	}
#line 427 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp53_ = is_24hr;
#line 427 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp53_) {
#line 2387 "calendar-wall-time.c"
		const gchar* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp54_ = california_calendar_FMT_24HOUR_MIN_SEC;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp55_ = self->priv->_hour;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp56_ = self->priv->_minute;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp57_ = self->priv->_second;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp58_ = g_strdup_printf (_tmp54_, _tmp55_, _tmp56_, _tmp57_);
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp59_ = _tmp58_;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp60_ = california_string_reduce_whitespace (_tmp59_);
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp61_ = _tmp60_;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp59_);
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp61_;
#line 428 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2418 "calendar-wall-time.c"
	}
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp62_ = california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp63_ = self->priv->_12hour;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp64_ = self->priv->_minute;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp65_ = self->priv->_second;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp66_ = meridiem;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp67_ = g_strdup_printf (_tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_);
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp68_ = _tmp67_;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp69_ = california_string_reduce_whitespace (_tmp68_);
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp70_ = _tmp69_;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp68_);
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp70_;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2444 "calendar-wall-time.c"
}


static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gint result = 0;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint diff = 0;
	gint _tmp1_ = 0;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	CaliforniaCalendarWallTime* _tmp10_ = NULL;
	gint _tmp11_ = 0;
#line 433 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 433 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), 0);
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 434 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (self == _tmp0_) {
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = 0;
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2476 "calendar-wall-time.c"
	}
#line 437 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_hour;
#line 437 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = other;
#line 437 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_->priv->_hour;
#line 437 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp1_ - _tmp3_;
#line 438 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = diff;
#line 438 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ != 0) {
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2494 "calendar-wall-time.c"
	}
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = self->priv->_minute;
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = other;
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_->priv->_minute;
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp5_ - _tmp7_;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = diff;
#line 442 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ != 0) {
#line 443 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 443 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2512 "calendar-wall-time.c"
	}
#line 445 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = self->priv->_second;
#line 445 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = other;
#line 445 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = _tmp10_->priv->_second;
#line 445 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp9_ - _tmp11_;
#line 445 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2524 "calendar-wall-time.c"
}


static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gboolean result = FALSE;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 448 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 448 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), FALSE);
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp1_ == 0;
#line 449 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2545 "calendar-wall-time.c"
}


static guint california_calendar_wall_time_real_hash (GeeHashable* base) {
	CaliforniaCalendarWallTime * self;
	guint result = 0U;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 452 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 454 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 454 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_minute;
#line 454 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_second;
#line 454 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = ((((guint) _tmp0_) << 12) | (((guint) _tmp1_) << 6)) | ((guint) _tmp2_);
#line 454 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2567 "calendar-wall-time.c"
}


static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarWallTime * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 457 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 458 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_to_pretty_string (self, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS);
#line 458 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 458 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2583 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__earliest;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2596 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__earliest);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__earliest = _tmp1_;
#line 2611 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__latest;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2624 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__latest);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__latest = _tmp1_;
#line 2639 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2654 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_hour = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "hour");
#line 2668 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_12hour;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2683 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_12hour = _tmp0_;
#line 2695 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_minute;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2710 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_minute = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "minute");
#line 2724 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_second;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2739 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_second = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "second");
#line 2753 "calendar-wall-time.c"
}


gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), FALSE);
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_ >= 12;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2768 "calendar-wall-time.c"
}


static void california_calendar_wall_time_class_init (CaliforniaCalendarWallTimeClass * klass) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarWallTimePrivate));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_wall_time_real_to_string;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_wall_time_get_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_wall_time_set_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_wall_time_finalize;
#line 2785 "calendar-wall-time.c"
	/**
	     * Zero-based hour of the day in 24-hour (or "military") time.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_HOUR, g_param_spec_int ("hour", "hour", "hour", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2791 "calendar-wall-time.c"
	/**
	     * Zero-based minute of the {@link hour}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_MINUTE, g_param_spec_int ("minute", "minute", "minute", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2797 "calendar-wall-time.c"
	/**
	     * Zero-based second of the {@link minute}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_SECOND, g_param_spec_int ("second", "second", "second", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2803 "calendar-wall-time.c"
	/**
	     * Indicates if post-meridiem.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_IS_PM, g_param_spec_boolean ("is-pm", "is-pm", "is-pm", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2809 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_wall_time_real_compare_to;
#line 2818 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_wall_time_real_equal_to;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_wall_time_real_hash;
#line 2829 "calendar-wall-time.c"
}


static void california_calendar_wall_time_instance_init (CaliforniaCalendarWallTime * self) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv = CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE (self);
#line 2836 "calendar-wall-time.c"
}


static void california_calendar_wall_time_finalize (GObject* obj) {
	CaliforniaCalendarWallTime * self;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (california_calendar_wall_time_parent_class)->finalize (obj);
#line 2846 "calendar-wall-time.c"
}


/**
 * An immutable represenation of "wall clock time", that is, an hour, minute, and seconds with no
 * correspondence to a day of a year.
 */
GType california_calendar_wall_time_get_type (void) {
	static volatile gsize california_calendar_wall_time_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarWallTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_wall_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarWallTime), 0, (GInstanceInitFunc) california_calendar_wall_time_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_wall_time_type_id;
		california_calendar_wall_time_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarWallTime", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_wall_time_type_id__volatile, california_calendar_wall_time_type_id);
	}
	return california_calendar_wall_time_type_id__volatile;
}


static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_hour (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_minute (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_second (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_IS_PM:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_boolean (value, california_calendar_wall_time_get_is_pm (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2899 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2905 "calendar-wall-time.c"
	}
}


static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_hour (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_minute (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_second (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2933 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2939 "calendar-wall-time.c"
	}
}



