/* calendar-wall-time.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-wall-time.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;
typedef struct _CaliforniaCalendarWallTimePrivate CaliforniaCalendarWallTimePrivate;

#define CALIFORNIA_CALENDAR_WALL_TIME_TYPE_PRETTY_FLAG (california_calendar_wall_time_pretty_flag_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIME_UNIT (california_calendar_time_unit_get_type ())

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarWallTime {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarWallTimePrivate * priv;
};

struct _CaliforniaCalendarWallTimeClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaCalendarWallTimePrivate {
	gint _hour;
	gint _12hour;
	gint _minute;
	gint _second;
};

typedef enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS = 1 << 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES = 1 << 1,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY = 1 << 2,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM = 1 << 3
} CaliforniaCalendarWallTimePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_TIME_UNIT_SECOND,
	CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE,
	CALIFORNIA_CALENDAR_TIME_UNIT_HOUR
} CaliforniaCalendarTimeUnit;


static gpointer california_calendar_wall_time_parent_class = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest = NULL;
extern const gchar* california_calendar_MIDNIGHT;
extern const gchar* california_calendar_NOON;
extern const gchar* california_calendar_FMT_AM;
extern const gchar* california_calendar_FMT_BRIEF_AM;
extern const gchar* california_calendar_FMT_PM;
extern const gchar* california_calendar_FMT_BRIEF_PM;
extern const gchar* california_calendar_FMT_24HOUR_MIN;
extern const gchar* california_calendar_FMT_12HOUR_MIN_MERIDIEM;
extern const gchar* california_calendar_FMT_24HOUR_MIN_SEC;
extern const gchar* california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
static GeeComparableIface* california_calendar_wall_time_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_wall_time_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimePrivate))
enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_WALL_TIME_HOUR,
	CALIFORNIA_CALENDAR_WALL_TIME_MINUTE,
	CALIFORNIA_CALENDAR_WALL_TIME_SECOND,
	CALIFORNIA_CALENDAR_WALL_TIME_IS_PM
};
GType california_calendar_wall_time_pretty_flag_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY 24
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR (CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE (CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND (CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - 1)
CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second);
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_new_from_exact_time (CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarWallTime* california_calendar_wall_time_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time);
gint california_calendar_exact_time_get_hour (CaliforniaCalendarExactTime* self);
gint california_calendar_exact_time_get_minute (CaliforniaCalendarExactTime* self);
gint california_calendar_exact_time_get_second (CaliforniaCalendarExactTime* self);
void california_calendar_wall_time_init (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void);
static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void);
static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value);
void california_calendar_wall_time_terminate (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed);
gboolean california_string_is_empty (const gchar* str);
gboolean california_string_is_numeric (const gchar* str);
GType california_calendar_time_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover);
gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self);
static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover);
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags);
gboolean california_calendar_system_get_is_24hr (void);
gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self);
gchar* california_string_reduce_whitespace (const gchar* str);
static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other);
static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other);
static guint california_calendar_wall_time_real_hash (GeeHashable* base);
static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base);
static void california_calendar_wall_time_finalize (GObject* obj);
static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Options for {@link to_pretty_string}.
     */
GType california_calendar_wall_time_pretty_flag_get_type (void) {
	static volatile gsize california_calendar_wall_time_pretty_flag_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_pretty_flag_type_id__volatile)) {
		static const GFlagsValue values[] = {{CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE", "none"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS", "include-seconds"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES", "optional-minutes"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY", "meridiem-post-only"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM", "brief-meridiem"}, {0, NULL, NULL}};
		GType california_calendar_wall_time_pretty_flag_type_id;
		california_calendar_wall_time_pretty_flag_type_id = g_flags_register_static ("CaliforniaCalendarWallTimePrettyFlag", values);
		g_once_init_leave (&california_calendar_wall_time_pretty_flag_type_id__volatile, california_calendar_wall_time_pretty_flag_type_id);
	}
	return california_calendar_wall_time_pretty_flag_type_id__volatile;
}


/**
     * Generate a new {@link WallTime} object with the specified values.
     *
     * Note that hour must be in 24-hour time.
     *
     * Values will be clamped to create a valid time.
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second) {
	CaliforniaCalendarWallTime * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = (CaliforniaCalendarWallTime*) california_base_object_construct (object_type);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = hour;
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = CLAMP (_tmp0_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_hour (self, _tmp1_);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = minute;
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = CLAMP (_tmp2_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_minute (self, _tmp3_);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = second;
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = CLAMP (_tmp4_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_second (self, _tmp5_);
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = hour;
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_ == 0) {
#line 105 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_12hour (self, 12);
#line 238 "calendar-wall-time.c"
	} else {
		gint _tmp7_ = 0;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp7_ = hour;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp7_ > 12) {
#line 245 "calendar-wall-time.c"
			gint _tmp8_ = 0;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = hour;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp8_ - 12);
#line 251 "calendar-wall-time.c"
		} else {
			gint _tmp9_ = 0;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp9_ = hour;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp9_);
#line 258 "calendar-wall-time.c"
		}
	}
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self;
#line 263 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second) {
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return california_calendar_wall_time_construct (CALIFORNIA_CALENDAR_TYPE_WALL_TIME, hour, minute, second);
#line 270 "calendar-wall-time.c"
}


/**
     * Generate a new {@link WallTime} with the {@link ExactTIme}'s values.
     *
     * Because date and timezone information is lost in this conversion, the caller should convert
     * the ExactTime to the desired timezone before constructing the WallTime.
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time) {
	CaliforniaCalendarWallTime * self = NULL;
	CaliforniaCalendarExactTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	CaliforniaCalendarExactTime* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	CaliforniaCalendarExactTime* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 118 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME (exact_time), NULL);
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = exact_time;
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = california_calendar_exact_time_get_hour (_tmp0_);
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = _tmp1_;
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = exact_time;
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_exact_time_get_minute (_tmp3_);
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = exact_time;
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = california_calendar_exact_time_get_second (_tmp6_);
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = _tmp7_;
#line 119 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = (CaliforniaCalendarWallTime*) california_calendar_wall_time_construct (object_type, _tmp2_, _tmp5_, _tmp8_);
#line 118 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self;
#line 315 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_new_from_exact_time (CaliforniaCalendarExactTime* exact_time) {
#line 118 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return california_calendar_wall_time_construct_from_exact_time (CALIFORNIA_CALENDAR_TYPE_WALL_TIME, exact_time);
#line 322 "calendar-wall-time.c"
}


/**
     * Called from Calendar.init().
     */
void california_calendar_wall_time_init (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	CaliforniaCalendarWallTime* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarWallTime* _tmp7_ = NULL;
#line 126 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 126 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 126 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND);
#line 126 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 126 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (_tmp3_);
#line 126 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp3_);
#line 127 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_wall_time_get_latest ();
#line 127 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 127 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 127 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_;
#line 127 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (_tmp7_);
#line 127 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp7_);
#line 362 "calendar-wall-time.c"
}


/**
     * Called from Calendar.terminate().
     */
void california_calendar_wall_time_terminate (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
#line 134 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 134 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 134 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (NULL);
#line 135 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_get_latest ();
#line 135 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 135 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (NULL);
#line 386 "calendar-wall-time.c"
}


/**
     * Attempt to convert a string into {@link WallTime}.
     *
     * 24-hour and 12-hour time is recognized, as are localized versions of AM and PM.  If the time
     * was "liberally" parsed (in other words, "8" is converted to 8am), the returned flag is
     * cleared.
     */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 416 "calendar-wall-time.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1226 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1227 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1227 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1227 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1228 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1228 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 449 "calendar-wall-time.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1229 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1229 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1229 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 458 "calendar-wall-time.c"
	}
#line 1231 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1231 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 464 "calendar-wall-time.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1232 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1232 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1232 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 473 "calendar-wall-time.c"
	}
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 479 "calendar-wall-time.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 488 "calendar-wall-time.c"
	} else {
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 492 "calendar-wall-time.c"
	}
#line 1234 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 500 "calendar-wall-time.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 509 "calendar-wall-time.c"
	} else {
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 513 "calendar-wall-time.c"
	}
#line 1235 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1236 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1236 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1236 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1237 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 535 "calendar-wall-time.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1278 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 548 "calendar-wall-time.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 579 "calendar-wall-time.c"
				goto __catch26_g_regex_error;
			}
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1280 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 588 "calendar-wall-time.c"
		}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 604 "calendar-wall-time.c"
				goto __catch26_g_regex_error;
			}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
			return NULL;
#line 615 "calendar-wall-time.c"
		}
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1281 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return result;
#line 629 "calendar-wall-time.c"
	}
	goto __finally26;
	__catch26_g_regex_error:
	{
		GError* e = NULL;
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1283 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 643 "calendar-wall-time.c"
	}
	__finally26:
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1279 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
		return NULL;
#line 654 "calendar-wall-time.c"
	}
}


CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed) {
	gboolean _vala_strictly_parsed = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gchar* token = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean pm = FALSE;
	gboolean meridiem_unknown = FALSE;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gint length = 0;
	const gchar* _tmp85_ = NULL;
	gint _tmp86_ = 0;
	gint _tmp87_ = 0;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp89_ = FALSE;
	const gchar* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp94_ = FALSE;
	gint _tmp95_ = 0;
	gint h = 0;
	const gchar* _tmp121_ = NULL;
	gint _tmp122_ = 0;
	gboolean _tmp123_ = FALSE;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp127_ = FALSE;
	gint _tmp128_ = 0;
	CaliforniaCalendarWallTime* _tmp129_ = NULL;
#line 145 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = FALSE;
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = str;
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = string_strip (_tmp0_);
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = _tmp1_;
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) (-1));
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = _tmp3_;
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp2_);
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp4_;
#line 149 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = token;
#line 149 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_string_is_empty (_tmp5_);
#line 149 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_) {
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 735 "calendar-wall-time.c"
		}
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 739 "calendar-wall-time.c"
	}
#line 153 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = token;
#line 153 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = california_calendar_MIDNIGHT;
#line 153 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) (-1));
#line 153 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = _tmp9_;
#line 153 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
#line 153 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp10_);
#line 153 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 755 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp12_ = NULL;
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_wall_time_new (0, 0, 0);
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp12_;
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 769 "calendar-wall-time.c"
		}
#line 156 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 773 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = token;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp14_ = california_calendar_NOON;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = g_utf8_casefold (_tmp14_, (gssize) (-1));
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = _tmp15_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp16_);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp17_) {
#line 794 "calendar-wall-time.c"
			CaliforniaCalendarWallTime* _tmp18_ = NULL;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_strictly_parsed = TRUE;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = california_calendar_wall_time_new (12, 0, 0);
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp18_;
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (strictly_parsed) {
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				*strictly_parsed = _vala_strictly_parsed;
#line 808 "calendar-wall-time.c"
			}
#line 160 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 812 "calendar-wall-time.c"
		}
	}
#line 164 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = FALSE;
#line 165 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_unknown = FALSE;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp19_ = token;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp20_ = california_calendar_FMT_AM;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) (-1));
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp22_ = _tmp21_;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp23_ = g_str_has_suffix (_tmp19_, _tmp22_);
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp24_ = _tmp23_;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp22_);
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp24_) {
#line 835 "calendar-wall-time.c"
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gchar* _tmp34_ = NULL;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = token;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = token;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp27_ = strlen (_tmp26_);
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp28_ = _tmp27_;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp29_ = california_calendar_FMT_AM;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp30_ = g_utf8_casefold (_tmp29_, (gssize) (-1));
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = _tmp30_;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp32_ = strlen (_tmp31_);
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp33_ = _tmp32_;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp34_ = string_slice (_tmp25_, (glong) 0, (glong) (_tmp28_ - _tmp33_));
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		token = _tmp34_;
#line 167 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp31_);
#line 872 "calendar-wall-time.c"
	} else {
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = token;
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp36_ = california_calendar_FMT_BRIEF_AM;
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp37_ = g_utf8_casefold (_tmp36_, (gssize) (-1));
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp38_ = _tmp37_;
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp39_ = g_str_has_suffix (_tmp35_, _tmp38_);
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp40_ = _tmp39_;
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp38_);
#line 168 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp40_) {
#line 896 "calendar-wall-time.c"
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			const gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gchar* _tmp50_ = NULL;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = token;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = token;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp43_ = strlen (_tmp42_);
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp44_ = _tmp43_;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp45_ = california_calendar_FMT_BRIEF_AM;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp46_ = g_utf8_casefold (_tmp45_, (gssize) (-1));
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp47_ = _tmp46_;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp48_ = strlen (_tmp47_);
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp49_ = _tmp48_;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp50_ = string_slice (_tmp41_, (glong) 0, (glong) (_tmp44_ - _tmp49_));
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			token = _tmp50_;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp47_);
#line 933 "calendar-wall-time.c"
		} else {
			const gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_ = FALSE;
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp51_ = token;
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp52_ = california_calendar_FMT_PM;
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp53_ = g_utf8_casefold (_tmp52_, (gssize) (-1));
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp54_ = _tmp53_;
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp55_ = g_str_has_suffix (_tmp51_, _tmp54_);
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp56_ = _tmp55_;
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp54_);
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp56_) {
#line 957 "calendar-wall-time.c"
				const gchar* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				const gchar* _tmp61_ = NULL;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				gchar* _tmp66_ = NULL;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp57_ = token;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp58_ = token;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp59_ = strlen (_tmp58_);
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp60_ = _tmp59_;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp61_ = california_calendar_FMT_PM;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp62_ = g_utf8_casefold (_tmp61_, (gssize) (-1));
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp63_ = _tmp62_;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp64_ = strlen (_tmp63_);
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp65_ = _tmp64_;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp66_ = string_slice (_tmp57_, (glong) 0, (glong) (_tmp60_ - _tmp65_));
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (token);
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				token = _tmp66_;
#line 171 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (_tmp63_);
#line 172 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				pm = TRUE;
#line 996 "calendar-wall-time.c"
			} else {
				const gchar* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_ = NULL;
				gboolean _tmp71_ = FALSE;
				gboolean _tmp72_ = FALSE;
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp67_ = token;
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp68_ = california_calendar_FMT_BRIEF_PM;
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp69_ = g_utf8_casefold (_tmp68_, (gssize) (-1));
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp70_ = _tmp69_;
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp71_ = g_str_has_suffix (_tmp67_, _tmp70_);
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp72_ = _tmp71_;
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_free0 (_tmp70_);
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				if (_tmp72_) {
#line 1020 "calendar-wall-time.c"
					const gchar* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					gint _tmp75_ = 0;
					gint _tmp76_ = 0;
					const gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
					gchar* _tmp79_ = NULL;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gchar* _tmp82_ = NULL;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp73_ = token;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp74_ = token;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp75_ = strlen (_tmp74_);
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp76_ = _tmp75_;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp77_ = california_calendar_FMT_BRIEF_PM;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp78_ = g_utf8_casefold (_tmp77_, (gssize) (-1));
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp79_ = _tmp78_;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp80_ = strlen (_tmp79_);
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp81_ = _tmp80_;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_tmp82_ = string_slice (_tmp73_, (glong) 0, (glong) (_tmp76_ - _tmp81_));
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_g_free0 (token);
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					token = _tmp82_;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					_g_free0 (_tmp79_);
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					pm = TRUE;
#line 1059 "calendar-wall-time.c"
				} else {
#line 177 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
					meridiem_unknown = TRUE;
#line 1063 "calendar-wall-time.c"
				}
			}
		}
	}
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp83_ = token;
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp84_ = string_replace (_tmp83_, ":", "");
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 181 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp84_;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp85_ = token;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp86_ = strlen (_tmp85_);
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp87_ = _tmp86_;
#line 182 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	length = _tmp87_;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp90_ = token;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp91_ = california_string_is_numeric (_tmp90_);
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp91_) {
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp89_ = TRUE;
#line 1092 "calendar-wall-time.c"
	} else {
		gint _tmp92_ = 0;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp92_ = length;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp89_ = _tmp92_ == 0;
#line 1099 "calendar-wall-time.c"
	}
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp89_) {
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp88_ = TRUE;
#line 1105 "calendar-wall-time.c"
	} else {
		gint _tmp93_ = 0;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp93_ = length;
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp88_ = _tmp93_ > 4;
#line 1112 "calendar-wall-time.c"
	}
#line 185 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp88_) {
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1124 "calendar-wall-time.c"
		}
#line 186 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1128 "calendar-wall-time.c"
	}
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp95_ = length;
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp95_ == 3) {
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp94_ = TRUE;
#line 1136 "calendar-wall-time.c"
	} else {
		gint _tmp96_ = 0;
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp96_ = length;
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp94_ = _tmp96_ == 4;
#line 1143 "calendar-wall-time.c"
	}
#line 189 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp94_) {
#line 1147 "calendar-wall-time.c"
		gint h = 0;
		gint m = 0;
		gint _tmp97_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_ = FALSE;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		CaliforniaCalendarWallTime* _tmp120_ = NULL;
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp97_ = length;
#line 191 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp97_ == 3) {
#line 1160 "calendar-wall-time.c"
			const gchar* _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
			gint _tmp101_ = 0;
			const gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gint _tmp105_ = 0;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp98_ = token;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp99_ = string_slice (_tmp98_, (glong) 0, (glong) 1);
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp100_ = _tmp99_;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp101_ = atoi (_tmp100_);
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp101_;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp100_);
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp102_ = token;
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp103_ = string_slice (_tmp102_, (glong) 1, (glong) 3);
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp104_ = _tmp103_;
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp105_ = atoi (_tmp104_);
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp105_;
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp104_);
#line 1193 "calendar-wall-time.c"
		} else {
			const gchar* _tmp106_ = NULL;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gint _tmp109_ = 0;
			const gchar* _tmp110_ = NULL;
			gchar* _tmp111_ = NULL;
			gchar* _tmp112_ = NULL;
			gint _tmp113_ = 0;
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp106_ = token;
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp107_ = string_slice (_tmp106_, (glong) 0, (glong) 2);
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp108_ = _tmp107_;
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp109_ = atoi (_tmp108_);
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp109_;
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp108_);
#line 196 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp110_ = token;
#line 196 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp111_ = string_slice (_tmp110_, (glong) 2, (glong) 4);
#line 196 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp112_ = _tmp111_;
#line 196 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp113_ = atoi (_tmp112_);
#line 196 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp113_;
#line 196 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp112_);
#line 1227 "calendar-wall-time.c"
		}
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp115_ = meridiem_unknown;
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (!_tmp115_) {
#line 1233 "calendar-wall-time.c"
			gboolean _tmp116_ = FALSE;
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp116_ = pm;
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp114_ = _tmp116_;
#line 1239 "calendar-wall-time.c"
		} else {
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp114_ = FALSE;
#line 1243 "calendar-wall-time.c"
		}
#line 199 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp114_) {
#line 1247 "calendar-wall-time.c"
			gint _tmp117_ = 0;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp117_ = h;
#line 200 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp117_ + 12;
#line 1253 "calendar-wall-time.c"
		}
#line 202 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp118_ = h;
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp119_ = m;
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp120_ = california_calendar_wall_time_new (_tmp118_, _tmp119_, 0);
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp120_;
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1271 "calendar-wall-time.c"
		}
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1275 "calendar-wall-time.c"
	}
#line 209 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp121_ = token;
#line 209 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp122_ = atoi (_tmp121_);
#line 209 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	h = _tmp122_;
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp124_ = meridiem_unknown;
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp124_) {
#line 1287 "calendar-wall-time.c"
		gboolean _tmp125_ = FALSE;
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp125_ = pm;
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp123_ = _tmp125_;
#line 1293 "calendar-wall-time.c"
	} else {
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp123_ = FALSE;
#line 1297 "calendar-wall-time.c"
	}
#line 210 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp123_) {
#line 1301 "calendar-wall-time.c"
		gint _tmp126_ = 0;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp126_ = h;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		h = _tmp126_ + 12;
#line 1307 "calendar-wall-time.c"
	}
#line 213 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp127_ = meridiem_unknown;
#line 213 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = !_tmp127_;
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp128_ = h;
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp129_ = california_calendar_wall_time_new (_tmp128_, 0, 0);
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp129_;
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (strictly_parsed) {
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*strictly_parsed = _vala_strictly_parsed;
#line 1325 "calendar-wall-time.c"
	}
#line 215 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1329 "calendar-wall-time.c"
}


/**
     * Returns {@link WallTime} adjusted before or after this one.
     *
     * To subtract time, use a negative value.
     *
     * Like a wall clock, this will rollover to the next or previous day if enough time is
     * specified.  When this occurs, it's indicated in the rollover bool as an out result.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 230 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self ? g_object_ref (self) : NULL;
#line 1344 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	gint new_hour = 0;
	gint _tmp2_ = 0;
	gint new_minute = 0;
	gint _tmp3_ = 0;
	gint new_second = 0;
	gint _tmp4_ = 0;
	CaliforniaCalendarTimeUnit _tmp5_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	CaliforniaCalendarWallTime* _tmp15_ = NULL;
#line 226 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 1369 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 228 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 230 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 230 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 230 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 230 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1381 "calendar-wall-time.c"
		}
#line 230 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1385 "calendar-wall-time.c"
	}
#line 233 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_hour;
#line 233 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_hour = _tmp2_;
#line 234 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = self->priv->_minute;
#line 234 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_minute = _tmp3_;
#line 235 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = self->priv->_second;
#line 235 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_second = _tmp4_;
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = unit;
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp5_) {
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 1405 "calendar-wall-time.c"
		{
			gint _tmp6_ = 0;
			gboolean _tmp7_ = FALSE;
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp6_ = value;
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, &new_hour, _tmp6_, &_tmp7_);
#line 239 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp7_;
#line 240 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1417 "calendar-wall-time.c"
		}
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 1421 "calendar-wall-time.c"
		{
			gint _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
#line 243 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = value;
#line 243 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, &new_hour, &new_minute, _tmp8_, &_tmp9_);
#line 243 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp9_;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1433 "calendar-wall-time.c"
		}
#line 237 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 1437 "calendar-wall-time.c"
		{
			gint _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
#line 247 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp10_ = value;
#line 247 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_second (self, &new_hour, &new_minute, &new_second, _tmp10_, &_tmp11_);
#line 247 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp11_;
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1449 "calendar-wall-time.c"
		}
		default:
		{
#line 251 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 1455 "calendar-wall-time.c"
		}
	}
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp12_ = new_hour;
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp13_ = new_minute;
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = new_second;
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = california_calendar_wall_time_new (_tmp12_, _tmp13_, _tmp14_);
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp15_;
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1472 "calendar-wall-time.c"
	}
#line 254 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1476 "calendar-wall-time.c"
}


static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint rem = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 258 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 258 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 259 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 261 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 261 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1502 "calendar-wall-time.c"
		}
#line 261 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1506 "calendar-wall-time.c"
	}
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 266 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp2_ % CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1518 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = rem;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1524 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = rem;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1531 "calendar-wall-time.c"
	}
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = *current_hour;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_hour = _tmp7_ + _tmp3_;
#line 270 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = *current_hour;
#line 270 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ < 0) {
#line 1541 "calendar-wall-time.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 271 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = *current_hour;
#line 271 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = abs (_tmp9_);
#line 271 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_hour = CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - _tmp10_;
#line 272 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = TRUE;
#line 1552 "calendar-wall-time.c"
	} else {
		gint _tmp11_ = 0;
#line 273 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp11_ = *current_hour;
#line 273 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp11_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 1559 "calendar-wall-time.c"
			gint _tmp12_ = 0;
#line 274 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp12_ = *current_hour;
#line 274 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_hour = _tmp12_ - CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 275 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = TRUE;
#line 1567 "calendar-wall-time.c"
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp13_ = value;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp14_ = abs (_tmp13_);
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp14_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 277 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = TRUE;
#line 1579 "calendar-wall-time.c"
			} else {
#line 279 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = FALSE;
#line 1583 "calendar-wall-time.c"
			}
		}
	}
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 257 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1591 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint hours = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 285 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 287 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 287 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1624 "calendar-wall-time.c"
		}
#line 287 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1628 "calendar-wall-time.c"
	}
#line 290 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 290 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 290 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	hours = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1640 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = hours;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1646 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = hours;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1653 "calendar-wall-time.c"
	}
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_hour (self, current_hour, _tmp3_, &_tmp7_);
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 293 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 293 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 293 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1669 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1675 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1682 "calendar-wall-time.c"
	}
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_minute;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_minute = _tmp14_ + _tmp10_;
#line 297 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_minute;
#line 297 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1692 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 298 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_minute;
#line 298 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 298 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_minute = CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - _tmp17_;
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_hour (self, current_hour, -1, &_tmp18_);
#line 300 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1715 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1722 "calendar-wall-time.c"
		}
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1726 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_minute;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR) {
#line 1733 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_minute;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_minute = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 305 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, current_hour, 1, &_tmp24_);
#line 305 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 1753 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 1760 "calendar-wall-time.c"
			}
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 1764 "calendar-wall-time.c"
		}
	}
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 283 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1771 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint minutes = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 312 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 312 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1804 "calendar-wall-time.c"
		}
#line 315 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1808 "calendar-wall-time.c"
	}
#line 318 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 318 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 318 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	minutes = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1820 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = minutes;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1826 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = minutes;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1833 "calendar-wall-time.c"
	}
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, _tmp3_, &_tmp7_);
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 322 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 322 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 322 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1849 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1855 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1862 "calendar-wall-time.c"
	}
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_second;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_second = _tmp14_ + _tmp10_;
#line 326 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_second;
#line 326 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1872 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_second;
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_second = CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - _tmp17_;
#line 329 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, -1, &_tmp18_);
#line 329 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1895 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1902 "calendar-wall-time.c"
		}
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1906 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_second;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE) {
#line 1913 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_second;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_second = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 334 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, 1, &_tmp24_);
#line 334 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 1933 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 1940 "calendar-wall-time.c"
			}
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 1944 "calendar-wall-time.c"
		}
	}
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 310 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1951 "calendar-wall-time.c"
	}
}


/**
     * Returns a prettified, localized user-visible string.
     *
     * The string respects {@link System.is_24hr}.
     */
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags) {
	gchar* result = NULL;
	gboolean include_sec = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp0_ = 0;
	gboolean optional_min = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp1_ = 0;
	gboolean meridiem_post_only = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp2_ = 0;
	gboolean brief_meridiem = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp3_ = 0;
	gboolean is_24hr = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* pm = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* am = NULL;
	const gchar* meridiem = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	const gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
#line 344 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 345 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = flags;
#line 345 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	include_sec = (_tmp0_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS) != 0;
#line 346 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = flags;
#line 346 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	optional_min = (_tmp1_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES) != 0;
#line 347 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = flags;
#line 347 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_post_only = (_tmp2_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY) != 0;
#line 348 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = flags;
#line 348 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	brief_meridiem = (_tmp3_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM) != 0;
#line 349 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_system_get_is_24hr ();
#line 349 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 349 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	is_24hr = _tmp5_;
#line 351 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = brief_meridiem;
#line 351 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp7_) {
#line 2023 "calendar-wall-time.c"
		const gchar* _tmp8_ = NULL;
#line 351 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp8_ = california_calendar_FMT_BRIEF_PM;
#line 351 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp8_;
#line 2029 "calendar-wall-time.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 351 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = california_calendar_FMT_PM;
#line 351 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp9_;
#line 2036 "calendar-wall-time.c"
	}
#line 351 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = _tmp6_;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = brief_meridiem;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 2044 "calendar-wall-time.c"
		const gchar* _tmp12_ = NULL;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_FMT_BRIEF_AM;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 2050 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = california_calendar_FMT_AM;
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp13_;
#line 2057 "calendar-wall-time.c"
	}
#line 352 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	am = _tmp10_;
#line 355 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = is_24hr;
#line 355 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp14_) {
#line 356 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		meridiem = "";
#line 2067 "calendar-wall-time.c"
	} else {
		gboolean _tmp15_ = FALSE;
#line 357 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = meridiem_post_only;
#line 357 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp15_) {
#line 2074 "calendar-wall-time.c"
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
#line 358 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = california_calendar_wall_time_get_is_pm (self);
#line 358 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = _tmp17_;
#line 358 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp18_) {
#line 2084 "calendar-wall-time.c"
				const gchar* _tmp19_ = NULL;
#line 358 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp19_ = pm;
#line 358 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = _tmp19_;
#line 2090 "calendar-wall-time.c"
			} else {
#line 358 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = "";
#line 2094 "calendar-wall-time.c"
			}
#line 358 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp16_;
#line 2098 "calendar-wall-time.c"
		} else {
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = california_calendar_wall_time_get_is_pm (self);
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp22_ = _tmp21_;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp22_) {
#line 2109 "calendar-wall-time.c"
				const gchar* _tmp23_ = NULL;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp23_ = pm;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp23_;
#line 2115 "calendar-wall-time.c"
			} else {
				const gchar* _tmp24_ = NULL;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp24_ = am;
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp24_;
#line 2122 "calendar-wall-time.c"
			}
#line 360 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp20_;
#line 2126 "calendar-wall-time.c"
		}
	}
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp26_ = optional_min;
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp26_) {
#line 2133 "calendar-wall-time.c"
		gint _tmp27_ = 0;
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp27_ = self->priv->_minute;
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = _tmp27_ == 0;
#line 2139 "calendar-wall-time.c"
	} else {
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = FALSE;
#line 2143 "calendar-wall-time.c"
	}
#line 365 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp25_) {
#line 2147 "calendar-wall-time.c"
		gint _tmp28_ = 0;
		gboolean _tmp29_ = FALSE;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp29_ = is_24hr;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp29_) {
#line 2156 "calendar-wall-time.c"
			gint _tmp30_ = 0;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp30_ = self->priv->_hour;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp28_ = _tmp30_;
#line 2162 "calendar-wall-time.c"
		} else {
			gint _tmp31_ = 0;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp31_ = self->priv->_12hour;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp28_ = _tmp31_;
#line 2169 "calendar-wall-time.c"
		}
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp32_ = meridiem;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp33_ = g_strdup_printf ("%d%s", _tmp28_, _tmp32_);
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp33_;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2179 "calendar-wall-time.c"
	}
#line 368 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp34_ = include_sec;
#line 368 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp34_) {
#line 2185 "calendar-wall-time.c"
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		const gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
#line 370 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = is_24hr;
#line 370 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp35_) {
#line 2199 "calendar-wall-time.c"
			const gchar* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp36_ = california_calendar_FMT_24HOUR_MIN;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp37_ = self->priv->_hour;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp38_ = self->priv->_minute;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp39_ = g_strdup_printf (_tmp36_, _tmp37_, _tmp38_);
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp40_ = _tmp39_;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = california_string_reduce_whitespace (_tmp40_);
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = _tmp41_;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp40_);
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp42_;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2227 "calendar-wall-time.c"
		}
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp43_ = california_calendar_FMT_12HOUR_MIN_MERIDIEM;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp44_ = self->priv->_12hour;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp45_ = self->priv->_minute;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp46_ = meridiem;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp47_ = g_strdup_printf (_tmp43_, _tmp44_, _tmp45_, _tmp46_);
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp48_ = _tmp47_;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp49_ = california_string_reduce_whitespace (_tmp48_);
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp50_ = _tmp49_;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp48_);
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp50_;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2251 "calendar-wall-time.c"
	}
#line 377 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp51_ = is_24hr;
#line 377 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp51_) {
#line 2257 "calendar-wall-time.c"
		const gchar* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp52_ = california_calendar_FMT_24HOUR_MIN_SEC;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp53_ = self->priv->_hour;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp54_ = self->priv->_minute;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp55_ = self->priv->_second;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp56_ = g_strdup_printf (_tmp52_, _tmp53_, _tmp54_, _tmp55_);
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp57_ = _tmp56_;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp58_ = california_string_reduce_whitespace (_tmp57_);
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp59_ = _tmp58_;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp57_);
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp59_;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2288 "calendar-wall-time.c"
	}
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp60_ = california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp61_ = self->priv->_12hour;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp62_ = self->priv->_minute;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp63_ = self->priv->_second;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp64_ = meridiem;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp65_ = g_strdup_printf (_tmp60_, _tmp61_, _tmp62_, _tmp63_, _tmp64_);
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp66_ = _tmp65_;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp67_ = california_string_reduce_whitespace (_tmp66_);
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp68_ = _tmp67_;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp66_);
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp68_;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2314 "calendar-wall-time.c"
}


static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gint result = 0;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint diff = 0;
	gint _tmp1_ = 0;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	CaliforniaCalendarWallTime* _tmp10_ = NULL;
	gint _tmp11_ = 0;
#line 383 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 383 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), 0);
#line 384 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 384 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (self == _tmp0_) {
#line 385 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = 0;
#line 385 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2346 "calendar-wall-time.c"
	}
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_hour;
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = other;
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_->priv->_hour;
#line 387 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp1_ - _tmp3_;
#line 388 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = diff;
#line 388 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ != 0) {
#line 389 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 389 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2364 "calendar-wall-time.c"
	}
#line 391 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = self->priv->_minute;
#line 391 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = other;
#line 391 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_->priv->_minute;
#line 391 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp5_ - _tmp7_;
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = diff;
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ != 0) {
#line 393 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 393 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2382 "calendar-wall-time.c"
	}
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = self->priv->_second;
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = other;
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = _tmp10_->priv->_second;
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp9_ - _tmp11_;
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2394 "calendar-wall-time.c"
}


static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gboolean result = FALSE;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 398 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 398 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), FALSE);
#line 399 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 399 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 399 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp1_ == 0;
#line 399 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2415 "calendar-wall-time.c"
}


static guint california_calendar_wall_time_real_hash (GeeHashable* base) {
	CaliforniaCalendarWallTime * self;
	guint result = 0U;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 402 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_minute;
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_second;
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = ((((guint) _tmp0_) << 12) | (((guint) _tmp1_) << 6)) | ((guint) _tmp2_);
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2437 "calendar-wall-time.c"
}


static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarWallTime * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 407 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 408 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_to_pretty_string (self, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS);
#line 408 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 408 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2453 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__earliest;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2466 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__earliest);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__earliest = _tmp1_;
#line 2481 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__latest;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2494 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__latest);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__latest = _tmp1_;
#line 2509 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2524 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_hour = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "hour");
#line 2538 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_12hour;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2553 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_12hour = _tmp0_;
#line 2565 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_minute;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2580 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_minute = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "minute");
#line 2594 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_second;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2609 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_second = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "second");
#line 2623 "calendar-wall-time.c"
}


gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), FALSE);
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_ >= 12;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2638 "calendar-wall-time.c"
}


static void california_calendar_wall_time_class_init (CaliforniaCalendarWallTimeClass * klass) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarWallTimePrivate));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_wall_time_real_to_string;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_wall_time_get_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_wall_time_set_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_wall_time_finalize;
#line 2655 "calendar-wall-time.c"
	/**
	     * Zero-based hour of the day in 24-hour (or "military") time.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_HOUR, g_param_spec_int ("hour", "hour", "hour", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2661 "calendar-wall-time.c"
	/**
	     * Zero-based minute of the {@link hour}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_MINUTE, g_param_spec_int ("minute", "minute", "minute", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2667 "calendar-wall-time.c"
	/**
	     * Zero-based second of the {@link minute}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_SECOND, g_param_spec_int ("second", "second", "second", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2673 "calendar-wall-time.c"
	/**
	     * Indicates if post-meridiem.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_IS_PM, g_param_spec_boolean ("is-pm", "is-pm", "is-pm", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2679 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_wall_time_real_compare_to;
#line 2688 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_wall_time_real_equal_to;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_wall_time_real_hash;
#line 2699 "calendar-wall-time.c"
}


static void california_calendar_wall_time_instance_init (CaliforniaCalendarWallTime * self) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv = CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE (self);
#line 2706 "calendar-wall-time.c"
}


static void california_calendar_wall_time_finalize (GObject* obj) {
	CaliforniaCalendarWallTime * self;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (california_calendar_wall_time_parent_class)->finalize (obj);
#line 2716 "calendar-wall-time.c"
}


/**
 * An immutable represenation of "wall clock time", that is, an hour, minute, and seconds with no
 * correspondence to a day of a year.
 */
GType california_calendar_wall_time_get_type (void) {
	static volatile gsize california_calendar_wall_time_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarWallTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_wall_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarWallTime), 0, (GInstanceInitFunc) california_calendar_wall_time_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_wall_time_type_id;
		california_calendar_wall_time_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarWallTime", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_wall_time_type_id__volatile, california_calendar_wall_time_type_id);
	}
	return california_calendar_wall_time_type_id__volatile;
}


static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_hour (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_minute (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_second (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_IS_PM:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_boolean (value, california_calendar_wall_time_get_is_pm (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2769 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2775 "calendar-wall-time.c"
	}
}


static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_hour (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_minute (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_second (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2803 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 2809 "calendar-wall-time.c"
	}
}



