/* calendar-duration.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-duration.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_DURATION (california_calendar_duration_get_type ())
#define CALIFORNIA_CALENDAR_DURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration))
#define CALIFORNIA_CALENDAR_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))
#define CALIFORNIA_CALENDAR_IS_DURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_IS_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_DURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))

typedef struct _CaliforniaCalendarDuration CaliforniaCalendarDuration;
typedef struct _CaliforniaCalendarDurationClass CaliforniaCalendarDurationClass;
typedef struct _CaliforniaCalendarDurationPrivate CaliforniaCalendarDurationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarDuration {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarDurationPrivate * priv;
};

struct _CaliforniaCalendarDurationClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaCalendarDurationPrivate {
	guint64 _seconds;
};


static gpointer california_calendar_duration_parent_class = NULL;
extern gchar** california_calendar_UNIT_DAYS;
extern gint california_calendar_UNIT_DAYS_length1;
extern gchar** california_calendar_UNIT_HOURS;
extern gint california_calendar_UNIT_HOURS_length1;
extern gchar** california_calendar_UNIT_MINS;
extern gint california_calendar_UNIT_MINS_length1;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_duration_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DURATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationPrivate))
enum  {
	CALIFORNIA_CALENDAR_DURATION_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_DURATION_DAYS,
	CALIFORNIA_CALENDAR_DURATION_HOURS,
	CALIFORNIA_CALENDAR_DURATION_MINUTES,
	CALIFORNIA_CALENDAR_DURATION_SECONDS
};
CaliforniaCalendarDuration* california_calendar_duration_new (guint days, guint hours, guint64 minutes, guint64 seconds);
CaliforniaCalendarDuration* california_calendar_duration_construct (GType object_type, guint days, guint hours, guint64 minutes, guint64 seconds);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
#define CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR 60
#define CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY 24
static void california_calendar_duration_set_seconds (CaliforniaCalendarDuration* self, guint64 value);
CaliforniaCalendarDuration* california_calendar_duration_parse (const gchar* value, const gchar* unit);
gboolean california_string_is_empty (const gchar* str);
gboolean california_string_is_numeric (const gchar* str);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static gchar* california_calendar_duration_real_to_string (CaliforniaBaseObject* base);
guint64 california_calendar_duration_get_seconds (CaliforniaCalendarDuration* self);
guint64 california_calendar_duration_get_days (CaliforniaCalendarDuration* self);
guint64 california_calendar_duration_get_hours (CaliforniaCalendarDuration* self);
guint64 california_calendar_duration_get_minutes (CaliforniaCalendarDuration* self);
static void california_calendar_duration_finalize (GObject* obj);
static void _vala_california_calendar_duration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_duration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


CaliforniaCalendarDuration* california_calendar_duration_construct (GType object_type, guint days, guint hours, guint64 minutes, guint64 seconds) {
	CaliforniaCalendarDuration * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint64 _tmp2_ = 0ULL;
	guint64 _tmp3_ = 0ULL;
#line 36 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	self = (CaliforniaCalendarDuration*) california_base_object_construct (object_type);
#line 38 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp0_ = days;
#line 38 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp1_ = hours;
#line 38 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp2_ = minutes;
#line 38 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp3_ = seconds;
#line 38 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	california_calendar_duration_set_seconds (self, (((((_tmp0_ * CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE) * CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR) * CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) + ((_tmp1_ * CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE) * CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR)) + (_tmp2_ * CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE)) + _tmp3_);
#line 36 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return self;
#line 123 "calendar-duration.c"
}


CaliforniaCalendarDuration* california_calendar_duration_new (guint days, guint hours, guint64 minutes, guint64 seconds) {
#line 36 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return california_calendar_duration_construct (CALIFORNIA_CALENDAR_TYPE_DURATION, days, hours, minutes, seconds);
#line 130 "calendar-duration.c"
}


/**
     * Parses the two tokens into a {@link Duration}.
     *
     * parse() is looking for a pattern where the first token is a number and the second a string
     * of units of time (localized), either hours, minutes, or seconds.  null is returned if that
     * pattern is not located.
     *
     * Future expansion could include a pattern where the first token has a unit as a suffix, i.e.
     * "3hrs" or "4m".
     *
     * It's possible for this call to return a Duration of zero time.
     */
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	for (i = 0; i < stack_length; i++) {
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
			return TRUE;
#line 154 "calendar-duration.c"
		}
	}
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return FALSE;
#line 159 "calendar-duration.c"
}


CaliforniaCalendarDuration* california_calendar_duration_parse (const gchar* value, const gchar* unit) {
	CaliforniaCalendarDuration* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint duration = 0;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
#line 57 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 57 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_return_val_if_fail (unit != NULL, NULL);
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp1_ = value;
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp2_ = california_string_is_empty (_tmp1_);
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	if (_tmp2_) {
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp0_ = TRUE;
#line 195 "calendar-duration.c"
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp3_ = unit;
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp4_ = california_string_is_empty (_tmp3_);
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp0_ = _tmp4_;
#line 205 "calendar-duration.c"
	}
#line 58 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	if (_tmp0_) {
#line 59 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		result = NULL;
#line 59 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		return result;
#line 213 "calendar-duration.c"
	}
#line 61 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp5_ = value;
#line 61 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp6_ = california_string_is_numeric (_tmp5_);
#line 61 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	if (!_tmp6_) {
#line 62 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		result = NULL;
#line 62 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		return result;
#line 225 "calendar-duration.c"
	}
#line 64 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp7_ = value;
#line 64 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp8_ = atoi (_tmp7_);
#line 64 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	duration = _tmp8_;
#line 65 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp9_ = duration;
#line 65 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	if (_tmp9_ < 0) {
#line 66 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		result = NULL;
#line 66 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		return result;
#line 241 "calendar-duration.c"
	}
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp10_ = unit;
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp11_ = california_calendar_UNIT_DAYS;
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp11__length1 = california_calendar_UNIT_DAYS_length1;
#line 68 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	if (_vala_string_array_contains (_tmp11_, _tmp11__length1, _tmp10_)) {
#line 251 "calendar-duration.c"
		gint _tmp12_ = 0;
		CaliforniaCalendarDuration* _tmp13_ = NULL;
#line 69 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp12_ = duration;
#line 69 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp13_ = california_calendar_duration_new ((guint) _tmp12_, (guint) 0, (guint64) 0, (guint64) 0);
#line 69 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		result = _tmp13_;
#line 69 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		return result;
#line 262 "calendar-duration.c"
	}
#line 71 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp14_ = unit;
#line 71 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp15_ = california_calendar_UNIT_HOURS;
#line 71 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp15__length1 = california_calendar_UNIT_HOURS_length1;
#line 71 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	if (_vala_string_array_contains (_tmp15_, _tmp15__length1, _tmp14_)) {
#line 272 "calendar-duration.c"
		gint _tmp16_ = 0;
		CaliforniaCalendarDuration* _tmp17_ = NULL;
#line 72 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp16_ = duration;
#line 72 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp17_ = california_calendar_duration_new ((guint) 0, (guint) _tmp16_, (guint64) 0, (guint64) 0);
#line 72 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		result = _tmp17_;
#line 72 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		return result;
#line 283 "calendar-duration.c"
	}
#line 74 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp18_ = unit;
#line 74 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp19_ = california_calendar_UNIT_MINS;
#line 74 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp19__length1 = california_calendar_UNIT_MINS_length1;
#line 74 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	if (_vala_string_array_contains (_tmp19_, _tmp19__length1, _tmp18_)) {
#line 293 "calendar-duration.c"
		gint _tmp20_ = 0;
		CaliforniaCalendarDuration* _tmp21_ = NULL;
#line 75 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp20_ = duration;
#line 75 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		_tmp21_ = california_calendar_duration_new ((guint) 0, (guint) 0, (guint64) _tmp20_, (guint64) 0);
#line 75 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		result = _tmp21_;
#line 75 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		return result;
#line 304 "calendar-duration.c"
	}
#line 77 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	result = NULL;
#line 77 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return result;
#line 310 "calendar-duration.c"
}


static gchar* california_calendar_duration_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarDuration * self;
	gchar* result = NULL;
	guint64 _tmp0_ = 0ULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 80 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration);
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp0_ = self->priv->_seconds;
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp1_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp0_);
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp2_ = _tmp1_;
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp3_ = g_strdup_printf ("%ss", _tmp2_);
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp4_ = _tmp3_;
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_g_free0 (_tmp2_);
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	result = _tmp4_;
#line 81 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return result;
#line 340 "calendar-duration.c"
}


guint64 california_calendar_duration_get_days (CaliforniaCalendarDuration* self) {
	guint64 result;
	guint64 _tmp0_ = 0ULL;
	guint64 _tmp1_ = 0ULL;
#line 19 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DURATION (self), 0ULL);
#line 19 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp0_ = california_calendar_duration_get_hours (self);
#line 19 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp1_ = _tmp0_;
#line 19 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	result = _tmp1_ / CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 19 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return result;
#line 358 "calendar-duration.c"
}


guint64 california_calendar_duration_get_hours (CaliforniaCalendarDuration* self) {
	guint64 result;
	guint64 _tmp0_ = 0ULL;
	guint64 _tmp1_ = 0ULL;
#line 24 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DURATION (self), 0ULL);
#line 24 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp0_ = california_calendar_duration_get_minutes (self);
#line 24 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp1_ = _tmp0_;
#line 24 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	result = _tmp1_ / CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 24 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return result;
#line 376 "calendar-duration.c"
}


guint64 california_calendar_duration_get_minutes (CaliforniaCalendarDuration* self) {
	guint64 result;
	guint64 _tmp0_ = 0ULL;
#line 29 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DURATION (self), 0ULL);
#line 29 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp0_ = self->priv->_seconds;
#line 29 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	result = _tmp0_ / CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 29 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return result;
#line 391 "calendar-duration.c"
}


guint64 california_calendar_duration_get_seconds (CaliforniaCalendarDuration* self) {
	guint64 result;
	guint64 _tmp0_ = 0ULL;
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DURATION (self), 0ULL);
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp0_ = self->priv->_seconds;
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	result = _tmp0_;
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	return result;
#line 406 "calendar-duration.c"
}


static void california_calendar_duration_set_seconds (CaliforniaCalendarDuration* self, guint64 value) {
	guint64 _tmp0_ = 0ULL;
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DURATION (self));
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	_tmp0_ = value;
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	self->priv->_seconds = _tmp0_;
#line 34 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_object_notify ((GObject *) self, "seconds");
#line 420 "calendar-duration.c"
}


static void california_calendar_duration_class_init (CaliforniaCalendarDurationClass * klass) {
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	california_calendar_duration_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarDurationPrivate));
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_duration_real_to_string;
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_duration_get_property;
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_duration_set_property;
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_duration_finalize;
#line 437 "calendar-duration.c"
	/**
	     * Number of absolute days the duration spans.
	     */
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DURATION_DAYS, g_param_spec_uint64 ("days", "days", "days", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 443 "calendar-duration.c"
	/**
	     * Number of absolute hours the duration spans.
	     */
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DURATION_HOURS, g_param_spec_uint64 ("hours", "hours", "hours", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 449 "calendar-duration.c"
	/**
	     * Number of absolute minutes the duration spans.
	     */
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DURATION_MINUTES, g_param_spec_uint64 ("minutes", "minutes", "minutes", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 455 "calendar-duration.c"
	/**
	     * Number of absolute seconds the duration spans.
	     */
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DURATION_SECONDS, g_param_spec_uint64 ("seconds", "seconds", "seconds", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 461 "calendar-duration.c"
}


static void california_calendar_duration_instance_init (CaliforniaCalendarDuration * self) {
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	self->priv = CALIFORNIA_CALENDAR_DURATION_GET_PRIVATE (self);
#line 468 "calendar-duration.c"
}


static void california_calendar_duration_finalize (GObject* obj) {
	CaliforniaCalendarDuration * self;
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration);
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	G_OBJECT_CLASS (california_calendar_duration_parent_class)->finalize (obj);
#line 478 "calendar-duration.c"
}


/**
 * An immutable representation of duration, as in a positive span of time.
 *
 * See [[https://tools.ietf.org/html/rfc5545#section-3.8.2.5]]
 */
GType california_calendar_duration_get_type (void) {
	static volatile gsize california_calendar_duration_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_duration_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarDurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_duration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarDuration), 0, (GInstanceInitFunc) california_calendar_duration_instance_init, NULL };
		GType california_calendar_duration_type_id;
		california_calendar_duration_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarDuration", &g_define_type_info, 0);
		g_once_init_leave (&california_calendar_duration_type_id__volatile, california_calendar_duration_type_id);
	}
	return california_calendar_duration_type_id__volatile;
}


static void _vala_california_calendar_duration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDuration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration);
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		case CALIFORNIA_CALENDAR_DURATION_DAYS:
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		g_value_set_uint64 (value, california_calendar_duration_get_days (self));
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		break;
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		case CALIFORNIA_CALENDAR_DURATION_HOURS:
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		g_value_set_uint64 (value, california_calendar_duration_get_hours (self));
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		break;
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		case CALIFORNIA_CALENDAR_DURATION_MINUTES:
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		g_value_set_uint64 (value, california_calendar_duration_get_minutes (self));
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		break;
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		case CALIFORNIA_CALENDAR_DURATION_SECONDS:
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		g_value_set_uint64 (value, california_calendar_duration_get_seconds (self));
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		break;
#line 528 "calendar-duration.c"
		default:
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		break;
#line 534 "calendar-duration.c"
	}
}


static void _vala_california_calendar_duration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDuration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration);
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		case CALIFORNIA_CALENDAR_DURATION_SECONDS:
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		california_calendar_duration_set_seconds (self, g_value_get_uint64 (value));
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		break;
#line 550 "calendar-duration.c"
		default:
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/calendar/calendar-duration.vala"
		break;
#line 556 "calendar-duration.c"
	}
}



