/* calendar-date-span.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-date-span.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanIface))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanIface CaliforniaCalendarSpanIface;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;
typedef struct _CaliforniaCalendarDateSpanPrivate CaliforniaCalendarDateSpanPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN (california_calendar_exact_time_span_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpan))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))

typedef struct _CaliforniaCalendarExactTimeSpan CaliforniaCalendarExactTimeSpan;
typedef struct _CaliforniaCalendarExactTimeSpanClass CaliforniaCalendarExactTimeSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR (california_calendar_date_span_date_span_iterator_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN_DATE_SPAN_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, CaliforniaCalendarDateSpanDateSpanIterator))
#define CALIFORNIA_CALENDAR_DATE_SPAN_DATE_SPAN_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, CaliforniaCalendarDateSpanDateSpanIteratorClass))
#define CALIFORNIA_CALENDAR_DATE_SPAN_IS_DATE_SPAN_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR))
#define CALIFORNIA_CALENDAR_DATE_SPAN_IS_DATE_SPAN_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR))
#define CALIFORNIA_CALENDAR_DATE_SPAN_DATE_SPAN_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, CaliforniaCalendarDateSpanDateSpanIteratorClass))

typedef struct _CaliforniaCalendarDateSpanDateSpanIterator CaliforniaCalendarDateSpanDateSpanIterator;
typedef struct _CaliforniaCalendarDateSpanDateSpanIteratorClass CaliforniaCalendarDateSpanDateSpanIteratorClass;

#define CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK (california_calendar_first_of_week_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_WEEK_SPAN (california_calendar_week_span_get_type ())
#define CALIFORNIA_CALENDAR_WEEK_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK_SPAN, CaliforniaCalendarWeekSpan))
#define CALIFORNIA_CALENDAR_WEEK_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK_SPAN, CaliforniaCalendarWeekSpanClass))
#define CALIFORNIA_CALENDAR_IS_WEEK_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK_SPAN))
#define CALIFORNIA_CALENDAR_IS_WEEK_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK_SPAN))
#define CALIFORNIA_CALENDAR_WEEK_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK_SPAN, CaliforniaCalendarWeekSpanClass))

typedef struct _CaliforniaCalendarWeekSpan CaliforniaCalendarWeekSpan;
typedef struct _CaliforniaCalendarWeekSpanClass CaliforniaCalendarWeekSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define CALIFORNIA_CALENDAR_TYPE_DURATION (california_calendar_duration_get_type ())
#define CALIFORNIA_CALENDAR_DURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration))
#define CALIFORNIA_CALENDAR_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))
#define CALIFORNIA_CALENDAR_IS_DURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_IS_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_DURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))

typedef struct _CaliforniaCalendarDuration CaliforniaCalendarDuration;
typedef struct _CaliforniaCalendarDurationClass CaliforniaCalendarDurationClass;
typedef struct _CaliforniaCalendarDateSpanDateSpanIteratorPrivate CaliforniaCalendarDateSpanDateSpanIteratorPrivate;

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarSpanIface {
	GTypeInterface parent_iface;
	gpointer (*start) (CaliforniaCalendarSpan* self);
	gpointer (*end) (CaliforniaCalendarSpan* self);
	gboolean (*contains) (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date);
	gboolean (*has) (CaliforniaCalendarSpan* self, gconstpointer unit);
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCalendarDateSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarDateSpanPrivate * priv;
};

struct _CaliforniaCalendarDateSpanClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaCalendarDateSpanPrivate {
	CaliforniaCalendarDate* _start_date;
	CaliforniaCalendarDate* _end_date;
};

typedef enum  {
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY
} CaliforniaCalendarFirstOfWeek;

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;

struct _CaliforniaCalendarDateSpanDateSpanIterator {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarDateSpanDateSpanIteratorPrivate * priv;
	CaliforniaCalendarDate* first;
	CaliforniaCalendarDate* last;
	CaliforniaCalendarDate* current;
};

struct _CaliforniaCalendarDateSpanDateSpanIteratorClass {
	CaliforniaBaseObjectClass parent_class;
};


static gpointer california_calendar_date_span_parent_class = NULL;
static gpointer california_calendar_date_span_date_span_iterator_parent_class = NULL;
static CaliforniaCollectionSimpleIteratorIface* california_calendar_date_span_date_span_iterator_california_collection_simple_iterator_parent_iface = NULL;
static CaliforniaCollectionSimpleIterableIface* california_calendar_date_span_california_collection_simple_iterable_parent_iface = NULL;
static CaliforniaCalendarSpanIface* california_calendar_date_span_california_calendar_span_parent_iface = NULL;
static GeeComparableIface* california_calendar_date_span_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_date_span_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanPrivate))
enum  {
	CALIFORNIA_CALENDAR_DATE_SPAN_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_DATE_SPAN_START_DATE,
	CALIFORNIA_CALENDAR_DATE_SPAN_END_DATE,
	CALIFORNIA_CALENDAR_DATE_SPAN_IS_SAME_DAY,
	CALIFORNIA_CALENDAR_DATE_SPAN_DURATION
};
CaliforniaCalendarDateSpan* california_calendar_date_span_new (CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
void california_calendar_date_span_init_span (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
GType california_calendar_exact_time_span_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_start_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarDate* california_calendar_date_new_from_exact_time (CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarDate* california_calendar_date_construct_from_exact_time (GType object_type, CaliforniaCalendarExactTime* exact_time);
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_end_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarDateSpan* california_calendar_date_span_new_uninitialized (void);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_uninitialized (GType object_type);
static CaliforniaCalendarDate* california_calendar_date_span_real_start (CaliforniaCalendarSpan* base);
static CaliforniaCalendarDate* california_calendar_date_span_real_end (CaliforniaCalendarSpan* base);
static gboolean california_calendar_date_span_real_contains (CaliforniaCalendarSpan* base, CaliforniaCalendarDate* date);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
static gboolean california_calendar_date_span_real_has (CaliforniaCalendarSpan* base, CaliforniaCalendarDate* date);
gboolean california_calendar_span_contains (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date);
static CaliforniaCollectionSimpleIterator* california_calendar_date_span_real_iterator (CaliforniaCollectionSimpleIterable* base);
static CaliforniaCalendarDateSpanDateSpanIterator* california_calendar_date_span_date_span_iterator_new (CaliforniaCalendarDateSpan* owner);
static CaliforniaCalendarDateSpanDateSpanIterator* california_calendar_date_span_date_span_iterator_construct (GType object_type, CaliforniaCalendarDateSpan* owner);
static GType california_calendar_date_span_date_span_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType california_calendar_first_of_week_get_type (void) G_GNUC_CONST;
GType california_calendar_week_span_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWeekSpan* california_calendar_date_span_weeks (CaliforniaCalendarDateSpan* self, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarWeekSpan* california_calendar_week_span_new (CaliforniaCalendarDateSpan* dates, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarWeekSpan* california_calendar_week_span_construct (GType object_type, CaliforniaCalendarDateSpan* dates, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_start_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_start_date);
gint california_calendar_date_difference (CaliforniaCalendarDate* self, CaliforniaCalendarDate* other);
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_adjust (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit);
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_end_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_end_date);
CaliforniaCalendarDateSpan* california_calendar_date_span_clamp (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDateSpan* span);
static gint california_calendar_date_span_real_compare_to (GeeComparable* base, CaliforniaCalendarDateSpan* other);
static gboolean california_calendar_date_span_real_equal_to (GeeHashable* base, CaliforniaCalendarDateSpan* other);
static guint california_calendar_date_span_real_hash (GeeHashable* base);
static gchar* california_calendar_date_span_real_to_string (CaliforniaBaseObject* base);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
gboolean california_calendar_date_span_get_is_same_day (CaliforniaCalendarDateSpan* self);
GType california_calendar_duration_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDuration* california_calendar_date_span_get_duration (CaliforniaCalendarDateSpan* self);
CaliforniaCalendarDuration* california_calendar_duration_new (guint days, guint hours, guint64 minutes, guint64 seconds);
CaliforniaCalendarDuration* california_calendar_duration_construct (GType object_type, guint days, guint hours, guint64 minutes, guint64 seconds);
enum  {
	CALIFORNIA_CALENDAR_DATE_SPAN_DATE_SPAN_ITERATOR_DUMMY_PROPERTY
};
static CaliforniaCalendarDate* california_calendar_date_span_date_span_iterator_real_get (CaliforniaCollectionSimpleIterator* base);
static gboolean california_calendar_date_span_date_span_iterator_real_next (CaliforniaCollectionSimpleIterator* base);
static gchar* california_calendar_date_span_date_span_iterator_real_to_string (CaliforniaBaseObject* base);
static void california_calendar_date_span_date_span_iterator_finalize (GObject* obj);
static void california_calendar_date_span_finalize (GObject* obj);
static void _vala_california_calendar_date_span_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
     * Create a {@link DateSpan} with the specified start and end dates.
     *
     * DateSpan will arrange the two dates so start_date is chronologically earlier (or the same
     * as) the end_date.
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date) {
	CaliforniaCalendarDateSpan * self = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 76 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (start_date), NULL);
#line 76 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (end_date), NULL);
#line 76 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = (CaliforniaCalendarDateSpan*) california_base_object_construct (object_type);
#line 77 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = start_date;
#line 77 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = end_date;
#line 77 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_init_span (self, _tmp0_, _tmp1_);
#line 76 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self;
#line 304 "calendar-date-span.c"
}


CaliforniaCalendarDateSpan* california_calendar_date_span_new (CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date) {
#line 76 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return california_calendar_date_span_construct (CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, start_date, end_date);
#line 311 "calendar-date-span.c"
}


/**
     * Create a {@link DateSpan} from the {@link ExactTimeSpan}.
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span) {
	CaliforniaCalendarDateSpan * self = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTime* _tmp1_ = NULL;
	CaliforniaCalendarExactTime* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp5_ = NULL;
	CaliforniaCalendarExactTime* _tmp6_ = NULL;
	CaliforniaCalendarExactTime* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDate* _tmp9_ = NULL;
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN (exact_time_span), NULL);
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = (CaliforniaCalendarDateSpan*) california_base_object_construct (object_type);
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = exact_time_span;
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_exact_time_span_get_start_exact_time (_tmp0_);
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = california_calendar_date_new_from_exact_time (_tmp2_);
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = _tmp3_;
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = exact_time_span;
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = california_calendar_exact_time_span_get_end_exact_time (_tmp5_);
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = california_calendar_date_new_from_exact_time (_tmp7_);
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = _tmp8_;
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_init_span (self, _tmp4_, _tmp9_);
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp9_);
#line 84 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp4_);
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self;
#line 362 "calendar-date-span.c"
}


CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span) {
#line 83 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return california_calendar_date_span_construct_from_exact_time_span (CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, exact_time_span);
#line 369 "calendar-date-span.c"
}


/**
     * Create an unintialized {@link DateSpan).
     *
     * Because it's sometimes inconvenient to generate the necessary {@link Date}s until the
     * subclass's constructor completes, DateSpan allows for itself to be created empty assuming
     * that the subclass will call {@link init_span} as soon as it's finished initializing.
     *
     * init_span() must be called.  DateSpan will not function properly when uninitialized.
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_uninitialized (GType object_type) {
	CaliforniaCalendarDateSpan * self = NULL;
#line 97 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = (CaliforniaCalendarDateSpan*) california_base_object_construct (object_type);
#line 97 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self;
#line 388 "calendar-date-span.c"
}


CaliforniaCalendarDateSpan* california_calendar_date_span_new_uninitialized (void) {
#line 97 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return california_calendar_date_span_construct_uninitialized (CALIFORNIA_CALENDAR_TYPE_DATE_SPAN);
#line 395 "calendar-date-span.c"
}


/**
     * Initialize the {@link DateSpan} with s start and end date.
     *
     * DateSpan will sort the start and end to ensure that start is chronologically prior
     * to end.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 108 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self ? g_object_ref (self) : NULL;
#line 408 "calendar-date-span.c"
}


void california_calendar_date_span_init_span (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date) {
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 106 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self));
#line 106 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (start_date));
#line 106 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (end_date));
#line 107 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = start_date;
#line 107 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = end_date;
#line 107 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp1_);
#line 107 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	if (_tmp2_ <= 0) {
#line 430 "calendar-date-span.c"
		CaliforniaCalendarDate* _tmp3_ = NULL;
		CaliforniaCalendarDate* _tmp4_ = NULL;
		CaliforniaCalendarDate* _tmp5_ = NULL;
		CaliforniaCalendarDate* _tmp6_ = NULL;
#line 108 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp3_ = start_date;
#line 108 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 108 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (self->priv->_start_date);
#line 108 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		self->priv->_start_date = _tmp4_;
#line 109 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp5_ = end_date;
#line 109 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 109 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (self->priv->_end_date);
#line 109 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		self->priv->_end_date = _tmp6_;
#line 451 "calendar-date-span.c"
	} else {
		CaliforniaCalendarDate* _tmp7_ = NULL;
		CaliforniaCalendarDate* _tmp8_ = NULL;
		CaliforniaCalendarDate* _tmp9_ = NULL;
		CaliforniaCalendarDate* _tmp10_ = NULL;
#line 111 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp7_ = end_date;
#line 111 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 111 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (self->priv->_start_date);
#line 111 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		self->priv->_start_date = _tmp8_;
#line 112 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp9_ = start_date;
#line 112 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 112 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (self->priv->_end_date);
#line 112 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		self->priv->_end_date = _tmp10_;
#line 473 "calendar-date-span.c"
	}
}


/**
     * @inheritDoc
     */
static CaliforniaCalendarDate* california_calendar_date_span_real_start (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDateSpan * self;
	CaliforniaCalendarDate* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 119 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 120 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = self->priv->_start_date;
#line 120 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 120 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 120 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 496 "calendar-date-span.c"
}


/**
     * @inheritDoc
     */
static CaliforniaCalendarDate* california_calendar_date_span_real_end (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDateSpan * self;
	CaliforniaCalendarDate* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 126 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 127 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = self->priv->_end_date;
#line 127 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 127 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 127 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 518 "calendar-date-span.c"
}


/**
     * @inheritDoc
     */
static gboolean california_calendar_date_span_real_contains (CaliforniaCalendarSpan* base, CaliforniaCalendarDate* date) {
	CaliforniaCalendarDateSpan * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
#line 133 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 133 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (date), FALSE);
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = _tmp2_;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = date;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp4_);
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = _tmp5_ <= 0;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp3_);
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	if (_tmp6_) {
#line 555 "calendar-date-span.c"
		CaliforniaCalendarDate* _tmp7_ = NULL;
		CaliforniaCalendarDate* _tmp8_ = NULL;
		CaliforniaCalendarDate* _tmp9_ = NULL;
		CaliforniaCalendarDate* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp7_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp8_ = _tmp7_;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp9_ = _tmp8_;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp10_ = date;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp11_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp10_);
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp0_ = _tmp11_ >= 0;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (_tmp9_);
#line 575 "calendar-date-span.c"
	} else {
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp0_ = FALSE;
#line 579 "calendar-date-span.c"
	}
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp0_;
#line 134 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 585 "calendar-date-span.c"
}


/**
     * @inheritDoc
     */
static gboolean california_calendar_date_span_real_has (CaliforniaCalendarSpan* base, CaliforniaCalendarDate* date) {
	CaliforniaCalendarDateSpan * self;
	gboolean result = FALSE;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 140 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 140 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (date), FALSE);
#line 141 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = date;
#line 141 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_span_contains (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan), _tmp0_);
#line 141 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 141 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 609 "calendar-date-span.c"
}


/**
     * Returns an Iterator for all {@link Date}s in the {@link DateSpan}.
     */
static CaliforniaCollectionSimpleIterator* california_calendar_date_span_real_iterator (CaliforniaCollectionSimpleIterable* base) {
	CaliforniaCalendarDateSpan * self;
	CaliforniaCollectionSimpleIterator* result = NULL;
	CaliforniaCalendarDateSpanDateSpanIterator* _tmp0_ = NULL;
#line 147 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 148 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_date_span_date_span_iterator_new (self);
#line 148 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator);
#line 148 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 628 "calendar-date-span.c"
}


/**
     * Returns a {@link WeekSpan} for each {@link Week} (full and partial) in the {@link DateSpan}.
     */
CaliforniaCalendarWeekSpan* california_calendar_date_span_weeks (CaliforniaCalendarDateSpan* self, CaliforniaCalendarFirstOfWeek first_of_week) {
	CaliforniaCalendarWeekSpan* result = NULL;
	CaliforniaCalendarFirstOfWeek _tmp0_ = 0;
	CaliforniaCalendarWeekSpan* _tmp1_ = NULL;
#line 154 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), NULL);
#line 155 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = first_of_week;
#line 155 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_week_span_new (self, _tmp0_);
#line 155 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 155 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 649 "calendar-date-span.c"
}


/**
     * Adjusts the start of the {@link DateSpan} preserving the span duration.
     *
     * Since DateSpan always guarantees the {@link start_date} will be before the {@link end_date},
     * it's sometimes desirable to manipulate the start_date and preserve the duration between its
     * original value and the end_date.
     *
     * @see adjust_end_date
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_start_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_start_date) {
	CaliforniaCalendarDateSpan* result = NULL;
	gint diff = 0;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDate* _tmp9_ = NULL;
	CaliforniaCalendarDate* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDateSpan* _tmp12_ = NULL;
	CaliforniaCalendarDateSpan* _tmp13_ = NULL;
#line 167 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), NULL);
#line 167 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (new_start_date), NULL);
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = _tmp3_;
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = california_calendar_date_difference (_tmp2_, _tmp5_);
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp5_);
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp2_);
#line 168 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	diff = _tmp7_;
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = new_start_date;
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = new_start_date;
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp10_ = california_calendar_date_adjust (_tmp9_, diff, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp11_ = _tmp10_;
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp12_ = california_calendar_date_span_new (_tmp8_, _tmp11_);
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp13_ = _tmp12_;
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp11_);
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp13_;
#line 170 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 723 "calendar-date-span.c"
}


/**
     * Adjusts the end of the {@link DateSpan} preserving the span duration.
     *
     * Since DateSpan always guarantees the {@link start_date} will be before the {@link end_date},
     * it's sometimes desirable to manipulate the end_date and preserve the duration between its
     * original value and the start_date.
     *
     * @see adjust_start_date
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_adjust_end_date (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* new_end_date) {
	CaliforniaCalendarDateSpan* result = NULL;
	gint diff = 0;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDate* _tmp9_ = NULL;
	CaliforniaCalendarDate* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDateSpan* _tmp12_ = NULL;
	CaliforniaCalendarDateSpan* _tmp13_ = NULL;
#line 182 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), NULL);
#line 182 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (new_end_date), NULL);
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = _tmp3_;
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = california_calendar_date_difference (_tmp2_, _tmp5_);
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp5_);
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp2_);
#line 183 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	diff = _tmp7_;
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = new_end_date;
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = california_calendar_date_adjust (_tmp8_, diff, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp10_ = _tmp9_;
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp11_ = new_end_date;
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp12_ = california_calendar_date_span_new (_tmp10_, _tmp11_);
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp13_ = _tmp12_;
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp10_);
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp13_;
#line 185 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 797 "calendar-date-span.c"
}


/**
     * Returns a {@link DateSpan} with starting and ending points within the boundary specified
     * (inclusive).
     *
     * If this DateSpan is within the clamped dates, this object may be returned.
     *
     * This method will not expand a DateSpan to meet the clamp range.
     */
CaliforniaCalendarDateSpan* california_calendar_date_span_clamp (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDateSpan* span) {
	CaliforniaCalendarDateSpan* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDateSpan* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarDate* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	CaliforniaCalendarDate* new_start = NULL;
	CaliforniaCalendarDate* _tmp15_ = NULL;
	CaliforniaCalendarDate* _tmp16_ = NULL;
	CaliforniaCalendarDate* _tmp17_ = NULL;
	CaliforniaCalendarDate* _tmp18_ = NULL;
	CaliforniaCalendarDate* _tmp19_ = NULL;
	CaliforniaCalendarDateSpan* _tmp20_ = NULL;
	CaliforniaCalendarDate* _tmp21_ = NULL;
	CaliforniaCalendarDate* _tmp22_ = NULL;
	CaliforniaCalendarDate* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gboolean _tmp25_ = FALSE;
	CaliforniaCalendarDate* new_end = NULL;
	CaliforniaCalendarDate* _tmp31_ = NULL;
	CaliforniaCalendarDate* _tmp32_ = NULL;
	CaliforniaCalendarDateSpan* _tmp33_ = NULL;
#line 196 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), NULL);
#line 196 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (span), NULL);
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = _tmp2_;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = span;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = _tmp5_;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp7_);
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = _tmp8_ < 0;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp7_);
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp3_);
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	if (_tmp9_) {
#line 865 "calendar-date-span.c"
		CaliforniaCalendarDateSpan* _tmp10_ = NULL;
		CaliforniaCalendarDate* _tmp11_ = NULL;
		CaliforniaCalendarDate* _tmp12_ = NULL;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp10_ = span;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp11_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp12_ = _tmp11_;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (_tmp0_);
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp0_ = _tmp12_;
#line 879 "calendar-date-span.c"
	} else {
		CaliforniaCalendarDate* _tmp13_ = NULL;
		CaliforniaCalendarDate* _tmp14_ = NULL;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp13_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp14_ = _tmp13_;
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (_tmp0_);
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp0_ = _tmp14_;
#line 891 "calendar-date-span.c"
	}
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp15_ = _g_object_ref0 (_tmp0_);
#line 197 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	new_start = _tmp15_;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp17_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp18_ = _tmp17_;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp19_ = _tmp18_;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp20_ = span;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp21_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp22_ = _tmp21_;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp23_ = _tmp22_;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp24_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp23_);
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp25_ = _tmp24_ > 0;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp23_);
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp19_);
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	if (_tmp25_) {
#line 921 "calendar-date-span.c"
		CaliforniaCalendarDateSpan* _tmp26_ = NULL;
		CaliforniaCalendarDate* _tmp27_ = NULL;
		CaliforniaCalendarDate* _tmp28_ = NULL;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp26_ = span;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp27_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp28_ = _tmp27_;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (_tmp16_);
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp16_ = _tmp28_;
#line 935 "calendar-date-span.c"
	} else {
		CaliforniaCalendarDate* _tmp29_ = NULL;
		CaliforniaCalendarDate* _tmp30_ = NULL;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp29_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp30_ = _tmp29_;
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (_tmp16_);
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp16_ = _tmp30_;
#line 947 "calendar-date-span.c"
	}
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp31_ = _g_object_ref0 (_tmp16_);
#line 198 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	new_end = _tmp31_;
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp32_ = new_start;
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp33_ = california_calendar_date_span_new (_tmp32_, new_end);
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp33_;
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (new_end);
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp16_);
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (new_start);
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp0_);
#line 200 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 969 "calendar-date-span.c"
}


/**
     * Compares two {@link DateSpan}s by their {@link start_date}.
     */
static gint california_calendar_date_span_real_compare_to (GeeComparable* base, CaliforniaCalendarDateSpan* other) {
	CaliforniaCalendarDateSpan * self;
	gint result = 0;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDateSpan* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarDate* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 206 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 206 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (other), 0);
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = other;
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = _tmp5_;
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp6_);
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = _tmp7_;
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp6_);
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp2_);
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp8_;
#line 207 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1018 "calendar-date-span.c"
}


static gboolean california_calendar_date_span_real_equal_to (GeeHashable* base, CaliforniaCalendarDateSpan* other) {
	CaliforniaCalendarDateSpan * self;
	gboolean result = FALSE;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDateSpan* _tmp5_ = NULL;
	CaliforniaCalendarDate* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
#line 210 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 210 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (other), FALSE);
#line 211 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = other;
#line 211 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	if (self == _tmp0_) {
#line 212 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		result = TRUE;
#line 212 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		return result;
#line 1048 "calendar-date-span.c"
	}
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = _tmp2_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = _tmp3_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = other;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = _tmp7_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_HASHABLE, GeeHashable), _tmp8_);
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp10_ = _tmp9_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp8_);
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp4_);
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	if (_tmp10_) {
#line 1074 "calendar-date-span.c"
		CaliforniaCalendarDate* _tmp11_ = NULL;
		CaliforniaCalendarDate* _tmp12_ = NULL;
		CaliforniaCalendarDate* _tmp13_ = NULL;
		CaliforniaCalendarDateSpan* _tmp14_ = NULL;
		CaliforniaCalendarDate* _tmp15_ = NULL;
		CaliforniaCalendarDate* _tmp16_ = NULL;
		CaliforniaCalendarDate* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp11_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp12_ = _tmp11_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp13_ = _tmp12_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp14_ = other;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp15_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp16_ = _tmp15_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp17_ = _tmp16_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp18_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_HASHABLE, GeeHashable), _tmp17_);
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp1_ = _tmp18_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (_tmp17_);
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (_tmp13_);
#line 1105 "calendar-date-span.c"
	} else {
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp1_ = FALSE;
#line 1109 "calendar-date-span.c"
	}
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 214 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1115 "calendar-date-span.c"
}


static guint california_calendar_date_span_real_hash (GeeHashable* base) {
	CaliforniaCalendarDateSpan * self;
	guint result = 0U;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarDate* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
#line 217 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_HASHABLE, GeeHashable));
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = _tmp5_;
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_HASHABLE, GeeHashable));
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = _tmp3_ ^ _tmp7_;
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp6_);
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp2_);
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp8_;
#line 218 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1159 "calendar-date-span.c"
}


static gchar* california_calendar_date_span_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarDateSpan * self;
	gchar* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarDate* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 221 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = _tmp3_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = _tmp5_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp9_ = _tmp8_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp10_ = g_strdup_printf ("%s::%s", _tmp4_, _tmp9_);
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp11_ = _tmp10_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_free0 (_tmp9_);
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp7_);
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_free0 (_tmp4_);
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp2_);
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp11_;
#line 222 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1216 "calendar-date-span.c"
}


static CaliforniaCalendarDate* california_calendar_date_span_real_get_start_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDateSpan* self;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 52 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 52 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = self->priv->_start_date;
#line 52 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 52 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1235 "calendar-date-span.c"
}


static CaliforniaCalendarDate* california_calendar_date_span_real_get_end_date (CaliforniaCalendarSpan* base) {
	CaliforniaCalendarDate* result;
	CaliforniaCalendarDateSpan* self;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 58 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 58 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = self->priv->_end_date;
#line 58 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 58 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 58 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1254 "calendar-date-span.c"
}


gboolean california_calendar_date_span_get_is_same_day (CaliforniaCalendarDateSpan* self) {
	gboolean result;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), FALSE);
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = _tmp3_;
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_HASHABLE, GeeHashable), _tmp5_);
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp5_);
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp2_);
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp7_;
#line 63 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1294 "calendar-date-span.c"
}


CaliforniaCalendarDuration* california_calendar_date_span_get_duration (CaliforniaCalendarDateSpan* self) {
	CaliforniaCalendarDuration* result;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	CaliforniaCalendarDuration* _tmp7_ = NULL;
	CaliforniaCalendarDuration* _tmp8_ = NULL;
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (self), NULL);
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _tmp0_;
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = _tmp3_;
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = california_calendar_date_difference (_tmp2_, _tmp5_);
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = california_calendar_duration_new ((guint) _tmp6_, (guint) 0, (guint64) 0, (guint64) 0);
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp8_ = _tmp7_;
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp5_);
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (_tmp2_);
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp8_;
#line 68 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1337 "calendar-date-span.c"
}


static CaliforniaCalendarDateSpanDateSpanIterator* california_calendar_date_span_date_span_iterator_construct (GType object_type, CaliforniaCalendarDateSpan* owner) {
	CaliforniaCalendarDateSpanDateSpanIterator * self = NULL;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDateSpan* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
#line 23 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (owner), NULL);
#line 23 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = (CaliforniaCalendarDateSpanDateSpanIterator*) california_base_object_construct (object_type);
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = owner;
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (self->first);
#line 24 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self->first = _tmp2_;
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = owner;
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (self->last);
#line 25 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self->last = _tmp5_;
#line 23 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return self;
#line 1375 "calendar-date-span.c"
}


static CaliforniaCalendarDateSpanDateSpanIterator* california_calendar_date_span_date_span_iterator_new (CaliforniaCalendarDateSpan* owner) {
#line 23 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return california_calendar_date_span_date_span_iterator_construct (CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, owner);
#line 1382 "calendar-date-span.c"
}


static CaliforniaCalendarDate* california_calendar_date_span_date_span_iterator_real_get (CaliforniaCollectionSimpleIterator* base) {
	CaliforniaCalendarDateSpanDateSpanIterator * self;
	CaliforniaCalendarDate* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
#line 28 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, CaliforniaCalendarDateSpanDateSpanIterator);
#line 29 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = self->current;
#line 29 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 29 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp1_;
#line 29 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1401 "calendar-date-span.c"
}


static gboolean california_calendar_date_span_date_span_iterator_real_next (CaliforniaCollectionSimpleIterator* base) {
	CaliforniaCalendarDateSpanDateSpanIterator * self;
	gboolean result = FALSE;
	CaliforniaCalendarDate* _tmp0_ = NULL;
#line 32 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, CaliforniaCalendarDateSpanDateSpanIterator);
#line 33 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = self->current;
#line 33 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	if (_tmp0_ == NULL) {
#line 1415 "calendar-date-span.c"
		CaliforniaCalendarDate* _tmp1_ = NULL;
		CaliforniaCalendarDate* _tmp2_ = NULL;
#line 34 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp1_ = self->first;
#line 34 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 34 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_g_object_unref0 (self->current);
#line 34 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		self->current = _tmp2_;
#line 1426 "calendar-date-span.c"
	} else {
		CaliforniaCalendarDate* _tmp3_ = NULL;
		CaliforniaCalendarDate* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 35 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp3_ = self->current;
#line 35 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp4_ = self->last;
#line 35 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		_tmp5_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp4_);
#line 35 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		if (_tmp5_ < 0) {
#line 1439 "calendar-date-span.c"
			CaliforniaCalendarDate* _tmp6_ = NULL;
			CaliforniaCalendarDate* _tmp7_ = NULL;
#line 36 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
			_tmp6_ = self->current;
#line 36 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
			_tmp7_ = california_calendar_date_adjust (_tmp6_, 1, CALIFORNIA_CALENDAR_DATE_UNIT_DAY);
#line 36 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
			_g_object_unref0 (self->current);
#line 36 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
			self->current = _tmp7_;
#line 1450 "calendar-date-span.c"
		} else {
#line 38 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
			result = FALSE;
#line 38 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
			return result;
#line 1456 "calendar-date-span.c"
		}
	}
#line 40 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = TRUE;
#line 40 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1463 "calendar-date-span.c"
}


static gchar* california_calendar_date_span_date_span_iterator_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarDateSpanDateSpanIterator * self;
	gchar* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 43 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, CaliforniaCalendarDateSpanDateSpanIterator);
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp0_ = self->first;
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp1_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp2_ = _tmp1_;
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp3_ = self->last;
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp4_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp5_ = _tmp4_;
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp6_ = g_strdup_printf ("DateSpanIterator %s::%s", _tmp2_, _tmp5_);
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_tmp7_ = _tmp6_;
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_free0 (_tmp5_);
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_free0 (_tmp2_);
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	result = _tmp7_;
#line 44 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	return result;
#line 1504 "calendar-date-span.c"
}


static void california_calendar_date_span_date_span_iterator_class_init (CaliforniaCalendarDateSpanDateSpanIteratorClass * klass) {
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_date_span_iterator_parent_class = g_type_class_peek_parent (klass);
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_date_span_date_span_iterator_real_to_string;
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_date_span_date_span_iterator_finalize;
#line 1515 "calendar-date-span.c"
}


static void california_calendar_date_span_date_span_iterator_california_collection_simple_iterator_interface_init (CaliforniaCollectionSimpleIteratorIface * iface) {
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_date_span_iterator_california_collection_simple_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->get = (gpointer (*)(CaliforniaCollectionSimpleIterator*)) california_calendar_date_span_date_span_iterator_real_get;
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->next = (gboolean (*)(CaliforniaCollectionSimpleIterator*)) california_calendar_date_span_date_span_iterator_real_next;
#line 1526 "calendar-date-span.c"
}


static void california_calendar_date_span_date_span_iterator_instance_init (CaliforniaCalendarDateSpanDateSpanIterator * self) {
#line 21 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self->current = NULL;
#line 1533 "calendar-date-span.c"
}


static void california_calendar_date_span_date_span_iterator_finalize (GObject* obj) {
	CaliforniaCalendarDateSpanDateSpanIterator * self;
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_DATE_SPAN_TYPE_DATE_SPAN_ITERATOR, CaliforniaCalendarDateSpanDateSpanIterator);
#line 19 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (self->first);
#line 20 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (self->last);
#line 21 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (self->current);
#line 18 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	G_OBJECT_CLASS (california_calendar_date_span_date_span_iterator_parent_class)->finalize (obj);
#line 1549 "calendar-date-span.c"
}


static GType california_calendar_date_span_date_span_iterator_get_type (void) {
	static volatile gsize california_calendar_date_span_date_span_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_span_date_span_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarDateSpanDateSpanIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_date_span_date_span_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarDateSpanDateSpanIterator), 0, (GInstanceInitFunc) california_calendar_date_span_date_span_iterator_instance_init, NULL };
		static const GInterfaceInfo california_collection_simple_iterator_info = { (GInterfaceInitFunc) california_calendar_date_span_date_span_iterator_california_collection_simple_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_date_span_date_span_iterator_type_id;
		california_calendar_date_span_date_span_iterator_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarDateSpanDateSpanIterator", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_date_span_date_span_iterator_type_id, CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, &california_collection_simple_iterator_info);
		g_once_init_leave (&california_calendar_date_span_date_span_iterator_type_id__volatile, california_calendar_date_span_date_span_iterator_type_id);
	}
	return california_calendar_date_span_date_span_iterator_type_id__volatile;
}


static void california_calendar_date_span_class_init (CaliforniaCalendarDateSpanClass * klass) {
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarDateSpanPrivate));
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_date_span_real_to_string;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_date_span_get_property;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_date_span_finalize;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_SPAN_START_DATE, g_param_spec_object ("start-date", "start-date", "start-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_SPAN_END_DATE, g_param_spec_object ("end-date", "end-date", "end-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1582 "calendar-date-span.c"
	/**
	     * Convenience property indicating if the {@link DateSpan} spans only one day.
	     */
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_SPAN_IS_SAME_DAY, g_param_spec_boolean ("is-same-day", "is-same-day", "is-same-day", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1588 "calendar-date-span.c"
	/**
	     * Returns the {@link Duration} this {@link DateSpan} represents.
	     */
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_DATE_SPAN_DURATION, g_param_spec_object ("duration", "duration", "duration", CALIFORNIA_CALENDAR_TYPE_DURATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1594 "calendar-date-span.c"
}


static void california_calendar_date_span_california_collection_simple_iterable_interface_init (CaliforniaCollectionSimpleIterableIface * iface) {
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_california_collection_simple_iterable_parent_iface = g_type_interface_peek_parent (iface);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->iterator = (CaliforniaCollectionSimpleIterator* (*)(CaliforniaCollectionSimpleIterable*)) california_calendar_date_span_real_iterator;
#line 1603 "calendar-date-span.c"
}


static void california_calendar_date_span_california_calendar_span_interface_init (CaliforniaCalendarSpanIface * iface) {
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_california_calendar_span_parent_iface = g_type_interface_peek_parent (iface);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->start = (gpointer (*)(CaliforniaCalendarSpan*)) california_calendar_date_span_real_start;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->end = (gpointer (*)(CaliforniaCalendarSpan*)) california_calendar_date_span_real_end;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->contains = (gboolean (*)(CaliforniaCalendarSpan*, CaliforniaCalendarDate*)) california_calendar_date_span_real_contains;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->has = (gboolean (*)(CaliforniaCalendarSpan*, gconstpointer)) california_calendar_date_span_real_has;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->get_start_date = california_calendar_date_span_real_get_start_date;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->get_end_date = california_calendar_date_span_real_get_end_date;
#line 1622 "calendar-date-span.c"
}


static void california_calendar_date_span_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_date_span_real_compare_to;
#line 1631 "calendar-date-span.c"
}


static void california_calendar_date_span_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	california_calendar_date_span_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_date_span_real_equal_to;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_date_span_real_hash;
#line 1642 "calendar-date-span.c"
}


static void california_calendar_date_span_instance_init (CaliforniaCalendarDateSpan * self) {
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self->priv = CALIFORNIA_CALENDAR_DATE_SPAN_GET_PRIVATE (self);
#line 1649 "calendar-date-span.c"
}


static void california_calendar_date_span_finalize (GObject* obj) {
	CaliforniaCalendarDateSpan * self;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 51 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (self->priv->_start_date);
#line 57 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	_g_object_unref0 (self->priv->_end_date);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	G_OBJECT_CLASS (california_calendar_date_span_parent_class)->finalize (obj);
#line 1663 "calendar-date-span.c"
}


/**
 * Represents an immutable span of consecutive {@link Date}s.
 *
 * A DateSpan may be naturally iterated over its {@link Date}s.  It also provides iterators for
 * {@link Week}s.
 */
GType california_calendar_date_span_get_type (void) {
	static volatile gsize california_calendar_date_span_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_date_span_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarDateSpanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_date_span_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarDateSpan), 0, (GInstanceInitFunc) california_calendar_date_span_instance_init, NULL };
		static const GInterfaceInfo california_collection_simple_iterable_info = { (GInterfaceInitFunc) california_calendar_date_span_california_collection_simple_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo california_calendar_span_info = { (GInterfaceInitFunc) california_calendar_date_span_california_calendar_span_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_date_span_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_date_span_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_date_span_type_id;
		california_calendar_date_span_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarDateSpan", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_date_span_type_id, CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, &california_collection_simple_iterable_info);
		g_type_add_interface_static (california_calendar_date_span_type_id, CALIFORNIA_CALENDAR_TYPE_SPAN, &california_calendar_span_info);
		g_type_add_interface_static (california_calendar_date_span_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_date_span_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_date_span_type_id__volatile, california_calendar_date_span_type_id);
	}
	return california_calendar_date_span_type_id__volatile;
}


static void _vala_california_calendar_date_span_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarDateSpan * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		case CALIFORNIA_CALENDAR_DATE_SPAN_START_DATE:
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		g_value_take_object (value, california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		break;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		case CALIFORNIA_CALENDAR_DATE_SPAN_END_DATE:
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		g_value_take_object (value, california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan)));
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		break;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		case CALIFORNIA_CALENDAR_DATE_SPAN_IS_SAME_DAY:
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		g_value_set_boolean (value, california_calendar_date_span_get_is_same_day (self));
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		break;
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		case CALIFORNIA_CALENDAR_DATE_SPAN_DURATION:
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		g_value_take_object (value, california_calendar_date_span_get_duration (self));
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		break;
#line 1722 "calendar-date-span.c"
		default:
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/calendar/calendar-date-span.vala"
		break;
#line 1728 "calendar-date-span.c"
	}
}



