/***************************************************************************
 *            brasero-disc-option-dialog.h
 *
 *  jeu sep 28 17:28:45 2006
 *  Copyright  2006  Philippe Rouquier
 *  bonfire-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BRASERO_DISC_OPTION_DIALOG_H
#define BRASERO_DISC_OPTION_DIALOG_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkwidget.h>
#include <gtk/gtkdialog.h>

#include <nautilus-burn-drive.h>

#include "disc.h"
#include "burn-caps.h"

G_BEGIN_DECLS

#define BRASERO_TYPE_DISC_OPTION_DIALOG         (brasero_disc_option_dialog_get_type ())
#define BRASERO_DISC_OPTION_DIALOG(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), BRASERO_TYPE_DISC_OPTION_DIALOG, BraseroDiscOptionDialog))
#define BRASERO_DISC_OPTION_DIALOG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), BRASERO_TYPE_DISC_OPTION_DIALOG, BraseroDiscOptionDialogClass))
#define BRASERO_IS_DISC_OPTION_DIALOG(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), BRASERO_TYPE_DISC_OPTION_DIALOG))
#define BRASERO_IS_DISC_OPTION_DIALOG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), BRASERO_TYPE_DISC_OPTION_DIALOG))
#define BRASERO_DISC_OPTION_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), BRASERO_TYPE_DISC_OPTION_DIALOG, BraseroDiscOptionDialogClass))

typedef struct _BraseroDiscOptionDialog BraseroDiscOptionDialog;
typedef struct _BraseroDiscOptionDialogPrivate BraseroDiscOptionDialogPrivate;
typedef struct _BraseroDiscOptionDialogClass BraseroDiscOptionDialogClass;

struct _BraseroDiscOptionDialog {
	GtkDialog parent;
	BraseroDiscOptionDialogPrivate *priv;
};

struct _BraseroDiscOptionDialogClass {
	GtkDialogClass parent_class;
};

GType brasero_disc_option_dialog_get_type ();
GtkWidget *brasero_disc_option_dialog_new ();

void
brasero_disc_option_dialog_set_disc (BraseroDiscOptionDialog *dialog,
				     NautilusBurnDrive *drive,
				     BraseroBurnFlag flags,
				     BraseroDisc *disc);

gboolean
brasero_disc_option_dialog_get_param (BraseroDiscOptionDialog *dialog,
				      BraseroBurnFlag *flags,
				      NautilusBurnDrive **drive,
				      gint *speed,
				      BraseroTrackSource **source,
				      gchar **output,
				      gboolean *checksum);

G_END_DECLS

#endif /* BRASERO_DISC_OPTION_DIALOG_H */
