/**
 * bonobo-property-types.h: property type functions.
 *
 * This file defines the standard types for Bonobo properties.
 *
 * Author:
 *    Nat Friedman (nat@nat.org)
 *
 * Copyright 1999, Helix Code, Inc.
 */
#ifndef __BONOBO_PROPERTY_TYPES_H__
#define __BONOBO_PROPERTY_TYPES_H__

#include <bonobo/bonobo-property-bag.h>

BEGIN_GNOME_DECLS

/*
 * Standard type marshaler.
 */
CORBA_any *bonobo_property_marshal_boolean   (const char *type, gconstpointer value,
					      gpointer user_data);
CORBA_any *bonobo_property_marshal_string    (const char *type, gconstpointer value,
					      gpointer user_data);
CORBA_any *bonobo_property_marshal_short     (const char *type, gconstpointer value,
					      gpointer user_data);
CORBA_any *bonobo_property_marshal_ushort    (const char *type, gconstpointer value,
					      gpointer user_data);
CORBA_any *bonobo_property_marshal_long	     (const char *type, gconstpointer value,
					      gpointer user_data);
CORBA_any *bonobo_property_marshal_ulong     (const char *type, gconstpointer value,
					      gpointer user_data);
CORBA_any *bonobo_property_marshal_float     (const char *type, gconstpointer value,
					      gpointer user_data);
CORBA_any *bonobo_property_marshal_double    (const char *type, gconstpointer value,
					      gpointer user_data);

/*
 * Standard type demarshalers.
 */
gpointer   bonobo_property_demarshal_boolean (const char *type, const CORBA_any *any,
					      gpointer user_data);
gpointer   bonobo_property_demarshal_string  (const char *type, const CORBA_any *any,
					      gpointer user_data);
gpointer   bonobo_property_demarshal_short   (const char *type, const CORBA_any *any,
					      gpointer user_data);
gpointer   bonobo_property_demarshal_ushort  (const char *type, const CORBA_any *any,
					      gpointer user_data);
gpointer   bonobo_property_demarshal_long    (const char *type, const CORBA_any *any,
					      gpointer user_data);
gpointer   bonobo_property_demarshal_ulong   (const char *type, const CORBA_any *any,
					      gpointer user_data);
gpointer   bonobo_property_demarshal_float   (const char *type, const CORBA_any *any,
					      gpointer user_data);
gpointer   bonobo_property_demarshal_double  (const char *type, const CORBA_any *any,
					      gpointer user_data);

/*
 * Standard type comparers.
 */
gboolean   bonobo_property_compare_boolean   (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);
gboolean   bonobo_property_compare_string    (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);
gboolean   bonobo_property_compare_short     (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);
gboolean   bonobo_property_compare_ushort    (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);
gboolean   bonobo_property_compare_long      (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);
gboolean   bonobo_property_compare_ulong     (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);
gboolean   bonobo_property_compare_float     (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);
gboolean   bonobo_property_compare_double    (const char *type, gpointer value1,
					      gpointer value2,  gpointer user_data);


/*
 * Standard type releaser.
 */
void	   bonobo_property_generic_releaser  (const char *type, gpointer value,
					     gpointer user_data);

END_GNOME_DECLS

#endif /* ! __BONOBO_PROPERTY_TYPES_H__ */
