#! gmake

## AbiSource Program Utilities
## Copyright (C) 1998 AbiSource, Inc.
##
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License
## as published by the Free Software Foundation; either version 2
## of the License, or (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
## 02111-1307, USA.

##############################################################################
## Linux platform defines
##############################################################################

##################################################################
##################################################################
## The main makefile and/or this file requires that OS_ARCH be set
## to something to describe which chip that this OS is running on.
## This can be used to change which tools are used and/or which
## compiler/loader options are used.  It will probably also be used
## in constructing the name object file destination directory.

OS_ARCH		:= $(shell uname -m | sed -e s/i.86/i386/ -e s/sun4u/sparc64/ -e s/arm.*/arm/ -e s/sa110/arm/ | sed "s/\//-/")


# Define architecture-specific flags (L. Kollar, 3 Nov 1998)
# These are (probably) optional for your platform.

# Compiler defaults should be fine for Intel.
i386_ARCH_FLAGS		=

# Jerry LeVan <levan@eagle.eku.edu> provided the PPC flags
# Gary Thomas <gdt@linuxppc.org> suggests using -fno-schedule-insns2 
# for some EGCS builds
PPC_ARCH_FLAGS		= -fsigned-char -fno-schedule-insns2

ALPHA_ARCH_FLAGS 	= 
SPARC_ARCH_FLAGS 	= 
IA64_ARCH_FLAGS		=
S390_ARCH_FLAGS		=

# Define tools
CC		= gcc
CCC		= g++
RANLIB		= ranlib

# Suffixes
OBJ_SUFFIX	= o
LIB_SUFFIX	= a
DLL_SUFFIX	= so
AR		= ar cr $@

# Compiler flags

ifeq ($(ABI_OPT_PROF),1)
OPTIMIZER   	= -pg -Wall -ansi -pedantic -fprofile-arcs -ftest-coverage
DEFINES  	= 
OBJ_DIR_SFX	= PRF
ABI_OPT_DEBUG 	= ""
ABI_OPT_OPTIMIZE= ""
ABI_OPTIONS	+= Profile:On
else

	ifeq ($(ABI_OPT_OPTIMIZE),1)
	OPTIMIZER	= -O3 -Wall -ansi -pedantic
	DEFINES		=
	OBJ_DIR_SFX	= OPT
	ABI_OPTIONS	+= Optimize:On
	ABI_OPT_DEBUG	= ""
	else #/* OPTIMIZE*/	

	ifeq ($(ABI_OPT_DEBUG),1)
#	OPTIMIZER	= -g -Wall -ansi -pedantic 
	OPTIMIZER	= -g -Wall -pedantic -Wno-long-long 
	DEFINES		= -DDEBUG -UNDEBUG
	OBJ_DIR_SFX	= DBG
		ifeq ($(ABI_OPT_GNOME),1)
			ifeq ($(ABI_OPT_LIBXML2),1)
			OBJ_DIR_SFX	= GNOME_XML
			else
			OBJ_DIR_SFX	= GNOME
			endif #/* LIBXML2 */
		endif #/* GNOME */
	else # DEBUG

	OPTIMIZER	= -O2 -Wall -ansi -pedantic
	DEFINES		=
	OBJ_DIR_SFX	= OBJ
	endif #/* DEBUG */ 
	endif #/* OPTIMIZE */
	ifeq ($(ABI_OPT_GNOME),1)
		ifeq ($(ABI_OPT_LIBXML2),1)
		OBJ_DIR_SFX	= GNOME_XML
		else
		OBJ_DIR_SFX	= GNOME
		endif #/* LIBXML2 */
	else #/* GNOME */
		ifeq ($(ABI_OPT_LIBXML2),1)
		OBJ_DIR_SFX	= GTK_XML
		endif #/* LIBXML2 */
	endif #/* GNOME */

endif #/* PROF */

ifeq ($(ABI_OPT_WAY_TOO_MANY_WARNINGS),1)
	OPTIMIZER 	+= -Weffc++
endif #/* WAY_TOO_MANY_WARNINGS */

# Includes
OS_INCLUDES		=
G++INCLUDES		= -I/usr/include/g++

# Compiler flags
PLATFORM_FLAGS		= -pipe -DLINUX -Dlinux
PORT_FLAGS		= -D_POSIX_SOURCE -D_BSD_SOURCE -DHAVE_STRERROR -D_XOPEN_SOURCE -D__USE_XOPEN_EXTENDED
OS_CFLAGS		= $(DSO_CFLAGS) $(PLATFORM_FLAGS) $(PORT_FLAGS)

# Architecture-specific flags
ifeq ($(OS_ARCH), i386)
PLATFORM_FLAGS		+= $(i386_ARCH_FLAGS)
OS_ENDIAN		= LittleEndian32
endif

ifeq ($(OS_ARCH), ppc)
PLATFORM_FLAGS		+= $(PPC_ARCH_FLAGS)
OS_ENDIAN		= BigEndian32
endif

ifeq ($(OS_ARCH), alpha)
PLATFORM_FLAGS		+= $(ALPHA_ARCH_FLAGS)
OS_ENDIAN		= LittleEndian32
endif

ifeq ($(OS_ARCH), sparc)
PLATFORM_FLAGS		+= $(SPARC_ARCH_FLAGS)
OS_ENDIAN		= BigEndian32
endif

# Endian for ARM from Jim Studt <jim@federated.com>
ifeq ($(OS_ARCH), arm)
PLATFORM_FLAGS		+= $(ARM_ARCH_FLAGS)
OS_ENDIAN		= LittleEndian32
endif

# Endian for M68K from Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
ifeq ($(OS_ARCH), m68k)
PLATFORM_FLAGS		+= $(M68K_ARCH_FLAGS)
OS_ENDIAN		= BigEndian32
endif

ifeq ($(OS_ARCH), ia64)
PLATFORM_FLAGS		+= $(IA64_ARCH_FLAGS)
OS_ENDIAN		= LittleEndian32
endif

ifeq ($(OS_ARCH), s390)
PLATFORM_FLAGS		+= $(S390_ARCH_FLAGS)
OS_ENDIAN		= BigEndian32
endif

ifeq ($(OS_ARCH), parisc)
PLATFORM_FLAGS      += $(HPPA_ARCH_FLAGS)
OS_ENDIAN       = BigEndian32
endif

ifeq ($(OS_ARCH), parisc64)
PLATFORM_FLAGS      += $(HPPA_ARCH_FLAGS)
OS_ENDIAN       = BigEndian32
endif

GLIB_CONFIG		= glib-config
GTK_CONFIG		= gtk-config
GNOME_CONFIG    	= gnome-config
LIBXML_CONFIG		= xml2-config

# Shared library flags
MKSHLIB			= $(LD) $(DSO_LDOPTS) -soname $(@:$(OBJDIR)/%.so=%.so)

# Which links can this platform create.  Define one or
# both of these options.
UNIX_CAN_BUILD_DYNAMIC=1
UNIX_CAN_BUILD_STATIC=1

# Compiler options for static and dynamic linkage
DL_LIBS			= dl
STATIC_FLAGS		= -static

ABI_NATIVE	= unix
ABI_FE		= Unix

##################################################################
## Here you can choice if you want to use the gnome stuff.
## Set ABI_OPT_GNOME to 1 (when invoking 'make') or set as
## an environment variable.
##
##ABI_OPT_GNOME=1

##################################################################
## ABIPKGDIR defines the directory containing the Makefile to use to
## build a set of distribution archives (.deb, .rpm, .tgz, .exe, etc)
## This is relative to $(ABI_ROOT)/src/pkg

ABIPKGDIR	= linux
PSICONV_PLATFORM_DEFS= CFLAGS='-O2'

# End of linux defs




