/* This is -*- C -*- */
/* $Id: guppi-plug-in.h,v 1.3 2000/02/16 02:58:11 trow Exp $ */

/*
 * guppi-plug-in.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLUG_IN_H
#define _INC_GUPPI_PLUG_IN_H

#include <config.h>
#include <gnome.h>

#define GUPPI_PLUG_IN_MAGIC_NUMBER 0xb0bee001

typedef struct _GuppiPlugIn GuppiPlugIn;
typedef struct _GuppiPlugInClass GuppiPlugInClass;

struct _GuppiPlugIn {
  GtkObject parent;

  guint32 magic_number;

  const gchar* type;
  const gchar* external_name;
  const gchar* internal_name;

  gint major_version, minor_version, micro_version;

  const gchar* copyright;
  const gchar* authors;

  const gchar* keywords;

  const gchar* load_path;
  gpointer reserved;
};

struct _GuppiPlugInClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_PLUG_IN (guppi_plug_in_get_type())
#define GUPPI_PLUG_IN(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLUG_IN,GuppiPlugIn))
#define GUPPI_PLUG_IN0(obj) ((obj) ? (GUPPI_PLUG_IN(obj)) : NULL)
#define GUPPI_PLUG_IN_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLUG_IN,GuppiPlugInClass))
#define GUPPI_IS_PLUG_IN(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLUG_IN))
#define GUPPI_IS_PLUG_IN0(obj) (((obj) == NULL) || (GUPPI_IS_PLUG_IN(obj)))
#define GUPPI_IS_PLUG_IN_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLUG_IN))

GtkType guppi_plug_in_get_type(void);

GuppiPlugIn* guppi_plug_in_new(void);

GuppiPlugIn* guppi_plug_in_lookup(const gchar* type, const gchar* name);

GuppiPlugIn* guppi_plug_in_load(const gchar* path);
void guppi_plug_in_load_dir(const gchar* path, gboolean recursive);
void guppi_plug_in_load_all(void);

void guppi_plug_in_foreach(void (*func)(GuppiPlugIn*, gpointer), gpointer);
void guppi_plug_in_foreach_of_type(const gchar* type,
				   void (*func)(GuppiPlugIn*, gpointer),
				   gpointer);

#endif /* _INC_GUPPI_PLUG_IN_H */

/* $Id: guppi-plug-in.h,v 1.3 2000/02/16 02:58:11 trow Exp $ */
