/* This is -*- C -*- */
/* $Id: guppi-plot-view.c,v 1.4 2000/04/13 19:45:20 trow Exp $ */

/*
 * guppi-plot-view.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-plot-view.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0,
  ARG_STATE
};

static void
guppi_plot_view_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void guppi_plot_view_set_state(GuppiPlotView*, GuppiPlotState*);

static void
guppi_plot_view_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  GuppiPlotView* gpv = GUPPI_PLOT_VIEW(obj);

  switch (arg_id) {
  case ARG_STATE:
    guppi_plot_view_set_state(gpv, GUPPI_PLOT_STATE(GTK_VALUE_POINTER(*arg)));
    break;

  default:
    break;
  };
}

static void
guppi_plot_view_destroy(GtkObject* obj)
{
  GuppiPlotView* view = GUPPI_PLOT_VIEW(obj);

  if (parent_class->destroy)
    parent_class->destroy(obj);

  if (view->state) {
    gtk_object_unref(GTK_OBJECT(view->state));
    view->state = NULL;
  }
}

static void
guppi_plot_view_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_plot_view_class_init(GuppiPlotViewClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GNOME_TYPE_CANVAS);

  gtk_object_add_arg_type("GuppiPlotView::state",
			  GTK_TYPE_POINTER,
			  GTK_ARG_WRITABLE,
			  ARG_STATE);

  object_class->get_arg = guppi_plot_view_get_arg;
  object_class->set_arg = guppi_plot_view_set_arg;
  object_class->destroy = guppi_plot_view_destroy;
  object_class->finalize = guppi_plot_view_finalize;

}

static void
guppi_plot_view_init(GuppiPlotView* obj)
{
  GdkColor* color;

  /* Hopefully the Gnome Gods will not strike me down for doing this. */
  GNOME_CANVAS(obj)->aa = 1;

  obj->state = NULL;

  /* Is this the right way to do this?  Probably a FAQ... */
  color = &GTK_WIDGET(obj)->style->bg[GTK_STATE_NORMAL];
  color->red = 0xffff;
  color->green = 0xffff;
  color->blue = 0xffff;

  /* We like motion hints. */
  gtk_widget_add_events(GTK_WIDGET(obj), GDK_POINTER_MOTION_HINT_MASK);
}

static void
guppi_plot_view_set_state(GuppiPlotView* gpv, GuppiPlotState* state)
{
  g_return_if_fail(gpv != NULL);
  g_return_if_fail(state != NULL);
  g_return_if_fail(gpv->state == NULL); /* can only set state once */

  gpv->state = state;
  gtk_object_ref(GTK_OBJECT(state));

  guppi_plot_state_render(state, GNOME_CANVAS(gpv));
}

GtkType
guppi_plot_view_get_type(void)
{
  static GtkType guppi_plot_view_type = 0;
  if (!guppi_plot_view_type) {
    static const GtkTypeInfo guppi_plot_view_info = {
      "GuppiPlotView",
      sizeof(GuppiPlotView),
      sizeof(GuppiPlotViewClass),
      (GtkClassInitFunc)guppi_plot_view_class_init,
      (GtkObjectInitFunc)guppi_plot_view_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_plot_view_type = gtk_type_unique(GNOME_TYPE_CANVAS, &guppi_plot_view_info);
  }
  return guppi_plot_view_type;
}

GtkWidget*
guppi_plot_view_new(GuppiPlotState* state)
{
  GtkWidget* w = GTK_WIDGET(gtk_type_new(guppi_plot_view_get_type()));

  guppi_plot_view_set_state(GUPPI_PLOT_VIEW(w), state);

  return w;
}



/* $Id: guppi-plot-view.c,v 1.4 2000/04/13 19:45:20 trow Exp $ */
