/* $Id: init.c,v 1.1 2000/04/25 13:57:13 trow Exp $ */

/*
 * init.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.

 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-plot-plug-in.h>
#include "guppi-boxplot-element.h"
/* #include "guppi-scm-axis.h" */

GuppiPlugIn* guppi_plug_in(void);

static GuppiPlotElement*
make_element(void)
{
  return guppi_boxplot_element_new();
}

GuppiPlugIn*
guppi_plug_in(void)
{
  GuppiPlugIn* pi;
  GuppiPlotPlugIn* ppi;

  pi = guppi_plot_plug_in_new();
  ppi = GUPPI_PLOT_PLUG_IN(pi);

  pi->magic_number = GUPPI_PLUG_IN_MAGIC_NUMBER;
  pi->type = "plot";
  pi->external_name = _("Box Plot");
  pi->internal_name = "boxplot";
  pi->major_version = GUPPI_MAJOR_VERSION;
  pi->minor_version = GUPPI_MINOR_VERSION;
  pi->micro_version = GUPPI_MICRO_VERSION;
  pi->copyright = "(C) 2000 EMC Capital Management, Inc.";
  pi->authors = "Jon Trowbridge <trow@gnu.org>";

  ppi->element_constructor = make_element;

  /* guppi_scm_axis_init(); */

  /* Do any other necessary initialization here. */
  
  return pi;
}





/* $Id: init.c,v 1.1 2000/04/25 13:57:13 trow Exp $ */
