/* This is -*- C -*- */
/* $Id: guppi-boxplot-state.c,v 1.2 2000/05/03 17:06:48 trow Exp $ */

/*
 * guppi-boxplot-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-boxplot-state.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_boxplot_state_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_boxplot_state_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_boxplot_state_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_boxplot_state_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static gboolean
set_x_data(GuppiItemState* state, GuppiData* data)
{
  GuppiBoxplotState* bps = GUPPI_BOXPLOT_STATE(state);
  GuppiSeqScalar* sc = GUPPI_SEQ_SCALAR0(data);

  bps->horizontal = TRUE;

  if (bps->data == sc)
    return FALSE;

  if (bps->data)
    gtk_object_unref(bps->data);
  bps->data = sc;

  return TRUE;
}

static GuppiData*
get_x_data(GuppiItemState* state)
{
  GuppiBoxplotState* bps = GUPPI_BOXPLOT_STATE(state);
  return bps->horizontal ? GUPPI_DATA0(bps->data) : NULL;
}

static gboolean
set_y_data(GuppiItemState* state, GuppiData* data)
{
  GuppiBoxplotState* bps = GUPPI_BOXPLOT_STATE(state);
  GuppiSeqScalar* sc = GUPPI_SEQ_SCALAR0(data);

  bps->horizontal = FALSE;

  if (bps->data == sc)
    return FALSE;

  if (bps->data)
    gtk_object_unref(bps->data);
  bps->data = sc;

  return TRUE;
}

static GuppiData*
get_y_data(GuppiItemState* state)
{
  GuppiBoxplotState* bps = GUPPI_BOXPLOT_STATE(state);
  return bps->horizontal ? NULL : GUPPI_DATA0(bps->data);
}

static void
guppi_boxplot_state_class_init(GuppiBoxplotStateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiItemStateClass* is_class = GUPPI_ITEM_STATE_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_ITEM_STATE);

  object_class->get_arg = guppi_boxplot_state_get_arg;
  object_class->set_arg = guppi_boxplot_state_set_arg;
  object_class->destroy = guppi_boxplot_state_destroy;
  object_class->finalize = guppi_boxplot_state_finalize;

  is_class->set_x_data = set_x_data;
  is_class->get_x_data = get_x_data;

  is_class->set_y_data = set_y_data;
  is_class->get_y_data = get_y_data;

}

static void
guppi_boxplot_state_init(GuppiBoxplotState* obj)
{
  /* Some helpful (?) defaults */
  obj->width = 1.5;
  obj->color = 0xff0000ff;
}

GtkType
guppi_boxplot_state_get_type(void)
{
  static GtkType guppi_boxplot_state_type = 0;
  if (!guppi_boxplot_state_type) {
    static const GtkTypeInfo guppi_boxplot_state_info = {
      "GuppiBoxplotState",
      sizeof(GuppiBoxplotState),
      sizeof(GuppiBoxplotStateClass),
      (GtkClassInitFunc)guppi_boxplot_state_class_init,
      (GtkObjectInitFunc)guppi_boxplot_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_boxplot_state_type = gtk_type_unique(GUPPI_TYPE_ITEM_STATE, &guppi_boxplot_state_info);
  }
  return guppi_boxplot_state_type;
}

GtkObject*
guppi_boxplot_state_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_boxplot_state_get_type()));
}



/* $Id: guppi-boxplot-state.c,v 1.2 2000/05/03 17:06:48 trow Exp $ */
