/* $Id: guppi-defaults.c,v 1.1 2000/04/13 19:45:21 trow Exp $ */

/*
 * guppi-defaults.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.

 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-defaults.h"

GnomeFont*
guppi_default_font(void)
{
  static GnomeFont* font = NULL;

  if (font == NULL) {
    font = gnome_font_new("Helvetica", 12.0);
    if (font == NULL)
      g_error("Can't find default font.");
  }

  return font;
}

double
guppi_default_axis_label_size(void)
{
  return 14.0;
}

double
guppi_default_plot_label_size(void)
{
  return 12.0;
}


/* $Id: guppi-defaults.c,v 1.1 2000/04/13 19:45:21 trow Exp $ */
