/* $Id: guppi-debug.c,v 1.2 2000/04/06 23:27:32 trow Exp $ */

/*
 * guppi-debug.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-debug.h"
#include <signal.h>

void
_guppi_unimplemented_function_dialog(const gchar* function,
				     const gchar* filename,
				     gint line)
{
  gchar* s;

  g_return_if_fail(function != NULL);
  g_return_if_fail(filename != NULL);
  g_return_if_fail(line > 0);

  s = g_strdup_printf("\"%s\" is not implemented yet.\n\nCode needs to be added at %s, line %d.", function, filename, line);

  gtk_widget_show_all(gnome_warning_dialog(s));

  g_free(s);
}

/****************************************************************************/

static gboolean track_entry_and_exit = FALSE;

void
_guppi_track_entry(const gchar* filename, const gchar* function)
{
  if (track_entry_and_exit) {
    g_message("Entering %s:%s", filename, function);
  }
}

void
_guppi_track_exit(const gchar* filename, const gchar* function)
{
  if (track_entry_and_exit) {
    g_message("Exiting %s:%s", filename, function);
  }
}

/****************************************************************************/

/*
  All of the following code is blatently stolen from Nautilus
  (extracted from nautilus-debug.h on 23 Mar 2000)
*/

/*
  Raise a SIGINT signal to get the attention of the debugger.
  When not running under the debugger, we don't want to stop,
  so we ignore the signal for just the moment that we raise it.
*/

void
guppi_stop_in_debugger(void)
{
  void (* saved_handler) (int);

  saved_handler = signal (SIGINT, SIG_IGN);
  raise (SIGINT);
  signal (SIGINT, saved_handler);
}

/* 
   Stop in the debugger after running the default log handler.
   This makes certain kinds of messages stop in the debugger
   without making them fatal.
*/

static void
guppi_stop_after_default_log_handler(const char* domain,
				     GLogLevelFlags level,
				     const char* message,
				     gpointer data)
{
  g_log_default_handler (domain, level, message, data);
  guppi_stop_in_debugger ();
}

static void
guppi_set_stop_after_default_log_handler(const char* domain)
{
  g_log_set_handler (domain, G_LOG_LEVEL_CRITICAL | G_LOG_LEVEL_WARNING,
		     guppi_stop_after_default_log_handler, NULL);
}


void
guppi_make_warnings_and_criticals_stop_in_debugger(const char* first_domain,
						   ...)
{
  va_list domains;
  const char* domain;

  guppi_set_stop_after_default_log_handler (first_domain);
  
  va_start (domains, first_domain);
  
  for (;;) {
    domain = va_arg (domains, const char*);
    if (domain == NULL)
      break;
    guppi_set_stop_after_default_log_handler (domain);
  }
  
  va_end (domains);
}


/* $Id: guppi-debug.c,v 1.2 2000/04/06 23:27:32 trow Exp $ */
