/* This is -*- C -*- */
/* $Id: guppi-seq-boolean-impl.h,v 1.2 2000/02/21 18:31:36 trow Exp $ */

/*
 * guppi-seq-boolean-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_BOOLEAN_IMPL_H
#define _INC_GUPPI_SEQ_BOOLEAN_IMPL_H

#include <config.h>
#include <gnome.h>

#include "guppi-seq-impl.h"
#include "guppi-seq-scalar.h"

typedef struct _GuppiSeqBooleanImpl GuppiSeqBooleanImpl;
typedef struct _GuppiSeqBooleanImplClass GuppiSeqBooleanImplClass;

struct _GuppiSeqBooleanImpl {
  GuppiSeqImpl parent;
};

struct _GuppiSeqBooleanImplClass {
  GuppiSeqImplClass parent_class;

  gboolean (*get)(const GuppiSeqBooleanImpl*, gint);
  void (*set)(GuppiSeqBooleanImpl*, gint, gboolean);
  void (*set_all)(GuppiSeqBooleanImpl*, gboolean);
  void (*insert)(GuppiSeqBooleanImpl*, gint, gboolean);
  void (*insert_many)(GuppiSeqBooleanImpl*, gint, gboolean, gsize);
  void (*bitwise_and)(GuppiSeqBooleanImpl*, const GuppiSeqBooleanImpl*);
  void (*bitwise_or)(GuppiSeqBooleanImpl*, const GuppiSeqBooleanImpl*);
  void (*bitwise_xor)(GuppiSeqBooleanImpl*, const GuppiSeqBooleanImpl*);
  void (*bitwise_not)(GuppiSeqBooleanImpl*);
  gint (*next_true)(const GuppiSeqBooleanImpl*, gint);
  gsize (*true_count)(const GuppiSeqBooleanImpl*);
  
  gint (*range_query)(const GuppiSeqScalar*, GuppiSeqBooleanImpl*,
		      double min, double max, gboolean do_and);
  
};

#define GUPPI_TYPE_SEQ_BOOLEAN_IMPL (guppi_seq_boolean_impl_get_type())
#define GUPPI_SEQ_BOOLEAN_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_BOOLEAN_IMPL,GuppiSeqBooleanImpl))
#define GUPPI_SEQ_BOOLEAN_IMPL0(obj) ((obj) ? (GUPPI_SEQ_BOOLEAN_IMPL(obj)) : NULL)
#define GUPPI_SEQ_BOOLEAN_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_BOOLEAN_IMPL,GuppiSeqBooleanImplClass))
#define GUPPI_IS_SEQ_BOOLEAN_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_BOOLEAN_IMPL))
#define GUPPI_IS_SEQ_BOOLEAN_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_BOOLEAN_IMPL(obj)))
#define GUPPI_IS_SEQ_BOOLEAN_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_BOOLEAN_IMPL))

GtkType guppi_seq_boolean_impl_get_type(void);

GtkObject* guppi_seq_boolean_impl_new(void);



#endif /* _INC_GUPPI_SEQ_BOOLEAN_IMPL_H */

/* $Id: guppi-seq-boolean-impl.h,v 1.2 2000/02/21 18:31:36 trow Exp $ */
