/* This is -*- C -*- */
/* $Id: guppi-axis-state.h,v 1.1 2000/04/07 18:32:41 trow Exp $ */

/*
 * guppi-axis-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_AXIS_STATE_H
#define _INC_GUPPI_AXIS_STATE_H

#include <config.h>
#include <gnome.h>
#include <libgnomeprint/gnome-font.h>

#include <guppi-item-state.h>
#include <guppi-seq-scalar.h>

typedef enum _GuppiAxisType GuppiAxisType;
enum _GuppiAxisType {
  AXIS_NORTH,
  AXIS_SOUTH,
  AXIS_EAST,
  AXIS_WEST
};

typedef struct _GuppiAxisState GuppiAxisState;
typedef struct _GuppiAxisStateClass GuppiAxisStateClass;

struct _GuppiAxisState {
  GuppiItemState parent;

  GuppiAxisType type;
  GuppiSeqScalar* data;
  GnomeFont* default_font;
};

struct _GuppiAxisStateClass {
  GuppiItemStateClass parent_class;
};

#define GUPPI_TYPE_AXIS_STATE (guppi_axis_state_get_type())
#define GUPPI_AXIS_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_AXIS_STATE,GuppiAxisState))
#define GUPPI_AXIS_STATE0(obj) ((obj) ? (GUPPI_AXIS_STATE(obj)) : NULL)
#define GUPPI_AXIS_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_AXIS_STATE,GuppiAxisStateClass))
#define GUPPI_IS_AXIS_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_AXIS_STATE))
#define GUPPI_IS_AXIS_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_AXIS_STATE(obj)))
#define GUPPI_IS_AXIS_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_AXIS_STATE))

GtkType guppi_axis_state_get_type(void);

GuppiAxisState* guppi_axis_state_new(void);



#endif /* _INC_GUPPI_AXIS_STATE_H */

/* $Id: guppi-axis-state.h,v 1.1 2000/04/07 18:32:41 trow Exp $ */
