/* This is -*- C -*- */
/* $Id: guppi-axis-state.c,v 1.1 2000/04/07 18:32:41 trow Exp $ */

/*
 * guppi-axis-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <math.h>
#include "guppi-axis-state.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_axis_state_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_axis_state_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_axis_state_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_axis_state_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_axis_state_class_init(GuppiAxisStateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GUPPI_TYPE_ITEM_STATE);

  object_class->get_arg = guppi_axis_state_get_arg;
  object_class->set_arg = guppi_axis_state_set_arg;
  object_class->destroy = guppi_axis_state_destroy;
  object_class->finalize = guppi_axis_state_finalize;

}

static void
guppi_axis_state_init(GuppiAxisState* obj)
{

}

GtkType
guppi_axis_state_get_type(void)
{
  static GtkType guppi_axis_state_type = 0;
  if (!guppi_axis_state_type) {
    static const GtkTypeInfo guppi_axis_state_info = {
      "GuppiAxisState",
      sizeof(GuppiAxisState),
      sizeof(GuppiAxisStateClass),
      (GtkClassInitFunc)guppi_axis_state_class_init,
      (GtkObjectInitFunc)guppi_axis_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_axis_state_type = gtk_type_unique(GUPPI_TYPE_ITEM_STATE, &guppi_axis_state_info);
  }
  return guppi_axis_state_type;
}

GuppiAxisState*
guppi_axis_state_new(void)
{
  return GUPPI_AXIS_STATE(gtk_type_new(guppi_axis_state_get_type()));
}

/* $Id: guppi-axis-state.c,v 1.1 2000/04/07 18:32:41 trow Exp $ */
