/* This is -*- C -*- */
/* $Id: guppi-axis-element.h,v 1.1 2000/04/07 18:32:41 trow Exp $ */

/*
 * guppi-axis-element.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_AXIS_ELEMENT_H
#define _INC_GUPPI_AXIS_ELEMENT_H

#include <config.h>
#include <gnome.h>

#include <guppi-plot-element.h>
#include "guppi-axis-state.h"

typedef struct _GuppiAxisElement GuppiAxisElement;
typedef struct _GuppiAxisElementClass GuppiAxisElementClass;

struct _GuppiAxisElement {
  GuppiPlotElement parent;

  GuppiAxisState* state;
};

struct _GuppiAxisElementClass {
  GuppiPlotElementClass parent_class;
};

#define GUPPI_TYPE_AXIS_ELEMENT (guppi_axis_element_get_type())
#define GUPPI_AXIS_ELEMENT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_AXIS_ELEMENT,GuppiAxisElement))
#define GUPPI_AXIS_ELEMENT0(obj) ((obj) ? (GUPPI_AXIS_ELEMENT(obj)) : NULL)
#define GUPPI_AXIS_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_AXIS_ELEMENT,GuppiAxisElementClass))
#define GUPPI_IS_AXIS_ELEMENT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_AXIS_ELEMENT))
#define GUPPI_IS_AXIS_ELEMENT0(obj) (((obj) == NULL) || (GUPPI_IS_AXIS_ELEMENT(obj)))
#define GUPPI_IS_AXIS_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_AXIS_ELEMENT))

GtkType guppi_axis_element_get_type(void);

GuppiPlotElement* guppi_axis_element_new(void);
GuppiPlotElement* guppi_axis_element_new_with_state(GuppiAxisState*);



#endif /* _INC_GUPPI_AXIS_ELEMENT_H */

/* $Id: guppi-axis-element.h,v 1.1 2000/04/07 18:32:41 trow Exp $ */
