/* This is -*- C -*- */
/* $Id: guppi-plot-tool.c,v 1.4 2000/03/07 15:42:32 trow Exp $ */

/*
 * guppi-plot-tool.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-plot-tool.h"
#include "guppi-plot-element.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_plot_tool_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_tool_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_tool_destroy(GtkObject* obj)
{
  GuppiPlotTool* tool;

  tool = GUPPI_PLOT_TOOL(obj);

  g_free((gchar*)tool->name);
  tool->name = NULL;

  if (tool->cursor) {
    gdk_cursor_destroy(tool->cursor);
    tool->cursor = NULL;
  }

  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_plot_tool_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_plot_tool_class_init(GuppiPlotToolClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_plot_tool_get_arg;
  object_class->set_arg = guppi_plot_tool_set_arg;
  object_class->destroy = guppi_plot_tool_destroy;
  object_class->finalize = guppi_plot_tool_finalize;

}

static void
guppi_plot_tool_init(GuppiPlotTool* obj)
{
  obj->cue_type = GPTPC_NONE;
  obj->cue_fill_color = 0x0000ff30;
}

GtkType
guppi_plot_tool_get_type(void)
{
  static GtkType guppi_plot_tool_type = 0;
  if (!guppi_plot_tool_type) {
    static const GtkTypeInfo guppi_plot_tool_info = {
      "GuppiPlotTool",
      sizeof(GuppiPlotTool),
      sizeof(GuppiPlotToolClass),
      (GtkClassInitFunc)guppi_plot_tool_class_init,
      (GtkObjectInitFunc)guppi_plot_tool_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_plot_tool_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_plot_tool_info);
  }
  return guppi_plot_tool_type;
}

GuppiPlotTool*
guppi_plot_tool_new(void)
{
  return GUPPI_PLOT_TOOL(gtk_type_new(guppi_plot_tool_get_type()));
}

/****************************************************************************/

/* Some generic tools */

static void
rescale_cb(GuppiPlotTool* tool, GuppiCanvasItem* gci)
{
  guppi_canvas_item_rescale_around_point(gci, tool->x, tool->y, tool->arg1);
}

GuppiPlotTool*
guppi_plot_tool_new_rescale(double scale)
{
  GuppiPlotTool* tool;
  
  g_return_val_if_fail(scale > 0, NULL);

  tool = guppi_plot_tool_new();
  tool->name = g_strdup(_("Rescale"));
  tool->acts_on = GUPPI_TYPE_PLOT_ELEMENT;
  tool->cursor = gdk_cursor_new(GDK_CROSSHAIR);
  tool->tracks_motion = TRUE;
  tool->repeating = TRUE;
  tool->repeat_interval = 100;
  tool->arg1 = scale;
  tool->first = tool->repeat = rescale_cb;

  return tool;
}

static void
recenter_cb(GuppiPlotTool* tool, GuppiCanvasItem* gci)
{
  guppi_canvas_item_recenter_around_point(gci, tool->x, tool->y);
}

GuppiPlotTool*
guppi_plot_tool_new_recenter(void)
{
  GuppiPlotTool* tool;

  tool = guppi_plot_tool_new();
  tool->name = g_strdup(_("Recenter"));
  tool->acts_on = GUPPI_TYPE_PLOT_ELEMENT;
  tool->tracks_motion = FALSE;
  tool->repeating = FALSE;
  tool->first = recenter_cb;

  return tool;
}

static void
drag_cb(GuppiPlotTool* tool, GuppiCanvasItem* gci)
{
  double x0, x1, y0, y1;

  /* We need to do it this way to avoid a jittery effect. */
  guppi_canvas_item_world2plot(gci,tool->raw_prev_x,tool->raw_prev_y,&x0,&y0);
  guppi_canvas_item_world2plot(gci, tool->raw_x, tool->raw_y, &x1, &y1);

  guppi_canvas_item_translate(gci, x0-x1, y0-y1);
}

GuppiPlotTool*
guppi_plot_tool_new_drag(void)
{
  GuppiPlotTool* tool;

  tool = guppi_plot_tool_new();
  tool->name = g_strdup(_("Drag"));
  tool->acts_on = GUPPI_TYPE_PLOT_ELEMENT;
  tool->cursor = gdk_cursor_new(GDK_FLEUR);
  tool->tracks_motion = TRUE;
  tool->repeating = FALSE;
  tool->middle = drag_cb;
  
  return tool;
}

static void
reframe_cb(GuppiPlotTool* tool, GuppiCanvasItem* gci)
{
  /*
    Reframe only if our selected rectangle is sufficiently large.
    (We do this to avoid zooming in really, really close due to a
    stray click.
  */
  if (abs(tool->raw_start_x - tool->raw_x) > 3 &&
      abs(tool->raw_start_y - tool->raw_y) > 3)
    guppi_canvas_item_set_scales(gci,
				 MIN(tool->start_x, tool->x),
				 MIN(tool->start_y, tool->y),
				 MAX(tool->start_x, tool->x),
				 MAX(tool->start_y, tool->y));
}

GuppiPlotTool*
guppi_plot_tool_new_reframe(void)
{
  GuppiPlotTool* tool;

  tool = guppi_plot_tool_new();
  tool->name = g_strdup(_("Reframe"));
  tool->acts_on = GUPPI_TYPE_PLOT_ELEMENT;
  tool->cursor = gdk_cursor_new(GDK_SIZING);
  tool->tracks_motion = FALSE;
  tool->cue_type = GPTPC_FRAME;
  tool->repeating = FALSE;
  tool->last = reframe_cb;

  return tool;
}


/* $Id: guppi-plot-tool.c,v 1.4 2000/03/07 15:42:32 trow Exp $ */
