/* This is -*- C -*- */
/* $Id: guppi-data-impl.h,v 1.1 2000/02/09 21:04:56 trow Exp $ */

/*
 * guppi-data-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_IMPL_H
#define _INC_GUPPI_DATA_IMPL_H

#include <config.h>
#include <gnome.h>

typedef struct _GuppiDataImpl GuppiDataImpl;
typedef struct _GuppiDataImplClass GuppiDataImplClass;

typedef gpointer (*GuppiDataImplHook)(GuppiDataImpl*, gpointer);

struct _GuppiDataImpl {
  GtkObject parent;
};

struct _GuppiDataImplClass {
  GtkObjectClass parent_class;
  
  const gchar* impl_name;
  GHashTable* hooks;

  /* virtual functions */
  GuppiDataImpl* (*copy)(GuppiDataImpl*);
  gint (*get_size_in_bytes)(GuppiDataImpl*);
  void (*get_size_info)(GuppiDataImpl*, gchar*, gsize);
};

#define GUPPI_TYPE_DATA_IMPL (guppi_data_impl_get_type())
#define GUPPI_DATA_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATA_IMPL,GuppiDataImpl))
#define GUPPI_DATA_IMPL0(obj) ((obj) ? (GUPPI_DATA_IMPL(obj)) : NULL)
#define GUPPI_DATA_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATA_IMPL,GuppiDataImplClass))
#define GUPPI_IS_DATA_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATA_IMPL))
#define GUPPI_IS_DATA_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_DATA_IMPL(obj)))
#define GUPPI_IS_DATA_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATA_IMPL))

GtkType guppi_data_impl_get_type(void);

const gchar* guppi_data_impl_get_impl_name(const GuppiDataImpl*);

gboolean guppi_data_impl_has_hook(const GuppiDataImpl*, const gchar*);
gpointer guppi_data_impl_call_hook(GuppiDataImpl*, const gchar*, gpointer);
void guppi_data_impl_class_add_hook(GuppiDataImplClass*, const gchar*,
				    GuppiDataImplHook);

#endif /* _INC_GUPPI_DATA_IMPL_H */

/* $Id: guppi-data-impl.h,v 1.1 2000/02/09 21:04:56 trow Exp $ */
