/* This is -*- C -*- */
/* $Id: guppi-slinreg-item.c,v 1.4 2000/03/09 23:00:17 trow Exp $ */

/*
 * guppi-slinreg-item.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <libart_lgpl/art_svp.h>
#include "guppi-slinreg-item.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0,
  ARG_STATE
};

static void
guppi_slinreg_item_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  }
}

static void
guppi_slinreg_item_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {
  case ARG_STATE:
    guppi_canvas_item_set_state(GUPPI_CANVAS_ITEM(obj),
				GUPPI_ITEM_STATE(GTK_VALUE_POINTER(*arg)));
    break;

  default:
    break;
  }
}

static void
guppi_slinreg_item_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_slinreg_item_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}


static void
guppi_slinreg_item_class_init(GuppiSlinregItemClass* klass)
{
  static void guppi_slinreg_item_update(GnomeCanvasItem*, double affine[6],
					ArtSVP*, gint);
  static void guppi_slinreg_item_render(GnomeCanvasItem*, GnomeCanvasBuf*);
  static void state_set_hook(GuppiCanvasItem*, GuppiItemState*);

  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GnomeCanvasItemClass* item_class = GNOME_CANVAS_ITEM_CLASS(klass);
  GuppiCanvasItemClass* gci_class = GUPPI_CANVAS_ITEM_CLASS(klass);
 
  parent_class = gtk_type_class(GUPPI_TYPE_CANVAS_ITEM);

  gtk_object_add_arg_type("GuppiSlinregItem::state",
			  GTK_TYPE_POINTER,
			  GTK_ARG_WRITABLE,
			  ARG_STATE);

  object_class->get_arg = guppi_slinreg_item_get_arg;
  object_class->set_arg = guppi_slinreg_item_set_arg;
  object_class->destroy = guppi_slinreg_item_destroy;
  object_class->finalize = guppi_slinreg_item_finalize;

  item_class->update = guppi_slinreg_item_update;
  item_class->render = guppi_slinreg_item_render;

  gci_class->state_set_hook = state_set_hook;
}

static void
guppi_slinreg_item_init(GuppiSlinregItem* obj)
{
  GuppiCanvasItem* gci = GUPPI_CANVAS_ITEM(obj);

  gci->bb_passive = TRUE;
  gci->bb_x0 = gci->bb_x1 = gci->bb_y0 = gci->bb_y1 = 0;
}

GtkType
guppi_slinreg_item_get_type(void)
{
  static GtkType guppi_slinreg_item_type = 0;
  if (!guppi_slinreg_item_type) {
    static const GtkTypeInfo guppi_slinreg_item_info = {
      "GuppiSlinregItem",
      sizeof(GuppiSlinregItem),
      sizeof(GuppiSlinregItemClass),
      (GtkClassInitFunc)guppi_slinreg_item_class_init,
      (GtkObjectInitFunc)guppi_slinreg_item_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_slinreg_item_type = gtk_type_unique(GUPPI_TYPE_CANVAS_ITEM, &guppi_slinreg_item_info);
  }
  return guppi_slinreg_item_type;
}

/*****************************************************************************/

static void
guppi_slinreg_item_update(GnomeCanvasItem* item, double affine[6],
			  ArtSVP* clip_path, gint flags)
{
  GuppiCanvasItem* gci;
  GuppiSlinregItem* si;
  GuppiSlinregState* state =
    GUPPI_SLINREG_STATE(guppi_canvas_item_state(GUPPI_CANVAS_ITEM(item)));
  ArtVpath linepath[3];
  ArtSVP* svp;
  double x0, x1, y0, y1;
  double wx0, wx1, wy0, wy1;
  double xspan, scale;

  /* Chain our calls to update */
  if (parent_class && GNOME_CANVAS_ITEM_CLASS(parent_class)->update)
    GNOME_CANVAS_ITEM_CLASS(parent_class)->update(item,affine,clip_path,flags);

  gci = GUPPI_CANVAS_ITEM(item);
  si = GUPPI_SLINREG_ITEM(item);

  if (state && state->slr && state->slr->valid) {

    scale = guppi_canvas_item_magnification(gci);

    xspan = fabs(gci->x1 - gci->x0);
    /* Put the endpoints of the line we draw just outside of our view. */
    x0 = gci->x0 - 0.1*xspan;
    x1 = gci->x1 + 0.1*xspan;
    y0 = state->slr->slope * x0 + state->slr->intercept;
    y1 = state->slr->slope * x1 + state->slr->intercept;

    guppi_canvas_item_plot2world(gci, x0, y0, &wx0, &wy0);
    guppi_canvas_item_plot2world(gci, x1, y1, &wx1, &wy1);

    linepath[0].code = ART_MOVETO;
    linepath[0].x = wx0;
    linepath[0].y = wy0;

    linepath[1].code = ART_LINETO;
    linepath[1].x = wx1;
    linepath[1].y = wy1;

    linepath[2].code = ART_END;
    linepath[2].x = 0;
    linepath[2].y = 0;

    svp = art_svp_vpath_stroke(linepath,
			       ART_PATH_STROKE_JOIN_ROUND,
			       ART_PATH_STROKE_CAP_ROUND,
			       scale * state->line_width,
			       4, 0.25);

    /* Notice that I'm ignoring the affine.
       That is probably not a good idea. */
  
    gnome_canvas_item_update_svp_clip (item, &si->line_svp, svp, clip_path);
  }

  guppi_canvas_item_request_total_redraw(GUPPI_CANVAS_ITEM(item));  
}

static void
guppi_slinreg_item_render(GnomeCanvasItem* item,
			  GnomeCanvasBuf* buf)
{
  GuppiSlinregItem* si;
  GuppiSlinregState* state;

  /* Chain our calls to render */
  if (parent_class && GNOME_CANVAS_ITEM_CLASS(parent_class)->render)
    GNOME_CANVAS_ITEM_CLASS(parent_class)->render(item, buf);

  si = GUPPI_SLINREG_ITEM(item);
  state = GUPPI_SLINREG_STATE(guppi_canvas_item_state(GUPPI_CANVAS_ITEM(si)));

  /* This is nice and easy. */
  if (si->line_svp != NULL) // && si->state != NULL)
    gnome_canvas_render_svp(buf,
			    si->line_svp,
			    state->line_color);
}

static void
state_set_hook(GuppiCanvasItem* item, GuppiItemState* state)
{
  GuppiSlinregItem* si = GUPPI_SLINREG_ITEM(item);
  GuppiSlinregState* ss = GUPPI_SLINREG_STATE(state);

  g_return_if_fail(si != NULL);
  g_return_if_fail(ss != NULL);


  gtk_signal_connect_object(GTK_OBJECT(ss),
			    "reset_x_data",
			    GTK_SIGNAL_FUNC(guppi_canvas_item_request_update),
			    GTK_OBJECT(si));

  gtk_signal_connect_object(GTK_OBJECT(ss),
			    "reset_y_data",
			    GTK_SIGNAL_FUNC(guppi_canvas_item_request_update),
			    GTK_OBJECT(si));

  gtk_signal_connect_object(GTK_OBJECT(ss),
			    "changed_x_data",
			    GTK_SIGNAL_FUNC(guppi_canvas_item_request_update),
			    GTK_OBJECT(si));

  gtk_signal_connect_object(GTK_OBJECT(ss),
			    "changed_y_data",
			    GTK_SIGNAL_FUNC(guppi_canvas_item_request_update),
			    GTK_OBJECT(si));

}


/* $Id: guppi-slinreg-item.c,v 1.4 2000/03/09 23:00:17 trow Exp $ */
