/* This is -*- C -*- */
/* $Id: guppi-slinreg-element.c,v 1.3 2000/03/09 23:00:17 trow Exp $ */

/*
 * guppi-slinreg-element.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-slinreg-item.h"
#include "guppi-slinreg-element.h"
#include "guppi-slinreg-statviewer.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_slinreg_element_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_slinreg_element_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_slinreg_element_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_slinreg_element_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

/*****************************************************************************/

static GtkWidget*
make_state_widget(GuppiPlotElement* gpe)
{
  GuppiSlinregElement* gse = GUPPI_SLINREG_ELEMENT(gpe);

  return guppi_slinreg_statviewer_new(gse->state->slr);
}

static GuppiCanvasItem*
make_canvas_item(GuppiPlotElement* gpe, GnomeCanvas* canv,
		 double x1, double y1, double x2, double y2)
{
  GnomeCanvasItem* ci;

  ci = gnome_canvas_item_new(gnome_canvas_root(canv),
			     guppi_slinreg_item_get_type(),
			     "x1", x1, "y1", y1,
			     "x2", x2, "y2", y2,
			     "state", GUPPI_SLINREG_ELEMENT(gpe)->state,
			     NULL);

  return GUPPI_CANVAS_ITEM(ci);
}

static void
guppi_slinreg_element_class_init(GuppiSlinregElementClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiPlotElementClass* pe_class = GUPPI_PLOT_ELEMENT_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_PLOT_ELEMENT);

  pe_class->type_name = _("simple linear regression");
  pe_class->make_canvas_item = make_canvas_item;
  pe_class->make_state_widget = make_state_widget;

  object_class->get_arg = guppi_slinreg_element_get_arg;
  object_class->set_arg = guppi_slinreg_element_set_arg;
  object_class->destroy = guppi_slinreg_element_destroy;
  object_class->finalize = guppi_slinreg_element_finalize;
}

static void
guppi_slinreg_element_init(GuppiSlinregElement* obj)
{
  obj->state = GUPPI_SLINREG_STATE(guppi_slinreg_state_new());
}

GtkType
guppi_slinreg_element_get_type(void)
{
  static GtkType guppi_slinreg_element_type = 0;
  if (!guppi_slinreg_element_type) {
    static const GtkTypeInfo guppi_slinreg_element_info = {
      "GuppiSlinregElement",
      sizeof(GuppiSlinregElement),
      sizeof(GuppiSlinregElementClass),
      (GtkClassInitFunc)guppi_slinreg_element_class_init,
      (GtkObjectInitFunc)guppi_slinreg_element_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_slinreg_element_type = gtk_type_unique(GUPPI_TYPE_PLOT_ELEMENT, &guppi_slinreg_element_info);
  }
  return guppi_slinreg_element_type;
}

GuppiPlotElement*
guppi_slinreg_element_new(void)
{
  return GUPPI_PLOT_ELEMENT(gtk_type_new(guppi_slinreg_element_get_type()));
}

GuppiPlotElement*
guppi_slinreg_element_new_with_state(GuppiSlinregState* state)
{
  GuppiPlotElement* e;
  g_return_val_if_fail(state != NULL, NULL);

  e = guppi_slinreg_element_new();
  g_error("State arg ignored!");
  return e;
}



/* $Id: guppi-slinreg-element.c,v 1.3 2000/03/09 23:00:17 trow Exp $ */
