/* This is -*- C -*- */
/* $Id: guppi-seq-date.c,v 1.1 2000/02/21 18:32:54 trow Exp $ */

/*
 * guppi-seq-date.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-seq-date.h"
#include "guppi-seq-date-impl.h"
#include "guppi-seq-date-core-impl.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_date_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_date_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_date_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_seq_date_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_seq_date_class_init(GuppiSeqDateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiDataClass* data_class = GUPPI_DATA_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_SEQ);

  data_class->default_impl = GUPPI_TYPE_SEQ_DATE_CORE_IMPL;
  data_class->type_name = _("Date Sequence");

  object_class->get_arg = guppi_seq_date_get_arg;
  object_class->set_arg = guppi_seq_date_set_arg;
  object_class->destroy = guppi_seq_date_destroy;
  object_class->finalize = guppi_seq_date_finalize;

}

static void
guppi_seq_date_init(GuppiSeqDate* obj)
{

}

GtkType
guppi_seq_date_get_type(void)
{
  static GtkType guppi_seq_date_type = 0;
  if (!guppi_seq_date_type) {
    static const GtkTypeInfo guppi_seq_date_info = {
      "GuppiSeqDate",
      sizeof(GuppiSeqDate),
      sizeof(GuppiSeqDateClass),
      (GtkClassInitFunc)guppi_seq_date_class_init,
      (GtkObjectInitFunc)guppi_seq_date_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_seq_date_type = gtk_type_unique(GUPPI_TYPE_SEQ, &guppi_seq_date_info);
  }
  return guppi_seq_date_type;
}

GuppiData*
guppi_seq_date_new(void)
{
  return GUPPI_DATA(gtk_type_new(guppi_seq_date_get_type()));
}

const GDate*
guppi_seq_date_get(const GuppiSeqDate* seq, gint i)
{
  const GuppiSeqDateImpl* impl;
  GuppiSeqDateImplClass* impl_class;

  g_return_val_if_fail(seq != NULL, NULL);
  g_return_val_if_fail(guppi_seq_in_bounds(GUPPI_SEQ(seq), i), NULL);

  impl = GUPPI_SEQ_DATE_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_DATE_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->set != NULL);
  return (impl_class->get)(impl, i);
}

void
guppi_seq_date_set(GuppiSeqDate* seq, gint i, const GDate* dt)
{
  GuppiSeqDateImpl* impl;
  GuppiSeqDateImplClass* impl_class;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(dt != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));
  g_return_if_fail(guppi_seq_in_bounds(GUPPI_SEQ(seq), i));

  impl = GUPPI_SEQ_DATE_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_DATE_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->set != NULL);
  (impl_class->set)(impl, i, dt);
}

void
guppi_seq_date_prepend(GuppiSeqDate* seq, const GDate* dt)
{
  gint first;
  first = guppi_seq_min_index(GUPPI_SEQ(seq));
  guppi_seq_date_insert(seq, first, dt);
}

void
guppi_seq_date_append(GuppiSeqDate* seq, const GDate* dt)
{
  gint last;
  last = guppi_seq_max_index(GUPPI_SEQ(seq));
  guppi_seq_date_insert(seq, last+1, dt);
}

void
guppi_seq_date_insert(GuppiSeqDate* seq, gint i, const GDate* dt)
{
  GuppiSeqDateImpl* impl;
  GuppiSeqDateImplClass* impl_class;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(dt != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  impl = GUPPI_SEQ_DATE_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_DATE_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->insert != NULL);
  (impl_class->insert)(impl, i, dt);
}

const GDate*
guppi_seq_date_min(const GuppiSeqDate* seq)
{
  const GuppiSeqDateImpl* impl;
  GuppiSeqDateImplClass* impl_class;

  g_return_val_if_fail(seq != NULL, NULL);

  impl = GUPPI_SEQ_DATE_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_DATE_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->min != NULL);
  return (impl_class->min)(impl);
}

const GDate*
guppi_seq_date_max(const GuppiSeqDate* seq)
{
  const GuppiSeqDateImpl* impl;
  GuppiSeqDateImplClass* impl_class;

  g_return_val_if_fail(seq != NULL, NULL);

  impl = GUPPI_SEQ_DATE_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_DATE_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  g_assert(impl_class->max != NULL);
  return (impl_class->max)(impl);
}


/* $Id: guppi-seq-date.c,v 1.1 2000/02/21 18:32:54 trow Exp $ */
