/* This is -*- C -*- */
/* $Id: guppi-plot-element.h,v 1.3 2000/02/18 06:49:40 trow Exp $ */

/*
 * guppi-plot-element.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLOT_ELEMENT_H
#define _INC_GUPPI_PLOT_ELEMENT_H

#include <config.h>
#include <gnome.h>
#include <guppi-canvas-item.h>

typedef struct _GuppiPlotElement GuppiPlotElement;
typedef struct _GuppiPlotElementClass GuppiPlotElementClass;

struct _GuppiPlotElement {
  GtkObject parent;

  gboolean visible;
  gchar* label;
};

struct _GuppiPlotElementClass {
  GtkObjectClass parent_class;

  /* virtual data/functions */
  const gchar* type_name;
  GuppiCanvasItem* (*make_canvas_item)(GuppiPlotElement*,
				       GnomeCanvas*,
				       double,double,double,double);
  GtkWidget* (*make_state_widget)(GuppiPlotElement*);

  /* signal functions */
  void (*changed_label)(GuppiPlotElement*);
  void (*show)(GuppiPlotElement*);
  void (*hide)(GuppiPlotElement*);
  void (*raise_or_lower)(GuppiPlotElement*, gint);
  void (*update)(GuppiPlotElement*);

};

#define GUPPI_TYPE_PLOT_ELEMENT (guppi_plot_element_get_type())
#define GUPPI_PLOT_ELEMENT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLOT_ELEMENT,GuppiPlotElement))
#define GUPPI_PLOT_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLOT_ELEMENT,GuppiPlotElementClass))
#define GUPPI_IS_PLOT_ELEMENT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLOT_ELEMENT))
#define GUPPI_IS_PLOT_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLOT_ELEMENT))

GtkType guppi_plot_element_get_type(void);

/* virtual constructor */
GuppiPlotElement* guppi_plot_element_new(const gchar* name);

const gchar* guppi_plot_element_type_name(GuppiPlotElement*);
const gchar* guppi_plot_element_label(GuppiPlotElement*);
void guppi_plot_element_set_label(GuppiPlotElement*, const gchar*);

GuppiCanvasItem* guppi_plot_element_make_canvas_item(GuppiPlotElement*,
						     GnomeCanvas*,
						     double x1, double y1,
						     double x2, double y2);
GtkWidget* guppi_plot_element_make_state_editor(GuppiPlotElement*);

void guppi_plot_element_show(GuppiPlotElement*);
void guppi_plot_element_hide(GuppiPlotElement*);
void guppi_plot_element_set_visible(GuppiPlotElement*, gboolean);
void guppi_plot_element_reverse_visibility(GuppiPlotElement*);

void guppi_plot_element_raise(GuppiPlotElement*, gint);
void guppi_plot_element_raise_to_top(GuppiPlotElement*);
void guppi_plot_element_lower(GuppiPlotElement*, gint);
void guppi_plot_element_lower_to_bottom(GuppiPlotElement*);
void guppi_plot_element_request_update(GuppiPlotElement*);
						
/* Functions useful for debugging/experimentation... */
void guppi_plot_element_edit(GuppiPlotElement*);



#endif /* _INC_GUPPI_PLOT_ELEMENT_H */

/* $Id: guppi-plot-element.h,v 1.3 2000/02/18 06:49:40 trow Exp $ */
