/* This is -*- C -*- */
/* $Id: guppi-canvas-item.h,v 1.5 2000/02/06 03:14:54 trow Exp $ */

/*
 * guppi-canvas-item.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CANVAS_ITEM_H
#define _INC_GUPPI_CANVAS_ITEM_H

#include <config.h>
#include <gnome.h>
#include "transform.h"
#include "guppi-bounder.h"
#include "guppi-item-state.h"

typedef struct _GuppiCanvasItem GuppiCanvasItem;
typedef struct _GuppiCanvasItemClass GuppiCanvasItemClass;

struct _GuppiCanvasItem {
  GnomeCanvasItem canvas_item;

  /* Bounding box of object in world & canvas coordinates. */
  double wx0, wy0, wx1, wy1;
  gint cx0, cy0, cx1, cy1;

  /* x- and y-ranges of plot coordinates. */
  double x0, y0, x1, y1;

  /* "Full window" x- and y- ranges of plot coordinates */
  double full_x0, full_y0, full_x1, full_y1;

  /* plot <-> pixel coordinate transformers */
  Transform* x_transform;
  Transform* y_transform;

  gboolean expecting_double_bound_change;
  GuppiBounder* x_bounder;
  GuppiBounder* y_bounder;
  guint x_bnd_sh, y_bnd_sh;

  GuppiItemState* state;
};

struct _GuppiCanvasItemClass {
  GnomeCanvasItemClass parent_class;

  void (*resized)(GnomeCanvasItem*, double wx0, double wy0, double wx1, double wy1);
  void (*rescaled)(GnomeCanvasItem*, double x0, double y0, double x1, double y1);
  void (*rescaled_x)(GnomeCanvasItem*, double x0, double x1);
  void (*rescaled_y)(GnomeCanvasItem*, double y0, double y1);
  
};

#define GUPPI_TYPE_CANVAS_ITEM (guppi_canvas_item_get_type())
#define GUPPI_CANVAS_ITEM(obj) (GTK_CHECK_CAST((obj), \
                                   GUPPI_TYPE_CANVAS_ITEM, \
                                   GuppiCanvasItem))
#define GUPPI_CANVAS_ITEM_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), \
                                           GUPPI_TYPE_CANVAS_ITEM, \
                                           GuppiCanvasItemClass))
#define GUPPI_IS_CANVAS_ITEM(obj) (GTK_CHECK_TYPE((obj), \
                                      GUPPI_TYPE_CANVAS_Item))
#define GUPPI_IS_CANVAS_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
                                              GUPPI_TYPE_CANVAS_ITEM))

GtkType guppi_canvas_item_get_type(void);

void guppi_canvas_item_set_state(GuppiCanvasItem*, GuppiItemState*);

void guppi_canvas_item_set_x_bounds(GuppiCanvasItem*, double x0, double x1);
void guppi_canvas_item_set_y_bounds(GuppiCanvasItem*, double y0, double y1);
void guppi_canvas_item_set_bounds(GuppiCanvasItem*,
				  double x0, double y0,
				  double x1, double y1);

void guppi_canvas_item_set_x_scale(GuppiCanvasItem*, double x0, double x1);
void guppi_canvas_item_set_y_scale(GuppiCanvasItem*, double y0, double y1);
void guppi_canvas_item_set_scales(GuppiCanvasItem*,
				  double x0, double y0,
				  double x1, double y1);
void guppi_canvas_item_rescale_around_point(GuppiCanvasItem*,
					    double x, double y,
					    double factor);
void guppi_canvas_item_recenter_around_point(GuppiCanvasItem*,
					     double x, double y);

void guppi_canvas_item_set_x_bounder(GuppiCanvasItem*, GuppiBounder*);
void guppi_canvas_item_set_y_bounder(GuppiCanvasItem*, GuppiBounder*);

double guppi_canvas_item_x_magnification(const GuppiCanvasItem*);
double guppi_canvas_item_y_magnification(const GuppiCanvasItem*);

void guppi_canvas_item_plot2pixel(const GuppiCanvasItem*,
				  double x, double y,
				  gint* cx, gint* cy);
    
void guppi_canvas_item_pixel2plot(const GuppiCanvasItem*,
				  gint cx, gint cy,
				  double* x, double* y);

/* Convert canvas "world" coordinates to plot coordinates, and vis versa */
void guppi_canvas_item_world2plot(const GuppiCanvasItem*,
				  double wx, double wy,
				  double* x, double* y);
void guppi_canvas_item_plot2world(const GuppiCanvasItem*,
				  double wx, double wy,
				  double* x, double* y);

void guppi_canvas_item_request_redraw(GuppiCanvasItem*,
				      double x0, double y0,
				      double x1, double y1);
void guppi_canvas_item_request_total_redraw(GuppiCanvasItem*);

void guppi_canvas_item_request_update(GuppiCanvasItem*);

#endif /* _INC_GUPPI_CANVAS_ITEM_H */

/* $Id: guppi-canvas-item.h,v 1.5 2000/02/06 03:14:54 trow Exp $ */
