/* $Id: guppi-scm-scatter-state.c,v 1.2 2000/01/21 07:55:32 trow Exp $ */

/*
 * guppi-scm-scatter-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scm-scatter-state.h"
#include "guppi-scatter-state-control.h"

static long scatstate_type_tag;

#define SCM_TO_SCATTER_STATE(x) (GUPPI_SCATTER_STATE(SCM_CDR(x)))
#define SCM_SCATTER_STATE_P(x) (SCM_NIMP(x) && SCM_CAR(x) == scatstate_type_tag)

gboolean
scm_scatter_state_p(SCM x)
{
  return SCM_SCATTER_STATE_P(x);
}

SCM
scatter_state2scm(GuppiScatterState* x)
{
  SCM smob;

  SCM_DEFER_INTS;
  SCM_NEWCELL(smob);
  SCM_SETCAR(smob, scatstate_type_tag);
  SCM_SETCDR(smob, x);
  gtk_object_ref(GTK_OBJECT(x));
  SCM_ALLOW_INTS;

  return smob;
}

GuppiScatterState*
scm2scatter_state(SCM x)
{
  return SCM_SCATTER_STATE_P(x) ? SCM_TO_SCATTER_STATE(x) : NULL;
}

/*****************************************************************************/

GUPPI_PROC(sst, "scatter-state?",
           1,0,0, (SCM x))
{
  return gh_bool2scm(SCM_SCATTER_STATE_P(x));
}

GUPPI_PROC(sst_new, "make-scatter-state",
           0,0,0, ())
{
  return scatter_state2scm(guppi_scatter_state_new());
}

GUPPI_PROC(sst_edit, "edit-scatter-state",
	   1,0,0, (SCM x))
{
  GtkWidget* win;
  GtkWidget* control;

  SCM_ASSERT(SCM_SCATTER_STATE_P(x), x, SCM_ARG1, str_sst_edit);

  win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  control = guppi_scatter_state_control_new(SCM_TO_SCATTER_STATE(x));
  gtk_container_add(GTK_CONTAINER(win), control);
  gtk_widget_show(win);
  gtk_widget_show(control);
  return SCM_UNSPECIFIED;
}

#include <guppi-plot-window.h>
#include <guppi-plot-state.h>
#include "guppi-scatter-element.h"
GUPPI_PROC(sst_view, "view-scatter-state",
	   1,0,0, (SCM x))
{
  GtkWidget* win;
  GtkWidget* control;
  GuppiPlotState* plot_state;
  GuppiPlotElement* elem;

  SCM_ASSERT(SCM_SCATTER_STATE_P(x), x, SCM_ARG1, str_sst_edit);

  plot_state = GUPPI_PLOT_STATE(guppi_plot_state_new());

  elem = guppi_scatter_element_new_with_state(SCM_TO_SCATTER_STATE(x));
  guppi_plot_state_add_element(plot_state, elem);

  win = guppi_plot_window_new(plot_state);
  gtk_widget_show_all(win);

  return SCM_UNSPECIFIED;
}


/*****************************************************************************/

static SCM
mark_data(SCM x)
{
  return SCM_BOOL_F;
}

static scm_sizet
free_data(SCM x)
{
  GuppiScatterState* d = SCM_TO_SCATTER_STATE(x);

  SCM_DEFER_INTS;
  gtk_object_unref(GTK_OBJECT(d));
  SCM_ALLOW_INTS;

  return 0;
}

static int
print_data(SCM x, SCM port, scm_print_state* state)
{
  scm_puts("<ScatterState>", port);

  return 1;
}


/*****************************************************************************/

void
guppi_scm_scatter_state_init(void)
{
  static gboolean initialized = FALSE;
  static struct scm_smobfuns scatstate_fns = {
    mark_data, free_data, print_data, NULL
  };
  
  g_return_if_fail(!initialized);
  initialized = TRUE;

  scatstate_type_tag = scm_newsmob(&scatstate_fns);

#include "guppi-scm-scatter-state.x"
  
}

/* $Id: guppi-scm-scatter-state.c,v 1.2 2000/01/21 07:55:32 trow Exp $ */

