/* This is -*- C -*- */
/* $Id: guppi-dataset.c,v 1.2 1999/12/06 05:07:20 trow Exp $ */

/*
 * guppi-dataset.c
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-dataset.h"

static GtkObjectClass* parent_class = NULL;

enum {
  CHANGED,
  LAST_SIGNAL
};

static guint dataset_signals[LAST_SIGNAL] = { 0 };

enum {
  ARG_0
};

static void
guppi_dataset_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_dataset_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_dataset_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_dataset_finalize(GtkObject* obj)
{
  GuppiDataset* ds = GUPPI_DATASET(obj);

  g_free(ds->name);
  g_free(ds->source);
  g_free(ds->reference);
  g_free(ds->contact);
  g_free(ds->URL);
  g_free(ds->notes);

  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_dataset_class_init(GuppiDatasetClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  dataset_signals[CHANGED] =
    gtk_signal_new("changed",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiDatasetClass, changed),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);
  gtk_object_class_add_signals(object_class, dataset_signals, LAST_SIGNAL);

  object_class->get_arg = guppi_dataset_get_arg;
  object_class->set_arg = guppi_dataset_set_arg;
  object_class->destroy = guppi_dataset_destroy;
  object_class->finalize = guppi_dataset_finalize;

}

static void
guppi_dataset_init(GuppiDataset* obj)
{
  obj->name = NULL;
  obj->source = NULL;
  obj->reference = NULL;
  obj->contact = NULL;
  obj->URL = NULL;
  obj->notes = NULL;
}

GtkType
guppi_dataset_get_type(void)
{
  static GtkType guppi_dataset_type = 0;
  if (!guppi_dataset_type) {
    static const GtkTypeInfo guppi_dataset_info = {
      "GuppiDataset",
      sizeof(GuppiDataset),
      sizeof(GuppiDatasetClass),
      (GtkClassInitFunc)guppi_dataset_class_init,
      (GtkObjectInitFunc)guppi_dataset_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_dataset_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_dataset_info);
  }
  return guppi_dataset_type;
}

GuppiDataset*
guppi_dataset_new(void)
{
  return GUPPI_DATASET(gtk_type_new(guppi_dataset_get_type()));
}

const gchar*
guppi_dataset_name(const GuppiDataset* ds)
{
  g_return_val_if_fail(ds != NULL, NULL);
  return ds->name ? ds->name : "";
}

const gchar*
guppi_dataset_source(const GuppiDataset* ds)
{
  g_return_val_if_fail(ds != NULL, NULL);
  return ds->source ? ds->source : "";
}

const gchar*
guppi_dataset_reference(const GuppiDataset* ds)
{
  g_return_val_if_fail(ds != NULL, NULL);
  return ds->reference ? ds->reference : "";
}

const gchar*
guppi_dataset_contact(const GuppiDataset* ds)
{
  g_return_val_if_fail(ds != NULL, NULL);
  return ds->contact ? ds->contact : "";
}

const gchar*
guppi_dataset_URL(const GuppiDataset* ds)
{
  g_return_val_if_fail(ds != NULL, NULL);
  return ds->URL ? ds->URL : "";
}

const gchar*
guppi_dataset_notes(const GuppiDataset* ds)
{
  g_return_val_if_fail(ds != NULL, NULL);
  return ds->notes ? ds->notes : "";
}

static gboolean
diff(const gchar* a, const gchar* b)
{
  return
    (a == NULL && b != NULL) ||
    (a != NULL && b == NULL) ||
    (a != NULL && b != NULL && strcmp(a,b) != 0);
}


void
guppi_dataset_set_name(GuppiDataset* ds, const gchar* str)
{
  g_return_if_fail(ds != NULL);

  if (diff(ds->name, str)) {
    g_free(ds->name);
    ds->name = g_strdup(str);
    gtk_signal_emit(GTK_OBJECT(ds), dataset_signals[CHANGED]);
  }
}

void
guppi_dataset_set_source(GuppiDataset* ds, const gchar* str)
{
  g_return_if_fail(ds != NULL);

  if (diff(ds->source, str)) {
    g_free(ds->source);
    ds->source = g_strdup(str);
    gtk_signal_emit(GTK_OBJECT(ds), dataset_signals[CHANGED]);
  }
}

void
guppi_dataset_set_reference(GuppiDataset* ds, const gchar* str)
{
  g_return_if_fail(ds != NULL);

  if (diff(ds->reference, str)) {
    g_free(ds->reference);
    ds->reference = g_strdup(str);
    gtk_signal_emit(GTK_OBJECT(ds), dataset_signals[CHANGED]);
  }
}

void
guppi_dataset_set_contact(GuppiDataset* ds, const gchar* str)
{
  g_return_if_fail(ds != NULL);
  if (diff(ds->contact, str)) {
    g_free(ds->contact);
    ds->contact = g_strdup(str);
    gtk_signal_emit(GTK_OBJECT(ds), dataset_signals[CHANGED]);
  }
}

void
guppi_dataset_set_URL(GuppiDataset* ds, const gchar* str)
{
  g_return_if_fail(ds != NULL);
  if (diff(ds->URL, str)) {
    g_free(ds->URL);
    ds->URL = g_strdup(str);
    gtk_signal_emit(GTK_OBJECT(ds), dataset_signals[CHANGED]);
  }
}

void
guppi_dataset_set_notes(GuppiDataset* ds, const gchar* str)
{
  g_return_if_fail(ds != NULL);
  g_free(ds->notes);
  if (diff(ds->notes, str)) {
    ds->notes = g_strdup(str);
    gtk_signal_emit(GTK_OBJECT(ds), dataset_signals[CHANGED]);
  }
}







/* $Id: guppi-dataset.c,v 1.2 1999/12/06 05:07:20 trow Exp $ */
