/* $Id: init.c,v 1.3 2000/01/19 19:48:53 trow Exp $ */

/*
 * init.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-plot-plug-in.h>
#include "guppi-scatter-element.h"
#include "guppi-scm-scatter-style.h"
#include "guppi-scm-scatter-state.h"

GuppiPlotPlugInInfo* plot_plug_in(void);

/***************************************************************************/

static GuppiPlotElement*
make_element(void)
{
  return guppi_scatter_element_new();
}

static GuppiPlotPlugInInfo info = {
  GUPPI_PLOT_PLUG_IN_MAGIC_NUMBER,
  N_("Scatter Plot"),
  "scatter",
  GUPPI_MAJOR_VERSION,
  GUPPI_MINOR_VERSION,
  GUPPI_MICRO_VERSION,
  "Copyright (C) 2000 EMC Capital Management, Inc.",
  "Jon Trowbridge",
  make_element,
  NULL
};


GuppiPlotPlugInInfo*
plot_plug_in(void)
{
  guppi_scm_scatter_style_init();
  guppi_scm_scatter_state_init();

  /* Do any other necessary initialization here. */
  
  return &info;
}


/* $Id: init.c,v 1.3 2000/01/19 19:48:53 trow Exp $ */
