/* This is -*- C++ -*- */
/* $Id: guppi-scatter-state.h,v 1.3 2000/01/21 06:11:36 trow Exp $ */

/*
 * guppi-scatter-state.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SCATTER_STATE_H
#define _INC_GUPPI_SCATTER_STATE_H

#include <config.h>
#include <gnome.h>
#include <guppi-boolean-data.h>
#include <guppi-scalar-data.h>
#include <guppi-item-state.h>
#include "guppi-scatter-style.h"

typedef struct _GuppiScatterState GuppiScatterState;
typedef struct _GuppiScatterStateClass GuppiScatterStateClass;

#define GUPPI_SCATTER_STATE_STYLE_COUNT 16
struct _GuppiScatterState {
  GuppiItemState object;
  
  GuppiScalarData* x_data;
  GuppiScalarData* y_data;
  guint x_signal_hander, y_signal_handler;

  GuppiScatterStyle* style[GUPPI_SCATTER_STATE_STYLE_COUNT];
  GuppiBooleanData* mask[GUPPI_SCATTER_STATE_STYLE_COUNT];
};

struct _GuppiScatterStateClass {
  GtkObjectClass parent_class;

  /* signal handlers */
  void (*changed_x_data)(GuppiScalarData*);
  void (*changed_y_data)(GuppiScalarData*);
  void (*changed_style)(gint);
  void (*changed)(void);
};

#define GUPPI_TYPE_SCATTER_STATE (guppi_scatter_state_get_type())
#define GUPPI_SCATTER_STATE(obj) (GTK_CHECK_CAST((obj), \
                                  GUPPI_TYPE_SCATTER_STATE,GuppiScatterState))
#define GUPPI_SCATTER_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), \
                                          GUPPI_TYPE_SCATTER_STATE, \
					  GuppiScatterStateClass))
#define GUPPI_IS_SCATTER_STATE(obj) (GTK_CHECK_TYPE((obj), \
                                     GUPPI_TYPE_SCATTER_STATE))
#define GUPPI_IS_SCATTER_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
                                    GUPPI_TYPE_SCATTER_STATE))

GtkType guppi_scatter_state_get_type(void);

GuppiScatterState* guppi_scatter_state_new(void);

void guppi_scatter_state_set_x_data(GuppiScatterState*, GuppiScalarData*);
void guppi_scatter_state_set_y_data(GuppiScatterState*, GuppiScalarData*);

GuppiScatterStyle* guppi_scatter_state_get_style(GuppiScatterState*, gint);

void guppi_scatter_state_brush_rectangle(GuppiScatterState*,
					 gint brush_number,
					 double x0, double y0,
					 double x1, double y1);

void guppi_scatter_state_brush_circle(GuppiScatterState*,
				      gint brush_number,
				      double x, double y, gint r_pixels,
				      double x_scale,
				      double y_scale);
					 


#endif /* _INC_GUPPI_SCATTER-STATE_H */

/* $Id: guppi-scatter-state.h,v 1.3 2000/01/21 06:11:36 trow Exp $ */
