/* $Id: guppi-scm-delimited-importer.c,v 1.1 2000/01/17 06:44:17 trow Exp $ */

/*
 * guppi-scm-delimited-importer.c
 *
 * Copyright (C) 1999,2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scm-importer.h"
#include "guppi-scm-delimited-importer.h"

#define SCM_TO_DELIMITED_IMPORTER(x) (GUPPI_DELIMITED_IMPORTER(SCM_CDR(x)))
#define SCM_DELIMITED_IMPORTER_P(x) \
(SCM_NIMP(x) && scm_importer_p(x) && GUPPI_IS_DELIMITED_IMPORTER(SCM_CDR(x)))

gboolean
scm_delimited_importer_p(SCM x)
{
  return SCM_DELIMITED_IMPORTER_P(x);
}

GuppiDelimitedImporter*
scm2delimited_importer(SCM x)
{
  return SCM_DELIMITED_IMPORTER_P(x) ?
    SCM_TO_DELIMITED_IMPORTER(x) : NULL;
}

/*****************************************************************************/

GUPPI_PROC(dti_new, "make-delimited-importer",
	   0,0,0, ())
{
  return importer2scm(guppi_delimited_importer_new());
}

/*** Title Line ***/

GUPPI_PROC(dti_title, "delimited-importer-title-line",
	   1,0,0, (SCM x))
{
  gint l;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_title);

  l = guppi_delimited_importer_title_line(SCM_TO_DELIMITED_IMPORTER(x));
  return l<0 ? SCM_BOOL_F : gh_int2scm(l);
}

GUPPI_PROC(dti_settitle, "delimited-importer-set-title-line!",
	   2,0,0, (SCM x, SCM sl))
{
  GuppiDelimitedImporter* gi;
  gint l;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_settitle);
  SCM_ASSERT(gh_exact_p(sl), sl, SCM_ARG2, str_dti_settitle);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  l = gh_scm2int(sl);

  guppi_delimited_importer_set_title_line(gi, l);
  
  return x;
}


/*** Skip Lines Before ***/

GUPPI_PROC(dti_skipb, "delimited-importer-skip-lines-before",
	   1,0,0, (SCM x))
{
  gint l;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_skipb);

  l = guppi_delimited_importer_skip_lines_before(SCM_TO_DELIMITED_IMPORTER(x));
  return l<0 ? SCM_BOOL_F : gh_int2scm(l);
}

GUPPI_PROC(dti_skipsetb, "delimited-importer-set-skip-lines-before!",
	   2,0,0, (SCM x, SCM sl))
{
  GuppiDelimitedImporter* gi;
  gint l;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_skipsetb);
  SCM_ASSERT(gh_exact_p(sl), sl, SCM_ARG2, str_dti_skipsetb);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  l = gh_scm2int(sl);

  guppi_delimited_importer_set_skip_lines_before(gi, l);
  
  return x;
}

/*** Skip Lines After ***/

GUPPI_PROC(dti_skipa, "delimited-importer-skip-lines-after",
	   1,0,0, (SCM x))
{
  gint l;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_skipa);

  l = guppi_delimited_importer_skip_lines_after(SCM_TO_DELIMITED_IMPORTER(x));
  return l<0 ? SCM_BOOL_F : gh_int2scm(l);
}

GUPPI_PROC(dti_skipseta, "delimited-importer-set-skip-lines-after!",
	   2,0,0, (SCM x, SCM sl))
{
  GuppiDelimitedImporter* gi;
  gint l;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_skipseta);
  SCM_ASSERT(gh_exact_p(sl), sl, SCM_ARG2, str_dti_skipseta);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  l = gh_scm2int(sl);

  guppi_delimited_importer_set_skip_lines_after(gi, l);
  
  return x;
}

/*** Skip Non-Contiguous Lines ***/

GUPPI_PROC(dti_noncont, "delimited-importer-skip-noncontiguous?",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_noncont);

  return gh_bool2scm(guppi_delimited_importer_skip_noncontiguous(SCM_TO_DELIMITED_IMPORTER(x)));
}

GUPPI_PROC(dti_setnoncont, "delimited-importer-set-skip-noncontiguous!",
	   2,0,0, (SCM x, SCM stf))
{
  GuppiDelimitedImporter* gi;
  gboolean tf;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_setnoncont);
  SCM_ASSERT(gh_boolean_p(stf), stf, SCM_ARG2, str_dti_setnoncont);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  tf = gh_scm2bool(stf);

  guppi_delimited_importer_set_skip_noncontiguous(gi, tf);
  
  return x;
}


/*** Skip Alpha Lines ***/

GUPPI_PROC(dti_skipalpha, "delimited-importer-skip-alpha?",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_skipalpha);

  return gh_bool2scm(guppi_delimited_importer_skip_alpha(SCM_TO_DELIMITED_IMPORTER(x)));
}

GUPPI_PROC(dti_skipsetalpha, "delimited-importer-set-skip-alpha!",
	   2,0,0, (SCM x, SCM stf))
{
  GuppiDelimitedImporter* gi;
  gboolean tf;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_skipsetalpha);
  SCM_ASSERT(gh_boolean_p(stf), stf, SCM_ARG2, str_dti_skipsetalpha);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  tf = gh_scm2bool(stf);

  guppi_delimited_importer_set_skip_alpha(gi, tf);
  
  return x;
}

/*** Auto-filter ***/

GUPPI_PROC(dti_autof, "delimited-importer-autofilter?",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_autof);

  return gh_bool2scm(guppi_delimited_importer_autofilter(SCM_TO_DELIMITED_IMPORTER(x)));
}

GUPPI_PROC(dti_setautof, "delimited-importer-set-autofilter!",
	   2,0,0, (SCM x, SCM stf))
{
  GuppiDelimitedImporter* gi;
  gboolean tf;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_setautof);
  SCM_ASSERT(gh_boolean_p(stf), stf, SCM_ARG2, str_dti_setautof);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  tf = gh_scm2bool(stf);

  guppi_delimited_importer_set_autofilter(gi, tf);
  
  return x;
}


/*** Delimiter ***/

GUPPI_PROC(dti_delim, "delimited-importer-delimiter",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_delim);

  return gh_char2scm(guppi_delimited_importer_delimiter(SCM_TO_DELIMITED_IMPORTER(x)));
}

GUPPI_PROC(dti_setdelim, "delimited-importer-set-delimiter!",
	   2,0,0, (SCM x, SCM sd))
{
  GuppiDelimitedImporter* gi;
  gchar d;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_setdelim);
  SCM_ASSERT(gh_char_p(sd), sd, SCM_ARG2, str_dti_setdelim);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  d = gh_scm2char(sd);

  guppi_delimited_importer_set_delimiter(gi, d);
  
  return x;
}

/*** Columns ***/

GUPPI_PROC(dti_col, "delimited-importer-columns",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_col);
  
  return gh_int2scm(guppi_delimited_importer_columns(SCM_TO_DELIMITED_IMPORTER(x)));
}

GUPPI_PROC(dti_setcol, "delimited-importer-set-columns!",
	   2,0,0, (SCM x, SCM sn))
{
  gint n;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_setcol);
  SCM_ASSERT(gh_exact_p(sn), sn, SCM_ARG2, str_dti_setcol);

  n = gh_scm2int(sn);
  SCM_ASSERT(n > 0, sn, SCM_OUTOFRANGE, str_dti_setcol);

  guppi_delimited_importer_set_columns(SCM_TO_DELIMITED_IMPORTER(x), n);

  return x;
}

/****************************************************************************/

GUPPI_PROC(dti_skip, "delimited-importer-skip-line?",
	   3,0,0, (SCM x, SCM sline, SCM slineno))
{
  GuppiDelimitedImporter* gi;
  gchar* line;
  gint len;
  gint lineno;
  gboolean tf;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_skip);
  SCM_ASSERT(gh_string_p(sline), sline, SCM_ARG2, str_dti_skip);
  SCM_ASSERT(gh_exact_p(slineno), slineno, SCM_ARG3, str_dti_skip);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  line = gh_scm2newstr(sline, &len);
  lineno = gh_scm2int(slineno);

  tf = guppi_delimited_importer_line_skip(gi,line,lineno);
  g_free(line);

  return gh_bool2scm(tf);
}

GUPPI_PROC(dti_split, "delimited-importer-split-line",
	   2,0,0, (SCM x, SCM sline))
{
  GuppiDelimitedImporter* gi;
  gchar* line;
  gchar** split;
  int len, i;
  SCM output = SCM_EOL;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_split);
  SCM_ASSERT(gh_string_p(sline), sline, SCM_ARG2, str_dti_split);

  gi = SCM_TO_DELIMITED_IMPORTER(x);
  line = gh_scm2newstr(sline, &len);
  
  split = guppi_delimited_importer_line_split(gi, line, NULL, -1, FALSE);

  if (split == NULL)
    return SCM_EOL;

  i=0;
  while (split[i] != NULL) ++i;
  while (i>0) {
    --i;
    output = gh_cons(gh_str02scm(split[i]), output);
  }
  
  return output;
}

/*****************************************************************************/

/*
GUPPI_PROC(dti_preview, "delimited-importer-preview",
	   1,0,0, (SCM x))
{
  GtkWidget* window;
  GtkWidget* preview;

  SCM_ASSERT(SCM_DELIMITED_IMPORTER_P(x), x, SCM_ARG1, str_dti_preview);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  preview = guppi_delimited_preview_new(SCM_TO_DELIMITED_IMPORTER(x));
  gtk_container_add(GTK_CONTAINER(window), preview);
  gtk_widget_show_all(window);

  return x;
}
*/

/*****************************************************************************/

void
guppi_scm_delimited_importer_init(void)
{
  static gboolean init = FALSE;
  g_return_if_fail(!init);
  init = TRUE;

#include "guppi-scm-delimited-importer.x"
}


/* $Id: guppi-scm-delimited-importer.c,v 1.1 2000/01/17 06:44:17 trow Exp $ */
