/* rygel-http-item-uri.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY
};
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPItemURI * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	RygelHTTPServer* _tmp5_;
	g_return_val_if_fail (item_id != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (item_id);
	_tmp1_ = _tmp0_;
	_g_free0 (self->item_id);
	self->item_id = _tmp1_;
	self->thumbnail_index = thumbnail_index;
	self->subtitle_index = subtitle_index;
	_tmp2_ = g_strdup (transcode_target);
	_tmp3_ = _tmp2_;
	_g_free0 (self->transcode_target);
	self->transcode_target = _tmp3_;
	_tmp4_ = _g_object_ref0 (http_server);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp5_;
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item_id, http_server, thumbnail_index, subtitle_index, transcode_target);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch64_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch64_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally64;
	__catch64_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally64:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	gchar* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* request_uri;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp7_;
	gchar** parts;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	self->thumbnail_index = -1;
	self->subtitle_index = -1;
	_tmp0_ = NULL;
	_g_free0 (self->transcode_target);
	self->transcode_target = _tmp0_;
	_tmp1_ = _g_object_ref0 (http_server);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp2_;
	_tmp3_ = rygel_http_server_get_path_root (http_server);
	_tmp4_ = string_replace (uri, _tmp3_, "");
	request_uri = _tmp4_;
	_tmp6_ = _tmp5_ = g_strsplit (request_uri, "/", 0);
	_tmp7_ = _tmp6_;
	parts_length1 = _vala_array_length (_tmp5_);
	_parts_size_ = parts_length1;
	parts = _tmp7_;
	if (parts_length1 < 2) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = (parts_length1 % 2) == 0;
	}
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp9_ = _ ("Invalid URI '%s'");
		_tmp10_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp9_, request_uri);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		gint i;
		i = 1;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				const gchar* _tmp12_;
				GQuark _tmp13_;
				static GQuark _tmp13__label0 = 0;
				static GQuark _tmp13__label1 = 0;
				static GQuark _tmp13__label2 = 0;
				static GQuark _tmp13__label3 = 0;
				if (!_tmp11_) {
					i = i + 2;
				}
				_tmp11_ = FALSE;
				if (!(i < (parts_length1 - 1))) {
					break;
				}
				_tmp12_ = parts[i];
				_tmp13_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
				if (_tmp13_ == ((0 != _tmp13__label0) ? _tmp13__label0 : (_tmp13__label0 = g_quark_from_static_string ("item")))) {
					switch (0) {
						default:
						{
							gchar* _tmp14_ = NULL;
							gchar* _tmp15_;
							size_t _tmp16_;
							guchar* _tmp17_ = NULL;
							guchar* _tmp18_;
							gint data_length1;
							gint _data_size_;
							guchar* _tmp19_;
							guchar* data;
							GString* _tmp20_ = NULL;
							GString* builder;
							gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp14_ = soup_uri_decode (parts[i + 1]);
							_tmp15_ = _tmp14_;
							_tmp17_ = g_base64_decode (_tmp15_, &_tmp16_);
							_tmp19_ = (_tmp18_ = _tmp17_, _g_free0 (_tmp15_), _tmp18_);
							data_length1 = _tmp16_;
							_data_size_ = data_length1;
							data = _tmp19_;
							_tmp20_ = g_string_new ("");
							builder = _tmp20_;
							g_string_append (builder, (const gchar*) data);
							_tmp21_ = g_strdup (builder->str);
							_tmp22_ = _tmp21_;
							_g_free0 (self->item_id);
							self->item_id = _tmp22_;
							_g_string_free0 (builder);
							data = (g_free (data), NULL);
							break;
						}
					}
				} else if (_tmp13_ == ((0 != _tmp13__label1) ? _tmp13__label1 : (_tmp13__label1 = g_quark_from_static_string ("transcoded")))) {
					switch (0) {
						default:
						{
							gchar* _tmp23_ = NULL;
							gchar* _tmp24_;
							_tmp23_ = soup_uri_decode (parts[i + 1]);
							_tmp24_ = _tmp23_;
							_g_free0 (self->transcode_target);
							self->transcode_target = _tmp24_;
							break;
						}
					}
				} else if (_tmp13_ == ((0 != _tmp13__label2) ? _tmp13__label2 : (_tmp13__label2 = g_quark_from_static_string ("thumbnail")))) {
					switch (0) {
						default:
						{
							gint _tmp25_;
							_tmp25_ = atoi (parts[i + 1]);
							self->thumbnail_index = _tmp25_;
							break;
						}
					}
				} else if (_tmp13_ == ((0 != _tmp13__label3) ? _tmp13__label3 : (_tmp13__label3 = g_quark_from_static_string ("subtitle")))) {
					switch (0) {
						default:
						{
							gint _tmp26_;
							_tmp26_ = atoi (parts[i + 1]);
							self->subtitle_index = _tmp26_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
			}
		}
	}
	if (self->item_id == NULL) {
		const gchar* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
		_tmp27_ = _ ("Not Found");
		_tmp28_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp27_);
		_inner_error_ = _tmp28_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (request_uri);
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _result__length1;
	gint __result__size_;
	gchar* _tmp2_;
	gchar* _result_;
	glong _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = g_new0 (gchar, _tmp0_ + 1);
	_tmp2_ = _tmp1_;
	_result__length1 = _tmp0_ + 1;
	__result__size_ = _result__length1;
	_result_ = _tmp2_;
	_result__length1--;
	_tmp3_ = strlen (self);
	memcpy (_result_, self, (gsize) _tmp3_);
	_tmp4_ = _result_;
	*result_length1 = _result__length1;
	result = _tmp4_;
	return result;
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp2_;
	gchar* data;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* escaped;
	gchar* path;
	gchar* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = string_to_utf8 (self->item_id, &_tmp0_);
	_tmp2_ = _tmp1_;
	data_length1 = _tmp0_;
	_data_size_ = data_length1;
	data = _tmp2_;
	_tmp3_ = g_base64_encode ((guchar*) data, data_length1);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_uri_escape_string (_tmp4_, "", TRUE);
	escaped = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp6_);
	path = g_strconcat ("/item/", escaped, NULL);
	if (self->transcode_target != NULL) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = g_uri_escape_string (self->transcode_target, "", TRUE);
		_tmp8_ = _tmp7_;
		_g_free0 (escaped);
		escaped = _tmp8_;
		_tmp9_ = g_strconcat ("/transcoded/", escaped, NULL);
		_tmp10_ = g_strconcat (path, _tmp9_, NULL);
		_g_free0 (path);
		path = _tmp10_;
		_g_free0 (_tmp9_);
	} else {
		if (self->thumbnail_index >= 0) {
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = g_strdup_printf ("%i", self->thumbnail_index);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("/thumbnail/", _tmp12_, NULL);
			_tmp14_ = g_strconcat (path, _tmp13_, NULL);
			_g_free0 (path);
			path = _tmp14_;
			_g_free0 (_tmp13_);
			_g_free0 (_tmp12_);
		} else {
			if (self->subtitle_index >= 0) {
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = g_strdup_printf ("%i", self->subtitle_index);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat ("/subtitle/", _tmp16_, NULL);
				_tmp18_ = g_strconcat (path, _tmp17_, NULL);
				_g_free0 (path);
				path = _tmp18_;
				_g_free0 (_tmp17_);
				_g_free0 (_tmp16_);
			}
		}
	}
	_tmp19_ = rygel_http_item_uri_create_uri_for_path (self, path);
	result = _tmp19_;
	_g_free0 (path);
	_g_free0 (escaped);
	data = (g_free (data), NULL);
	return result;
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = gssdp_client_get_host_ip ((GSSDPClient*) self->http_server->context);
	_tmp1_ = gupnp_context_get_port (self->http_server->context);
	_tmp2_ = rygel_http_server_get_path_root (self->http_server);
	_tmp3_ = g_strdup_printf ("http://%s:%u%s%s", _tmp0_, _tmp1_, _tmp2_, path);
	result = _tmp3_;
	return result;
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
	self = RYGEL_HTTP_ITEM_URI (obj);
	_g_free0 (self->item_id);
	_g_free0 (self->transcode_target);
	_g_object_unref0 (self->http_server);
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



