/* rygel-tracker-search-container.c generated by valac, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_TRACKER_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_IS_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER))
#define RYGEL_IS_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TYPE_TRACKER_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_QUERY, RygelTrackerQueryClass))
#define RYGEL_IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_QUERY))
#define RYGEL_IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TYPE_TRACKER_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_IS_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SELECTION_QUERY))
#define RYGEL_IS_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TYPE_TRACKER_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_IS_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_ITEM_FACTORY))
#define RYGEL_IS_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TYPE_TRACKER_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_IS_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_TRACKER_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_IS_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS))
#define RYGEL_IS_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TYPE_TRACKER_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_IS_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLET))
#define RYGEL_IS_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerSearchContainerSearchData RygelTrackerSearchContainerSearchData;
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _RygelTrackerSearchContainer {
	RygelMediaContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerSearchContainerPrivate {
	RygelTrackerResourcesIface* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	char* category;
	char* upnp_class;
	char* resources_class_path;
	char* upload_dir;
	GeeArrayList* key_chains;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const char* id, const char* uri, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	RygelRelationalExpression* expression;
	char* _tmp0_;
	char* _tmp1_;
	guint total_matches;
	GeeList* _tmp2_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* mandatory;
	RygelTrackerQueryTriplets* optional;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	char* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	char* order_by;
	gint offset;
	gint max_count;
	char** result;
	gint result_length1;
	gint result_length2;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSearchContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	GeeList* result;
	GeeArrayList* results;
	RygelTrackerSelectionQuery* query;
	GeeList* _tmp0_;
	guint i;
	gboolean _tmp1_;
	char* id;
	char* uri;
	char** metadata;
	gint _tmp2_;
	char** _tmp3_;
	gint _metadata_size_;
	gint metadata_length1;
	RygelMediaItem* item;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelTrackerSelectionQuery* query;
	GeeArrayList* _tmp0_;
	RygelTrackerQueryTriplets* _tmp1_;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_search_container_parent_class = NULL;

GType rygel_tracker_search_container_get_type (void);
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_param_spec_tracker_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_tracker_query (GValue* value, gpointer v_object);
void rygel_value_take_tracker_query (GValue* value, gpointer v_object);
gpointer rygel_value_get_tracker_query (const GValue* value);
GType rygel_tracker_query_get_type (void);
GType rygel_tracker_selection_query_get_type (void);
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_tracker_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_tracker_item_factory (GValue* value, gpointer v_object);
void rygel_value_take_tracker_item_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_tracker_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void);
GType rygel_tracker_resources_iface_get_type (void);
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainerPrivate))
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_SEARCH_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE "?item"
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PREDICATE "nfo:fileLastModified"
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_VARIABLE "?modified"
#define RYGEL_TRACKER_SEARCH_CONTAINER_URL_PREDICATE "nie:url"
#define RYGEL_TRACKER_SEARCH_CONTAINER_URL_VARIABLE "?url"
GType rygel_tracker_query_triplets_get_type (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const char* subject, const char* predicate, const char* obj, gboolean optional);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const char* subject, const char* predicate, const char* obj, gboolean optional);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_param_spec_tracker_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_tracker_query_triplet (GValue* value, gpointer v_object);
void rygel_value_take_tracker_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_value_get_tracker_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void);
static RygelTrackerQueryTriplet* rygel_tracker_search_container_triplet_from_chain (RygelTrackerSearchContainer* self, GeeList* chain, const char* variable, const char* subject);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* mandatory, RygelTrackerQueryTriplets* optional, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* mandatory, RygelTrackerQueryTriplets* optional, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
static void rygel_tracker_search_container_create_proxies (RygelTrackerSearchContainer* self, GError** error);
static void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* mandatory, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* mandatory, GeeArrayList* filters);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* data);
static void rygel_tracker_search_container_real_search_data_free (gpointer _data);
static void rygel_tracker_search_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, gint offset, gint max_count);
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
char* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const char* urn);
static char** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, char** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1);
RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const char* id, const char* uri, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
static gboolean rygel_tracker_search_container_real_search_co (RygelTrackerSearchContainerSearchData* data);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new_chain (const char* subject, const char* predicate, RygelTrackerQueryTriplet* next, gboolean optional);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct_chain (GType object_type, const char* subject, const char* predicate, RygelTrackerQueryTriplet* next, gboolean optional);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* data);
static char* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression);
static char* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const char* item_id, char** parent_id);
static void rygel_tracker_search_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 1052 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 348 "rygel-tracker-search-container.c"
	char* result = NULL;
	GError * _inner_error_;
#line 1052 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1052 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1052 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 357 "rygel-tracker-search-container.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1054 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 366 "rygel-tracker-search-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1055 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 377 "rygel-tracker-search-container.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1055 "glib-2.0.vapi"
		return result;
#line 392 "rygel-tracker-search-container.c"
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1057 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 403 "rygel-tracker-search-container.c"
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 47 "rygel-tracker-search-container.vala"
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* mandatory, GeeArrayList* filters) {
#line 418 "rygel-tracker-search-container.c"
	GError * _inner_error_;
	RygelTrackerSearchContainer * self;
	RygelTrackerItemFactory* _tmp0_;
	GeeArrayList* variables;
	RygelTrackerQueryTriplets* our_mandatory;
	RygelTrackerQueryTriplet* _tmp3_;
	RygelTrackerQueryTriplet* _tmp4_;
	RygelTrackerQueryTriplet* _tmp5_;
	RygelTrackerQueryTriplets* optional;
	RygelTrackerSelectionQuery* _tmp8_;
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_factory != NULL, NULL);
#line 437 "rygel-tracker-search-container.c"
	_inner_error_ = NULL;
#line 53 "rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) rygel_media_container_construct (object_type, id, parent, title, 0);
#line 55 "rygel-tracker-search-container.vala"
	self->item_factory = (_tmp0_ = _rygel_tracker_item_factory_ref0 (item_factory), _rygel_tracker_item_factory_unref0 (self->item_factory), _tmp0_);
#line 57 "rygel-tracker-search-container.vala"
	variables = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 58 "rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) variables, RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE);
#line 59 "rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) variables, RYGEL_TRACKER_SEARCH_CONTAINER_URL_VARIABLE);
#line 449 "rygel-tracker-search-container.c"
	our_mandatory = NULL;
#line 62 "rygel-tracker-search-container.vala"
	if (mandatory != NULL) {
#line 453 "rygel-tracker-search-container.c"
		RygelTrackerQueryTriplets* _tmp1_;
#line 63 "rygel-tracker-search-container.vala"
		our_mandatory = (_tmp1_ = _g_object_ref0 (mandatory), _g_object_unref0 (our_mandatory), _tmp1_);
#line 457 "rygel-tracker-search-container.c"
	} else {
		RygelTrackerQueryTriplets* _tmp2_;
#line 65 "rygel-tracker-search-container.vala"
		our_mandatory = (_tmp2_ = rygel_tracker_query_triplets_new (), _g_object_unref0 (our_mandatory), _tmp2_);
#line 462 "rygel-tracker-search-container.c"
	}
#line 68 "rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) our_mandatory, _tmp3_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE, "a", item_factory->category, FALSE));
#line 466 "rygel-tracker-search-container.c"
	_rygel_tracker_query_triplet_unref0 (_tmp3_);
#line 72 "rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) our_mandatory, _tmp4_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE, RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PREDICATE, RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_VARIABLE, FALSE));
#line 470 "rygel-tracker-search-container.c"
	_rygel_tracker_query_triplet_unref0 (_tmp4_);
#line 76 "rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) our_mandatory, _tmp5_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE, RYGEL_TRACKER_SEARCH_CONTAINER_URL_PREDICATE, RYGEL_TRACKER_SEARCH_CONTAINER_URL_VARIABLE, FALSE));
#line 474 "rygel-tracker-search-container.c"
	_rygel_tracker_query_triplet_unref0 (_tmp5_);
#line 81 "rygel-tracker-search-container.vala"
	optional = rygel_tracker_query_triplets_new ();
#line 478 "rygel-tracker-search-container.c"
	{
		GeeIterator* _chain_it;
		_chain_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->item_factory->key_chains);
#line 82 "rygel-tracker-search-container.vala"
		while (TRUE) {
#line 484 "rygel-tracker-search-container.c"
			GeeArrayList* chain;
			char* key;
			char* _tmp6_;
			char* _tmp7_;
			char* variable;
			RygelTrackerQueryTriplet* triplet;
#line 82 "rygel-tracker-search-container.vala"
			if (!gee_iterator_next (_chain_it)) {
#line 82 "rygel-tracker-search-container.vala"
				break;
#line 495 "rygel-tracker-search-container.c"
			}
#line 82 "rygel-tracker-search-container.vala"
			chain = (GeeArrayList*) gee_iterator_get (_chain_it);
#line 83 "rygel-tracker-search-container.vala"
			key = (char*) gee_abstract_list_last ((GeeAbstractList*) chain);
#line 84 "rygel-tracker-search-container.vala"
			variable = (_tmp7_ = g_strconcat ("?", _tmp6_ = string_replace (key, ":", "_"), NULL), _g_free0 (_tmp6_), _tmp7_);
#line 86 "rygel-tracker-search-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) variables, variable);
#line 88 "rygel-tracker-search-container.vala"
			triplet = rygel_tracker_search_container_triplet_from_chain (self, (GeeList*) chain, variable, RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE);
#line 92 "rygel-tracker-search-container.vala"
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) our_mandatory, triplet)) {
#line 93 "rygel-tracker-search-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) optional, triplet);
#line 511 "rygel-tracker-search-container.c"
			}
			_g_object_unref0 (chain);
			_g_free0 (key);
			_g_free0 (variable);
			_rygel_tracker_query_triplet_unref0 (triplet);
		}
		_g_object_unref0 (_chain_it);
	}
#line 97 "rygel-tracker-search-container.vala"
	self->query = (_tmp8_ = rygel_tracker_selection_query_new (variables, our_mandatory, optional, filters, RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_VARIABLE, 0, -1), _rygel_tracker_query_unref0 (self->query), _tmp8_);
#line 522 "rygel-tracker-search-container.c"
	{
#line 104 "rygel-tracker-search-container.vala"
		rygel_tracker_search_container_create_proxies (self, &_inner_error_);
#line 526 "rygel-tracker-search-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch5_dbus_gerror;
			}
			_g_object_unref0 (variables);
			_g_object_unref0 (our_mandatory);
			_g_object_unref0 (optional);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 106 "rygel-tracker-search-container.vala"
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
#line 540 "rygel-tracker-search-container.c"
	}
	goto __finally5;
	__catch5_dbus_gerror:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 108 "rygel-tracker-search-container.vala"
			g_critical (_ ("Failed to connect to session bus: %s"), _error_->message);
#line 551 "rygel-tracker-search-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (variables);
		_g_object_unref0 (our_mandatory);
		_g_object_unref0 (optional);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (variables);
	_g_object_unref0 (our_mandatory);
	_g_object_unref0 (optional);
	return self;
}


#line 47 "rygel-tracker-search-container.vala"
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* mandatory, GeeArrayList* filters) {
#line 47 "rygel-tracker-search-container.vala"
	return rygel_tracker_search_container_construct (RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, id, parent, title, item_factory, mandatory, filters);
#line 575 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, data);
}


static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
	_data_->self = g_object_ref (self);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static GeeList* rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_real_get_children_co (data);
}


static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->expression = rygel_relational_expression_new ();
#line 118 "rygel-tracker-search-container.vala"
		((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 119 "rygel-tracker-search-container.vala"
		((RygelSearchExpression*) data->expression)->operand1 = (data->_tmp0_ = g_strdup ("@parentID"), _g_free0 (((RygelSearchExpression*) data->expression)->operand1), data->_tmp0_);
#line 120 "rygel-tracker-search-container.vala"
		((RygelSearchExpression*) data->expression)->operand2 = (data->_tmp1_ = g_strdup (((RygelMediaObject*) data->self)->id), _g_free0 (((RygelSearchExpression*) data->expression)->operand2), data->_tmp1_);
#line 643 "rygel-tracker-search-container.c"
		data->_state_ = 2;
		rygel_media_container_search ((RygelMediaContainer*) data->self, (RygelSearchExpression*) data->expression, data->offset, data->max_count, data->cancellable, rygel_tracker_search_container_get_children_ready, data);
		return FALSE;
		_state_2:
		data->_tmp2_ = rygel_media_container_search_finish ((RygelMediaContainer*) data->self, data->_res_, &data->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_search_expression_unref0 (data->expression);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp2_;
		_rygel_search_expression_unref0 (data->expression);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_rygel_search_expression_unref0 (data->expression);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_tracker_search_container_real_search_data_free (gpointer _data) {
	RygelTrackerSearchContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerSearchContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_tracker_search_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerSearchData* _data_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_search_container_real_search_co (_data_);
}


static GeeList* rygel_tracker_search_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	GeeList* result;
	RygelTrackerSearchContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	_data_->total_matches = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_real_search_co (data);
}


static gboolean rygel_tracker_search_container_real_search_co (RygelTrackerSearchContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->results = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		data->query = rygel_tracker_search_container_create_query (data->self, data->expression, (gint) data->offset, (gint) data->max_count);
#line 142 "rygel-tracker-search-container.vala"
		if (data->query == NULL) {
#line 760 "rygel-tracker-search-container.c"
			data->_state_ = 3;
			RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_search_container_parent_class)->search (RYGEL_MEDIA_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_tracker_search_container_search_ready, data);
			return FALSE;
			_state_3:
			data->_tmp0_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_search_container_parent_class)->search_finish (RYGEL_MEDIA_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->results);
				_rygel_tracker_query_unref0 (data->query);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp0_;
			_g_object_unref0 (data->results);
			_rygel_tracker_query_unref0 (data->query);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->_state_ = 4;
		rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_search_container_search_ready, data);
		return FALSE;
		_state_4:
#line 150 "rygel-tracker-search-container.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
#line 800 "rygel-tracker-search-container.c"
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->results);
			_rygel_tracker_query_unref0 (data->query);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			data->i = (guint) 0;
			{
				data->_tmp1_ = TRUE;
#line 153 "rygel-tracker-search-container.vala"
				while (TRUE) {
#line 153 "rygel-tracker-search-container.vala"
					if (!data->_tmp1_) {
#line 153 "rygel-tracker-search-container.vala"
						data->i++;
#line 826 "rygel-tracker-search-container.c"
					}
#line 153 "rygel-tracker-search-container.vala"
					data->_tmp1_ = FALSE;
#line 153 "rygel-tracker-search-container.vala"
					if (!(data->i < data->query->result_length1)) {
#line 153 "rygel-tracker-search-container.vala"
						break;
#line 834 "rygel-tracker-search-container.c"
					}
					data->id = rygel_tracker_search_container_create_child_id_for_urn (data->self, data->query->result[(data->i * data->query->result_length2) + 0]);
					data->uri = g_strdup (data->query->result[(data->i * data->query->result_length2) + 1]);
					data->metadata = (data->_tmp3_ = rygel_tracker_search_container_slice_strvv_tail (data->self, data->query->result, data->query->result_length1, data->query->result_length2, data->i, (guint) 2, &data->_tmp2_), data->metadata_length1 = data->_tmp2_, data->_metadata_size_ = data->metadata_length1, data->_tmp3_);
					data->item = rygel_tracker_item_factory_create (data->self->item_factory, data->id, data->uri, data->self, data->metadata, data->metadata_length1, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						_g_free0 (data->id);
						_g_free0 (data->uri);
						data->metadata = (_vala_array_free (data->metadata, data->metadata_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (data->results);
						_rygel_tracker_query_unref0 (data->query);
						{
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
					}
#line 159 "rygel-tracker-search-container.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) data->results, (RygelMediaObject*) data->item);
#line 860 "rygel-tracker-search-container.c"
					_g_free0 (data->id);
					_g_free0 (data->uri);
					data->metadata = (_vala_array_free (data->metadata, data->metadata_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (data->item);
				}
			}
		}
#line 162 "rygel-tracker-search-container.vala"
		data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->results);
#line 870 "rygel-tracker-search-container.c"
		data->result = (GeeList*) data->results;
		_rygel_tracker_query_unref0 (data->query);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->results);
		_rygel_tracker_query_unref0 (data->query);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 167 "rygel-tracker-search-container.vala"
char* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const char* urn) {
#line 899 "rygel-tracker-search-container.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
#line 167 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (urn != NULL, NULL);
#line 907 "rygel-tracker-search-container.c"
	result = (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (((RygelMediaObject*) self)->id, ":", NULL), urn, NULL), _g_free0 (_tmp0_), _tmp1_);
#line 168 "rygel-tracker-search-container.vala"
	return result;
#line 911 "rygel-tracker-search-container.c"
}


#line 171 "rygel-tracker-search-container.vala"
static RygelTrackerQueryTriplet* rygel_tracker_search_container_triplet_from_chain (RygelTrackerSearchContainer* self, GeeList* chain, const char* variable, const char* subject) {
#line 917 "rygel-tracker-search-container.c"
	RygelTrackerQueryTriplet* result = NULL;
	char* key;
	RygelTrackerQueryTriplet* triplet;
#line 171 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 171 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (chain != NULL, NULL);
#line 175 "rygel-tracker-search-container.vala"
	key = (char*) gee_list_first (chain);
#line 927 "rygel-tracker-search-container.c"
	triplet = NULL;
#line 179 "rygel-tracker-search-container.vala"
	if (gee_collection_get_size ((GeeCollection*) chain) == 1) {
#line 931 "rygel-tracker-search-container.c"
		RygelTrackerQueryTriplet* _tmp0_;
#line 180 "rygel-tracker-search-container.vala"
		triplet = (_tmp0_ = rygel_tracker_query_triplet_new (subject, key, variable, subject != NULL), _rygel_tracker_query_triplet_unref0 (triplet), _tmp0_);
#line 935 "rygel-tracker-search-container.c"
	} else {
		GeeList* child_chain;
		RygelTrackerQueryTriplet* child;
		RygelTrackerQueryTriplet* _tmp1_;
#line 185 "rygel-tracker-search-container.vala"
		child_chain = gee_list_slice (chain, gee_list_index_of (chain, key) + 1, gee_collection_get_size ((GeeCollection*) chain));
#line 188 "rygel-tracker-search-container.vala"
		child = rygel_tracker_search_container_triplet_from_chain (self, child_chain, variable, NULL);
#line 190 "rygel-tracker-search-container.vala"
		triplet = (_tmp1_ = rygel_tracker_query_triplet_new_chain (subject, key, child, TRUE), _rygel_tracker_query_triplet_unref0 (triplet), _tmp1_);
#line 946 "rygel-tracker-search-container.c"
		_g_object_unref0 (child_chain);
		_rygel_tracker_query_triplet_unref0 (child);
	}
	result = triplet;
	_g_free0 (key);
#line 193 "rygel-tracker-search-container.vala"
	return result;
#line 954 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenCountData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, data);
}


static void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_get_children_count);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
	_data_->self = g_object_ref (self);
	rygel_tracker_search_container_get_children_count_co (_data_);
}


static void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_get_children_count_co (data);
}


static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->query = rygel_tracker_selection_query_new_clone (data->self->query);
#line 200 "rygel-tracker-search-container.vala"
			data->query->variables = (data->_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (data->query->variables), data->_tmp0_);
#line 201 "rygel-tracker-search-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) data->query->variables, "COUNT(" RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE ") AS x");
#line 202 "rygel-tracker-search-container.vala"
			((RygelTrackerQuery*) data->query)->optional = (data->_tmp1_ = rygel_tracker_query_triplets_new (), _g_object_unref0 (((RygelTrackerQuery*) data->query)->optional), data->_tmp1_);
#line 1009 "rygel-tracker-search-container.c"
			data->_state_ = 5;
			rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_search_container_get_children_count_ready, data);
			return FALSE;
			_state_5:
#line 204 "rygel-tracker-search-container.vala"
			rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
#line 1016 "rygel-tracker-search-container.c"
			if (data->_inner_error_ != NULL) {
				_rygel_tracker_query_unref0 (data->query);
				goto __catch6_g_error;
			}
#line 206 "rygel-tracker-search-container.vala"
			((RygelMediaContainer*) data->self)->child_count = atoi (data->query->result[(0 * data->query->result_length2) + 0]);
#line 207 "rygel-tracker-search-container.vala"
			rygel_media_container_updated ((RygelMediaContainer*) data->self);
#line 1025 "rygel-tracker-search-container.c"
			_rygel_tracker_query_unref0 (data->query);
		}
		goto __finally6;
		__catch6_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 209 "rygel-tracker-search-container.vala"
				g_critical (_ ("Error getting item count under category '%s': %s"), data->self->item_factory->category, data->_error_->message);
#line 1036 "rygel-tracker-search-container.c"
				_g_error_free0 (data->_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->_error_);
			}
		}
		__finally6:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 217 "rygel-tracker-search-container.vala"
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, gint offset, gint max_count) {
#line 1071 "rygel-tracker-search-container.c"
	RygelTrackerSelectionQuery* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelSearchExpression* _tmp1_;
	RygelRelationalExpression* rel_expression;
	RygelTrackerSelectionQuery* query;
#line 217 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 217 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 220 "rygel-tracker-search-container.vala"
	if (expression == NULL) {
#line 220 "rygel-tracker-search-container.vala"
		_tmp0_ = TRUE;
#line 1085 "rygel-tracker-search-container.c"
	} else {
#line 220 "rygel-tracker-search-container.vala"
		_tmp0_ = !RYGEL_IS_RELATIONAL_EXPRESSION (expression);
#line 1089 "rygel-tracker-search-container.c"
	}
#line 220 "rygel-tracker-search-container.vala"
	if (_tmp0_) {
#line 1093 "rygel-tracker-search-container.c"
		result = NULL;
#line 221 "rygel-tracker-search-container.vala"
		return result;
#line 1097 "rygel-tracker-search-container.c"
	}
#line 224 "rygel-tracker-search-container.vala"
	rel_expression = _rygel_search_expression_ref0 ((_tmp1_ = expression, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp1_) ? ((RygelRelationalExpression*) _tmp1_) : NULL));
#line 225 "rygel-tracker-search-container.vala"
	query = rygel_tracker_selection_query_new_clone (self->query);
#line 227 "rygel-tracker-search-container.vala"
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) rel_expression)->operand1, "@parentID") == 0) {
#line 228 "rygel-tracker-search-container.vala"
		if (!rygel_relational_expression_compare_string (rel_expression, ((RygelMediaObject*) self)->id)) {
#line 1107 "rygel-tracker-search-container.c"
			result = NULL;
			_rygel_search_expression_unref0 (rel_expression);
			_rygel_tracker_query_unref0 (query);
#line 229 "rygel-tracker-search-container.vala"
			return result;
#line 1113 "rygel-tracker-search-container.c"
		}
	} else {
		char* filter;
#line 232 "rygel-tracker-search-container.vala"
		filter = rygel_tracker_search_container_create_filter_for_child (self, rel_expression);
#line 233 "rygel-tracker-search-container.vala"
		if (filter != NULL) {
#line 234 "rygel-tracker-search-container.vala"
			gee_abstract_list_insert ((GeeAbstractList*) query->filters, 0, filter);
#line 1123 "rygel-tracker-search-container.c"
		} else {
			result = NULL;
			_g_free0 (filter);
			_rygel_search_expression_unref0 (rel_expression);
			_rygel_tracker_query_unref0 (query);
#line 236 "rygel-tracker-search-container.vala"
			return result;
#line 1131 "rygel-tracker-search-container.c"
		}
		_g_free0 (filter);
	}
#line 240 "rygel-tracker-search-container.vala"
	query->offset = offset;
#line 241 "rygel-tracker-search-container.vala"
	query->max_count = max_count;
#line 1139 "rygel-tracker-search-container.c"
	result = query;
	_rygel_search_expression_unref0 (rel_expression);
#line 243 "rygel-tracker-search-container.vala"
	return result;
#line 1144 "rygel-tracker-search-container.c"
}


#line 246 "rygel-tracker-search-container.vala"
static char* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression) {
#line 1150 "rygel-tracker-search-container.c"
	char* result = NULL;
	char* filter;
	char* variable;
	char* value;
	gboolean _tmp12_ = FALSE;
#line 246 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 246 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 247 "rygel-tracker-search-container.vala"
	filter = NULL;
#line 248 "rygel-tracker-search-container.vala"
	variable = NULL;
#line 249 "rygel-tracker-search-container.vala"
	value = NULL;
#line 251 "rygel-tracker-search-container.vala"
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "@id") == 0) {
#line 1168 "rygel-tracker-search-container.c"
		char* _tmp0_;
		char* parent_id;
		char* _tmp3_;
		char* _tmp2_;
		char* _tmp1_ = NULL;
		char* urn;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 252 "rygel-tracker-search-container.vala"
		variable = (_tmp0_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE), _g_free0 (variable), _tmp0_);
#line 1179 "rygel-tracker-search-container.c"
		parent_id = NULL;
#line 256 "rygel-tracker-search-container.vala"
		urn = (_tmp2_ = rygel_tracker_search_container_get_item_info (self, (const char*) ((RygelSearchExpression*) expression)->operand2, &_tmp1_), parent_id = (_tmp3_ = _tmp1_, _g_free0 (parent_id), _tmp3_), _tmp2_);
#line 257 "rygel-tracker-search-container.vala"
		if (urn == NULL) {
#line 257 "rygel-tracker-search-container.vala"
			_tmp5_ = TRUE;
#line 1187 "rygel-tracker-search-container.c"
		} else {
#line 257 "rygel-tracker-search-container.vala"
			_tmp5_ = parent_id == NULL;
#line 1191 "rygel-tracker-search-container.c"
		}
#line 257 "rygel-tracker-search-container.vala"
		if (_tmp5_) {
#line 257 "rygel-tracker-search-container.vala"
			_tmp4_ = TRUE;
#line 1197 "rygel-tracker-search-container.c"
		} else {
#line 257 "rygel-tracker-search-container.vala"
			_tmp4_ = _vala_strcmp0 (parent_id, ((RygelMediaObject*) self)->id) != 0;
#line 1201 "rygel-tracker-search-container.c"
		}
#line 257 "rygel-tracker-search-container.vala"
		if (_tmp4_) {
#line 1205 "rygel-tracker-search-container.c"
			result = NULL;
			_g_free0 (parent_id);
			_g_free0 (urn);
			_g_free0 (filter);
			_g_free0 (variable);
			_g_free0 (value);
#line 258 "rygel-tracker-search-container.vala"
			return result;
#line 1214 "rygel-tracker-search-container.c"
		}
#line 261 "rygel-tracker-search-container.vala"
		switch (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op)) {
#line 1218 "rygel-tracker-search-container.c"
			case GUPNP_SEARCH_CRITERIA_OP_EQ:
			{
				char* _tmp7_;
				char* _tmp6_;
#line 263 "rygel-tracker-search-container.vala"
				value = (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat ("<", urn, NULL), ">", NULL), _g_free0 (value), _tmp7_);
#line 1225 "rygel-tracker-search-container.c"
				_g_free0 (_tmp6_);
#line 264 "rygel-tracker-search-container.vala"
				break;
#line 1229 "rygel-tracker-search-container.c"
			}
			case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
			{
				char* _tmp8_;
#line 266 "rygel-tracker-search-container.vala"
				value = (_tmp8_ = g_strdup ((const char*) ((RygelSearchExpression*) expression)->operand2), _g_free0 (value), _tmp8_);
#line 267 "rygel-tracker-search-container.vala"
				break;
#line 1238 "rygel-tracker-search-container.c"
			}
		}
		_g_free0 (parent_id);
		_g_free0 (urn);
	} else {
#line 269 "rygel-tracker-search-container.vala"
		if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "res") == 0) {
#line 1246 "rygel-tracker-search-container.c"
			char* _tmp9_;
			char* _tmp11_;
			char* _tmp10_;
#line 270 "rygel-tracker-search-container.vala"
			variable = (_tmp9_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_URL_VARIABLE), _g_free0 (variable), _tmp9_);
#line 271 "rygel-tracker-search-container.vala"
			value = (_tmp11_ = g_strconcat (_tmp10_ = g_strconcat ("\"", (const char*) ((RygelSearchExpression*) expression)->operand2, NULL), "\"", NULL), _g_free0 (value), _tmp11_);
#line 1254 "rygel-tracker-search-container.c"
			_g_free0 (_tmp10_);
		}
	}
#line 274 "rygel-tracker-search-container.vala"
	if (variable == NULL) {
#line 274 "rygel-tracker-search-container.vala"
		_tmp12_ = TRUE;
#line 1262 "rygel-tracker-search-container.c"
	} else {
#line 274 "rygel-tracker-search-container.vala"
		_tmp12_ = value == NULL;
#line 1266 "rygel-tracker-search-container.c"
	}
#line 274 "rygel-tracker-search-container.vala"
	if (_tmp12_) {
#line 1270 "rygel-tracker-search-container.c"
		result = NULL;
		_g_free0 (filter);
		_g_free0 (variable);
		_g_free0 (value);
#line 275 "rygel-tracker-search-container.vala"
		return result;
#line 1277 "rygel-tracker-search-container.c"
	}
#line 278 "rygel-tracker-search-container.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op)) {
#line 1281 "rygel-tracker-search-container.c"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			char* _tmp14_;
			char* _tmp13_;
#line 280 "rygel-tracker-search-container.vala"
			filter = (_tmp14_ = g_strconcat (_tmp13_ = g_strconcat (variable, " = ", NULL), value, NULL), _g_free0 (filter), _tmp14_);
#line 1288 "rygel-tracker-search-container.c"
			_g_free0 (_tmp13_);
#line 281 "rygel-tracker-search-container.vala"
			break;
#line 1292 "rygel-tracker-search-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			char* _tmp19_;
			char* _tmp18_;
			char* _tmp17_;
			char* _tmp16_;
			char* _tmp15_;
#line 283 "rygel-tracker-search-container.vala"
			filter = (_tmp19_ = g_strconcat (_tmp18_ = g_strconcat (_tmp16_ = g_strconcat (_tmp15_ = g_strconcat ("regex(", variable, NULL), ", ", NULL), _tmp17_ = g_regex_escape_string (value, -1), NULL), ")", NULL), _g_free0 (filter), _tmp19_);
#line 1303 "rygel-tracker-search-container.c"
			_g_free0 (_tmp18_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp15_);
#line 286 "rygel-tracker-search-container.vala"
			break;
#line 1310 "rygel-tracker-search-container.c"
		}
	}
	result = filter;
	_g_free0 (variable);
	_g_free0 (value);
#line 289 "rygel-tracker-search-container.vala"
	return result;
#line 1318 "rygel-tracker-search-container.c"
}


#line 294 "rygel-tracker-search-container.vala"
static char* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const char* item_id, char** parent_id) {
#line 1324 "rygel-tracker-search-container.c"
	char* result = NULL;
	char** _tmp1_;
	gint _tokens_size_;
	gint tokens_length1;
	char** _tmp0_;
	char** tokens;
	gboolean _tmp2_ = FALSE;
#line 294 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 294 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 1336 "rygel-tracker-search-container.c"
	if (parent_id != NULL) {
		*parent_id = NULL;
	}
	tokens = (_tmp1_ = _tmp0_ = g_strsplit (item_id, ":", 2), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 298 "rygel-tracker-search-container.vala"
	if (tokens[0] != NULL) {
#line 298 "rygel-tracker-search-container.vala"
		_tmp2_ = tokens[1] != NULL;
#line 1345 "rygel-tracker-search-container.c"
	} else {
#line 298 "rygel-tracker-search-container.vala"
		_tmp2_ = FALSE;
#line 1349 "rygel-tracker-search-container.c"
	}
#line 298 "rygel-tracker-search-container.vala"
	if (_tmp2_) {
#line 1353 "rygel-tracker-search-container.c"
		char* _tmp3_;
#line 299 "rygel-tracker-search-container.vala"
		*parent_id = (_tmp3_ = g_strdup (tokens[0]), _g_free0 (*parent_id), _tmp3_);
#line 1357 "rygel-tracker-search-container.c"
		result = g_strdup (tokens[1]);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 301 "rygel-tracker-search-container.vala"
		return result;
#line 1362 "rygel-tracker-search-container.c"
	} else {
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 303 "rygel-tracker-search-container.vala"
		return result;
#line 1368 "rygel-tracker-search-container.c"
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}


#line 307 "rygel-tracker-search-container.vala"
static void rygel_tracker_search_container_create_proxies (RygelTrackerSearchContainer* self, GError** error) {
#line 1376 "rygel-tracker-search-container.c"
	GError * _inner_error_;
	DBusGConnection* connection;
	RygelTrackerResourcesIface* _tmp0_;
#line 307 "rygel-tracker-search-container.vala"
	g_return_if_fail (self != NULL);
#line 1382 "rygel-tracker-search-container.c"
	_inner_error_ = NULL;
#line 308 "rygel-tracker-search-container.vala"
	connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 1386 "rygel-tracker-search-container.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 310 "rygel-tracker-search-container.vala"
	self->priv->resources = (_tmp0_ = rygel_tracker_resources_iface_dbus_proxy_new (connection, RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE, RYGEL_TRACKER_SEARCH_CONTAINER_RESOURCES_PATH), _g_object_unref0 (self->priv->resources), _tmp0_);
#line 1399 "rygel-tracker-search-container.c"
	_dbus_g_connection_unref0 (connection);
}


#line 324 "rygel-tracker-search-container.vala"
static char** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, char** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1) {
#line 1406 "rygel-tracker-search-container.c"
	char** result = NULL;
	char** _tmp1_;
	gint _slice_size_;
	gint slice_length1;
	gint _tmp0_;
	char** slice;
	char** _tmp4_;
#line 324 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1416 "rygel-tracker-search-container.c"
	slice = (_tmp1_ = g_new0 (char*, (_tmp0_ = strvv_length2 - index) + 1), slice_length1 = _tmp0_, _slice_size_ = slice_length1, _tmp1_);
	{
		gint i;
#line 327 "rygel-tracker-search-container.vala"
		i = 0;
#line 1422 "rygel-tracker-search-container.c"
		{
			gboolean _tmp2_;
#line 327 "rygel-tracker-search-container.vala"
			_tmp2_ = TRUE;
#line 327 "rygel-tracker-search-container.vala"
			while (TRUE) {
#line 1429 "rygel-tracker-search-container.c"
				char* _tmp3_;
#line 327 "rygel-tracker-search-container.vala"
				if (!_tmp2_) {
#line 327 "rygel-tracker-search-container.vala"
					i++;
#line 1435 "rygel-tracker-search-container.c"
				}
#line 327 "rygel-tracker-search-container.vala"
				_tmp2_ = FALSE;
#line 327 "rygel-tracker-search-container.vala"
				if (!(i < slice_length1)) {
#line 327 "rygel-tracker-search-container.vala"
					break;
#line 1443 "rygel-tracker-search-container.c"
				}
#line 328 "rygel-tracker-search-container.vala"
				slice[i] = (_tmp3_ = g_strdup (strvv[(row * strvv_length2) + (i + index)]), _g_free0 (slice[i]), _tmp3_);
#line 1447 "rygel-tracker-search-container.c"
			}
		}
	}
	result = (_tmp4_ = slice, *result_length1 = slice_length1, _tmp4_);
#line 331 "rygel-tracker-search-container.vala"
	return result;
#line 1454 "rygel-tracker-search-container.c"
	slice = (_vala_array_free (slice, slice_length1, (GDestroyNotify) g_free), NULL);
}


static void rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass) {
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerSearchContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_search_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_search_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_tracker_search_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_tracker_search_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
}


static void rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self) {
	self->priv = RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE (self);
}


static void rygel_tracker_search_container_finalize (GObject* obj) {
	RygelTrackerSearchContainer * self;
	self = RYGEL_TRACKER_SEARCH_CONTAINER (obj);
	_rygel_tracker_query_unref0 (self->query);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
}


GType rygel_tracker_search_container_get_type (void) {
	static volatile gsize rygel_tracker_search_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_search_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		GType rygel_tracker_search_container_type_id;
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_search_container_type_id__volatile, rygel_tracker_search_container_type_id);
	}
	return rygel_tracker_search_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




