/* cmdmapui.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "libsrconf.h"
#include "cmdmapui.h"
#include "SRMessages.h"
#include <glade/glade.h>
#include "gnopiui.h"
#include "srintl.h"

/*#define __CMD_DEBUG__
*/
CmdMapFunctionsList cmd_function[] = 
    {
  	{"decrease y scale", 	N_("decrease y scale")},
	{"decrease x scale", 	N_("decrease x scale")},
	{"increase y scale", 	N_("increase y scale")},
	{"increase x scale", 	N_("increase x scale")},
	{"lock xy scale", 	N_("lock xy scale")},
	{"smoothing toggle", 	N_("smoothing toggle")},
	{"cursor toggle", 	N_("cursor toggle")},
	{"cursor on/off", 	N_("cursor on/off")},
	{"cursor mag on/off", 	N_("cursor mag on/off")},
	{"decrease cursor size", N_("decrease cursor size")},
	{"increase cursor size", N_("increase cursor size")},
	{"invert on/off", 	N_("invert on/off")},
	{"mag default", 	N_("mag default")},
	{"crosswire on/off", 	N_("crosswire on/off")},
	{"crosswire clip on/off", N_("crosswire clip on/off")},
	{"decrease crosswire size", N_("decrease crosswire size")},
	{"increase crosswire size", N_("increase crosswire size")},
	{"automatic panning on/off", N_("automatic panning on/off")},
	{"mouse tracking toggle", N_("mouse tracking toggle")},
	{"load magnifier defaults", N_("load magnifier defaults")},

	{"decrease pitch", 	N_("decrease pitch")},
	{"increase pitch", 	N_("increase pitch")},
	{"default pitch", 	N_("default pitch")},
	{"decrease rate", 	N_("decrease rate")},
	{"increase rate", 	N_("increase rate")},
	{"default rate", 	N_("default rate")},
	{"decrease volume", 	N_("decrease volume")},
	{"increase volume", 	N_("increase volume")},
	{"default volume", 	N_("default volume")},
	{"speech default", 	N_("speech default")},
	
	{"goto parent", 	N_("goto parent")},
	{"goto child", 		N_("goto child")},
	{"goto previous", 	N_("goto previous")},
	{"goto next",		N_("goto next")},
	{"repeat last", 	N_("repeat last")},
	{"goto focus", 		N_("goto focus")},
	{"goto title", 		N_("goto title")},
	{"goto menu", 		N_("goto menu")},
	{"goto toolbar", 	N_("goto toolbar")},
	{"goto statusbar", 	N_("goto statusbar")},
	{"widget surroundings", N_("widget surroundings")},
	
	{"goto caret", 		N_("goto caret")},
	{"goto first", 		N_("goto first")},
	{"goto last", 		N_("goto last")},
	{"change navigation mode", N_("change navigation mode")},

	{"toggle tracking mode",N_("toggle flat review/focus tracking mode")},	
	{"flat review", 	N_("flat review")},
	{"window hierarchy", 	N_("window hierarchy")},
	{"detailed informations", N_("detailed informations")},
	{"do default action", 	N_("do default action")},
	{"window overview", 	N_("window overview")},
	{"find next",		N_("find next")},
	{"find set", 		N_("find set")},
	{"attributes at caret", N_("attributes at caret")},	

	{"mouse left press", 	N_("mouse left press")},
	{"mouse left click", 	N_("mouse left click")},
	{"mouse left release", 	N_("mouse left release")},
	{"mouse right press", 	N_("mouse right press")},
	{"mouse right click", 	N_("mouse right click")},
	{"mouse right release", N_("mouse right release")},
	{"mouse middle press", 	N_("mouse middle press")},
	{"mouse middle release", N_("mouse middle release")},
	{"mouse middle click", 	N_("mouse middle click")},
	{"mouse goto current", 	N_("mouse goto current")},
	
	{"shutup",		N_("shutup")},
	{"pause/resume",	N_("pause/resume")},
	
	{"char left", 		N_("char left")}, 
	{"char right", 		N_("char right")},
	{"display left", 	N_("display left")},
	{"display right", 	N_("display right")},

	{NULL,			NULL}
	
    };

const gchar *key_list[] =
  {
  "A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z",
  "a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z",
   "F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","F13","F14",
   "F15","F16","F17","F18","F19","F20","F21","F22","F23","F24","F25","F26","F27",
   "F28","F29","F30","F31","F32","F33","F34","F35",
    "BackSpace","Tab","Return","Escape","Delete","Insert","space","Home","Left",
    "Up","Right","Down","Page_Up","Page_Down","End","KP_Space","KP_Tab","KP_Enter",
    "KP_F1","KP_F2","KP_F3","KP_F4","KP_Home","KP_Left","KP_Up","KP_Right","KP_Down",
    "KP_Prior","KP_Page_Up","KP_Next","KP_Page_Down","KP_End","KP_Begin","KP_Insert",
    "KP_Delete","KP_Equal","KP_Multiply","KP_Add","KP_Separator","KP_Subtract","KP_Decimal",
    "KP_Divide","KP_0","KP_1","KP_2","KP_3","KP_4","KP_5","KP_6","KP_7","KP_8","KP_9",
    "0","1","2","3","4","5","6","7","8","9","VoidSymbol","Linefeed","Clear" ,"Pause",
    "Scroll_Lock","Break","Num_Lock","Shift_L","Shift_R","Control_L","Control_R",
    "Caps_Lock","Shift_Lock","Meta_L","Meta_R","Alt_L","Alt_R","Super_L","Super_R",
    "Hyper_L","Hyper_R","exclam","quotedbl","numbersign","dollar","percent","ampersand",
    "apostrophe","quoteright","parenleft","parenright","asterisk","plus","comma",
    "minus","period","slash","colon","semicolon","less","equal","greater","question",
    "at","bracketleft","backslash","bracketright","asciicircum","underscore","grave",
    "quoteleft","braceleft","bar","braceright","asciitilde","nobreakspace","exclamdown",
    "dot","diez","caret"
};


typedef enum
{
    KEY_PAD,
    USER
}TypeOfUsingList;

struct {
    KeyItem 		*current_keyitem;
    GtkTreeIter 	current_iter;
    GSList		*current_list;
    GtkTreeView		*current_tree_view;
    gboolean		current_is_new;
    TypeOfUsingList    	current_type;
} current_item;
    
static GtkWidget	*w_user_keys = NULL;
static GtkWidget	*w_layer_key = NULL;
static GtkWidget	*w_add_modify = NULL;
static GtkWidget	*w_command_map = NULL;

static GtkWidget	*tv_cmd_list;
static GtkWidget	*tv_key_pad;
static GtkWidget	*tv_user_def;

static GtkWidget	*cb_key_list;
static GtkWidget	*ck_alt,*ck_ctrl,*ck_shift,*ck_numlock;

static GtkWidget	*sp_layer_no;
static GtkWidget	*sp_key_no;


GSList 		*user_def_list = NULL;
GSList 		*key_pad_list = NULL;

static GSList 		*removed_items_list = NULL;
static gboolean		cmdui_changes = FALSE;

/*********************DEBUG****************************/
#if 0
static void
cmdui_test_list (KeyItem *item)
{
    GSList *elem = NULL;
    sru_debug  ("\n KeyItem:%s",item->key_code);
    sru_debug  ("\n Commands:%s",item->commands);
    for (elem = item->command_list; elem ; elem = elem->next)
	sru_debug  ("\n Elem:%s", (gchar*)elem->data);
}

static void
cmdui_debug_list (GSList *list)
{
    GSList *tmp;
    if (!list)
	return;
    for (tmp = list ; tmp ; tmp = tmp->next)
    {
	cmdui_test_list ((KeyItem *)tmp->data);
    }
}
#endif

static void
cmdui_changes_set (gboolean state)
{
    cmdui_changes = state;
}

static gboolean
cmdui_changes_get ()
{
    return cmdui_changes;
}

#define SIZE_OF_LAYER_KEY 6
#define NO_REPR_DIGIT	  2
#define POS_DIGIT_0   1
#define POS_DIGIT_1   2
#define POS_DIGIT_2   4
#define POS_DIGIT_3   5

gchar*
cmdui_get_text_from_code (const gchar *str)
{
    sru_return_val_if_fail (str, NULL);

    if (str[0] == 'L' &&
	str[3] == 'K' &&
	strlen (str) == SIZE_OF_LAYER_KEY)
	return g_strdup_printf ("Layer%c%cKey%c%c", 
				str[POS_DIGIT_0], 
				str[POS_DIGIT_1], 
				str[POS_DIGIT_2], 
				str[POS_DIGIT_3]);
    
    return g_strdup (str);
}

gchar*
cmdui_get_code_from_text (const gchar *str)
{
    gchar *tmp = NULL;
    
    sru_return_val_if_fail (str, NULL);
    
    if (!g_ascii_strncasecmp (str,"Layer", strlen ("Layer")) &&
        !g_ascii_strncasecmp (str + strlen("Layer") + NO_REPR_DIGIT,"Key", strlen ("Key")))
    {
	tmp = g_strdup_printf ("L%c%cK%c%c", *(str + strlen("Layer")),
					     *(str + strlen("Layer") + 1),
					     *(str + strlen("Layer") + 2 + strlen ("Key")),
					     *(str + strlen("Layer") + 3 + strlen ("Key")));
	return tmp;
    }
    
    return g_strdup (str);
}

static GSList*
cmdui_remove_keyitem_from_list (GSList 	*list,
				GtkTreeView *tree_view);

static void
cmdui_selection_add_func (GtkTreeModel 	*model,
		    	GtkTreePath	*path,
			GtkTreeIter	*iter,
			gpointer	data)
{       
    gint pos;
    gchar *text = NULL; 

    sru_return_if_fail (GTK_IS_LIST_STORE (model));
    
    gtk_tree_model_get (model, 	 iter,
                    	CMD_COLUMN, &text,
                    	-1);
			    
    for (pos = 0 ; cmd_function[pos].descr ; pos++)
	if (!strcmp (_(cmd_function [pos].descr), text)) 
	    break;
	    
    g_free (text);
    
    if (cmd_function[pos].descr)
    {
	    (current_item.current_keyitem)->command_list = 
		g_slist_prepend ((current_item.current_keyitem)->command_list, 
				g_strdup (cmd_function [pos].name));
    }	
}


static void
cmdui_add_modify_set_changes (void)
{
    gchar *txt;
    GtkTreeModel *model = NULL;
    GtkTreeSelection *selection = 
	    gtk_tree_view_get_selection ( GTK_TREE_VIEW (tv_cmd_list));	    

    sru_return_if_fail (current_item.current_keyitem);	    
        		    
    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (current_item.current_tree_view));

    (current_item.current_keyitem)->command_list =
	cmdconf_free_list_and_data ((current_item.current_keyitem)->command_list);

    gtk_tree_selection_selected_foreach (selection, 
    					cmdui_selection_add_func, 
					NULL);

    (current_item.current_keyitem)->command_list = 
        cmdconf_check_integrity ( (current_item.current_keyitem)->command_list);
	    
    txt = cmdconf_create_view_string ((current_item.current_keyitem)->command_list);
	
    sru_return_if_fail (txt);
    sru_return_if_fail (GTK_IS_LIST_STORE (model));
    
    gtk_list_store_set (GTK_LIST_STORE (model), 
			&current_item.current_iter, 
			FUNC_COLUMN, txt,
			-1 );
			
    (current_item.current_keyitem)->commands = txt;
	    
    cmdui_changes_set (TRUE);
}

static GtkListStore*
cmdui_populate_cmd_list_store_with_keys (GtkListStore *store)
{
    GtkTreeIter iter;
    gint pos;
    
    for (pos = 0 ; cmd_function[pos].descr ; pos++)
    {
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 
		    	    CMD_COLUMN, _(cmd_function[pos].descr), 
		    	    -1);
    }
    
    return store;
}

static GtkTreeModel*
cmdui_create_model (void)
{
    GtkListStore *store;
  
    store = gtk_list_store_new (NO_OF_CMD_COLUMNS, 
				G_TYPE_STRING);

    cmdui_populate_cmd_list_store_with_keys (store);
  
    return GTK_TREE_MODEL (store);
}

void 
cmdui_treeviews_set_current_value (void)
{
    GtkTreeModel     *model;
    GtkTreeSelection *selection;
    GtkTreeIter      iter;
    gboolean 	     valid;

    if (!w_add_modify) 
	return;
	
    sru_return_if_fail (current_item.current_keyitem);
    sru_return_if_fail ((current_item.current_keyitem)->key_code);
    
    model 	  = gtk_tree_view_get_model 	( GTK_TREE_VIEW (tv_cmd_list));
    selection     = gtk_tree_view_get_selection ( GTK_TREE_VIEW (tv_cmd_list));

    gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);

    gtk_tree_selection_unselect_all (selection);	
    
    valid = gtk_tree_model_get_iter_first ( model, &iter );
    
    if (!strcmp ((current_item.current_keyitem)->key_code, BLANK))
	return;
	
    while (valid)
    {
	gchar *key = NULL;
	gint   pos = 0;
	    
	if (GTK_IS_LIST_STORE (model))
	{
	    gtk_tree_model_get (model, 	&iter,
    				CMD_COLUMN, &key,
                    		-1);
	}
	    
	for (pos = 0 ; cmd_function[pos].descr ; pos++)
	    if (!strcmp (_(cmd_function[pos].descr), key)) break;
				
	g_free (key);
	    
	if (cmd_function[pos].descr)
	{
	    GSList *elem = NULL;
	    for (elem = (current_item.current_keyitem)->command_list ; elem ; elem = elem->next)
	    {
	        if (!strcmp (cmd_function[pos].name,
	    		    (gchar*)elem->data))
	    	{
		    gtk_tree_selection_select_iter (selection, &iter);
		    break;
		}
	    }
	}

	valid = gtk_tree_model_iter_next (model, &iter);	    
    }
}

static void
cmdui_response_add_modify_event (GtkDialog *dialog,
		    		gint       response_id,
		    		gpointer   user_data)
{
    if (response_id == GTK_RESPONSE_OK)
	cmdui_add_modify_set_changes ();
	
    if (response_id == GTK_RESPONSE_CANCEL)
    {
	if (current_item.current_is_new)
	{
	    current_item.current_list =
		cmdui_remove_keyitem_from_list (current_item.current_list,
						current_item.current_tree_view);

	}
	if (current_item.current_type == KEY_PAD)
	    key_pad_list = current_item.current_list;
	if (current_item.current_type == USER)
	    user_def_list = current_item.current_list;
    }
    gtk_widget_hide ((GtkWidget*)dialog);	
}


static gint
cmdui_delete_emit_response_cancel (GtkDialog *dialog,
				   GdkEventAny *event,
				   gpointer data)
{
    gtk_dialog_response (GTK_DIALOG (dialog),
			 GTK_RESPONSE_CANCEL);
    return TRUE; /* Do not destroy */
}

static void
cmdui_cmd_list_activated (GtkTreeView       *tree_view,
                	  GtkTreePath       *path,
			  GtkTreeViewColumn *column)
{
    cmdui_response_add_modify_event (GTK_DIALOG (w_add_modify),
				    GTK_RESPONSE_OK,
				    NULL);
}

static gboolean
cmdui_search_equal_func (GtkTreeModel  *model,
			 gint 		column,
			 const gchar	*key,
			 GtkTreeIter	*iter,
			 gpointer	search_data)
{
    fprintf (stderr,"\n!!!!!!!!!!!!!!!!!!!!!!!!!!search\n\n\n");
    return FALSE;
}

static void
cmdui_set_handlers_add_modify (GladeXML *xml)
{
    GtkTreeModel 	*model;
    GtkCellRenderer 	*cell_renderer;
    GtkTreeSelection 	*selection;
    GtkTreeViewColumn 	*column;
    
    w_add_modify 	= glade_xml_get_widget (xml, "w_add_modify");
    tv_cmd_list		= glade_xml_get_widget (xml, "tv_cmd_list");
    
    g_signal_connect (w_add_modify , "response",
		      G_CALLBACK (cmdui_response_add_modify_event), NULL);
    g_signal_connect (w_add_modify , "delete_event",
                      G_CALLBACK (cmdui_delete_emit_response_cancel), NULL);

    model = cmdui_create_model ();
    
    gtk_tree_view_set_model (GTK_TREE_VIEW (tv_cmd_list), model);
    
    g_signal_connect (tv_cmd_list, "row_activated", 
		      G_CALLBACK (cmdui_cmd_list_activated), 
		      model);

    gtk_tree_view_set_search_column (GTK_TREE_VIEW (tv_cmd_list), CMD_COLUMN);
    
    gtk_tree_sortable_set_sort_column_id (  GTK_TREE_SORTABLE (model), 
					    CMD_COLUMN, 
					    GTK_SORT_ASCENDING);
	    
    g_object_unref (G_OBJECT (model));

    cell_renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes   (_("Commands"),
    							cell_renderer,
							"text", CMD_COLUMN,
							NULL);							
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_cmd_list), column);
    gtk_tree_view_column_set_sort_column_id (column, CMD_COLUMN);
    gtk_tree_view_set_search_equal_func (GTK_TREE_VIEW (tv_cmd_list),
					cmdui_search_equal_func,
					NULL, NULL);
    gtk_tree_view_set_enable_search (GTK_TREE_VIEW (tv_cmd_list), TRUE);
    
    selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (tv_cmd_list));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE); 
}

gboolean
cmdui_load_add_modify (void)
{
    if (!w_add_modify)
    {
	GladeXML *xml;
	xml = gn_load_interface ("User_Properties/user_properties.glade2", "w_add_modify");
	sru_return_val_if_fail (xml, FALSE);
	cmdui_set_handlers_add_modify (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (w_add_modify),
					   GTK_WINDOW (w_command_map));
				    
	gtk_window_set_destroy_with_parent (GTK_WINDOW (w_add_modify), 
						TRUE);
    }
    else
        gtk_widget_show (w_add_modify);
	
    
    cmdui_treeviews_set_current_value ();
    
    return TRUE;
}

/**************************************************************************/
#define MODIFIER(K,C) (K == TRUE ? C : "")
#define LINE(X)       (X == TRUE ? "-" : "")
#define STR(X)	      (X != NULL ? X : "")
#define STR_UPPER(X,Y)    ((Y == TRUE && g_unichar_isalpha (X) == TRUE) ? g_utf8_strup (X, -1) : X)

GSList*
cmdui_add_item_to_list (GtkTreeView *tree_view, 
			GSList      *list,
			const gchar  *key_code);

static gchar*
cmdui_get_key (void)
{
    gboolean alt, shift, ctrl,numlock;
    gboolean line;
    gchar *key = NULL;
    gchar *rv  = NULL;
    
    alt 	= gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ck_alt));
    shift 	= gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ck_shift));
    ctrl 	= gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ck_ctrl));
    numlock 	= gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ck_numlock));
    
    line = alt || shift || ctrl || numlock;
    (const gchar*) key = 
	gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cb_key_list)->entry));
    
    if (!key || strlen (key) == 0)
	return rv;
	
    rv = g_strconcat(MODIFIER(alt,"A"),
		     MODIFIER(ctrl,"C"),
		     MODIFIER(shift,"S"),
		     MODIFIER(numlock,"N"),
		     LINE(line),
		     STR(key) ,NULL);
    return rv;
}

static void
cmdui_set_key_value (void)
{
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ck_alt), FALSE);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ck_shift), FALSE);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ck_ctrl), FALSE);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ck_numlock), FALSE);
    gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cb_key_list)->entry), "");    
}

static void
cmdui_response_user_keys_event (GtkDialog *dialog,
		      gint       response_id,
		      gpointer   user_data)
{
    if (response_id == GTK_RESPONSE_OK) 
    {
	gchar *key_code = cmdui_get_key ();
	
	if (key_code)
	{
	    current_item.current_type = USER;
	    user_def_list = cmdui_add_item_to_list (GTK_TREE_VIEW (tv_user_def), 
						    user_def_list,
						    key_code);
	    g_free (key_code);
	}
    }
    gtk_widget_hide ((GtkWidget*)dialog);
}


static void
cmdui_foreach_key (gpointer data,
		   gpointer user_data)
{
    g_free ((gchar*)data);
}
		
static void
cmdui_set_handlers_user_keys (GladeXML *xml)
{
    GList *g_key_list = NULL;
    gint iter;
    
    w_user_keys	= glade_xml_get_widget (xml, "w_user_keys");
    cb_key_list	= glade_xml_get_widget (xml, "cb_key_list");
    ck_alt	= glade_xml_get_widget (xml, "ck_alt");
    ck_ctrl	= glade_xml_get_widget (xml, "ck_ctrl");
    ck_shift	= glade_xml_get_widget (xml, "ck_shift");
    ck_numlock	= glade_xml_get_widget (xml, "ck_numlock");

    g_signal_connect (w_user_keys, "response",
		      G_CALLBACK (cmdui_response_user_keys_event), NULL);
    g_signal_connect (w_user_keys, "delete_event",
                      G_CALLBACK (cmdui_delete_emit_response_cancel), NULL);
		      
    for (iter = 0 ; iter < G_N_ELEMENTS (key_list) ; iter++)
	g_key_list = g_list_append (g_key_list, g_strdup (key_list[iter]));
    
    gtk_combo_set_popdown_strings ( GTK_COMBO (cb_key_list),
				    g_key_list);
    g_key_list = g_list_first (g_key_list);
    g_list_foreach (g_key_list,(gpointer)cmdui_foreach_key, NULL);
    g_list_free (g_key_list);
}

gboolean
cmdui_load_user_keys (GtkWidget *parent_window)
{
    if (!w_user_keys)
    {
	GladeXML *xml;
	xml = gn_load_interface ("User_Properties/user_properties.glade2", "w_user_keys");
	sru_return_val_if_fail (xml, FALSE);
	cmdui_set_handlers_user_keys (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for (GTK_WINDOW (w_user_keys),
				      GTK_WINDOW (parent_window));
    	gtk_window_set_destroy_with_parent (GTK_WINDOW (w_user_keys), TRUE);
    }
    else
        gtk_widget_show (w_user_keys);
	    
    cmdui_set_key_value ();
    
    return TRUE;
}

/***************************************************************************/
static gchar*
cmdui_get_layer_key (void)
{
    gchar *str =
	g_strdup_printf ("L%02dK%02d",
	    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (sp_layer_no)),
	    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (sp_key_no)));
    return str;
}

static void
cmdui_response_layer_key_event (GtkDialog *dialog,
		    		gint       response_id,
		        	gpointer   user_data)
{
    if (response_id == GTK_RESPONSE_OK) 
    {
	gchar *layer_key = cmdui_get_layer_key ();
	if (layer_key)
	{
	    current_item.current_type = KEY_PAD;
	    key_pad_list =
		    cmdui_add_item_to_list (GTK_TREE_VIEW (tv_key_pad), 
					    key_pad_list,
					    layer_key);

	    g_free (layer_key);
	}
    }
    gtk_widget_hide ((GtkWidget*)dialog);
}

		
static void
cmdui_set_handlers_layer_key (GladeXML *xml)
{
    w_layer_key = glade_xml_get_widget (xml, "w_layer_key");
    sp_layer_no	= glade_xml_get_widget (xml, "sp_layer_no");
    sp_key_no	= glade_xml_get_widget (xml, "sp_key_no");

    gtk_spin_button_set_range ( GTK_SPIN_BUTTON (sp_layer_no), CMD_MIN_LAYER, CMD_MAX_LAYER);
    gtk_spin_button_set_range ( GTK_SPIN_BUTTON (sp_key_no),   CMD_MIN_LAYER, CMD_MAX_LAYER);
    g_signal_connect (w_layer_key, "response",
		      G_CALLBACK (cmdui_response_layer_key_event), NULL);
    g_signal_connect (w_layer_key, "delete_event",
                      G_CALLBACK (cmdui_delete_emit_response_cancel), NULL);
}

gboolean
cmdui_load_layer_key (GtkWidget *parent_window)
{
    if (!w_layer_key)
    {
	GladeXML *xml;
	xml = gn_load_interface ("User_Properties/user_properties.glade2", "w_layer_key");
	sru_return_val_if_fail (xml, FALSE);
	cmdui_set_handlers_layer_key (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for (GTK_WINDOW (w_layer_key),
				      GTK_WINDOW (parent_window));
    	gtk_window_set_destroy_with_parent (GTK_WINDOW (w_layer_key), TRUE);
    }
    else
        gtk_widget_show (w_layer_key);
		
    return TRUE;
}




/***************************************************************************/

static GSList*
cmdui_free_removed_list (void)
{
    if (!removed_items_list) 
	return NULL;
    
    removed_items_list =
	cmdconf_free_list_and_data (removed_items_list);
	
    return removed_items_list;
}

static GSList*
cmdui_removed_list_add (GSList *list,
			const gchar *str)
{
    GSList *elem = NULL;
    sru_return_val_if_fail (str, list);
	
    for (elem = list ; elem ; elem = elem->next)
     if (!strcmp ((gchar*)elem->data, str))
        return list;

    list = g_slist_append (list, g_strdup (str));
    
    return list;
}


static void
cmdui_apply_set (void)
{
    removed_items_list =
	cmdconf_remove_item_from_gconf_list (removed_items_list);
    cmdui_free_removed_list ();

    cmdconf_user_def_set (user_def_list);
    cmdconf_key_cmd_list_set (user_def_list);
    cmdconf_key_pad_set (key_pad_list);
    cmdconf_key_cmd_list_set (key_pad_list);
    
    cmdconf_changes_end_event 	();
}

static void
cmdui_clear_treeviews (void)
{

    GtkTreeModel *model_ud = 
        gtk_tree_view_get_model (GTK_TREE_VIEW (tv_user_def));
    GtkTreeModel *model_kp = 
        gtk_tree_view_get_model (GTK_TREE_VIEW (tv_key_pad));
	
    gtk_list_store_clear (GTK_LIST_STORE (model_ud));
    gtk_list_store_clear (GTK_LIST_STORE (model_kp));
}


static GSList*
cmdui_remove_keyitem_from_list (GSList 	*list,
				GtkTreeView *tree_view)
{
    GtkTreeIter  iter;
    GtkTreeModel *model = gtk_tree_view_get_model ( tree_view );
    GtkTreeSelection *selection = gtk_tree_view_get_selection ( tree_view );	    
    GSList *root = list;
    GSList *elem = NULL;
    gchar *key = NULL;
    gchar *tmp = NULL;

    
    if (!gtk_tree_selection_get_selected (selection, NULL, &iter))
	return root;
    
    if (GTK_IS_LIST_STORE (model))
    {
	gtk_tree_model_get (model, &iter,
        		    KEYS_COLUMN, &key,
            		    -1);
    }
	
    if (!key || strlen (key) == 0)
    {
	sru_message (_("cmdui:Invalid selected item"));
	g_free (key);
	return list;
    }
			
    tmp = cmdui_get_code_from_text (key);	
    g_free (key);
	
    if (!strcmp (tmp, BLANK))
	return root;
			
    for (elem = root; elem ; elem = elem->next)
	if (!strcmp (tmp, ((KeyItem*)elem->data)->key_code)) 
	break;
		
    g_free (tmp);	
	    
    if (!elem)
	return root;
    
    cmdui_changes_set (TRUE);
		
    root = g_slist_remove_link (root, elem);
		
    removed_items_list =
	    cmdui_removed_list_add (removed_items_list,
				   ((KeyItem*)elem->data)->key_code);
    elem = cmdconf_free_keyitem_list_item (elem);
		    
    gtk_list_store_remove ( GTK_LIST_STORE (model), &iter);

    return root;
}
				    

void
cmdui_user_remove_clicked (GtkWidget *button,
	        	   gpointer user_data)
{
    
    user_def_list = 
	cmdui_remove_keyitem_from_list (user_def_list,
				    	GTK_TREE_VIEW (tv_user_def));
}

void
cmdui_key_pad_remove_clicked (GtkWidget *button,
	        	      gpointer user_data)
{
    key_pad_list = 
	cmdui_remove_keyitem_from_list (key_pad_list,
				    	GTK_TREE_VIEW (tv_key_pad));
}


GSList*
cmdui_add_item_to_list (GtkTreeView *tree_view, 
			GSList      *list,
			const gchar  *key_code)
{
    KeyItem 	     *new_code  = NULL;
    gchar 	     *tmp = NULL;
    GtkTreeIter      iter;
    GtkTreeModel     *model;
    GtkTreeSelection *selection;

    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (tree_view));
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (tree_view));

    if (!key_code || strlen (key_code) == 0)
	return list;
	
    if (cmdconf_check_if_item_exist (list, key_code))
	return list;

    new_code = cmdconf_new_keyitem ();
    sru_return_val_if_fail (new_code, list);
    new_code->key_code = g_strdup (key_code);
    
    list = g_slist_prepend (list , new_code);		    
    tmp  = cmdui_get_text_from_code (new_code->key_code);
    gtk_list_store_append (GTK_LIST_STORE (model), &iter);
    gtk_list_store_set (GTK_LIST_STORE (model), &iter, 
	    		KEYS_COLUMN, tmp, 
			FUNC_COLUMN, "",
	    		-1);
    g_free (tmp);
    gtk_tree_selection_select_iter (selection, &iter);
    
    current_item.current_keyitem = new_code;
    current_item.current_iter = iter;
    current_item.current_list = list;
    current_item.current_tree_view = tree_view;
    current_item.current_is_new = TRUE;
    cmdui_changes_set (TRUE);
    cmdui_load_add_modify ();
    return list;
}

GSList*
cmdui_modify_item_to_list (GtkTreeView *tree_view, 
			   GSList      *list)
{
    KeyItem 	     *new_code  = NULL;
    GtkTreeIter      iter;
    GtkTreeModel     *model;
    GtkTreeSelection *selection;
    
    GSList *elem = NULL;
    gchar *key = NULL;
    gchar *tmp = NULL;

    
    model 	= gtk_tree_view_get_model ( GTK_TREE_VIEW (tree_view));
    selection 	= gtk_tree_view_get_selection ( GTK_TREE_VIEW (tree_view));

    sru_return_val_if_fail (GTK_IS_LIST_STORE (model), list);

    if (!gtk_tree_selection_get_selected (selection, NULL, &iter))
	return list;
	
    sru_return_val_if_fail (GTK_IS_LIST_STORE (model), list);
    
    gtk_tree_model_get (model, 	     &iter,
            		KEYS_COLUMN, &key,
            		-1);
	
    if (!key || strlen (key) == 0)
    {
	sru_message (_("cmdui:Invalid selected item"));	    
	return list;
    }
			
    tmp = cmdui_get_code_from_text (key);
    g_free (key);
    for (elem = list; elem ; elem = elem->next)
    {
	if (!strcmp (((KeyItem*)elem->data)->key_code, tmp))
	{
	        new_code = elem->data;
	        break;
	}
    }		
    g_free (tmp);
		
    if (!new_code)
	return list;
	
    current_item.current_keyitem = new_code;
    current_item.current_iter = iter;
    current_item.current_list = list;
    current_item.current_tree_view = tree_view;
    current_item.current_is_new = FALSE;
    cmdui_load_add_modify ();

    return list;
}

void
cmdui_key_pad_add_clicked (GtkWidget *button,
	        	   gpointer user_data)
{
    cmdui_load_layer_key ((GtkWidget*)user_data);
}

static void
cmdui_user_add_clicked (GtkWidget *button,
	                gpointer user_data)
{
    cmdui_load_user_keys ((GtkWidget*)user_data);
}


static void
cmdui_key_pad_modify_clicked (GtkWidget *button,
	        	      gpointer  user_data)
{
    current_item.current_type = KEY_PAD;
    key_pad_list = 
	cmdui_modify_item_to_list (GTK_TREE_VIEW (tv_key_pad), key_pad_list);

}

static void
cmdui_user_modify_clicked (GtkWidget 	*button,
	            	   gpointer 	user_data)
{
    current_item.current_type = USER;
    user_def_list =
	cmdui_modify_item_to_list (GTK_TREE_VIEW (tv_user_def), user_def_list);

}

static void
cmdui_key_pad_row_activated_cb (GtkTreeView       *tree_view,
                		GtkTreePath       *path,
				GtkTreeViewColumn *column)
{
    current_item.current_type = KEY_PAD;
    key_pad_list = 
	cmdui_modify_item_to_list (GTK_TREE_VIEW (tv_key_pad), key_pad_list);
}

static void
cmdui_user_def_row_activated_cb (GtkTreeView      *tree_view,
                		GtkTreePath       *path,
				GtkTreeViewColumn *column)
{
    current_item.current_type = USER;
    user_def_list =
	cmdui_modify_item_to_list (GTK_TREE_VIEW (tv_user_def), user_def_list);
}


static GtkListStore*
cmdui_populate_list_store_with_keys (GtkListStore *store, GSList *list)
{
    GtkTreeIter iter;
    GSList *elem = NULL;
    
    if (!list) 
	return store;
    
    for (elem = list; elem ; elem = elem->next)
    {
	gchar *tmp = cmdui_get_text_from_code (((KeyItem*)elem->data)->key_code);
	gtk_list_store_append ( GTK_LIST_STORE (store), &iter);
	gtk_list_store_set ( GTK_LIST_STORE (store), &iter, 
		    	    KEYS_COLUMN, tmp,
		    	    FUNC_COLUMN, ((KeyItem*)elem->data)->commands,
		    	    -1);
	g_free (tmp);
    }
    
    return store;
}


void
cmdui_update_list_stores (void)
{

    GtkTreeModel *model_ud = 
	gtk_tree_view_get_model (GTK_TREE_VIEW (tv_user_def));

    GtkTreeModel *model_kp = 
	gtk_tree_view_get_model (GTK_TREE_VIEW (tv_key_pad));
        
    if (user_def_list && GTK_IS_LIST_STORE (model_ud))
	cmdui_populate_list_store_with_keys (GTK_LIST_STORE (model_ud), 
					    user_def_list);
					    
    if (key_pad_list && GTK_IS_LIST_STORE (model_kp))
	cmdui_populate_list_store_with_keys (GTK_LIST_STORE (model_kp), 
					    key_pad_list);
    
}

static GtkTreeModel*
cmdui_create_model_list (GSList *list)
{
    GtkListStore *store;
      
    store = gtk_list_store_new (NO_OF_KEYS_COLUMNS, 
				G_TYPE_STRING, 
				G_TYPE_STRING);
    cmdui_populate_list_store_with_keys (store, list);
    return GTK_TREE_MODEL (store);
}

static void
cmdui_response_event (GtkDialog *dialog,
		      gint       response_id,
		      gpointer   user_data)
{
    switch (response_id)
    {
     case GTK_RESPONSE_OK: 
        {
	    cmdui_clear_treeviews ();
	    
	    if (cmdui_changes_get ())
		cmdui_apply_set ();
		
	    key_pad_list = cmdconf_free_keyitem_list_item (key_pad_list);
	    user_def_list = cmdconf_free_keyitem_list_item (user_def_list);

	    gtk_widget_hide ((GtkWidget*)dialog);
	}
        break;
     case GTK_RESPONSE_CANCEL:
        {
	    cmdui_clear_treeviews ();
	    
	    key_pad_list = cmdconf_free_keyitem_list_item (key_pad_list);
	    user_def_list = cmdconf_free_keyitem_list_item (user_def_list);
	    
	    cmdui_free_removed_list ();
    	    gtk_widget_hide ((GtkWidget*)dialog);	    
	}
        break;
     case GTK_RESPONSE_APPLY:
        {
	    cmdui_apply_set ();
    
	    cmdui_changes_set (FALSE);
	}
        break;
    case GTK_RESPONSE_HELP:
	gn_load_help ("gnopernicus-command-mapping");
	break;	
    default:
            cmdui_clear_treeviews ();
		    
	    key_pad_list = cmdconf_free_keyitem_list_item (key_pad_list);
	    user_def_list = cmdconf_free_keyitem_list_item (user_def_list);
	
	    cmdui_free_removed_list ();

            gtk_widget_hide ((GtkWidget*)dialog);
        break;
    }
}

static void
cmdui_set_handlers (GladeXML *xml)
{
    GtkTreeModel 	*model_user_def;
    GtkTreeModel 	*model_key_pad;
    GtkCellRenderer 	*cell_renderer;
    GtkTreeSelection 	*selection;
    GtkTreeViewColumn 	*column;
    
    w_command_map 	= glade_xml_get_widget (xml, "w_command_map");
    tv_key_pad		= glade_xml_get_widget (xml, "tv_layers");
    tv_user_def		= glade_xml_get_widget (xml, "tv_user_def");

    g_signal_connect (w_command_map, "response",
		      G_CALLBACK (cmdui_response_event), NULL);
    g_signal_connect (w_command_map, "delete_event",
                      G_CALLBACK (cmdui_delete_emit_response_cancel), NULL);

		      
    glade_xml_signal_connect (xml,"on_bt_user_remove_clicked",  
		GTK_SIGNAL_FUNC (cmdui_user_remove_clicked));
    glade_xml_signal_connect_data (xml,"on_bt_user_add_clicked",  	
		GTK_SIGNAL_FUNC (cmdui_user_add_clicked), w_command_map);
    glade_xml_signal_connect (xml,"on_bt_user_modify_clicked",	
		GTK_SIGNAL_FUNC (cmdui_user_modify_clicked));
		
    glade_xml_signal_connect (xml,"on_bt_key_pad_remove_clicked",	
		GTK_SIGNAL_FUNC (cmdui_key_pad_remove_clicked));
    glade_xml_signal_connect_data (xml,"on_bt_key_pad_add_clicked",		
		GTK_SIGNAL_FUNC (cmdui_key_pad_add_clicked), w_command_map);
    glade_xml_signal_connect (xml,"on_bt_key_pad_modify_clicked",		
		GTK_SIGNAL_FUNC (cmdui_key_pad_modify_clicked));

    model_user_def 	= cmdui_create_model_list (user_def_list);
    model_key_pad 	= cmdui_create_model_list (key_pad_list);
    
    gtk_tree_view_set_model (GTK_TREE_VIEW (tv_key_pad),  model_key_pad);
    gtk_tree_view_set_model (GTK_TREE_VIEW (tv_user_def), model_user_def);
    
    gtk_tree_sortable_set_sort_column_id ( GTK_TREE_SORTABLE (model_key_pad), 
					    KEYS_COLUMN, 
					    GTK_SORT_ASCENDING);

    gtk_tree_sortable_set_sort_column_id ( GTK_TREE_SORTABLE (model_user_def), 
					    KEYS_COLUMN, 
					    GTK_SORT_ASCENDING);

    g_signal_connect (tv_key_pad, "row_activated", 
		      G_CALLBACK (cmdui_key_pad_row_activated_cb), 
		      model_key_pad);
    g_signal_connect (tv_user_def, "row_activated", 
		      G_CALLBACK (cmdui_user_def_row_activated_cb), 
		      model_user_def);

	    
    g_object_unref (G_OBJECT (model_key_pad));
    g_object_unref (G_OBJECT (model_user_def));
    
    cell_renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes   (_("Layer keys"),
    							cell_renderer,
							"text", KEYS_COLUMN,
							NULL);	
    gtk_tree_view_column_set_sort_column_id (column, KEYS_COLUMN);
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_key_pad), column);
    column = gtk_tree_view_column_new_with_attributes   (_("Commands"),
    							cell_renderer,
							"text", FUNC_COLUMN,
							NULL);	
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_key_pad),column);
        
    cell_renderer = gtk_cell_renderer_text_new ();
    column = gtk_tree_view_column_new_with_attributes   (_("User keys"),
    							cell_renderer,
							"text", KEYS_COLUMN,
							NULL);
    gtk_tree_view_column_set_sort_column_id (column, KEYS_COLUMN);
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_user_def),column);
    column = gtk_tree_view_column_new_with_attributes   (_("Commands"),
    							cell_renderer,
							"text", FUNC_COLUMN,
							NULL);    
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_user_def), column);
        
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (tv_key_pad));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);
    
    selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (tv_user_def));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);

}

gboolean
cmdui_load_user_properties(GtkWidget *parent_window)
{
    user_def_list = cmdconf_user_def_get (user_def_list);
    key_pad_list = cmdconf_key_pad_get (key_pad_list);

    if (!w_command_map)
    {
	GladeXML *xml;
	xml = gn_load_interface ("User_Properties/user_properties.glade2", "w_command_map");
	sru_return_val_if_fail (xml, FALSE);
	cmdui_set_handlers (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for (GTK_WINDOW (w_command_map),
				      GTK_WINDOW (parent_window));
    	gtk_window_set_destroy_with_parent (GTK_WINDOW (w_command_map), TRUE);
    }
    else
    {
        cmdui_update_list_stores ();
        gtk_widget_show (w_command_map);
    }

    cmdui_changes_set (TRUE);
		    
    return TRUE;
}



