/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _BaseHelpProtocolHandler_h_
#define _BaseHelpProtocolHandler_h_

#include "BaseProtocolHandler.h"

#include "nsCOMPtr.h"
#include "nsString.h"
#include "nsIURI.h"
#include "nsIChannel.h"

class GBaseHelpProtocolHandler : public GBaseProtocolHandler
{
  public:
	NS_DECL_ISUPPORTS
	NS_IMETHODIMP NewURI(const nsACString &aSpec, const char *aOriginCharset,
			     nsIURI *aBaseURI, nsIURI **_retval);
	NS_IMETHODIMP NewChannel(nsIURI *aURI, nsIChannel **_retval);

	GBaseHelpProtocolHandler (const char *docType, const char *converter) :
	 			 GBaseProtocolHandler(docType),
				 mConverter(converter)
				 {NS_INIT_ISUPPORTS();};
	virtual ~GBaseHelpProtocolHandler() {};

  protected:
	/* additional members */
	NS_METHOD CreateGHelpURI (nsIURI **_retval);
	NS_METHOD CreatePage (void );
	nsCOMPtr<nsIChannel> mChannel;
	nsCOMPtr<nsIURI> mURI;
	nsCString mConverter;
	nsCString mDocName;
	nsCString mSection;
};

#endif //_BaseHelpProtocolHandler_h_
