/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

#ifndef GPDF_UTIL_H
#define GPDF_UTIL_H

/* This is for C++ _definitions_ to be exported with C linkage */
/* Hide braces and get back one level of indentation */
#define BEGIN_EXTERN_C extern "C" {
#define END_EXTERN_C }


#include <bonobo/bonobo-macros.h>

/*
 * Copied from bonobo-macros.h by Darin Adler and gnome-macros by
 * George Lebl, added casts for C++
 */

/* Define the boilerplate type stuff to reduce typos and code size.  Defines
 * the get_type method and the parent_class static variable. */

#define GPDF_BOILERPLATE(type, type_as_function, corba_type,		\
			 parent_type, parent_type_macro,		\
			 register_type_macro)				\
static void type_as_function ## _class_init    (type ## Class *klass);	\
static void type_as_function ## _instance_init (type          *object);	\
static parent_type ## Class *parent_class = NULL;			\
static void								\
type_as_function ## _class_init_trampoline (gpointer klass,		\
					    gpointer data)		\
{									\
	parent_class = (parent_type ## Class *)g_type_class_ref (	\
		parent_type_macro);					\
	type_as_function ## _class_init ((type ## Class *)klass);	\
}									\
GType									\
type_as_function ## _get_type (void)					\
{									\
	static GType object_type = 0;					\
	if (object_type == 0) {						\
		static const GTypeInfo object_info = {			\
		    sizeof (type ## Class),				\
		    NULL,		/* base_init */			\
		    NULL,		/* base_finalize */		\
		    type_as_function ## _class_init_trampoline,		\
		    NULL,		/* class_finalize */		\
		    NULL,               /* class_data */		\
		    sizeof (type),					\
		    0,                  /* n_preallocs */		\
		    (GInstanceInitFunc) type_as_function ## _instance_init \
		};							\
		object_type = register_type_macro			\
			(type, type_as_function, corba_type,		\
			 parent_type, parent_type_macro);		\
	}								\
	return object_type;						\
}

#define GPDF_CLASS_BOILERPLATE(type, type_as_function,			\
			       parent_type, parent_type_macro)		\
	GPDF_BOILERPLATE(type, type_as_function, type,			\
			 parent_type, parent_type_macro,		\
			 GPDF_REGISTER_TYPE)

#define GPDF_REGISTER_TYPE(type, type_as_function, corba_type,		\
		    	   parent_type, parent_type_macro)		\
	g_type_register_static (parent_type_macro, #type, &object_info, \
				(GTypeFlags)0)


/* DEPRECATED */
/* from gal */
#define E_MAKE_TYPE(l,str,t,ci,i,parent) \
GtkType l##_get_type(void)\
{\
	static GtkType type = 0;\
	if (!type){\
		GtkTypeInfo info = {\
			str,\
			sizeof (t),\
			sizeof (t##Class),\
			(GtkClassInitFunc) ci,\
			(GtkObjectInitFunc) i,\
			NULL, /* reserved 1 */\
			NULL, /* reserved 2 */\
			(GtkClassInitFunc) NULL\
		};\
                type = gtk_type_unique (parent, &info);\
	}\
	return type;\
}

#endif /* GPDF_UTIL_H */
