/* Totem NarrowSpace plugin scriptable
 *
 * Copyright (C) 2004 Bastien Nocera <hadess@hadess.net>
 * Copyright (C) 2002 David A. Schleef <ds@schleef.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301  USA.
 *
 * $Id: totemNarrowSpacePlugin.h 5373 2008-04-24 15:28:08Z hadess $
 */

#ifndef __NARROWSPACE_PLUGIN_H__
#define __NARROWSPACE_PLUGIN_H__

#include <nsIClassInfo.h>

#include "totemINarrowSpacePlayer.h"
#include "totemPlugin.h"

class totemScriptablePlugin : public totemINarrowSpacePlayer,
			      public nsIClassInfo
{
  public:
    NS_DECL_ISUPPORTS
    NS_DECL_TOTEMINARROWSPACEPLAYER
    NS_DECL_NSICLASSINFO

    void* operator new (size_t aSize) CPP_THROW_NEW;

    totemScriptablePlugin (totemPlugin *aPlugin);

    PRBool IsValid () { return mPlugin != nsnull; }
    void SetPlugin (totemPlugin *aPlugin) { mPlugin = aPlugin; }

    static char *PluginDescription ();
    static char *PluginLongDescription();
    static void PluginMimeTypes (const totemPluginMimeEntry **, PRUint32 *);

    enum PluginState {
      eState_Complete,
      eState_Error,
      eState_Loading,
      eState_Playable,
      eState_Waiting
    };

    PRUint32 mPluginState : 3; /* enough bits for PluginState enum values */

  private:
    ~totemScriptablePlugin ();

    totemPlugin *mPlugin;

    nsCString mBackgroundColour;
    nsCString mMatrix;
    nsCString mRectangle;
    nsCString mMovieName;

    PRUint32 mAutoPlay : 1;
    PRUint32 mControllerVisible : 1;
    PRUint32 mIsLooping : 1;
    PRUint32 mKioskMode : 1;
    PRUint32 mLoopIsPalindrome : 1;
    PRUint32 mMute : 1;
    PRUint32 mPlayEveryFrame : 1;
    PRUint32 mResetPropertiesOnReload : 1;
};

#endif /* __NARROWSPACE_PLUGIN_H__ */
