/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Authors: Iain Holmes <iain@ximian.com>
 *
 *  Copyright 2002 Iain Holmes.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __CDDB_PARSER_H__
#define __CDDB_PARSER_H__

CDDBEntry *cddb_entry_new (const char *discid,
			   int ntrks,
			   const char *offsets,
			   int nsecs);
gboolean cddb_entry_parse_file (CDDBEntry *entry, const char *filename);
CDDBEntry *cddb_entry_new_from_file (const char *filename);
gboolean cddb_entry_write_to_file (CDDBEntry *entry);

#endif
