/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-
 *
 * make-iso.h: code to generate iso files
 *
 * Copyright (C) 2002-2004 Red Hat, Inc.
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Alexander Larsson <alexl@redhat.com>
 *          William Jon McCann <mccann@jhu.edu>
 */

#include <glib/gerror.h>

G_BEGIN_DECLS

#define NAUTILUS_BURN_ISO_ERROR nautilus_burn_iso_error_quark ()

GQuark nautilus_burn_iso_error_quark (void);

typedef enum {
	NAUTILUS_BURN_ISO_ERROR_INTERNAL,
	NAUTILUS_BURN_ISO_ERROR_GENERAL
} NautilusBurnIsoError;

typedef enum {
	NAUTILUS_BURN_IMAGE_TYPE_UNKNOWN,
	NAUTILUS_BURN_IMAGE_TYPE_ISO9660,
	NAUTILUS_BURN_IMAGE_TYPE_BINCUE
} NautilusBurnImageType;

typedef enum {
	NAUTILUS_BURN_IMAGE_CREATE_NONE		= 0,
	NAUTILUS_BURN_IMAGE_CREATE_DEBUG	= 1 << 0,
	NAUTILUS_BURN_IMAGE_CREATE_WARN_SPACE	= 1 << 1,
	NAUTILUS_BURN_IMAGE_CREATE_JOLIET	= 1 << 2
} NautilusBurnImageCreateFlags;

int      nautilus_burn_make_iso            (const char                  *filename,
					    const char                  *label,
					    NautilusBurnImageCreateFlags flags,
					    NautilusBurnImageType       *type,
					    GError                     **error);
int      nautilus_burn_make_iso_from_drive (const char                  *filename,
					    NautilusBurnDrive           *drive,
					    NautilusBurnImageCreateFlags flags,
					    NautilusBurnImageType       *type,
					    char                       **toc_filename,
					    GError                     **error);
void     nautilus_burn_make_iso_cancel     (void);
gboolean nautilus_burn_verify_iso          (const char                  *filename,
					    char                       **name,
					    GError                     **error);

G_END_DECLS
