# $Id: totem.spec.in,v 1.8 2005/05/03 14:25:23 uraeus Exp $

Summary: Movie player for GNOME 2 based on the xine or GStreamer engine.
Name: totem
Version: 1.1.3
Release: 1
License: GPL
Group: Applications/Multimedia
Source: http://www.hadess.net/files/software/%{name}/%{name}-%{version}.tar.gz
URL: http://www.hadess.net/totem.php3
BuildRoot: %{_tmppath}/%{name}-root
Requires: gnome-desktop >= 2.0.0
BuildRequires: pkgconfig
BuildRequires: libgnomeui-devel >= 2.0.0, gnome-vfs2-devel, libglade2-devel

%description
Totem is simple movie player for the Gnome desktop based on xine or
GStreamer. It features a simple playlist, a full-screen mode, seek and
volume controls, as well as a pretty complete keyboard navigation.

It also includes a thumbnailer for your movie files, a properties page
for media metadata (both in Nautilus) and a browser plugin for Mozilla.

%prep
%setup -q

%build
export MOZILLA_PLUGINDIR=%{buildroot}%{_libdir}/mozilla
%configure --enable-gstreamer
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%makeinstall
%find_lang %{name}

%clean
rm -rf %{buildroot}

%post
scrollkeeper-update -q
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/totem.schemas > /dev/null
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/totem-video-thumbnail.schemas >/dev/null
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/totem-handlers.schemas >/dev/null

%files -f %{name}.lang
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%config %{_sysconfdir}/gconf/schemas/*.schemas
%{_bindir}/%{name}
%{_bindir}/totem-video-thumbnailer
%{_libexecdir}/totem-mozilla-viewer
%{_libdir}/libtotem-plparser*
%{_libdir}/nautilus/extensions-1.0
%{_libdir}/mozilla/plugins/libtotem_mozilla.*
%{_libdir}/pkgconfig/totem-plparser.pc
%{_libdir}/mozilla/plugins/*
%{_libexecdir}/totem-mozilla-viewer
%{_includedir}//totem/1/plparser/*.h
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/*
%{_datadir}/gnome/help
%{_datadir}/omf/totem/totem-*.omf
%{_datadir}/%{name}
%{_sysconfdir}/gconf/schemas/totem-handlers.schemas
%{_mandir}/man1/totem.1.gz
%{_mandir}/man1/totem-video-thumbnailer.1.gz
%{_datadir}/omf/totem/totem-de.omf
%{_datadir}/omf/totem/totem-es.omf
%{_mandir}/man1/*.1.gz

%changelog
* Tue May 3 2005 Christian Schaller <uraeus@gnome.org>
- Update spec file to handle the mozilla plugin install

* Fri Jan 28 2005 Christian Schaller <Uraeus@gnome.org>
- update spec file to reflect update to new nautilus version
- add playlist

* Thu Dec 23 2004 Christian Schaller <Uraeus@gnome.org>
- Add russian omf file
* Thu Sep 21 2004 Christian Schaller <Uraeus@gnome.org>
- Remove vanity
- Add manpage
- Add totem-handlers.schemas file
- Add a couple of omf files

* Fri Mar 19 2004 Christian Schaller <Uraeus@gnome.org>
- Add all unpackaged files
- Add scrollkeeper to post area

* Fri Apr 25 2003 Bastien Nocera <hadess@hadess.net>
- Package the thumbnailer as well (spotted by Chris Chabot <chabotc@4-ice.com>

* Mon Sep 30 2002 Bastien Nocera <hadess@hadess.net>
- Install gconf schemas properly

* Mon Sep 30 2002 Matthias Saou <matthias.saou@est.une.marmotte.net>
- Initial RPM release.

