#ifndef __GST_PLAYLIST_H__
#define __GST_PLAYLIST_H__

#include <gnome.h>

G_BEGIN_DECLS

#define GST_TYPE_PLAYLIST            (gst_playlist_get_type ())
#define GST_PLAYLIST(object)         (G_TYPE_CHECK_INSTANCE_CAST ((object), GST_TYPE_PLAYLIST, GstPlaylist))
#define GST_PLAYLIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GST_TYPE_PLAYLIST, GstPlaylistClass))
#define GST_IS_PLAYLIST(object)      (G_TYPE_CHECK_INSTANCE_TYPE ((object), GST_TYPE_PLAYLIST))
#define GST_PLAYLIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GST_TYPE_PLAYLIST, GstPlaylistClass))

typedef struct _GstPlaylist         GstPlaylist;
typedef struct _GstPlaylistClass    GstPlaylistClass;
typedef struct _GstPlaylistPrivate  GstPlaylistPrivate;

struct _GstPlaylist
{
	GtkVBox box;

	GstPlaylistPrivate *_priv;
};

struct _GstPlaylistClass
{
	GtkVBoxClass parent_class;

	void (*selection_change)  (GstPlaylist *playlist);
};

GtkType     gst_playlist_get_type      (void) G_GNUC_CONST;
GtkWidget*  gst_playlist_new           (void);

void        gst_playlist_append        (GstPlaylist *playlist, const gchar *location);
void        gst_playlist_clear         (GstPlaylist *playlist);
gchar*      gst_playlist_get_selected  (GstPlaylist *playlist);
void        gst_playlist_set_selected  (GstPlaylist *playlist, const gchar *path);
gboolean    gst_playlist_get_next      (GstPlaylist *playlist, gchar **location);
gboolean    gst_playlist_get_prev      (GstPlaylist *playlist, gchar **location);

G_END_DECLS

#endif /* __GST_PLAYLIST_H__ */
