/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
#include <config.h>
#include <bonobo/bonobo-i18n.h>
#include <gnome.h>
#include <libgnome/gnome-macros.h>
#include <string.h>

#include <gst/player/gstmediaplay.h>
#include "gst-player-view.h"

struct GstPlayerViewDetails {
/*	GtkWidget    *container;
	GstMediaPlay *mplay;
*/};

BONOBO_CLASS_BOILERPLATE (GstPlayerView, gst_player_view,
			  NautilusView, NAUTILUS_TYPE_VIEW)

static void
gst_player_view_finalize (GObject *object)
{
	GstPlayerView *view;
	view = GST_PLAYER_VIEW (object);
	
	/*g_free (view->details);*/
	G_OBJECT_CLASS (object)->finalize (object);
}

static void
gst_player_view_load_location(NautilusView *nautilus_view, const char *location, gpointer user_data)
{
	GstMediaPlay *mplay = user_data;

	g_return_if_fail (NAUTILUS_IS_VIEW (nautilus_view));
	g_return_if_fail (location != NULL);
	g_return_if_fail (GST_IS_MEDIA_PLAY(mplay));
	
	nautilus_view_report_load_underway (nautilus_view);
	gst_media_play_set_location(mplay, location);
	nautilus_view_report_load_complete (nautilus_view);
}

static void
gst_player_menu(BonoboUIComponent *ui, 
			gpointer           user_data, 
			const char        *verb)
{
 	GstPlayerView *view;

	g_assert (BONOBO_IS_UI_COMPONENT (ui));
        g_assert (verb != NULL);

	view = GST_PLAYER_VIEW (user_data);

	if (strcmp (verb, "Sample Menu Item") == 0) {
	} else {
		g_assert (strcmp (verb, "Sample Dock Item") == 0);
	}
}

static void
gst_player_view_merge_bonobo_items(BonoboControl *control, 
				    gboolean       state, 
				    gpointer       user_data)
{
 	GstPlayerView *view;
	BonoboUIComponent *ui_component;
	BonoboUIVerb verbs [] = {
		BONOBO_UI_VERB ("Sample Menu Item", gst_player_menu),
		BONOBO_UI_VERB ("Sample Dock Item", gst_player_menu),
		BONOBO_UI_VERB_END
	};

	g_assert (BONOBO_IS_CONTROL (control));
	
	view = GST_PLAYER_VIEW (user_data);

	if (state) {
		ui_component = nautilus_view_set_up_ui (NAUTILUS_VIEW (view),
							DATADIR,
							"gst-player-view-ui.xml",
							"gst-player-view");
									
		bonobo_ui_component_add_verb_list_with_data (ui_component, verbs, view);
	}
}

static void
gst_player_view_class_init (GstPlayerViewClass *class)
{
	G_OBJECT_CLASS (class)->finalize = gst_player_view_finalize;
}

static void
gst_player_view_instance_init (GstPlayerView *view)
{
	GtkWidget *container;
	GstMediaPlay *mplay;
	/*view->details = g_new0 (GstPlayerViewDetails, 1);*/
	
	mplay = gst_media_play_new ();
	gtk_widget_show (GTK_WIDGET(mplay));

	container = gtk_alignment_new(0.5, 0.4, 0.0, 0.0);
	gtk_container_add(GTK_CONTAINER(container), GTK_WIDGET(mplay));
	gtk_widget_show (GTK_WIDGET(container));

	nautilus_view_construct (NAUTILUS_VIEW (view), GTK_WIDGET(container));
	
	g_signal_connect (view, "load_location",
			  G_CALLBACK (gst_player_view_load_location), mplay);

        g_signal_connect_object (nautilus_view_get_bonobo_control (NAUTILUS_VIEW (view)), "activate",
				 G_CALLBACK (gst_player_view_merge_bonobo_items), view, 0);

}
