/*
 * GNOME panel mail check module.
 * (C) 1997 The Free Software Foundation
 *
 * Author: Miguel de Icaza
 *
 * Exported interfaces to the GNOME Panel
 */

#include <stdio.h>
#ifdef HAVE_LIBINTL
#include <libintl.h>
#define _(String) gettext(String)
#else
#define _(String) (String)
#endif
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include "gnome.h"
#include "../panel_cmds.h"
#include "../applet_cmds.h"
#include "../panel.h"


#define APPLET_ID "Mail check"


static PanelCmdFunc panel_cmd_func;

static char *mail_file;

gpointer applet_cmd_func(AppletCommand *cmd);

/* If set, the user has launched the mail viewer */
static int mailcleared;

/* Does the user have any mail at all? */
static int anymail;

/* New mail has arrived? */
static int newmail;

/* Does the user have unread mail? */
static int unreadmail;

/* The widget that holds the label with the mail information */
static GtkWidget *label;

/* The drawing area */
static GtkWidget *da;

/* handle for the timeout */
static int mail_timeout;


/*
 * Get file modification time, based upon the code
 * of Byron C. Darrah for coolmail and reused on fvwm95
 */
static void
check_mail_file_status ()
{
	static off_t oldsize = 0;
	struct stat s;
	off_t newsize;
	int status;

	status = stat (mail_file, &s);
	if (status < 0){
		oldsize = 0;
		anymail = newmail = unreadmail = 0;
		return;
	}
	
	newsize = s.st_size;
	anymail = newsize > 0;
	unreadmail = (s.st_mtime >= s.st_atime && newsize > 0);

	if (newsize >= oldsize && unreadmail){
		newmail = 1;
		mailcleared = 0;
	} else
		newmail = 0;
	oldsize = newsize;
}

static int
mail_check_timeout (void *data)
{
	char *text;

	check_mail_file_status ();
	if (anymail)
		text = g_copy_strings ("You have ", newmail ? "new" : "", " mail", NULL);
	else
		text = g_copy_strings ("No mail.", NULL);
	gtk_label_set (GTK_LABEL (label), text);
	free (text);
	return 1;
}

static void
mail_destroy (GtkWidget *widget, void *data)
{
	gtk_timeout_remove (mail_timeout);
}

static GtkWidget *
create_mail_widgets (GtkWidget *window)
{
	label = gtk_label_new ("");
	da = gtk_drawing_area_new ();
	gtk_drawing_area_size ((GtkDrawingArea *) da, 24, 20);
	
	mail_check_timeout (0);
	gtk_widget_show (label);
	mail_timeout = gtk_timeout_add (10000, mail_check_timeout, 0);
	gtk_signal_connect (GTK_OBJECT (label), "destroy", (GtkSignalFunc) mail_destroy, 0);
	return label;
}

static void
create_instance (Panel *panel, char *params, int xpos, int ypos)
{
	PanelCommand cmd;
	GtkWidget *mailcheck;

	/* Only allow one instance of this module */
	if (mail_file)
		return;
	
	mail_file = getenv ("MAIL");
	if (!mail_file)
		return;

	mailcheck = create_mail_widgets (panel->window);
	cmd.cmd = PANEL_CMD_REGISTER_TOY;
	cmd.params.register_toy.applet = mailcheck;
	cmd.params.register_toy.id     = APPLET_ID;
	cmd.params.register_toy.xpos   = xpos;
	cmd.params.register_toy.ypos   = ypos;
	cmd.params.register_toy.flags  = 0;

	(*panel_cmd_func) (&cmd);
}

gpointer
applet_cmd_func(AppletCommand *cmd)
{
	g_assert(cmd != NULL);

	switch (cmd->cmd) {
		case APPLET_CMD_QUERY:
			return APPLET_ID;

		case APPLET_CMD_INIT_MODULE:
			panel_cmd_func = cmd->params.init_module.cmd_func;
			break;

		case APPLET_CMD_DESTROY_MODULE:
			break;

		case APPLET_CMD_GET_DEFAULT_PARAMS:
			return g_strdup("");

		case APPLET_CMD_CREATE_INSTANCE:
			create_instance(cmd->panel,
					cmd->params.create_instance.params,
					cmd->params.create_instance.xpos,
					cmd->params.create_instance.ypos);
			break;

		case APPLET_CMD_GET_INSTANCE_PARAMS:
			return g_strdup("");

		case APPLET_CMD_PROPERTIES:
			fprintf(stderr, "Mail check properties\n"); /* FIXME */
			break;

		default:
			fprintf(stderr,
				APPLET_ID " applet_cmd_func: Oops, unknown command type %d\n",
				(int) cmd->cmd);
			break;
	}

	return NULL;
}
