#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <syslog.h>
#include <errno.h>

#include <gtk/gtk.h>

#include "raft_config.h"

#define COMMENT_CHAR	'#'

Raft_info raft_info;
Raft_launcher *raft_launcher;

static void raft_parse_str_upper(gchar *buf);
static gchar *raft_parse_line (gint nth, gchar *line, gchar token);

/* I HATE WRITING PARSERS IN C!  There's gotta be an easier way.. */

void raft_parse_config(char *config_file)
{
    char buf[4096];
    int done = 0, lineNo = 0;
    FILE *fp;
    Raft_launcher *rl;
    
    raft_launcher = g_malloc(sizeof (Raft_launcher));
    
    rl = raft_launcher;
    
    /* open config file */
    
    if ((fp = fopen(config_file, "r")) == NULL)
	    g_error("Opening config file %s: %s", config_file, g_strerror(errno));
    
    while (!done) {
	
	if ((fgets(buf, 4096, fp)) == NULL)
		break;
	
	lineNo++;
	
	/* check for comments, and give newline if found */
	
	if (buf[0] == COMMENT_CHAR || buf[0] == '\n')
		continue;
	
	rl->next = g_malloc0 (sizeof (Raft_launcher));
	rl = rl->next;
	
	rl->xpm_file = raft_parse_line(0, buf, ':');
	rl->command = raft_parse_line(1, buf, ':');
	rl->label_text = raft_parse_line(2, buf, ':');
	rl->tooltips_text = raft_parse_line(3, buf, ':');
	
    }
    fclose(fp);
}

/* returns the n'th token in the line seperated by token_char */
static gchar *raft_parse_line (gint nth, gchar *line, gchar token_char)
{
    int i;
    int line_len;
    int token_len;
    int token_start = 0;
    int token_count = 0;
    int found = 0;
    int done;
    GString *token = NULL;
    gchar *token_str;
    
    if (line == NULL)
	    return NULL;
    
    line_len = strlen(line);
    
    /* if nth == 0, we are getting the first string */
    if (nth == 0) {
	found = 1;
	token_start = 0;
	token = g_string_new(line);
    }
    
    for(i=0, done = 0; (i < line_len) && (!done); i++) {
	if (line[i] == token_char) {
	    token_count++;
	    if (token_count == nth) {
		token_start = i + 1;
		token = g_string_new(&line[token_start]);
		found = 1;
	    } else {
		/* token_count != nth */
		if (found == 1)
			done = 1;
	    }
	}
    }
    
    if (!found)
	    return (NULL);
    
    token_len = i - token_start - 1;
    
    if (token_len == 0) {
	g_string_free (token, TRUE);
	return (NULL);
    }
    
    g_string_truncate(token, token_len);
    
    token_str = g_strdup(token->str);
    
    g_string_free(token, TRUE);
    
    return(token_str);
}


void raft_parse_str_upper(gchar *buf)
{
    int len, i;
    
    len = strlen(buf);
    for (i = 0; i < len; i++) {
	buf[i] = toupper(buf[i]);
    }
}
